/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db;

import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.dbtools.connections.ConnectionConstants;
import oracle.dbtools.connections.ConnectionReference;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.connections.PathReferencePair;
import oracle.dbtools.connections.ReferencePair;
import oracle.dbtools.connections.StringReferencePair;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DBAdapterBundle;
import oracle.dbtools.connections.db.DatabaseProviderClassLoaderFactory;
import oracle.dbtools.connections.db.DatabaseProviderHelper;
import oracle.dbtools.connections.db.DefaultConnectionCreator;
import oracle.dbtools.connections.db.PasswordPrompter;
import oracle.dbtools.connections.security.ReferenceWorker;
import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;

public class DatabaseProvider
implements ConnectionReferenceable,
DataSource,
ConnectionConstants {
    static final Class PROVIDER_CLASS = DatabaseProvider.class;
    static final String PROVIDER_CLASSNAME = PROVIDER_CLASS.getName();
    public static final String SUBTYPE_CLASS_REFTYPE = "subtype";
    public static final String CUSTOM_URL_CLASS_REFTYPE = "customUrl";
    public static final String DRIVER_CLASS_REFTYPE = "driver";
    public static final String ROLE_CLASS_REFTYPE = "role";
    public static final String SID_CLASS_REFTYPE = "sid";
    public static final String DSN_CLASS_REFTYPE = "dataSourceName";
    @Deprecated
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";
    public static final String PARAMETERS_CLASS_REFTYPE = "parameters";
    public static final String SERVICENAME_CLASS_REFTYPE = "serviceName";
    public static final String SAVE_PASSWORD_CLASS_REFTYPE = "SavePassword";
    @Deprecated
    public static final String DEPLOY_PASSWORD_CLASS_REFTYPE = "DeployPassword";
    @Deprecated
    public static final String ALL_SCHEMAS_REFTYPE = "allSchemas";
    private static DatabaseProviderClassLoaderFactory s_clFactory;
    private static Map<String, Object> s_creators;
    private final Map<String, Object> m_properties = new ConcurrentHashMap<String, Object>();
    private final String m_name;
    private ReferenceWorker m_worker;
    private PrintWriter m_pw;
    private int m_timeout;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(String name, DatabaseProvider copy) {
        Builder builder = new Builder(name);
        builder.worker(copy.getReferenceWorker());
        String subtype = copy.getProperty(SUBTYPE_CLASS_REFTYPE);
        ConnectionCreator cc = DatabaseProvider.getCreatorImpl(subtype, true);
        for (Map.Entry<String, Object> entry : copy.m_properties.entrySet()) {
            String key = entry.getKey();
            if (!(key instanceof String)) continue;
            Object val = entry.getValue();
            String propName = key;
            if (val instanceof TextSecret) {
                builder.credential(propName, (TextSecret)val);
                continue;
            }
            if (val == null) continue;
            String s = String.valueOf(val);
            if (cc.shouldEncrypt(propName)) {
                builder.credential(propName, Secrets.instance().of(s.toCharArray(), true));
                continue;
            }
            builder.property(propName, s);
        }
        return builder;
    }

    private DatabaseProvider(String name) {
        this.m_name = name;
    }

    void setReferenceWorker(ReferenceWorker worker) {
        this.m_worker = worker;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public ConnectionReference getReference() {
        PasswordPrompter pp;
        ConnectionCreator cc = DatabaseProvider.getCreatorImpl(this, true);
        ReferenceWorker encryptionWorker = this.m_worker == null ? DatabaseProviderHelper.getDefaultWorker() : this.m_worker;
        ConnectionReference.ReferenceBuilder builder = new ConnectionReference.ReferenceBuilder(DatabaseProvider.class.getName());
        boolean cacheWithPrompter = false;
        for (Map.Entry<String, Object> entry : this.m_properties.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            boolean isSecret = value instanceof TextSecret;
            boolean enc = isSecret || cc.shouldEncrypt(name);
            boolean save = cc.shouldSave(name, this);
            if (!isSecret && !(value instanceof String)) {
                DatabaseProvider.getLogger().warning(this.m_name + ": invalid value for property " + name);
                continue;
            }
            if (save) {
                if (enc) {
                    TextSecret pwd = isSecret ? (TextSecret)value : Secrets.instance().of(((String)value).toCharArray(), true);
                    ReferencePair addr = encryptionWorker == null ? new StringReferencePair(name, null) : encryptionWorker.encrypt(name, pwd, this.m_name);
                    if (addr == null) {
                        DatabaseProvider.getLogger().info(DBAdapterBundle.format("ERROR_NO_ENCRYPTION", name));
                        continue;
                    }
                    builder.addValue(addr);
                    continue;
                }
                if (cc.isPath(name)) {
                    try {
                        URI path = new URI((String)value);
                        builder.addValue(new PathReferencePair(name, path));
                    }
                    catch (URISyntaxException e) {
                        DatabaseProvider.getLogger().warning("Invalid path value for property " + name + "(" + value + ")");
                    }
                    continue;
                }
                builder.addValue(new StringReferencePair(name, (String)value));
                continue;
            }
            if (!enc || value == null) continue;
            cacheWithPrompter = true;
        }
        if (cacheWithPrompter && (pp = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            pp.cache(this);
        }
        return builder.build();
    }

    private ReferenceWorker getReferenceWorker() {
        return this.m_worker;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getProperties());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = this.getProperties();
        props.setProperty("user", username);
        props.setProperty("password", password);
        return this.getConnection(props);
    }

    private Connection getConnection(Properties props) throws SQLException {
        PasswordPrompter pp;
        ConnectionCreator creator = DatabaseProvider.getCreatorImpl(this, false);
        if (creator.shouldPromptForPassword(props) && (pp = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            return pp.promptForPassword(this);
        }
        return creator.getConnection(props);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.m_pw;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.m_pw = out;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() {
        return DatabaseProvider.getLogger();
    }

    public String getConnectionURL() throws SQLException {
        return DatabaseProvider.getCreator(this).getConnectionURL(this.getProperties());
    }

    public Properties getJDBCProperties() throws SQLException {
        return DatabaseProvider.getCreator(this).getJDBCProperties(this.getProperties());
    }

    public String getDriverClassName() throws SQLException {
        return DatabaseProvider.getCreator(this).getDriverClassName(this.getProperties());
    }

    public boolean shouldPromptForCredentials() {
        ConnectionCreator creator = DatabaseProvider.getCreatorImpl(this, false);
        return creator != null && creator.shouldPromptForPassword(this.getProperties());
    }

    public String getProperty(String name) {
        Object val = this.m_properties.get(name);
        String retval = val instanceof TextSecret ? (String)((TextSecret)val).map(String::new) : (val instanceof String ? (String)val : null);
        return retval;
    }

    public Properties getProperties() {
        Properties retval = new Properties();
        for (String prop : this.m_properties.keySet()) {
            String value = this.getProperty(prop);
            if (value == null) continue;
            retval.setProperty(prop, value);
        }
        return retval;
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            this.m_properties.remove(name);
        } else {
            ConnectionCreator cc = DatabaseProvider.getCreatorImpl(this, true);
            this.setPropertyImpl(name, value, cc);
        }
    }

    private void setPropertyImpl(String name, String value, ConnectionCreator cc) {
        if (cc.shouldEncrypt(name)) {
            this.setCredential(name, Secrets.instance().of(value.toCharArray(), true));
        } else {
            this.m_properties.put(name, value);
        }
    }

    public void setCredential(String name, TextSecret value) {
        if (value == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.put(name, value);
        }
    }

    public void disconnect() {
        PasswordPrompter pp = DatabaseProviderHelper.getPasswordPrompter();
        if (pp != null) {
            pp.disconnect(this);
        }
    }

    public int hashCode() {
        return this.m_properties.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseProvider && this.equalsImpl((DatabaseProvider)obj);
    }

    private boolean equalsImpl(DatabaseProvider prov) {
        return DatabaseProvider.areEqual(this.m_name, prov.m_name) && DatabaseProvider.areEqual(this.m_properties, prov.m_properties);
    }

    private static boolean areEqual(Object o1, Object o2) {
        boolean retval;
        if (o1 == o2) {
            retval = true;
        } else if (o1 == null || o2 == null) {
            retval = false;
        } else if (o1 instanceof Map && o2 instanceof Map) {
            boolean mapsAreEqual = true;
            Map map1 = (Map)o1;
            Map map2 = (Map)o2;
            HashSet allKeys = new HashSet();
            allKeys.addAll(map1.keySet());
            allKeys.addAll(map2.keySet());
            for (Object key : allKeys) {
                Object val2;
                Object val1 = map1.get(key);
                if (DatabaseProvider.areEqual(val1, val2 = map2.get(key))) continue;
                mapsAreEqual = false;
                break;
            }
            retval = mapsAreEqual;
        } else {
            retval = o1 instanceof char[] && o2 instanceof char[] ? Arrays.equals((char[])o1, (char[])o2) : o1.equals(o2);
        }
        return retval;
    }

    static ClassLoader getClassLoader(String driverClass, ClassLoader creatorClassLoader) {
        ClassLoader cl = null;
        if (s_clFactory != null) {
            cl = s_clFactory.getClassLoader(driverClass);
        }
        if (cl == null && creatorClassLoader != null) {
            cl = DatabaseProvider.tryLoad(creatorClassLoader, driverClass);
        }
        if (cl == null) {
            cl = DatabaseProvider.tryLoad(Thread.currentThread().getContextClassLoader(), driverClass);
        }
        ClassLoader ourClassLoader = PROVIDER_CLASS.getClassLoader();
        if (cl == null && creatorClassLoader != ourClassLoader) {
            cl = DatabaseProvider.tryLoad(ourClassLoader, driverClass);
        }
        if (cl == null) {
            cl = DatabaseProvider.tryLoad(ClassLoader.getSystemClassLoader(), driverClass);
        }
        return cl;
    }

    private static ClassLoader tryLoad(ClassLoader l, String name) {
        if (l == null) {
            return null;
        }
        try {
            l.loadClass(name);
            return l;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static void setClassLoaderFactory(DatabaseProviderClassLoaderFactory factory) {
        s_clFactory = factory;
    }

    public static ConnectionCreator getCreator(String subtype) throws SQLException {
        ConnectionCreator retval = DatabaseProvider.getCreatorImpl(subtype, false);
        if (retval == null) {
            throw new SQLException(DBAdapterBundle.format("ERROR_INVALID_SUBTYPE", subtype));
        }
        return retval;
    }

    public static ConnectionCreator getCreator(DatabaseProvider dp) throws SQLException {
        return DatabaseProvider.getCreator(dp.getProperty(SUBTYPE_CLASS_REFTYPE));
    }

    private static ConnectionCreator getCreatorImpl(DatabaseProvider dp, boolean useDefault) {
        return DatabaseProvider.getCreatorImpl(dp.getProperty(SUBTYPE_CLASS_REFTYPE), useDefault);
    }

    private static ConnectionCreator getCreatorImpl(String subtype, boolean useDefault) {
        ConnectionCreator retval = null;
        if (subtype != null) {
            Object obj = s_creators.get(subtype);
            if (obj instanceof ConnectionCreator) {
                retval = (ConnectionCreator)obj;
            } else if (obj instanceof Callable) {
                try {
                    retval = (ConnectionCreator)((Callable)obj).call();
                }
                catch (Exception e) {
                    DatabaseProvider.getLogger().log(Level.SEVERE, subtype, e);
                }
            }
        }
        if (retval == null && useDefault) {
            retval = DefaultConnectionCreator.getInstance();
        }
        return retval;
    }

    public static synchronized void registerConnectionCreator(String subtype, ConnectionCreator creator) {
        DatabaseProvider.registerCCImpl(subtype, creator);
    }

    public static synchronized void registerLazyConnectionCreator(String subtype, Callable<ConnectionCreator> creator) {
        DatabaseProvider.registerCCImpl(subtype, creator);
    }

    private static void registerCCImpl(String subtype, Object obj) {
        Object removed = obj == null ? s_creators.remove(subtype) : s_creators.put(subtype, obj);
        if (removed != null) {
            DatabaseProvider.getLogger().fine("DB Adapter warning: Replacing connection creator  for subtype " + subtype);
        }
    }

    private static Logger getLogger() {
        return DatabaseProviderHelper.getLogger();
    }

    static {
        s_creators = new ConcurrentHashMap<String, Object>();
    }

    public static class Builder {
        private final String name;
        private ReferenceWorker worker;
        private final Map<String, String> props = new HashMap<String, String>();
        private final Map<String, TextSecret> creds = new HashMap<String, TextSecret>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder worker(ReferenceWorker worker) {
            this.worker = worker;
            return this;
        }

        public Builder property(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public Builder credential(String key, TextSecret value) {
            this.creds.put(key, value);
            return this;
        }

        public DatabaseProvider build() {
            DatabaseProvider provider = new DatabaseProvider(this.name);
            provider.setReferenceWorker(this.worker);
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                provider.setProperty(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.creds.entrySet()) {
                provider.setCredential(entry.getKey(), (TextSecret)entry.getValue());
            }
            return provider;
        }
    }
}

