/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import oracle.dbtools.parser.json.Jsonable;
import oracle.dbtools.parser.json.Util;

public class CompletionItem
implements Jsonable {
    public String entry;
    public Type type;

    public CompletionItem(String entry, Type type) {
        this.entry = entry;
        this.type = type;
    }

    public CompletionItem(String entry) {
        this.entry = entry;
        this.type = Type.UNKNOWN;
    }

    public String toString() {
        return this.entry + " " + this.type;
    }

    public boolean equals(Object obj) {
        CompletionItem cmp = (CompletionItem)obj;
        if (!cmp.entry.equals(this.entry)) {
            return false;
        }
        if (cmp.type == null && this.type != null) {
            return false;
        }
        if (cmp.type != null && this.type == null) {
            return false;
        }
        return cmp.type == null || cmp.type.equals((Object)this.type);
    }

    public int lspCode() {
        switch (this.type) {
            case TABLE: {
                return 6;
            }
            case VIEW: {
                return 6;
            }
            case COLUMN: {
                return 5;
            }
            case USER: {
                return 1;
            }
            case KEYWORD: {
                return 14;
            }
            case SYNONYM: {
                return 1;
            }
            case PROCEDURE: {
                return 3;
            }
            case FUNCTION: {
                return 3;
            }
            case PACKAGE: {
                return 9;
            }
            case PACKAGE_BODY: {
                return 9;
            }
            case INDEX: {
                return 6;
            }
            case OTHER_DB_OBJECT: {
                return 6;
            }
            case CONDITION: {
                return 15;
            }
            case JAVA_PACKAGE: {
                return 19;
            }
            case JAVA_CLASS: {
                return 3;
            }
            case JAVA_METHOD: {
                return 2;
            }
            case JAVA_VARIABLE: {
                return 6;
            }
            case SNIPPET: {
                return 15;
            }
        }
        return 1;
    }

    @Override
    public String toJson() {
        return "{\"label\":\"" + Util.sugarcoatText(this.entry) + "\",\"kind\":" + this.lspCode() + "}";
    }

    public static enum Type {
        TABLE,
        VIEW,
        COLUMN,
        USER,
        KEYWORD,
        TURLNET,
        SYNONYM,
        SEQUENCE,
        PROCEDURE,
        FUNCTION,
        PACKAGE,
        PACKAGE_BODY,
        INDEX,
        OTHER_DB_OBJECT,
        CONDITION,
        ARGUMENT,
        PARTIALLY_RECOGNIZED_SYNTAX,
        JAVA_PACKAGE,
        JAVA_CLASS,
        JAVA_METHOD,
        JAVA_VARIABLE,
        SNIPPET,
        FILE,
        STRING,
        BOOLEAN,
        UNKNOWN;

    }
}

