/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import java.util.Arrays;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.StrategoArrayList;

class StrategoArrayListBuilder
implements IStrategoList.Builder {
    private IStrategoTerm[] array;
    private int index = 0;
    private boolean built = false;

    StrategoArrayListBuilder(int size) {
        this.array = new IStrategoTerm[size];
    }

    @Override
    public void add(IStrategoTerm term) {
        if (this.built) {
            throw new UnsupportedOperationException("Cannot add to a built list.");
        }
        if (this.index >= this.array.length) {
            this.array = this.array.length == 0 ? new IStrategoTerm[2] : Arrays.copyOf(this.array, this.array.length * 2);
        }
        this.array[this.index] = term;
        ++this.index;
    }

    @Override
    public IStrategoList build() {
        this.built = true;
        return new StrategoArrayList(this.array, null, 0, this.index);
    }

    @Override
    public boolean isEmpty() {
        return this.index == 0;
    }

    public IStrategoList build(IStrategoList annotations) {
        this.built = true;
        return new StrategoArrayList(this.array, annotations, 0, this.index);
    }
}

