/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library;

import org.spoofax.interpreter.library.AbstractPrimitive;

public class PrimitiveCache {
    private final int levels;
    private final int entries;
    private final String[][] names;
    private final AbstractPrimitive[][] primitives;

    public PrimitiveCache(int levels, int entries) {
        if (levels <= 0) {
            throw new IllegalArgumentException("Levels must be at least 1.");
        }
        if (entries <= 0) {
            throw new IllegalArgumentException("Entries must be at least 1.");
        }
        this.levels = levels;
        this.entries = entries;
        this.names = new String[levels][entries];
        this.primitives = new AbstractPrimitive[levels][entries];
    }

    public AbstractPrimitive get(String name) {
        int entry = Integer.remainderUnsigned(name.hashCode(), this.entries);
        int level = 0;
        while (level < this.levels) {
            String entryName = this.names[level][entry];
            if (entryName == null) {
                return null;
            }
            if (name.equals(entryName)) {
                AbstractPrimitive primitive = this.primitives[level][entry];
                if (level == 0) {
                    return primitive;
                }
                int l = 1;
                while (l <= level) {
                    this.names[l][entry] = this.names[l - 1][entry];
                    this.primitives[l][entry] = this.primitives[l - 1][entry];
                    ++l;
                }
                this.names[0][entry] = name;
                this.primitives[0][entry] = primitive;
                return primitive;
            }
            ++level;
        }
        return null;
    }

    public void put(String name, AbstractPrimitive primitive) {
        int entry = Integer.remainderUnsigned(name.hashCode(), this.entries);
        int level = 1;
        while (level < this.levels) {
            this.names[level][entry] = this.names[level - 1][entry];
            this.primitives[level][entry] = this.primitives[level - 1][entry];
            ++level;
        }
        this.names[0][entry] = name;
        this.primitives[0][entry] = primitive;
    }
}

