/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.characterclasses;

import java.io.Serializable;
import org.metaborg.parsetable.characterclasses.CharacterClassOptimized;
import org.metaborg.parsetable.characterclasses.CharacterClassRangeList;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class CharacterClassSingle
implements ICharacterClass,
Serializable {
    private static final long serialVersionUID = -9025374026984306930L;
    private final int character;

    public CharacterClassSingle(int character) {
        this.character = character;
    }

    @Override
    public final boolean contains(int character) {
        return this.character == character;
    }

    @Override
    public int min() {
        return this.character;
    }

    @Override
    public int max() {
        return this.character;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int[] getRanges() {
        int[] nArray;
        if (this.character == -1) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = this.character;
            nArray = nArray2;
            nArray2[1] = this.character;
        }
        return nArray;
    }

    @Override
    public ICharacterClass setEOF(boolean eof) {
        if (this.character == -1) {
            return eof ? this : CharacterClassRangeList.EMPTY_CONSTANT;
        }
        return eof ? this.union(new CharacterClassSingle(-1)) : this;
    }

    @Override
    public ICharacterClass union(ICharacterClass other) {
        if (other instanceof CharacterClassSingle) {
            if (other.contains(this.character)) {
                return this;
            }
            CharacterClassRangeList result = CharacterClassRangeList.EMPTY_CONSTANT;
            result = result.addSingle(this.character);
            result = result.addSingle(other.min());
            return result;
        }
        if (other instanceof CharacterClassRangeList) {
            return ((CharacterClassRangeList)other).addSingle(this.character);
        }
        throw new IllegalStateException("Union can only be done with Single and RangeList character classes");
    }

    @Override
    public ICharacterClass intersection(ICharacterClass other) {
        if (other instanceof CharacterClassOptimized) {
            throw new IllegalStateException("Intersection can only be done with Single and RangeList character classes");
        }
        if (other.contains(this.character)) {
            return this;
        }
        return CharacterClassRangeList.EMPTY_CONSTANT;
    }

    @Override
    public ICharacterClass difference(ICharacterClass other) {
        if (other instanceof CharacterClassOptimized) {
            throw new IllegalStateException("Difference can only be done with Single and RangeList character classes");
        }
        if (other.contains(this.character)) {
            return CharacterClassRangeList.EMPTY_CONSTANT;
        }
        return this;
    }

    @Override
    public IStrategoTerm toAtermList(ITermFactory tf) {
        return tf.makeList(this.character == -1 ? tf.makeAppl(tf.makeConstructor("eof", 0), new IStrategoTerm[0]) : tf.makeInt(this.character));
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.character);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ICharacterClass)) {
            return false;
        }
        return ((ICharacterClass)o).min() == this.min() && ((ICharacterClass)o).max() == this.min();
    }

    public final String toString() {
        return "[" + (this.character == -1 ? "EOF" : Integer.valueOf(this.character)) + "]";
    }
}

