/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.impl;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class WorkStealingScheduler
implements IActorScheduler {
    private static final ILogger logger = LoggerUtils.logger(WorkStealingScheduler.class);
    private final int parallelism;
    private final ForkJoinPool executor;

    public WorkStealingScheduler(int parallelism) {
        this.parallelism = parallelism;
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = new ForkJoinPool.ForkJoinWorkerThreadFactory(){

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("PRaffrayiWorker-" + worker.getPoolIndex());
                return worker;
            }
        };
        this.executor = new ForkJoinPool(parallelism, factory, null, true);
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public void schedule(Runnable runnable, int priority, AtomicReference<Runnable> taskRef) {
        Task task = new Task(runnable);
        if (!taskRef.compareAndSet(null, task)) {
            logger.error("Actor {} already scheduled", runnable);
            throw new IllegalStateException("Actor " + runnable + " already scheduled.");
        }
        this.executor.execute(task);
    }

    @Override
    public void reschedule(Runnable oldTask, int newPriority, AtomicReference<Runnable> taskRef) {
    }

    @Override
    public boolean preempt(int priority) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.executor.getActiveThreadCount() != 0 || this.executor.getQueuedTaskCount() != 0L;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final AtomicBoolean active;

        Task(Runnable runnable) {
            this.runnable = runnable;
            this.active = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            if (this.active.compareAndSet(true, false)) {
                this.runnable.run();
            }
        }
    }
}

