/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.substitution;

import com.google.common.collect.Lists;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.Renaming;
import org.metaborg.util.collection.CapsuleUtil;

public class FreshVars {
    private List<Set<ITermVar>> oldVarSets;
    private Set.Immutable<ITermVar> oldVars;
    private Set.Immutable<ITermVar> newVars;

    public FreshVars() {
        this.oldVarSets = new ArrayList<Set<ITermVar>>();
        this.oldVars = CapsuleUtil.immutableSet();
        this.newVars = CapsuleUtil.immutableSet();
    }

    @SafeVarargs
    public FreshVars(Set<ITermVar> ... preExistingVarSets) {
        this.oldVarSets = Lists.newArrayList((Object[])preExistingVarSets);
        this.oldVars = CapsuleUtil.immutableSet();
        this.newVars = CapsuleUtil.immutableSet();
    }

    public FreshVars(Iterable<ITermVar> preExistingVars) {
        this.oldVarSets = new ArrayList<Set<ITermVar>>();
        this.oldVars = CapsuleUtil.toSet(preExistingVars);
        this.newVars = CapsuleUtil.immutableSet();
    }

    public void add(io.usethesource.capsule.Set<ITermVar> preExistingVarSet) {
        this.oldVarSets.add((Set<ITermVar>)preExistingVarSet);
    }

    public void add(Iterable<ITermVar> preExistingVars) {
        Set.Transient oldVars = this.oldVars.asTransient();
        for (ITermVar var : preExistingVars) {
            oldVars.__insert((Object)var);
        }
        this.oldVars = oldVars.freeze();
    }

    public ITermVar fresh(String name) {
        String base = this.dropSuffix(name);
        ITermVar fresh = TermBuild.B.newVar("", name);
        int i = 0;
        while (this.notFresh(fresh)) {
            fresh = TermBuild.B.newVar("", String.valueOf(base) + "-" + i++);
        }
        this.newVars = this.newVars.__insert((Object)fresh);
        return fresh;
    }

    public ITermVar fresh(ITermVar var) {
        String base = this.dropSuffix(var.getName());
        ITermVar fresh = var;
        int i = 0;
        while (this.notFresh(fresh)) {
            fresh = TermBuild.B.newVar("", String.valueOf(base) + "-" + i++);
        }
        this.newVars = this.newVars.__insert((Object)fresh);
        return fresh;
    }

    public IRenaming fresh(Set<ITermVar> vars) {
        Renaming.Builder renaming = Renaming.builder();
        for (ITermVar var : vars) {
            String base = var.getName().replaceAll("-?[0-9]*$", "");
            ITermVar fresh = var;
            int i = 0;
            while (vars.contains(fresh) && !var.equals(fresh) || this.notFresh(fresh)) {
                fresh = TermBuild.B.newVar(var.getResource(), String.valueOf(base) + "-" + i++);
            }
            this.newVars = this.newVars.__insert((Object)fresh);
            renaming.put(var, fresh);
            renaming.put(fresh, var);
        }
        return renaming.build();
    }

    private boolean notFresh(ITermVar var) {
        return this.oldVars.contains((Object)var) || this.newVars.contains((Object)var) || this.oldVarSets.stream().anyMatch(s -> s.contains(var));
    }

    public Set.Immutable<ITermVar> fix() {
        Set.Immutable<ITermVar> fixedVars = this.newVars;
        this.oldVars = this.oldVars.__insertAll(fixedVars);
        this.newVars = CapsuleUtil.immutableSet();
        return fixedVars;
    }

    public Set.Immutable<ITermVar> reset() {
        Set.Immutable<ITermVar> resetVars = this.newVars;
        this.newVars = CapsuleUtil.immutableSet();
        return resetVars;
    }

    private String dropSuffix(String name) {
        int idx = name.indexOf(45);
        return idx < 0 ? name : name.substring(0, idx);
    }
}

