/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import oracle.ide.net.URLKey;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.file.KnownFile;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.uses.UsesModel;
import oracle.javatools.exports.uses.UsesReaderWriter;

public class UsesSupplier {
    private final Path path;
    private final URL url;
    private final KnownFile defaultFile;
    private final ClassPathModel model;
    private final ExportDomain domain;
    private final NameSpace nameSpace;
    private final Log log;
    private UsesModel cache;

    public UsesSupplier(Path path, KnownFile defaultFile, ClassPathModel model, Log log) {
        this.path = path;
        this.url = null;
        this.defaultFile = defaultFile;
        this.model = model;
        this.domain = model.getDomain();
        this.nameSpace = model.getNameSpace();
        this.log = log;
    }

    public UsesSupplier(URL url, KnownFile defaultFile, ClassPathModel model, ExportDomain domain, NameSpace nameSpace, Log log) {
        this.path = null;
        this.url = null;
        this.defaultFile = defaultFile;
        this.model = model;
        this.domain = domain;
        this.nameSpace = nameSpace;
        this.log = log;
    }

    public UsesSupplier(Path path, KnownFile defaultFile, ClassPathModel model, ExportDomain domain, NameSpace nameSpace, Log log) {
        this.path = path;
        this.url = null;
        this.defaultFile = defaultFile;
        this.model = model;
        this.domain = domain;
        this.nameSpace = nameSpace;
        this.log = log;
    }

    public UsesModel get() throws CommandException {
        if (this.cache == null) {
            UsesModel uses = new UsesModel(this.model);
            if (this.path != null) {
                UsesReaderWriter.readUses(uses, this.path, this.nameSpace, false, this.log.child(new Tag("scope", new PathKey(this.path))));
            } else if (this.url != null) {
                UsesReaderWriter.readUses(uses, this.url, this.nameSpace, false, this.log.child(new Tag("scope", URLKey.getInstance(this.url))));
            } else {
                URL url = this.defaultFile.getUrl();
                InputStream stream = this.defaultFile.getStream();
                if (stream == null) {
                    throw new CommandException("Client uses %s not read", url);
                }
                UsesReaderWriter.readUses(uses, url, stream, this.nameSpace, false, this.log.child(new Tag("scope", url)));
            }
            this.cache = uses;
        }
        return this.cache;
    }
}

