/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.nio.file.Path;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.report.IssueHandler;
import oracle.javatools.exports.report.IssueModel;
import oracle.javatools.exports.report.IssueProperty;

public class DiscreteUsesHandler
extends IssueHandler {
    public static final IssueProperty<CompatibilityAccess> ACCESS = new IssueProperty<CompatibilityAccess>("ACCESS"){

        @Override
        public CompatibilityAccess getValue(IssueModel issue) {
            return issue instanceof ElementUse ? ((ElementUse)issue).getAccess() : null;
        }
    };
    public static final IssueProperty<String> PATH = new IssueProperty<String>("PATH"){

        @Override
        public String getValue(IssueModel issue) {
            return issue instanceof LibraryUse ? ((LibraryUse)issue).getPath() : null;
        }
    };
    public static final IssueProperty<ElementName> API = new IssueProperty<ElementName>("API"){

        @Override
        public ElementName getValue(IssueModel issue) {
            return issue instanceof ElementUse ? ((ElementUse)issue).getName() : null;
        }
    };
    public static final IssueProperty<String> LIBRARY = new IssueProperty<String>("LIBRARY"){

        @Override
        public String getValue(IssueModel issue) {
            return issue instanceof LibraryUse ? ((LibraryUse)issue).getName() : null;
        }
    };
    public static final IssueProperty<CompatibilityAccess> DIFFERENCE = new IssueProperty<CompatibilityAccess>("DIFFERENCE"){

        @Override
        public CompatibilityAccess getValue(IssueModel issue) {
            return ((ElementUse)issue).getAccess();
        }

        @Override
        public String toString(IssueModel left, IssueModel right) {
            return left != null && right != null ? "changed" : (left == null ? "added" : "removed");
        }
    };
    private final NameSpace nameSpace = NameSpace.defaultNameSpace();

    public IssueProperty<?>[] getProperties() {
        return new IssueProperty[]{ACCESS, PATH, API, LIBRARY, DIFFERENCE};
    }

    @Override
    public String[] getRules() {
        return new String[]{"oracle.jdeveloper.audit.export.used-api", "oracle.jdeveloper.audit.export.used-api-discrete", "oracle.jdeveloper.audit.export.concealed-api-hybrid"};
    }

    @Override
    public IssueModel issueReported(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, boolean suppressed, String message) {
        assert (Arrays.contains(new String[]{"oracle.jdeveloper.audit.export.used-api-discrete", "oracle.jdeveloper.audit.export.concealed-api-hybrid"}, rule));
        String[] tokens = message.split(" ");
        switch (tokens[0].toLowerCase()) {
            case "class": 
            case "interface": 
            case "type": {
                TypeName typeName = this.nameSpace.typeNameHybrid(tokens[1]);
                CompatibilityAccess access = null;
                switch (tokens[2]) {
                    case "is": 
                    case "used": {
                        access = this.getAccess(tokens[3]);
                    }
                    case "has": {
                        return new ElementUse(workspace, project, directory, file, line, column, rule, variation, message, typeName, access);
                    }
                    case "extended": {
                        boolean concrete = "(concrete)".equals(tokens[3]);
                        access = this.getAccess(tokens[4]);
                        return new ExtensionUse(workspace, project, directory, file, line, column, rule, variation, message, typeName, concrete, access);
                    }
                }
                throw new IllegalStateException("unexpected use kind \"" + tokens[2] + "\"");
            }
            case "constructor": 
            case "method": 
            case "field": {
                MemberName memberName = this.nameSpace.memberNameHybrid(tokens[1]);
                CompatibilityAccess access = rule.endsWith(".used-api") ? null : this.getAccess(tokens[3]);
                return new ElementUse(workspace, project, directory, file, line, column, rule, variation, message, memberName, access);
            }
            case "library": {
                int nameBegin = "Library ".length();
                int nameEnd = message.lastIndexOf(" at ");
                if (nameEnd < 0) {
                    throw new IllegalStateException("expected \" at \" in line " + line + ": %s" + message);
                }
                if (nameEnd - nameBegin >= 3 && message.charAt(nameBegin) == '\"' && message.charAt(nameEnd - 1) == '\"') {
                    ++nameBegin;
                    --nameEnd;
                }
                String name = message.substring(nameBegin, nameEnd);
                String path = tokens[tokens.length - 4];
                return new LibraryUse(workspace, project, directory, file, line, column, rule, variation, message, name, path);
            }
        }
        throw new IllegalStateException("unexpected element kind \"" + tokens[0] + "\"");
    }

    private CompatibilityAccess getAccess(String text) {
        return CompatibilityAccess.valueOfIgnoreCase(text.endsWith(":") ? text.substring(0, text.length() - 1) : text);
    }

    public static class ElementUse
    extends Use {
        private final ElementName name;
        private final CompatibilityAccess access;

        public ElementUse(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, String message, ElementName name, CompatibilityAccess access) {
            super(workspace, project, directory, file, line, column, rule, variation, message);
            this.name = name;
            this.access = access;
        }

        @Override
        public ElementName getName() {
            return this.name;
        }

        public boolean isReference() {
            return !this.isExtension();
        }

        public boolean isExtension() {
            return false;
        }

        public boolean isConcrete() {
            throw new UnsupportedOperationException();
        }

        public CompatibilityAccess getAccess() {
            return this.access;
        }

        @Override
        public int compareTo(IssueModel that) {
            return this.compareTo((ElementUse)that);
        }

        @Override
        public int compareTo(ElementUse that) {
            int comparison = super.compareTo(that);
            if (comparison != 0) {
                return comparison;
            }
            if (this.name == null) {
                return that.name == null ? 0 : -1;
            }
            int n = comparison = that.name == null ? 1 : this.name.compareTo(that.name);
            if (comparison != 0) {
                return comparison;
            }
            return CompatibilityAccess.compare(this.access, that.access);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ElementUse)) {
                return false;
            }
            ElementUse that = (ElementUse)object;
            return super.equals(that) && this.name.equals(that.name);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.name.hashCode();
        }
    }

    public static class ExtensionUse
    extends ElementUse {
        private final boolean concrete;

        public ExtensionUse(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, String message, TypeName name, boolean concrete, CompatibilityAccess access) {
            super(workspace, project, directory, file, line, column, message, rule, variation, name, access);
            this.concrete = concrete;
        }

        @Override
        public boolean isExtension() {
            return true;
        }

        @Override
        public boolean isConcrete() {
            return this.concrete;
        }
    }

    public static class LibraryUse
    extends Use {
        private final String name;
        private final String path;

        public LibraryUse(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, String message, String name, String path) {
            super(workspace, project, directory, file, line, column, rule, variation, message);
            this.name = name;
            this.path = path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }
    }

    public static abstract class Use
    extends IssueModel {
        public Use(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, String message) {
            super(workspace, project, directory, file, line, column, rule, variation, false, message);
        }

        public abstract Object getName();
    }
}

