/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZippingReaderWriter {
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;

    public static BufferedWriter newZippingWriter(Path path) throws IOException {
        return ZippingReaderWriter.newZippingWriter(path, DEFAULT_ENCODING);
    }

    public static BufferedWriter newZippingWriter(Path path, Charset encoding) throws IOException {
        Path zipPath = path;
        String entryName = zipPath.getFileName().toString();
        if (entryName.endsWith(".zip")) {
            entryName = entryName.substring(0, entryName.length() - 4);
        } else {
            zipPath = zipPath.resolveSibling(entryName + ".zip");
        }
        File zipFile = zipPath.toFile();
        zipFile.delete();
        ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(zipFile));
        zipStream.setLevel(9);
        ZipEntry entry = new ZipEntry(entryName);
        zipStream.putNextEntry(entry);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)zipStream, encoding));
    }

    public static BufferedReader newUnzippingReader(Path path) throws IOException {
        return ZippingReaderWriter.newUnzippingReader(path, DEFAULT_ENCODING);
    }

    public static BufferedReader newUnzippingReader(Path path, Charset encoding) throws IOException {
        String fileName = path.getFileName().toString();
        if (fileName.endsWith(".zip")) {
            ZipEntry entry;
            ZipFile zip = new ZipFile(path.toFile());
            String entryName = fileName.substring(0, fileName.length() - 4);
            switch (zip.size()) {
                case 0: {
                    throw new IOException("no entries found in " + path);
                }
                case 1: {
                    entry = zip.entries().nextElement();
                    break;
                }
                default: {
                    entry = zip.getEntry(entryName);
                    if (entry != null) break;
                    throw new IOException("entry " + entryName + " not found in " + path);
                }
            }
            return new BufferedReader(new InputStreamReader(zip.getInputStream(entry), encoding));
        }
        return Files.newBufferedReader(path, encoding);
    }
}

