/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.Element;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.common.Iterables;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.TypeExportSpecification;

public final class Package
extends Element {
    private ClassPathModel model;
    private final PackageName name;
    private Map<TypeName, Type> declaredTypes = Collections.emptyMap();
    private Map<ElementName, Type> derivedTypes = Collections.emptyMap();
    private int exportedMemberCount;
    private int restrictedMemberCount;
    private int concealedMemberCount;
    private int escalatedMemberCount;

    Package(ClassPathModel model, PackageName name, boolean deprecated, CompatibilityAccess defaultMemberAccess, String accessComment) {
        super(true, deprecated, defaultMemberAccess, accessComment);
        this.model = model;
        this.name = name;
    }

    Package(PackageName name, char flags) {
        super(flags);
        this.model = null;
        this.name = name;
    }

    @Override
    public PackageName getName() {
        return this.name;
    }

    void setModel(ClassPathModel model) {
        this.model = model;
    }

    Type addOrGetType(Type type) {
        if (type.isReferenceType()) {
            Type predecessor;
            if (this.declaredTypes.isEmpty()) {
                this.declaredTypes = new ConcurrentSkipListMap<TypeName, Type>(TypeName.UNQUALIFIED_COMPARATOR);
            }
            if ((predecessor = this.declaredTypes.putIfAbsent(type.getName(), type)) != null) {
                return predecessor;
            }
            if (type.hasOrContainsExported()) {
                ++this.exportedMemberCount;
            }
            if (type.hasOrContainsRestricted()) {
                ++this.restrictedMemberCount;
            }
            if (type.hasOrContainsConcealed()) {
                ++this.concealedMemberCount;
            }
            if (type.hasOrContainsEscalated()) {
                ++this.escalatedMemberCount;
            }
        } else {
            Type predecessor;
            if (this.derivedTypes.isEmpty()) {
                this.derivedTypes = new HashMap<ElementName, Type>();
            }
            if ((predecessor = this.derivedTypes.putIfAbsent(type.getName(), type)) != null) {
                return predecessor;
            }
        }
        return type;
    }

    int addExportedMember() {
        return ++this.exportedMemberCount;
    }

    int addRestrictedMember() {
        return ++this.restrictedMemberCount;
    }

    int removeConcealedMember() {
        return --this.concealedMemberCount;
    }

    int addEscalatedMember() {
        return ++this.escalatedMemberCount;
    }

    int removeEscalatedMember() {
        return --this.escalatedMemberCount;
    }

    @Override
    public ClassPathModel getModel() {
        return this.model;
    }

    @Override
    public Element getParent() {
        return null;
    }

    @Override
    public Package getPackage() {
        return this;
    }

    @Override
    public CompatibilityAccess getReferenceAccess() {
        return this.getCompatibilityAccess('\u0005') != null ? this.getMemberAccess() : null;
    }

    @Override
    public boolean containsExported() {
        return this.exportedMemberCount > 0;
    }

    @Override
    public boolean containsRestricted() {
        return this.restrictedMemberCount > 0;
    }

    @Override
    public boolean containsConcealed() {
        return this.concealedMemberCount > 0;
    }

    @Override
    public boolean containsEscalated() {
        return this.escalatedMemberCount > 0;
    }

    @Override
    public void resolve() {
        for (Type type : this.declaredTypes.values()) {
            if (!type.isExportable() || !type.isControlled()) continue;
            type.resolve();
        }
    }

    public boolean isDefault() {
        return this.name.isDefault();
    }

    public CompatibilityAccess getDefaultMemberAccess() {
        return this.getCompatibilityAccess('\u0005');
    }

    public boolean containsControlled() {
        return this.exportedMemberCount + this.restrictedMemberCount + this.concealedMemberCount != 0;
    }

    public Type getType(TypeName name) {
        Type type = this.declaredTypes.get(name);
        if (type == null) {
            type = this.derivedTypes.get(name);
        }
        return type;
    }

    public Collection<Type> getDeclaredTypes() {
        return this.declaredTypes.values();
    }

    public Iterable<Type> getControlledTypes() {
        return Iterables.filteredIterable(this.declaredTypes.values(), t -> t.isControlled());
    }

    public Iterable<Type> getExportableControlledTypes() {
        return Iterables.filteredIterable(this.declaredTypes.values(), t -> t.isExportable() && t.isControlled());
    }

    PackageExportSpecification inferExportSpecification(CompatibilityAccess restrictedAs, boolean resolve) {
        CompatibilityAccess access = this.getMemberAccess(restrictedAs);
        if (access == null) {
            return PackageExportSpecification.NULL_MEMBERS_NULL;
        }
        if (this.containsConsistentAccess(restrictedAs)) {
            switch (access) {
                case EXPORTED: {
                    return PackageExportSpecification.EXPORTED_MEMBERS_EXPORTED;
                }
                case RESTRICTED: {
                    return PackageExportSpecification.RESTRICTED_MEMBERS_RESTRICTED;
                }
                case CONCEALED: {
                    return PackageExportSpecification.CONCEALED_MEMBERS_CONCEALED;
                }
            }
        }
        HashMap<TypeName, TypeExportSpecification> types = new HashMap<TypeName, TypeExportSpecification>();
        HashSet<TypeName> interfaces = new HashSet<TypeName>();
        for (Type type : this.declaredTypes.values()) {
            if (type.isConcealedOrNull(restrictedAs)) continue;
            types.put(type.getName(), type.inferExportSpecification(restrictedAs, resolve));
            if (!type.isInterface()) continue;
            interfaces.add(type.getName());
        }
        return new PackageExportSpecification(CompatibilityAccess.CONCEALED, types, interfaces, null);
    }
}

