/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum Command {
    CREATE{

        @Override
        Object run(Graphics2D g, Object ... o) {
            return g.create();
        }
    }
    ,
    CREATE_INT{

        @Override
        Object run(Graphics2D g, Object ... o) {
            return g.create(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_LINE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawLine(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_STRING_INT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawString(Command.string_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_STRING_FLOAT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawString(Command.string_(o), Command.float_(o), Command.float_(o));
        }
    }
    ,
    DRAW_ATTR_INT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawString(Command.attr_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_ATTR_FLOAT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawString(Command.attr_(o), Command.float_(o), Command.float_(o));
        }
    }
    ,
    TRANSLATE_INT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.translate(Command.int_(o), Command.int_(o));
        }
    }
    ,
    TRANSLATE_DOUBLE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.translate(Command.double_(o), Command.double_(o));
        }
    }
    ,
    SET_COLOR{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setColor(Command.color_(o));
        }
    }
    ,
    SET_FONT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setFont(Command.font_(o));
        }
    }
    ,
    SCALE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.scale(Command.double_(o), Command.double_(o));
        }
    }
    ,
    FILL_OVAL{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.fillOval(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    FILL_RECT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.fillRect(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    CLIP_RECT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.clipRect(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    SET_CLIP_INT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setClip(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    SET_CLIP_SHAPE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setClip(Command.shape_(o));
        }
    }
    ,
    ADD_RENDERING_HINTS{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.addRenderingHints(Command.map_(o));
        }
    }
    ,
    SET_RENDERING_HINTS{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setRenderingHints(Command.map_(o));
        }
    }
    ,
    SET_RENDERING_HINT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setRenderingHint(Command.key_(o), Command.object_(o));
        }
    }
    ,
    DRAW_SHAPE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.draw(Command.shape_(o));
        }
    }
    ,
    FILL_SHAPE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.fill(Command.shape_(o));
        }
    }
    ,
    CLIP_SHAPE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.clip(Command.shape_(o));
        }
    }
    ,
    SET_PAINT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setPaint(Command.paint_(o));
        }
    }
    ,
    SET_STROKE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setStroke(Command.stroke_(o));
        }
    }
    ,
    DRAW_GLYPH_VECTOR{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawGlyphVector(Command.glyphVector_(o), Command.float_(o), Command.float_(o));
        }
    }
    ,
    TRANSFORM{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.transform(Command.transform_(o));
        }
    }
    ,
    SET_TRANSFORM{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setTransform(Command.transform_(o));
        }
    }
    ,
    DRAW_IMAGE_01{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.transform_(o), Command.observer_(o));
        }
    }
    ,
    DRAW_IMAGE_02{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.buffered_(o), Command.op_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_IMAGE_03{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawRenderedImage(Command.rendered_(o), Command.transform_(o));
        }
    }
    ,
    DRAW_IMAGE_04{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawRenderableImage(Command.renderable_(o), Command.transform_(o));
        }
    }
    ,
    DRAW_IMAGE_05{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.int_(o), Command.int_(o), Command.color_(o), Command.observer_(o));
        }
    }
    ,
    DRAW_IMAGE_06{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.int_(o), Command.int_(o), Command.observer_(o));
        }
    }
    ,
    DRAW_IMAGE_07{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.color_(o), Command.observer_(o));
        }
    }
    ,
    DRAW_IMAGE_08{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.observer_(o));
        }
    }
    ,
    DRAW_IMAGE_09{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.color_(o), Command.observer_(o));
        }
    }
    ,
    DRAW_IMAGE_10{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawImage(Command.image_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.observer_(o));
        }
    }
    ,
    HIT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.hit(Command.rectangle_(o), Command.shape_(o), Command.boolean_(o));
        }
    }
    ,
    SET_COMPOSITE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setComposite(Command.composite_(o));
        }
    }
    ,
    ROTATE_01{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.rotate(Command.double_(o));
        }
    }
    ,
    ROTATE_02{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.rotate(Command.double_(o), Command.double_(o), Command.double_(o));
        }
    }
    ,
    SHEAR{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.shear(Command.double_(o), Command.double_(o));
        }
    }
    ,
    SET_BACKGROUND{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setBackground(Command.color_(o));
        }
    }
    ,
    CLEAR_RECT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.clearRect(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    COPY_AREA{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.copyArea(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_ARC{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawArc(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_OVAL{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawOval(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    DRAW_POLYGON{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawPolygon(Command.int_arr_(o), Command.int_arr_(o), Command.int_(o));
        }
    }
    ,
    FILL_POLYGON{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.fillPolygon(Command.int_arr_(o), Command.int_arr_(o), Command.int_(o));
        }
    }
    ,
    DRAW_POLYLINE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawPolyline(Command.int_arr_(o), Command.int_arr_(o), Command.int_(o));
        }
    }
    ,
    DRAW_ROUND_RECT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.drawRoundRect(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    FILL_ROUND_RECT{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.fillRoundRect(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    FILL_ARC{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.fillArc(Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o), Command.int_(o));
        }
    }
    ,
    SET_PAINT_MODE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setPaintMode();
        }
    }
    ,
    SET_XOR_MODE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.setXORMode(Command.color_(o));
        }
    }
    ,
    DISPOSE{

        @Override
        void doRun(Graphics2D g, Object ... o) {
            g.dispose();
        }
    };

    private static int myIndex;

    void doRun(Graphics2D g, Object ... data) {
    }

    Object run(Graphics2D g, Object ... data) {
        return null;
    }

    final Object perform(Graphics2D g, Object ... data) {
        myIndex = 0;
        this.doRun(g, data);
        return this.run(g, data);
    }

    private static int int_(Object[] data) {
        return (Integer)data[myIndex++];
    }

    private static float float_(Object[] data) {
        return ((Float)data[myIndex++]).floatValue();
    }

    private static double double_(Object[] data) {
        return (Double)data[myIndex++];
    }

    private static String string_(Object[] data) {
        return (String)data[myIndex++];
    }

    private static Color color_(Object[] data) {
        return (Color)data[myIndex++];
    }

    private static Font font_(Object[] data) {
        return (Font)data[myIndex++];
    }

    private static Map map_(Object[] data) {
        return (Map)data[myIndex++];
    }

    private static Image image_(Object[] data) {
        return (Image)data[myIndex++];
    }

    private static ImageObserver observer_(Object[] data) {
        return (ImageObserver)data[myIndex++];
    }

    private static Shape shape_(Object[] data) {
        return (Shape)data[myIndex++];
    }

    private static Paint paint_(Object[] data) {
        return (Paint)data[myIndex++];
    }

    private static Stroke stroke_(Object[] data) {
        return (Stroke)data[myIndex++];
    }

    private static GlyphVector glyphVector_(Object[] data) {
        return (GlyphVector)data[myIndex++];
    }

    private static RenderingHints.Key key_(Object[] data) {
        return (RenderingHints.Key)data[myIndex++];
    }

    private static Object object_(Object[] data) {
        return data[myIndex++];
    }

    private static AffineTransform transform_(Object[] data) {
        return (AffineTransform)data[myIndex++];
    }

    private static BufferedImage buffered_(Object[] data) {
        return (BufferedImage)data[myIndex++];
    }

    private static BufferedImageOp op_(Object[] data) {
        return (BufferedImageOp)data[myIndex++];
    }

    private static RenderedImage rendered_(Object[] data) {
        return (RenderedImage)data[myIndex++];
    }

    private static RenderableImage renderable_(Object[] data) {
        return (RenderableImage)data[myIndex++];
    }

    private static AttributedCharacterIterator attr_(Object[] data) {
        return (AttributedCharacterIterator)data[myIndex++];
    }

    private static Rectangle rectangle_(Object[] data) {
        return (Rectangle)data[myIndex++];
    }

    private static boolean boolean_(Object[] data) {
        return (Boolean)data[myIndex++];
    }

    private static Composite composite_(Object[] data) {
        return (Composite)data[myIndex++];
    }

    private static int[] int_arr_(Object[] data) {
        return (int[])data[myIndex++];
    }

    static final class Operation {
        private int myIndex;
        private Object[] myData;
        private Command myCommand;

        Operation(int index, Command command, Object ... data) {
            this.myCommand = command;
            this.myIndex = index;
            this.myData = data;
        }

        Object perform(Graphics2D g) {
            return this.myCommand.perform(g, this.myData);
        }

        int getIndex() {
            return this.myIndex;
        }

        public String toString() {
            String str = this.myIndex + " " + this.myCommand;
            if (this.myData != null) {
                for (Object data : this.myData) {
                    str = str + ", " + data;
                }
            }
            return str;
        }

        public Command getCommand() {
            return this.myCommand;
        }

        public Object[] getData() {
            return this.myData;
        }
    }
}

