/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionMonitor
extends Thread {
    public static int DEFAULT_IDLE_CONNECTION_MONITOR_THREAD_WAIT_TIME_IN_SECONDS = 5;
    private static final Logger LOG = LoggerFactory.getLogger(IdleConnectionMonitor.class);
    private static final Map<WeakReference<HttpClientConnectionManager>, ConnectionMonitorSettings> connectionManagers = new ConcurrentHashMap<WeakReference<HttpClientConnectionManager>, ConnectionMonitorSettings>();
    private static final ReferenceQueue<HttpClientConnectionManager> referenceQueue = new ReferenceQueue();
    static volatile IdleConnectionMonitor instance;
    private volatile boolean shutdown;
    private volatile int waitTimeInSeconds;

    private IdleConnectionMonitor(int waitTimeInSeconds) {
        super("idle-connection-monitor-thread-" + System.currentTimeMillis());
        this.waitTimeInSeconds = waitTimeInSeconds;
        this.shutdown = false;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerConnectionManager(HttpClientConnectionManager connectionManager, int waitTimeInSeconds, int idleTimeoutInSeconds) {
        IdleConnectionMonitor.cleanStaleReferences();
        if (instance == null) {
            Class<IdleConnectionMonitor> clazz = IdleConnectionMonitor.class;
            synchronized (IdleConnectionMonitor.class) {
                if (instance == null) {
                    instance = new IdleConnectionMonitor(waitTimeInSeconds);
                    instance.start();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            IdleConnectionMonitor.instance.waitTimeInSeconds = Math.min(IdleConnectionMonitor.instance.waitTimeInSeconds, waitTimeInSeconds);
        }
        {
            LOG.debug("Registering ConnectionManager {} in IdleConnectionMonitor thread", (Object)connectionManager);
            return connectionManagers.put(new WeakReference<HttpClientConnectionManager>(connectionManager, referenceQueue), new ConnectionMonitorSettings(waitTimeInSeconds, idleTimeoutInSeconds)) == null;
        }
    }

    public static boolean removeConnectionManager(HttpClientConnectionManager connectionManager) {
        IdleConnectionMonitor.cleanStaleReferences();
        boolean wasRemoved = connectionManagers.keySet().removeIf(ref -> ref.get() == connectionManager);
        if (wasRemoved) {
            LOG.debug("Removing ConnectionManager {} from IdleConnectionMonitor thread", (Object)connectionManager);
        }
        if (connectionManagers.isEmpty()) {
            IdleConnectionMonitor.shutdown();
        }
        return wasRemoved;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                IdleConnectionMonitor.cleanStaleReferences();
                this.closeIdleConnections();
                TimeUnit.SECONDS.sleep(this.waitTimeInSeconds);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOG.debug("IdleConnectionMonitorThread was interrupted, terminating", (Throwable)ex);
            }
        }
    }

    public void closeIdleConnections() {
        int minWaitTime = Integer.MAX_VALUE;
        for (Map.Entry<WeakReference<HttpClientConnectionManager>, ConnectionMonitorSettings> entry : connectionManagers.entrySet()) {
            try {
                HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)entry.getKey().get();
                minWaitTime = Math.min(minWaitTime, entry.getValue().getWaitTimeInSeconds());
                if (connectionManager == null) continue;
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections((long)entry.getValue().getIdleTimeoutInSeconds(), TimeUnit.SECONDS);
            }
            catch (Exception t) {
                LOG.warn("Unable to close idle connections", (Throwable)t);
            }
        }
        this.waitTimeInSeconds = minWaitTime != Integer.MAX_VALUE ? minWaitTime : DEFAULT_IDLE_CONNECTION_MONITOR_THREAD_WAIT_TIME_IN_SECONDS;
    }

    public static void cleanStaleReferences() {
        WeakReference ref;
        while ((ref = (WeakReference)referenceQueue.poll()) != null) {
            connectionManagers.remove(ref);
        }
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            LOG.info("Shutting down IdleConnectionMonitor");
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            IdleConnectionMonitor.cleanStaleReferences();
            instance = null;
            return true;
        }
        return false;
    }

    private void markShuttingDown() {
        this.shutdown = true;
    }

    public static int idleConnectionMonitorThreadSize() {
        return connectionManagers.size();
    }

    public int getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    public boolean isIdleMonitorThreadShutdown() {
        return this.shutdown;
    }

    public static IdleConnectionMonitor getInstance() {
        return instance;
    }

    static {
        IdleConnectionMonitor.cleanStaleReferences();
    }

    private static class ConnectionMonitorSettings {
        private final int waitTimeInSeconds;
        private final int idleTimeoutInMillis;

        public ConnectionMonitorSettings(int waitTimeInSeconds, int idleTimeoutInSeconds) {
            this.waitTimeInSeconds = waitTimeInSeconds;
            this.idleTimeoutInMillis = idleTimeoutInSeconds;
        }

        public int getWaitTimeInSeconds() {
            return this.waitTimeInSeconds;
        }

        public int getIdleTimeoutInSeconds() {
            return this.idleTimeoutInMillis;
        }
    }
}

