/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ocsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.ocsp.MalformedRequestException;
import oracle.security.crypto.ocsp.OCSP;
import oracle.security.crypto.ocsp.OCSPUtils;
import oracle.security.crypto.ocsp.SingleRequest;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class OCSPRequest
implements ASN1Object {
    private static final OCSP.OIDRegistrar oidReg = new OCSP.OIDRegistrar();
    private GeneralName requestor = null;
    private Vector reqList = new Vector();
    private X509ExtensionSet reqExts = null;
    private int version = 0;
    private AlgorithmIdentifier sigAlgID = null;
    private byte[] sigBytes = null;
    private Vector sigCerts = null;
    private Vector X509sigCerts = null;
    private ASN1Sequence tbs;
    private ASN1Sequence req;

    public OCSPRequest() {
    }

    public OCSPRequest(SingleRequest request) {
        this.addRequest(request);
    }

    public OCSPRequest(X509Certificate cert, X509Certificate caCert) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.addRequest(cert, caCert);
    }

    public OCSPRequest(X509Certificate cert, X509Certificate caCert, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.addRequest(cert, caCert, hashAlgID);
    }

    public OCSPRequest(InputStream is) throws IOException {
        this.input(is);
    }

    public Enumeration requests() {
        return this.reqList.elements();
    }

    public void addRequest(SingleRequest request) {
        this.reqList.addElement(request);
        this.reset();
    }

    public void addRequest(X509Certificate cert, X509Certificate caCert) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.reqList.addElement(new SingleRequest(cert, caCert));
        this.reset();
    }

    public void addRequest(X509Certificate cert, X509Certificate caCert, AlgorithmIdentifier hashAlgID) throws NoSuchAlgorithmException, CertificateEncodingException {
        this.reqList.addElement(new SingleRequest(cert, caCert, hashAlgID));
        this.reset();
    }

    public void setRequestor(GeneralName name) {
        this.requestor = name;
        this.reset();
    }

    public GeneralName getRequestor() {
        return this.requestor;
    }

    public void addReqExtension(X509Extension ext) {
        if (this.reqExts == null) {
            this.reqExts = new X509ExtensionSet();
        }
        this.reqExts.addExtension(ext);
        this.reset();
    }

    public void setReqExtensions(X509ExtensionSet extensionSet) {
        this.reqExts = extensionSet;
        this.reset();
    }

    public X509Extension getReqExtension(ASN1ObjectID type) {
        if (this.reqExts != null) {
            return this.reqExts.getExtension(type);
        }
        return null;
    }

    public X509ExtensionSet getReqExtensions() {
        return this.reqExts;
    }

    public void sign(PrivateKey signingKey) throws SignatureException {
        try {
            String alg = signingKey.getAlgorithm();
            if (alg.equals("RSA")) {
                alg = "SHA1withRSA";
            } else if (alg.equals("DSA")) {
                alg = "SHA1withDSA";
            }
            Signature sig = Signature.getInstance(alg);
            sig.initSign(signingKey);
            sig.update(Utils.toBytes((Streamable)this.tbsRequest()));
            this.sigAlgID = OCSPUtils.getAlgoID(sig.getAlgorithm());
            this.sigBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex);
        }
        this.resetContents();
    }

    public void sign(PrivateKey signingKey, AlgorithmIdentifier sigAlgID) throws SignatureException {
        try {
            Signature sig = Signature.getInstance(OCSPUtils.getAlgoName(sigAlgID));
            sig.initSign(signingKey);
            sig.update(Utils.toBytes((Streamable)this.tbsRequest()));
            sigAlgID = OCSPUtils.getAlgoID(sig.getAlgorithm());
            this.sigBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex);
        }
        this.resetContents();
    }

    public void addSigVerifyCert(X509Certificate cert) throws CertificateEncodingException {
        if (this.sigCerts == null) {
            this.sigCerts = new Vector();
            this.X509sigCerts = new Vector();
        }
        this.sigCerts.addElement(cert);
        this.X509sigCerts.addElement(OCSPUtils.convertX509(cert));
    }

    public Vector getSigVerifyCerts() {
        return this.sigCerts;
    }

    public AlgorithmIdentifier getSigAlgID() {
        return this.sigAlgID;
    }

    public byte[] getSigBytes() {
        return this.sigBytes;
    }

    public boolean verifySignature(PublicKey verifyKey) throws AuthenticationException {
        try {
            String alg = verifyKey.getAlgorithm();
            if (alg.equals("RSA")) {
                alg = "SHA1withRSA";
            } else if (alg.equals("DSA")) {
                alg = "SHA1withDSA";
            }
            Signature signature = Signature.getInstance(alg);
            signature.initVerify(verifyKey);
            signature.update(Utils.toBytes((Streamable)this.tbsRequest()));
            return signature.verify(this.sigBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            AuthenticationException ex1 = new AuthenticationException(ex.toString());
            ex1.initCause((Throwable)ex);
            throw ex1;
        }
        catch (InvalidKeyException ex) {
            AuthenticationException ex1 = new AuthenticationException(ex.toString());
            ex1.initCause((Throwable)ex);
            throw ex1;
        }
        catch (SignatureException ex) {
            AuthenticationException ex1 = new AuthenticationException(ex.toString());
            ex1.initCause((Throwable)ex);
            throw ex1;
        }
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        try {
            ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
            this.inputTbsRequest((InputStream)seq);
            if (seq.getCurrentTag() == 0) {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
                ASN1SequenceInputStream sigSeq = new ASN1SequenceInputStream((InputStream)cis);
                this.sigAlgID = new AlgorithmIdentifier((InputStream)sigSeq);
                this.sigBytes = ASN1BitString.inputValue((InputStream)sigSeq);
                if (sigSeq.getCurrentTag() == 0) {
                    ASN1ConstructedInputStream cisCerts = new ASN1ConstructedInputStream((InputStream)sigSeq, 0);
                    ASN1SequenceInputStream certsSeq = new ASN1SequenceInputStream((InputStream)cisCerts);
                    this.sigCerts = new Vector();
                    this.X509sigCerts = new Vector();
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        while (certsSeq.hasMoreData()) {
                            X509 X509Cert = new X509((InputStream)certsSeq);
                            this.sigCerts.addElement(cf.generateCertificate(new ByteArrayInputStream(X509Cert.getEncoded())));
                            this.X509sigCerts.addElement(X509Cert);
                        }
                    }
                    catch (CertificateException ex) {
                        throw new IOException(ex.toString());
                    }
                    certsSeq.terminate();
                    cisCerts.terminate();
                }
                sigSeq.terminate();
                cis.terminate();
            } else {
                this.sigAlgID = null;
                this.sigBytes = null;
                this.sigCerts = null;
                this.X509sigCerts = null;
            }
            seq.terminate();
        }
        catch (ASN1FormatException ex) {
            throw new MalformedRequestException(ex.toString());
        }
    }

    private void inputTbsRequest(InputStream is) throws IOException {
        ASN1ConstructedInputStream cis;
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (seq.getCurrentTag() == 0) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 0);
            this.version = ASN1Integer.inputValue((InputStream)cis).intValue();
            if (this.version != 0) {
                throw new VersionException("Invalid version number");
            }
            cis.terminate();
        } else {
            this.version = 0;
        }
        if (seq.getCurrentTag() == 1) {
            cis = new ASN1ConstructedInputStream((InputStream)seq, 1);
            this.requestor = new GeneralName((InputStream)cis);
            cis.terminate();
        } else {
            this.requestor = null;
        }
        ASN1SequenceInputStream reqSeq = new ASN1SequenceInputStream((InputStream)seq);
        this.reqList = new Vector();
        while (reqSeq.hasMoreData()) {
            this.reqList.addElement(new SingleRequest((InputStream)reqSeq));
        }
        reqSeq.terminate();
        if (seq.getCurrentTag() == 2) {
            ASN1ConstructedInputStream cis2 = new ASN1ConstructedInputStream((InputStream)seq, 2);
            this.reqExts = new X509ExtensionSet((InputStream)cis2);
            cis2.terminate();
        } else {
            this.reqExts = null;
        }
        seq.terminate();
    }

    private ASN1Sequence tbsRequest() {
        if (this.tbs != null) {
            return this.tbs;
        }
        this.tbs = new ASN1Sequence();
        if (this.version != 0) {
            this.tbs.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1Integer((long)this.version), 0));
        }
        if (this.requestor != null) {
            this.tbs.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.requestor, 1));
        }
        ASN1Sequence list = new ASN1Sequence();
        Enumeration e = this.reqList.elements();
        while (e.hasMoreElements()) {
            list.addElement((ASN1Object)((SingleRequest)e.nextElement()));
        }
        this.tbs.addElement((ASN1Object)list);
        if (this.reqExts != null) {
            this.tbs.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)this.reqExts, 2));
        }
        return this.tbs;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.req != null) {
            return this.req;
        }
        ASN1Sequence req = new ASN1Sequence();
        req.addElement((ASN1Object)this.tbsRequest());
        if (this.sigBytes != null) {
            ASN1Sequence sig = new ASN1Sequence();
            sig.addElement((ASN1Object)this.sigAlgID);
            sig.addElement((ASN1Object)new ASN1BitString(this.sigBytes));
            if (this.sigCerts != null && this.sigCerts.size() > 0) {
                ASN1Sequence certs = new ASN1Sequence();
                Enumeration e = this.X509sigCerts.elements();
                while (e.hasMoreElements()) {
                    certs.addElement((ASN1Object)((X509)e.nextElement()));
                }
                sig.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)certs, 0));
            }
            req.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)sig, 0));
        }
        return req;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void reset() {
        this.tbs = null;
        this.resetContents();
    }

    private void resetContents() {
        this.req = null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("OCSP Request: ");
        Enumeration e = this.reqList.elements();
        while (e.hasMoreElements()) {
            s.append(e.nextElement());
            s.append("; ");
        }
        if (this.requestor != null) {
            s.append("requestor = " + this.requestor + ";");
        }
        if (this.reqExts != null) {
            s.append("request extensions : " + this.reqExts);
        }
        return s.toString();
    }
}

