/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.properties;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bali.inspector.JavaBeansPropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.annotations.MarkerAttribute;
import oracle.ide.model.LabelProvider;
import oracle.ideimpl.markers.properties.MarkerProperty;
import oracle.javatools.patterns.Operator;
import oracle.javatools.util.ClassHierarchyVisitor;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Pair;

public class MarkerPropertyModel
extends PropertyModel {
    static final Map<Class<? extends Marker>, MarkerPropertyGroup> GROUPS_BY_CLASS = Collections.synchronizedMap(new HashMap());
    private static Object[] COLUMN_MAPPING;
    private static Map<Object, Operator<MarkerProperty, ?>> GETTER_STRATEGIES;
    private static Map<Object, Operator<Pair<MarkerProperty, Object>, Boolean>> SETTER_STRATEGIES;
    private final transient Marker marker;
    private transient List<MarkerProperty> markerProperties;

    public MarkerPropertyModel(Marker marker) {
        this.marker = marker;
        this.initPropertyRows();
    }

    public Object[] getColumnMapping() {
        return COLUMN_MAPPING;
    }

    public String getTargetDisplayName() {
        return this.marker.getShortLabel();
    }

    public void invalidateValueData() {
    }

    public int getRowCount() {
        return null != this.markerProperties ? this.markerProperties.size() : 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        MarkerProperty property = this.markerProperties.get(rowIndex);
        if (null == property) {
            return null;
        }
        Object columnID = COLUMN_MAPPING[columnIndex];
        Operator<MarkerProperty, ?> operator = GETTER_STRATEGIES.get(columnID);
        return null != operator ? operator.operate((Object)property) : DOES_NOT_EXIST;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object columnID;
        Operator<Pair<MarkerProperty, Object>, Boolean> operator;
        MarkerProperty property = this.markerProperties.get(rowIndex);
        if (null != property && null != (operator = SETTER_STRATEGIES.get(columnID = COLUMN_MAPPING[columnIndex])) && ((Boolean)operator.operate((Object)new Pair((Object)property, aValue))).booleanValue()) {
            this.firePropertyModelUpdate(new PropertyModelUpdateEvent(new Object[]{COLUMN_VALUE}));
        }
    }

    private void initPropertyRows() {
        if (null == this.marker) {
            return;
        }
        MarkerPropertyCollector collector = new MarkerPropertyCollector(this.marker);
        ClassHierarchyVisitor visitor = new ClassHierarchyVisitor((Operator)collector, ClassHierarchyVisitor.VisitOrder.INTERFACES_FIRST_PREORDER);
        visitor.visit(new Class[]{this.marker.getClass()});
        this.markerProperties = new ArrayList<MarkerProperty>(collector.properties.values());
    }

    static {
        GETTER_STRATEGIES = new HashMap();
        GETTER_STRATEGIES.put(COLUMN_NAME, new MarkerAttributeStringGetterStrategy(){

            @Override
            protected String getValue(MarkerAttribute attr) {
                return attr.name();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_DISPLAY_NAME, new MarkerAttributeStringGetterStrategy(){

            @Override
            protected String getValue(MarkerAttribute attr) {
                return attr.name();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_DEFAULT_VALUE, new MarkerAttributeStringGetterStrategy(){

            @Override
            protected String getValue(MarkerAttribute attr) {
                return attr.defaultValue();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_DESCRIPTION, new MarkerAttributeStringGetterStrategy(){

            @Override
            protected String getValue(MarkerAttribute attr) {
                return attr.description();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_ID, new MarkerAttributeStringGetterStrategy(){

            @Override
            protected String getValue(MarkerAttribute attr) {
                return attr.id();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_IS_WRITABLE, new MarkerAttributeBooleanGetterStrategy(){

            @Override
            protected boolean getValue(MarkerAttribute attr) {
                return false;
            }
        });
        GETTER_STRATEGIES.put(COLUMN_MANDATORY, new MarkerAttributeBooleanGetterStrategy(){

            @Override
            protected boolean getValue(MarkerAttribute attr) {
                return true == attr.required();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_VALUE, new Operator<MarkerProperty, Object>(){

            public Object operate(MarkerProperty property) {
                try {
                    return property.getterMethod.invoke((Object)property.marker, (Object[])null);
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                    return null;
                }
            }
        });
        GETTER_STRATEGIES.put(COLUMN_DISPLAY_VALUE, new Operator<MarkerProperty, Object>(){

            public Object operate(MarkerProperty property) {
                LabelProvider provider = (LabelProvider)AdapterManager.Factory.getAdapterManager().adapt((Object)property.marker, LabelProvider.class);
                if (null == provider) {
                    return PropertyModel.DOES_NOT_EXIST;
                }
                return provider.labelFor((Object)property.marker, property.attribute.id());
            }
        });
        GETTER_STRATEGIES.put(COLUMN_VALUE_CLASS, new Operator<MarkerProperty, Class<?>>(){

            public Class<?> operate(MarkerProperty property) {
                return property.getterMethod.getReturnType();
            }
        });
        GETTER_STRATEGIES.put(COLUMN_GROUP, new Operator<MarkerProperty, PropertyGroup>(){

            public PropertyGroup operate(MarkerProperty property) {
                return GROUPS_BY_CLASS.get(property.markerClass);
            }
        });
        GETTER_STRATEGIES.put(COLUMN_EDITOR_FACTORY_2, new Operator<MarkerProperty, Object>(){

            public Object operate(MarkerProperty property) {
                PropertyEditorFactory2 factory = (PropertyEditorFactory2)AdapterManager.Factory.getAdapterManager().adapt((Object)property, PropertyEditorFactory2.class);
                if (null != factory) {
                    return factory;
                }
                PropertyEditor editor = (PropertyEditor)AdapterManager.Factory.getAdapterManager().adapt((Object)property, PropertyEditor.class);
                if (null != editor) {
                    return new JavaBeansPropertyEditorAdapter(editor);
                }
                editor = PropertyEditorManager.findEditor(property.getterMethod.getReturnType());
                if (null != editor) {
                    return new JavaBeansPropertyEditorAdapter(editor);
                }
                return PropertyModel.DOES_NOT_EXIST;
            }
        });
        GETTER_STRATEGIES.put(COLUMN_IS_HIDDEN, new Operator<MarkerProperty, Boolean>(){

            public Boolean operate(MarkerProperty obj) {
                return false;
            }
        });
        COLUMN_MAPPING = GETTER_STRATEGIES.keySet().toArray();
        SETTER_STRATEGIES = new HashMap<Object, Operator<Pair<MarkerProperty, Object>, Boolean>>();
        SETTER_STRATEGIES.put(COLUMN_VALUE, new Operator<Pair<MarkerProperty, Object>, Boolean>(){

            public Boolean operate(Pair<MarkerProperty, Object> pair) {
                try {
                    ((MarkerProperty)pair.first).setterMethod.invoke((Object)((MarkerProperty)pair.first).marker, pair.second);
                }
                catch (Exception e) {
                    FeedbackManager.reportException((Throwable)e);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    private static class MarkerPropertyCollector
    implements Operator<Class<?>[], Void> {
        private final Map<String, MarkerProperty> properties = new HashMap<String, MarkerProperty>();
        private final Marker marker;

        public MarkerPropertyCollector(Marker marker) {
            this.marker = marker;
        }

        public Void operate(Class<?>[] classes) {
            if (null == classes || 0 == classes.length) {
                return null;
            }
            for (Class<?> _class : classes) {
                Method[] declaredMethods;
                for (Method method : declaredMethods = _class.getDeclaredMethods()) {
                    Class<?> retType;
                    MarkerAttribute attr = method.getAnnotation(MarkerAttribute.class);
                    if (null == attr) continue;
                    MarkerProperty property = this.properties.get(method.getName());
                    if (null == property) {
                        property = new MarkerProperty(this.marker);
                        property.markerClass = _class;
                        if (!GROUPS_BY_CLASS.containsKey(_class)) {
                            GROUPS_BY_CLASS.put(_class, new MarkerPropertyGroup(_class));
                        }
                        this.properties.put(method.getName(), property);
                    }
                    if (ModelUtil.hasLength((String)attr.name())) {
                        property.attribute = attr;
                    }
                    if (null == (retType = method.getReturnType()) || Void.TYPE.equals(retType)) {
                        property.setterMethod = method;
                        continue;
                    }
                    property.getterMethod = method;
                }
            }
            return null;
        }
    }

    private static class MarkerPropertyGroup
    implements PropertyGroup {
        private final Class<? extends Marker> markerClass;

        public MarkerPropertyGroup(Class<? extends Marker> markerClass) {
            this.markerClass = markerClass;
        }

        public String getName(Locale locale) {
            return this.markerClass.getSimpleName();
        }
    }

    private static abstract class MarkerAttributeBooleanGetterStrategy
    implements Operator<MarkerProperty, Boolean> {
        private MarkerAttributeBooleanGetterStrategy() {
        }

        public Boolean operate(MarkerProperty property) {
            return this.getValue(property.attribute);
        }

        protected abstract boolean getValue(MarkerAttribute var1);
    }

    private static abstract class MarkerAttributeStringGetterStrategy
    implements Operator<MarkerProperty, String> {
        private MarkerAttributeStringGetterStrategy() {
        }

        public String operate(MarkerProperty property) {
            String value;
            String string = value = null != property.attribute ? this.getValue(property.attribute) : null;
            if (ModelUtil.hasLength((String)value)) {
                return value;
            }
            return "";
        }

        protected abstract String getValue(MarkerAttribute var1);
    }
}

