/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.usage.UsageData;
import oracle.dbtools.raptor.usage.UsagesTracker;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.model.Node;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;

public class EditorTracker
implements EditorListener,
ActiveViewListener {
    private ArrayList<WeakReference> _reported = new ArrayList();

    EditorTracker() {
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorOpened(Editor editor) {
        this.reportUsage((View)editor);
    }

    public void editorClosed(Editor editor) {
    }

    private void reportUsage(View view) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        UsageData usageData = UsagesTracker.getUsagesTracker().createUsageData();
        usageData.setEventId("editor-open");
        usageData.setSource(view.getClass().getName());
        Context context = view.getContext();
        if (context != null) {
            Node node = context.getNode();
            if (node instanceof ViewerNode) {
                DBObject dBObject = ((ViewerNode)node).getDBObject();
                hashMap.put("object-type", dBObject.getObjectType());
                if (view instanceof Editor) {
                    hashMap.put("editor-tab", ((Editor)view).getTabLabel());
                }
            }
            if (node != null) {
                hashMap.put("node-class", node.getClass().getName());
            } else {
                hashMap.put("node-class", view.getClass().getName());
            }
        }
        usageData.addDataPoint("values", hashMap);
        UsagesTracker.getUsagesTracker().report(usageData);
    }

    private boolean reported(Object object) {
        for (WeakReference weakReference : this._reported) {
            if (object != weakReference.get()) continue;
            return true;
        }
        return false;
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        View view = activeViewEvent.getNewView();
        boolean bl = this.reported(view);
        if (!bl) {
            this.reportUsage(view);
            this._reported.add(new WeakReference<View>(view));
        }
    }
}

