/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ide.extension.Extension;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.cmd.IdeSettingsCommand;
import oracle.ide.config.SettingsUIHook;
import oracle.ide.config.SettingsUIRegistry;
import oracle.ide.panels.Traversable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class IndexedPreferencesCommand
extends IdeSettingsCommand {
    private static Collection<String> indexedPages = new ArrayList<String>();
    private static boolean initialized;
    private static boolean fired;

    public int doit() throws Exception {
        fired = true;
        Logger.info(((Object)((Object)this)).getClass(), (String)"doit()");
        if (initialized) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)new IndexPreferencesTask());
        }
        return 0;
    }

    public void init() {
        Logger.info(((Object)((Object)this)).getClass(), (String)"init()");
        RaptorTaskManager.getInstance().addTask((RaptorTask)new IndexPreferencesTask());
    }

    class IndexPreferencesTask
    extends RaptorTask<Void> {
        public IndexPreferencesTask() {
            super(IndexPreferencesTask.class.getSimpleName(), true, IRaptorTaskRunMode.IDE_STATUSBAR);
            this.getDescriptor().addListener((IRaptorTaskListener)new WaitOver());
            this.getDescriptor().setMessage(this.getDescriptor().getName());
        }

        protected Void doWork() throws TaskException {
            long l = System.currentTimeMillis();
            try {
                Object object2;
                ArrayList<String> arrayList;
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                SettingsUIHook settingsUIHook = (SettingsUIHook)extensionRegistry.getHook(SettingsUIHook.ELEMENT);
                Collection collection = settingsUIHook.getExtensionSettingsUI().getPages();
                Collection collection2 = SettingsUIRegistry.getCustomizations().getHiddenPages();
                HashMap<Object, ArrayList<String>> hashMap = new HashMap<Object, ArrayList<String>>();
                HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
                for (Object object3 : collection) {
                    String string2 = object3.getIdPath();
                    if (indexedPages.contains(string2) || collection2.contains(string2) || !string2.startsWith("/preferences")) continue;
                    Logger.fine(((Object)((Object)this)).getClass(), (String)string2);
                    this.checkCanProceed();
                    arrayList = new ArrayList<String>();
                    this.addIndexTerm(arrayList, this.asIndexTerm(object3.getSearchTags()));
                    try {
                        Object object4;
                        Traversable traversable;
                        Component component;
                        object2 = object3.getTraversableClass();
                        Extension extension = extensionRegistry.findExtensionByClassLoader(object2.getClassLoader());
                        if (null == extension || !extensionRegistry.isFullyLoaded(extension) || !((component = (traversable = (Traversable)object2.newInstance()).getComponent()) instanceof JComponent)) continue;
                        List list = UIUtils.findAllOfType((JComponent)((JComponent)component), JLabel.class);
                        for (Object object4 : list) {
                            this.addIndexTerm(arrayList, this.asIndexTerm(((JLabel)object4).getText()));
                        }
                        List list2 = UIUtils.findAllOfType((JComponent)((JComponent)component), AbstractButton.class);
                        object4 = list2.iterator();
                        while (object4.hasNext()) {
                            AbstractButton abstractButton = (AbstractButton)object4.next();
                            this.addIndexTerm(arrayList, this.asIndexTerm(abstractButton.getText()));
                        }
                    }
                    catch (Throwable throwable) {
                        Logger.warn(((Object)((Object)this)).getClass(), (Throwable)throwable);
                    }
                    hashMap.put(object3, arrayList);
                    for (String string3 : arrayList) {
                        if (hashMap2.containsKey(string3)) {
                            hashMap2.put(string3, (Integer)hashMap2.get(string3) + 1);
                            continue;
                        }
                        hashMap2.put(string3, 1);
                    }
                }
                try {
                    final Field field = HashStructureAdapter.class.getDeclaredField("_hash");
                    if (field != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                field.setAccessible(true);
                                return null;
                            }
                        });
                    }
                    for (String string2 : hashMap.keySet()) {
                        arrayList = (ArrayList<String>)hashMap.get(string2);
                        arrayList.removeIf(string -> 20 < (Integer)hashMap2.get(string));
                        object2 = ((Object)arrayList).toString().substring(1, ((Object)arrayList).toString().length() - 1);
                        HashStructure hashStructure = (HashStructure)field.get(string2);
                        hashStructure.putString("search-tags", (String)object2);
                        indexedPages.add(string2.getIdPath());
                    }
                }
                catch (Throwable throwable) {
                    Logger.warn(((Object)((Object)this)).getClass(), (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)throwable);
                throw new TaskException(throwable);
            }
            finally {
                Logger.info(((Object)((Object)this)).getClass(), (String)(((Object)((Object)this)).getClass().getSimpleName() + ": " + String.valueOf(System.currentTimeMillis() - l) + "ms " + indexedPages.size() + " pages indexed"));
            }
            return null;
        }

        private void addIndexTerm(List<String> list, String string) {
            if (ModelUtil.hasLength((String)string) && !list.contains(string)) {
                list.add(string);
            }
        }

        private String asIndexTerm(String string) {
            if (ModelUtil.hasLength((String)string) && (string = string.trim().toLowerCase()).endsWith(":")) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        protected void invokeLater() {
            if (fired) {
                Logger.info(((Object)((Object)this)).getClass(), (String)"firing");
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow());
            }
        }

        private class WaitOver
        extends RaptorTaskAdapter {
            private WaitOver() {
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                initialized = true;
                Logger.info(((Object)((Object)this)).getClass(), (String)"initialized");
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        IndexPreferencesTask.this.invokeLater();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

