/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.jdevimpl.vcs.util.res.UtilArb;

public class OpenApplicationPanel
extends JPanel {
    private ApplicationGenericTable _table = new ApplicationGenericTable();
    private JEWTDialog _dialog;
    private String[] _columns = new String[]{UtilArb.get("OPEN_APPLICATION_COLUMN")};

    public OpenApplicationPanel(Collection<URL> urls) {
        ApplicationInfo[][] data = this.getDisplayData(urls);
        this._table.setModel((TableModel)((Object)new ApplicationModel(data, this._columns)));
        this.init();
        this._table.setSorted(true);
        this._table.setDefaultRenderer(Object.class, (TableCellRenderer)new GenericTableCellRenderer((TableCellRenderer)new ApplicationTableCellRenderer()));
    }

    public Collection<URL> getOpenApplications() {
        ApplicationModel model = (ApplicationModel)((Object)this._table.getModel());
        return model.getOpenApplications();
    }

    public void setDialog(JEWTDialog dialog) {
        this._dialog = dialog;
    }

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane((Component)((Object)this._table)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this._table.autoSizeColumnsToFit();
        this.addListener();
    }

    private void addListener() {
        this._table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Collection<URL> openApps = ((ApplicationModel)((Object)OpenApplicationPanel.this._table.getModel())).getOpenApplications();
                if (openApps.isEmpty() && OpenApplicationPanel.this._dialog != null) {
                    OpenApplicationPanel.this._dialog.setOKButtonEnabled(false);
                } else {
                    OpenApplicationPanel.this._dialog.setOKButtonEnabled(true);
                }
            }
        });
    }

    private ApplicationInfo[][] getDisplayData(Collection<URL> appUrls) {
        ApplicationInfo[][] data = new ApplicationInfo[appUrls.size()][1];
        int row = 0;
        Iterator<URL> it = appUrls.iterator();
        while (it.hasNext()) {
            data[row][0] = new ApplicationInfo(it.next());
            ++row;
        }
        return data;
    }

    private static class ApplicationGenericTable
    extends GenericTable
    implements KeyListener,
    MouseListener {
        private ApplicationCellEditor _editorCheckBox = new ApplicationCellEditor();

        public ApplicationGenericTable() {
            super.addKeyListener((KeyListener)this);
            super.addMouseListener((MouseListener)this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this._editorCheckBox.toggleCheckbox();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int checkWidth;
            TableCellRenderer renderer;
            Component comp;
            Point point = e.getPoint();
            int row = this.rowAtPoint(point);
            if (row != -1 && (comp = (renderer = this.getCellRenderer(row, 0)).getTableCellRendererComponent((JTable)((Object)this), this.getModel().getValueAt(this.convertRowIndexToModel(row), 0), this.isCellSelected(row, 0), false, row, 0)) instanceof JLabeledCheckBox && point.x < (checkWidth = ((JLabeledCheckBox)comp).checkBox.getWidth())) {
                this.setEditingRow(row);
                this.setEditingColumn(0);
                this._editorCheckBox.toggleCheckbox();
                Rectangle rect = this.getCellRect(row, 0, true);
                this.repaint(rect);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 0) {
                return this._editorCheckBox;
            }
            return super.getCellEditor(row, column);
        }

        private class ApplicationCellEditor
        extends DefaultCellEditor
        implements TableCellEditor {
            private JLabeledCheckBox _component;
            private ApplicationInfo _info;

            public ApplicationCellEditor() {
                super(new JTextField());
                this._component = new JLabeledCheckBox();
            }

            @Override
            public Object getCellEditorValue() {
                return this._info;
            }

            @Override
            public Component getComponent() {
                return this._component;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof ApplicationInfo) {
                    this._info = (ApplicationInfo)value;
                    this._component.checkBox.setSelected(this._info._include);
                    this._component.label.setText(this._info._display);
                    this._component.label.setSelected(true);
                }
                return this._component;
            }

            public void toggleCheckbox() {
                TableModel model = ApplicationGenericTable.this.getModel();
                int modelRow = ApplicationGenericTable.this.convertRowIndexToModel(ApplicationGenericTable.this.getEditingRow());
                ApplicationInfo data = (ApplicationInfo)model.getValueAt(modelRow, 0);
                boolean checkboxValue = data._include;
                data._include = checkboxValue = !checkboxValue;
                model.setValueAt(data, modelRow, 0);
                this._component.checkBox.setSelected(checkboxValue);
            }
        }
    }

    private class ApplicationInfo
    implements Comparable<ApplicationInfo> {
        private URL _url;
        private boolean _include;
        private String _display;

        ApplicationInfo(URL url) {
            this._url = url;
            this._include = true;
            this._display = URLFileSystem.getFileName((URL)url);
        }

        @Override
        public int compareTo(ApplicationInfo o) {
            return this._display.compareTo(o._display);
        }

        public String toString() {
            return this._display;
        }
    }

    private class ApplicationModel
    extends GenericBaseTableModel {
        private ApplicationModel(ApplicationInfo[][] data, String[] columns) {
            super((Object[][])data, (Object[])columns);
        }

        public Comparator getColumnSortComparator(int column) {
            return new ListComparator();
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (aValue instanceof ApplicationInfo) {
                super.setValueAt(aValue, row, column);
            }
        }

        private Collection<URL> getOpenApplications() {
            ArrayList<URL> openApps = new ArrayList<URL>();
            for (int row = 0; row < this.getRowCount(); ++row) {
                ApplicationInfo data = (ApplicationInfo)this.getValueAt(row, 0);
                if (!data._include) continue;
                openApps.add(data._url);
            }
            return openApps;
        }

        private class ListComparator
        implements Comparator {
            private ListComparator() {
            }

            public int compare(Object o1, Object o2) {
                ApplicationInfo app1 = (ApplicationInfo)o1;
                ApplicationInfo app2 = (ApplicationInfo)o2;
                return app1.compareTo(app2);
            }
        }
    }

    private static class ApplicationTableCellRenderer
    extends DefaultTableCellRenderer {
        private JLabeledCheckBox _check = new JLabeledCheckBox();

        private ApplicationTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column > 0) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (value instanceof ApplicationInfo) {
                ApplicationInfo info = (ApplicationInfo)value;
                this._check.label.setEnabled(true);
                this._check.checkBox.setEnabled(true);
                this._check.checkBox.setSelected(info._include);
                this._check.label.setSelected(isSelected);
                this._check.label.setText(info._display);
                this._check.label.setHasFocus(hasFocus);
                this._check.setToolTipText(info._url.getPath());
                this._check.checkBox.setOpaque(false);
                this._check.label.setOpaque(false);
            }
            return this._check;
        }
    }
}

