/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.merge;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.layout.VerticalFlowLayout;
import oracle.jdevimpl.merge.MergeOptions;
import oracle.jdevimpl.resource.MergeArb;

public final class MergePreferencesPanel
extends DefaultTraversablePanel {
    private final JCheckBox _xmlMergeCheckBox = new JCheckBox();
    private final JLabel _maxFileSizeLabel = new JLabel();
    private final JSpinner _maxFileSizeSpinner = new JSpinner();
    private final JCheckBox _reformatResultCheckBox = new JCheckBox();
    private final JCheckBox _validateMergeCheckBox = new JCheckBox();
    private JPanel _panel;

    public MergePreferencesPanel() {
        int step = (int)Math.pow(2.0, 2.0);
        this._maxFileSizeSpinner.setModel(new SpinnerNumberModel(step, step, (int)Math.pow(2.0, 10.0), step));
        JComponent editor = this._maxFileSizeSpinner.getEditor();
        Dimension size = this._maxFileSizeSpinner.getEditor().getPreferredSize();
        size.width = SwingUtilities.computeStringWidth(editor.getFontMetrics(editor.getFont()), "1,234,567");
        this._maxFileSizeSpinner.getEditor().setPreferredSize(size);
        JFormattedTextField field = ((JSpinner.DefaultEditor)this._maxFileSizeSpinner.getEditor()).getTextField();
        JFormattedTextField.AbstractFormatter format = field.getFormatter();
        ((DefaultFormatter)format).setAllowsInvalid(false);
        this._maxFileSizeSpinner.setToolTipText(MergeArb.format("MERGE_MAX_VALUE", ((SpinnerNumberModel)this._maxFileSizeSpinner.getModel()).getMaximum()));
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._xmlMergeCheckBox, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._reformatResultCheckBox, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._validateMergeCheckBox, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._maxFileSizeLabel, insets, 1, false, true);
        layoutBuilder.add((Component)this._maxFileSizeSpinner, insets, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        this._panel = new JPanel();
        layoutBuilder.addToPanel((Container)this._panel);
        ResourceUtils.resButton((AbstractButton)this._xmlMergeCheckBox, (String)MergeArb.get("MERGE_OPTIONS_XML_MERGE"));
        ResourceUtils.resLabel((JLabel)this._maxFileSizeLabel, (Component)this._maxFileSizeSpinner, (String)MergeArb.get("MERGE_OPTIONS_MAX_FILE_SIZE"));
        ResourceUtils.resButton((AbstractButton)this._reformatResultCheckBox, (String)MergeArb.get("REFORMAT_RESULT"));
        ResourceUtils.resButton((AbstractButton)this._validateMergeCheckBox, (String)MergeArb.get("VALIDATE_RESULT"));
        this._xmlMergeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MergePreferencesPanel.this.updateComponentsEnabled();
            }
        });
        this.updateComponentsEnabled();
        this.setHelpID("f1_idedidesetmerge_html");
    }

    public Component getComponent() {
        if (this._panel != null) {
            this.setLayout((LayoutManager)new VerticalFlowLayout(0, 5, 0, true, false));
            this.addToLayout();
            this.add(Box.createGlue());
            this._panel = null;
        }
        return this;
    }

    protected void addToLayout() {
        this.add(this._panel);
    }

    private void updateComponentsEnabled() {
        boolean xmlMergeEnabled = this._xmlMergeCheckBox.isSelected();
        this._maxFileSizeLabel.setEnabled(xmlMergeEnabled);
        this._maxFileSizeSpinner.setEnabled(xmlMergeEnabled);
        this._reformatResultCheckBox.setEnabled(xmlMergeEnabled);
        this._validateMergeCheckBox.setEnabled(xmlMergeEnabled);
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        MergeOptions options = MergePreferencesPanel.getMergeOptions(tc);
        this._xmlMergeCheckBox.setSelected(options.isXMLMergeEnabled());
        this._maxFileSizeSpinner.setValue(options.getMaximumFileSize());
        this._reformatResultCheckBox.setSelected(options.isReformatResult());
        this._validateMergeCheckBox.setSelected(options.isValidateResult());
        this.updateComponentsEnabled();
    }

    public void onExit(TraversableContext tc) {
        MergeOptions options = MergePreferencesPanel.getMergeOptions(tc);
        options.setXMLMergeEnabled(this._xmlMergeCheckBox.isSelected());
        options.setMaximumFileSize(((Number)this._maxFileSizeSpinner.getValue()).intValue());
        options.setReformatResult(this._reformatResultCheckBox.isSelected());
        options.setValidateResult(this._validateMergeCheckBox.isSelected());
    }

    private static MergeOptions getMergeOptions(TraversableContext tc) {
        return MergeOptions.getInstance((PropertyStorage)tc.getPropertyStorage());
    }
}

