/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.io.IOException;
import java.net.URL;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.diffmerge.diff3.Diff3Format;
import oracle.ide.diffmerge.diff3.Diff3Model;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.EditableTextCompareContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.compare.view.ViewEdit;
import oracle.javatools.compare.view.wedge.WedgeCompareView;
import oracle.javatools.editor.BasicDocument;
import oracle.jdeveloper.compare.FileNotComparableException;
import oracle.jdeveloper.compare.FileTooLargeException;
import oracle.jdeveloper.merge.BaseMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.merge.SaveMergeCommand;
import oracle.jdeveloper.merge.TextMergeContributor;
import oracle.jdeveloper.merge.TextMergeNode;
import oracle.jdeveloper.resource.MergeArb;
import oracle.jdevimpl.merge.MergeValidator;
import oracle.jdevimpl.merge.MergeValidatorFactory;

public abstract class BaseTextMergeEditor
extends BaseMergeEditor
implements CompareToolTipProvider {
    private NodeUpdater _ancestorUpdater;
    private TextBuffer _resultTextBuffer;
    private Diff3Model _diff3Model;
    private MergeValidator _validator;

    protected Diff3Model getDiff3Model() {
        return this._diff3Model;
    }

    @Override
    protected void initializeMergeView(CompareView mergeView) {
        if (mergeView instanceof WedgeCompareView) {
            ((WedgeCompareView)mergeView).setToolTipProvider((CompareToolTipProvider)this);
        }
    }

    private void clearAnnotationsSS() {
        if (this._diff3Model == null) {
            return;
        }
        if (this._diff3Model.getSourceAnnotations() != null) {
            this._diff3Model.getSourceAnnotations().clear();
        }
        if (this._diff3Model.getTargetAnnotations() != null) {
            this._diff3Model.getTargetAnnotations().clear();
        }
    }

    protected Class getAnnotationClassSS() {
        return Diff3Model.Annotation.class;
    }

    protected String createFirstContributorLabelSS() {
        StringBuilder labelBuffer = new StringBuilder();
        for (Object annotation : this._diff3Model.getSourceAnnotations().values()) {
            if (labelBuffer.length() > 0) {
                labelBuffer.append(',');
            }
            labelBuffer.append(annotation.toString());
        }
        return labelBuffer.toString();
    }

    public String getToolTipText(ContributorKind contributorKind, CompareDifference difference) {
        if (this._diff3Model == null) {
            return null;
        }
        if (!(difference instanceof SequenceCompareDifference)) {
            return null;
        }
        Object annotation = null;
        if (contributorKind == ContributorKind.FIRST) {
            annotation = this._diff3Model.getSourceAnnotations().get(((SequenceCompareDifference)difference).getId());
        }
        if (contributorKind == ContributorKind.SECOND) {
            annotation = this._diff3Model.getTargetAnnotations().get(((SequenceCompareDifference)difference).getId());
        }
        if (annotation != null) {
            return MergeArb.format("MERGE_DIFFERENCE_ANNOTATION", annotation.toString());
        }
        return null;
    }

    @Override
    public void close() {
        super.close();
        this.clearAnnotationsSS();
    }

    @Override
    protected boolean validateContent(CompareModel model) throws IOException {
        return this.getValidator().isValid(this.owner().getGUI(), this.getRealURL(), model);
    }

    @Override
    protected void installUndoableEditListener() {
        Node node;
        Document jdkDoc;
        super.installUndoableEditListener();
        Document document = jdkDoc = this.getCompareView() != null && this.getCompareView() instanceof WedgeCompareView ? ((WedgeCompareView)this.getCompareView()).getDocument(ContributorKind.ANCESTOR) : null;
        if (jdkDoc instanceof BasicDocument && (node = this.getContext().getNode()) != null) {
            this._ancestorUpdater = NodeUpdater.getUpdater((Subject)node, (TextBuffer)((BasicDocument)jdkDoc).getTextBuffer());
        }
    }

    @Override
    protected void deinstallUndoableEditListener() {
        super.deinstallUndoableEditListener();
        this._ancestorUpdater = null;
    }

    @Override
    protected CompareModel createMergeModelImpl(Context context) {
        SequenceCompareModel textMergeModel = null;
        try {
            try {
                textMergeModel = this.createTextMergeModel(context);
            }
            catch (UnsupportedOperationException uoe) {
                textMergeModel = MergeContext.isClientSideMerge(context) ? this.createMergeModelCS(context) : this.createMergeModelSS(context);
            }
        }
        catch (FileTooLargeException ftle) {
            return null;
        }
        catch (FileNotComparableException fnce) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            TextMergeContributor emptyContributor = new TextMergeContributor(TextBufferFactory.createTextBuffer(), "", "");
            return new SequenceCompareModel((SequenceCompareContributor)emptyContributor, (SequenceCompareContributor)emptyContributor, (SequenceCompareContributor)emptyContributor, new SequenceCompareDifference[0]);
        }
        if (textMergeModel == null) {
            return null;
        }
        final TextBuffer mergeTextBuffer = this.getResultTextBuffer();
        mergeTextBuffer.addTextBufferListener(new TextBufferListener(){

            public void attributeUpdate(TextBuffer buffer, int attribute) {
                if (attribute == 5) {
                    BaseTextMergeEditor.this.updateMergeAttributes(mergeTextBuffer);
                }
            }

            public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            }

            public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            }
        });
        if (URLFileSystem.isReadOnly((URL)this.getSaveURL(context))) {
            mergeTextBuffer.setReadOnly(true);
        }
        return textMergeModel;
    }

    protected TextBuffer getSaveResultForNode() {
        return this.getResultTextBuffer();
    }

    @Override
    protected void compareViewStatusChanged() {
        super.compareViewStatusChanged();
        IdeAction.find((int)SaveMergeCommand.SAVE_MERGE_CMD_ID).updateAction();
        if (!this.isDynamic()) {
            this._getContext().getNode().markDirty(this.isSaveEnabled());
        }
    }

    @Override
    protected boolean restartMergeImpl(Context context) throws IOException {
        this.reopen();
        return true;
    }

    @Override
    @Deprecated
    protected boolean saveMergeImpl(Context context, CompareModel compareModel) throws IOException {
        if (compareModel instanceof SequenceCompareModel) {
            return this.saveTextMerge(context, (SequenceCompareModel)compareModel);
        }
        return this._saveMerge(context, compareModel);
    }

    @Deprecated
    protected boolean saveTextMerge(Context context, SequenceCompareModel textMergeModel) throws IOException {
        return this._saveMerge(context, (CompareModel)textMergeModel);
    }

    @Deprecated
    private boolean _saveMerge(Context context, CompareModel textMergeModel) throws IOException {
        URL url = this.getSaveURL(context);
        if (URLFileSystem.isReadOnly((URL)url)) {
            return false;
        }
        TextBuffer ancestorTextBuffer = ((TextCompareContributor)textMergeModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer();
        TextMergeNode.saveResultToURL(ancestorTextBuffer, url);
        return true;
    }

    @Override
    protected Command createEditCommand(ViewEdit viewEdit) {
        return new UndoWrapperCommand((UndoableEdit)viewEdit, (Object)this._ancestorUpdater);
    }

    @Override
    protected boolean getClientSideMergeSetting() {
        return false;
    }

    protected SequenceCompareModel createTextMergeModel(Context context) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected CompareModel createMergeModelSS(Context context) throws IOException {
        this.clearAnnotationsSS();
        URL url = this.getRealURL();
        Diff3Format diff3Format = new Diff3Format();
        diff3Format.setAnnotationClass(this.getAnnotationClassSS());
        this._diff3Model = diff3Format.parse(this.createReader());
        String compareType = URLFileSystem.getSuffix((URL)url);
        String firstContributorLabel = this.createFirstContributorLabelSS();
        String fileName = URLFileSystem.getFileName((URL)url);
        TextMergeContributor contributor1 = new TextMergeContributor(this._diff3Model.getFirstTextBuffer(), compareType, firstContributorLabel);
        TextMergeContributor contributor2 = new TextMergeContributor(this._diff3Model.getSecondTextBuffer(), compareType, fileName);
        this.setResultTextBuffer(this._diff3Model.getAncestorTextBuffer());
        EditableTextCompareContributor contributorA = new EditableTextCompareContributor(this.getResultTextBuffer());
        this.configureAncestorContributor((CompareContributor)contributorA, (CompareContributor)contributor1, (CompareContributor)contributor2);
        return new SequenceCompareModel((SequenceCompareContributor)contributor1, (SequenceCompareContributor)contributor2, (SequenceCompareContributor)contributorA, this._diff3Model.getDifferenceBlocks());
    }

    private MergeValidator getValidator() {
        if (this._validator == null) {
            this._validator = MergeValidatorFactory.getMergeValidatorFactory().createValidator();
        }
        return this._validator;
    }

    private CompareModel createMergeModelCS(Context context) throws IOException, CompareFailedException {
        CompareModel compareModel = MergeContext.getModel(context);
        if (compareModel == null) {
            Node contextNode;
            CompareContributor contributor1 = MergeContext.getFirstContributor(context);
            CompareContributor contributor2 = MergeContext.getSecondContributor(context);
            CompareContributor contributorA = MergeContext.getAncestorContributor(context);
            if (contributor1 == null || contributor2 == null || contributorA == null) {
                throw new IllegalArgumentException("Context must be configured with CompareModel or CompareContributors through MergeContext in an override of BaseMergeEditor.initializeMergeContextCS()");
            }
            MergeEngine mergeEngine = MergeContext.getMergeEngine(context);
            if (mergeEngine == null) {
                mergeEngine = MergeEngine.getInstance();
            }
            mergeEngine.prepareMerge(contributor1, contributor2, contributorA, (Element)((contextNode = MergeContext.getContextNode(context)) != null ? contextNode : context.getNode()));
            this.setProgressCancelable(mergeEngine.isCancelable());
            compareModel = mergeEngine.executeMerge();
            if (compareModel == null) {
                return null;
            }
            this.configureAncestorContributor(compareModel.getContributor(ContributorKind.ANCESTOR), contributor1, contributor2);
        }
        this.setResultTextBuffer(((TextCompareContributor)compareModel.getContributor(ContributorKind.ANCESTOR)).getTextBuffer());
        return compareModel;
    }

    private final void configureAncestorContributor(CompareContributor contributorA, CompareContributor contributor1, CompareContributor contributor2) {
        contributorA.setShortLabel(MergeArb.get("RESULT_OF_MERGE"));
        contributorA.setLongLabel(MergeArb.get("RESULT_OF_MERGE"));
        contributorA.setType(contributor1.getType().equals(contributor2.getType()) ? contributor1.getType() : "");
    }

    private final void setResultTextBuffer(TextBuffer textBuffer) {
        this._resultTextBuffer = textBuffer;
    }

    private final TextBuffer getResultTextBuffer() {
        return this._resultTextBuffer;
    }
}

