/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12.metadata;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.metadata.AffiliationDescriptor;
import oracle.security.xmlsec.liberty.v12.metadata.ContactPerson;
import oracle.security.xmlsec.liberty.v12.metadata.IDPDescriptor;
import oracle.security.xmlsec.liberty.v12.metadata.Organization;
import oracle.security.xmlsec.liberty.v12.metadata.SPDescriptor;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityDescriptor
extends XMLElement {
    private static final String[] nsURIs = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "http://www.w3.org/2000/09/xmldsig#"};
    private static final String[] localNames = new String[]{"IDPDescriptor", "SPDescriptor", "AffiliationDescriptor", "ContactPerson", "Organization", "Extension", "Signature"};
    private static final String[] nsURIsPrecedeDSig = new String[]{"urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08", "urn:liberty:metadata:2003-08"};
    private static final String[] localNamesPrecedeDSig = new String[]{"IDPDescriptor", "SPDescriptor", "AffiliationDescriptor", "ContactPerson", "Organization", "Extension"};

    public EntityDescriptor(Element element) throws DOMException {
        super(element);
    }

    public EntityDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public EntityDescriptor(Document owner) throws DOMException {
        super(owner, "urn:liberty:metadata:2003-08", "EntityDescriptor");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:metadata:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:metadata:2003-08");
    }

    public void setProviderID(String providerID) throws DOMException {
        this.setAttribute("providerID", providerID);
    }

    public String getProviderID() {
        if (this.hasAttribute("providerID")) {
            return this.getAttribute("providerID");
        }
        return null;
    }

    public void setId(String id) throws DOMException {
        this.setAttribute("id", id);
    }

    public String getId() {
        if (this.hasAttribute("id")) {
            return this.getAttribute("id");
        }
        return null;
    }

    public void setValidUntil(Date validUntil) throws DOMException {
        this.setAttribute("validUntil", XMLUtils.formatDateTime((Date)validUntil));
    }

    public Date getValidUntil() {
        if (this.hasAttribute("validUntil")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("validUntil"));
        }
        return null;
    }

    public void setCacheDuration(String duration) throws DOMException {
        this.setAttribute("cacheDuration", duration);
    }

    public String getCacheDuration() {
        if (this.hasAttribute("cacheDuration")) {
            return this.getAttribute("cacheDuration");
        }
        return null;
    }

    public void addSPDescriptor(SPDescriptor descriptor) throws DOMException {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)descriptor, (String[])nsURIs, (String[])localNames);
    }

    public List getSPDescriptors() {
        return LibertyUtils.getChildElements(this, "urn:liberty:metadata:2003-08", "SPDescriptor");
    }

    public void addIDPDescriptor(IDPDescriptor descriptor) throws DOMException {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)descriptor, (String[])nsURIs, (String[])localNames);
    }

    public List getIDPDescriptors() {
        return LibertyUtils.getChildElements(this, "urn:liberty:metadata:2003-08", "IDPDescriptor");
    }

    public void setAffiliationDescriptor(AffiliationDescriptor descriptor) throws DOMException {
        LibertyUtils.setChildElement(this, descriptor, nsURIs, localNames);
    }

    public AffiliationDescriptor getAffiliationDescriptor() {
        return (AffiliationDescriptor)LibertyUtils.getChildElement(this, "urn:liberty:metadata:2003-08", "AffiliationDescriptor");
    }

    public void setContactPerson(ContactPerson contact) throws DOMException {
        LibertyUtils.setChildElement(this, contact, nsURIs, localNames);
    }

    public ContactPerson getContactPerson() {
        return (ContactPerson)LibertyUtils.getChildElement(this, "urn:liberty:metadata:2003-08", "ContactPerson");
    }

    public void setOrganization(Organization organization) throws DOMException {
        LibertyUtils.setChildElement(this, organization, nsURIs, localNames);
    }

    public Organization getOrganization() {
        return (Organization)LibertyUtils.getChildElement(this, "urn:liberty:metadata:2003-08", "Organization");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) throws DOMException, SigningException {
        String id = this.getId();
        if (id == null || id.length() == 0) {
            throw new SigningException("Cannot add ds:Signature, missing 'id' attribute");
        }
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        return LibDSigUtils.addSignature(this, id, signatureMethod, c14nMethod, digestMethod, nsURIsPrecedeDSig, localNamesPrecedeDSig);
    }

    public XSSignature getSignature() {
        return (XSSignature)LibertyUtils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

