/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.liberty.v12.LibAuthenticationStatement;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibAssertion
extends Assertion {
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 2;

    public LibAssertion(Element element) throws DOMException {
        this(element, null);
    }

    public LibAssertion(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public LibAssertion(Document owner) throws DOMException {
        super(owner);
        this.setVersion(1, 2);
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("http://www.w3.org/2001/XMLSchema-instance");
        String name = "type";
        String prefix = XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2001/XMLSchema-instance");
        if (prefix != null && prefix.length() != 0) {
            name = prefix + ":" + name;
        }
        String value = "AssertionType";
        prefix = XMLElement.getDefaultNSPrefix((String)"urn:liberty:iff:2003-08");
        if (prefix != null && prefix.length() != 0) {
            value = prefix + ":" + value;
        }
        this.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", name, value);
    }

    public LibAssertion(Document owner, String assertionId, String issuer, Date issueInstant, String inResponseTo) throws DOMException {
        this(owner);
        this.setAssertionID(assertionId);
        this.setIssuer(issuer);
        this.setIssueInstant(issueInstant);
        this.setInResponseTo(inResponseTo);
    }

    public List getLibAuthenticationStatements() {
        NodeList list = this.getChildElementsByTagNameNS("*", "AuthenticationStatement");
        Vector<LibAuthenticationStatement> vec = new Vector<LibAuthenticationStatement>();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Element element = (Element)list.item(i);
            String namespace = element.getNamespaceURI();
            if (!"urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) && !"urn:liberty:iff:2003-08".equals(namespace)) continue;
            vec.addElement(new LibAuthenticationStatement(element, this.systemId));
        }
        return vec;
    }

    public void setInResponseTo(String value) {
        this.setAttribute("InResponseTo", value);
    }

    public String getInResponseTo() {
        if (this.hasAttribute("InResponseTo")) {
            return this.getAttribute("InResponseTo");
        }
        return null;
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        String id = this.getID();
        if (id == null || id.length() == 0) {
            return super.addSignature(signatureMethod, c14nMethod, digestMethod);
        }
        this.clearSignature();
        return LibDSigUtils.addSignature((XMLElement)this, id, signatureMethod, c14nMethod, digestMethod, this.getNSURIsPrecedeDSig(), this.getLocalNamesPrecedeDSig());
    }

    protected String getID() {
        return this.getAssertionID();
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

