/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.arbori.util.ParseInt;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.Rexel;
import oracle.dbtools.parser.Token;

public class Lexer {
    public static String[] customLineCommentPrefixes = new String[0];
    public static boolean isSqlPlusCmd = false;
    private volatile boolean stop = false;
    public static final int QuotedStrings = 1;
    public static final int SqlPlusComments = 2;
    public static final int PlSqlMacros = 4;
    public static final int JavaLineComments = 8;
    public static final int SqlLineComments = 16;
    public static final int JavaSqlMultilineComments = 32;
    public static final int HtmlComments = 64;
    public static final int JsonStrings = 128;
    public static final int PoundComments = 256;
    public static final int RegExp = 512;
    public static final int SQL = 63;
    public static final int GRAMMAR = 49;
    public static final int ARBORI = 57;
    public static final int TEST = 49;
    public static final int JAVA = 41;
    public static final int JS = 937;
    Rexel rexel = null;

    public static List<LexerToken> parse(String input) {
        return new Lexer().doParse(input);
    }

    public static List<LexerToken> parse(String input, String extraOper) {
        return new Lexer().doParse(input, extraOper);
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS) {
        return new Lexer().doParse(input, keepWSandCOMMENTS);
    }

    public static List<LexerToken> parse(String input, boolean keepWSandCOMMENTS, int flags) {
        return new Lexer().doParse(input, keepWSandCOMMENTS, flags);
    }

    public static boolean match(List<LexerToken> list1, List<LexerToken> list2) {
        if (list1.size() != list2.size()) {
            System.err.println("list1.size()=" + list1.size() + " != list2.size()=" + list2.size());
            return false;
        }
        int i = -1;
        for (LexerToken t1 : list1) {
            LexerToken t2 = list2.get(++i);
            if ("\r\n".equals(t1.content) && "\r".equals(t2.content) || "\r\n".equals(t1.content) && "\n".equals(t2.content)) continue;
            String s1 = t1.toString();
            String s2 = t2.toString();
            if (("".equals(t1.content.trim()) || s1.equals(s2)) && t1.begin == t2.begin && t1.end == t2.end && t1.type == t2.type) continue;
            System.err.println("t1=" + s1 + "\n != t2=" + s2);
            return false;
        }
        return true;
    }

    private LinkedList<LexerToken> tokenize(String sourceExpr, int flags, String extraOper) throws ParsingCancelled {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        Object operation = "(){}[]^-|!*+.><='\",;:%@?/\\~" + extraOper;
        if ((flags & 0x40) == 64) {
            operation = "></-=\"!";
        }
        if ((flags & 0x100) == 256) {
            operation = (String)operation + "#";
        }
        String ws = " \n\r\t";
        StringTokenizer st = new StringTokenizer(sourceExpr, (String)operation + " \n\r\t", true);
        int pos = 0;
        boolean isWrapped = false;
        int contextualFlags = flags;
        block2: while (st.hasMoreTokens()) {
            int context;
            int lineEnd;
            int nextSlash;
            if (this.stop) {
                this.stop = false;
                throw new ParsingCancelled();
            }
            String token = st.nextToken();
            pos += token.length();
            LexerToken last = null;
            if (ret.size() > 0) {
                last = ret.getLast();
            }
            if (isWrapped) {
                if ("/".equals(token) | ";".equals(token) && last != null && "\n".equals(last.content)) {
                    String marker = "\"/\"";
                    ret.add(new LexerToken("\"/\"", pos - "\"/\"".length(), pos, Token.IDENTIFIER));
                    isWrapped = false;
                    continue;
                }
                if ("\n".equals(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.WS));
                    continue;
                }
                if (!"\n".equals(last.content)) continue;
                last.content = "?";
                continue;
            }
            if (last != null && last.type == Token.COMMENT && (contextualFlags & 0x20) == 32 && (!last.content.endsWith("*/") || last.content.equals("/*/"))) {
                last.content = last.content + token;
                last.end = pos;
                if (last == null || last.type != Token.COMMENT || !last.content.endsWith("*/") || last.content.equals("/*/")) continue;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.COMMENT && (contextualFlags & 0x40) == 64 && !last.content.endsWith(">")) {
                String abbr = "<! ...";
                if ("-".equals(token)) {
                    last.content = last.content + token;
                } else if (">".equals(token) && (last.content.length() <= 2 || last.content.charAt(2) != '-')) {
                    last.content = last.content + token;
                } else if (">".equals(token) && (last.content.length() <= 2 || last.content.charAt(last.content.length() - 2) == '-' && last.content.charAt(last.content.length() - 3) == '-')) {
                    last.content = last.content + token;
                }
                last.end = pos;
                if (last == null || last.type != Token.COMMENT || !last.content.endsWith(">")) continue;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (!(last == null || last.type != Token.LINE_COMMENT && last.type != Token.DBTOOLS_COMMAND && last.type != Token.SQLPLUS_COMMAND || "\n".equals(token) || "\r".equals(token))) {
                last.content = last.content + token;
                last.end += token.length();
                continue;
            }
            if (last != null && (last.type == Token.LINE_COMMENT || last.type == Token.DBTOOLS_COMMAND || last.type == Token.SQLPLUS_COMMAND) && ("\n".equals(token) || "\r".equals(token))) {
                last.end = last.begin + last.content.length();
            }
            if (last != null && last.type == Token.QUOTED_STRING && !last.isStandardLiteral(contextualFlags) && !last.isAltLiteral()) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                continue;
            }
            if (last != null && last.type == Token.DQUOTED_STRING && ("\"" != token || last.content.endsWith("\\")) && (!last.content.endsWith("\"") || (contextualFlags & 0x80) == 128 && last.content.endsWith("\\\"") || last.content.length() == 1)) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                continue;
            }
            if (last != null && last.type == Token.DQUOTED_STRING && "\"".equals(token)) {
                last.end = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.BQUOTED_STRING && !"`".equals(token) && (!last.content.endsWith("`") || last.content.length() <= 1)) continue;
            if (last != null && last.type == Token.BQUOTED_STRING && "`".equals(token)) {
                if (Lexer.insideTemplateVar(sourceExpr.substring(last.begin + 1, pos)) || sourceExpr.charAt(pos - 2) == '\\' && (pos - 3 < 0 || sourceExpr.charAt(pos - 3) != '\\')) continue;
                last.end = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.REGEXP && pos <= last.end) {
                if (!"/".equals(token) || last.end != pos) continue;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if ((contextualFlags & 0x20) == 32 && "*".equals(token) && last != null && "/".equals(last.content)) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                last.type = Token.COMMENT;
                continue;
            }
            if (!((contextualFlags & 0x200) != 512 || "*".equals(token) || "/".equals(token) || last == null || !"/".equals(last.content) || 0 >= (nextSlash = Lexer.terminatingSlash(sourceExpr, last.end, lineEnd = sourceExpr.indexOf(10, last.end))) || nextSlash >= lineEnd && lineEnd != -1)) {
                last.content = last.content + token;
                last.end = nextSlash + 1;
                last.type = Token.REGEXP;
                continue;
            }
            if ((contextualFlags & 0x10) == 16 && "-".equals(token) && last != null && "-".equals(last.content) || (contextualFlags & 8) == 8 && "/".equals(token) && last != null && "/".equals(last.content)) {
                boolean isHttp = false;
                if ("/".equals(token)) {
                    int start = last.begin - "http:".length();
                    if (0 <= start && "http:".equalsIgnoreCase(sourceExpr.substring(start, last.begin))) {
                        isHttp = true;
                    }
                    if (0 <= (start = last.begin - "https:".length()) && "https:".equalsIgnoreCase(sourceExpr.substring(start, last.begin))) {
                        isHttp = true;
                    }
                }
                if (!isHttp) {
                    last.content = last.content + token;
                    last.type = Token.LINE_COMMENT;
                    last.end += token.length();
                    continue;
                }
            }
            if ((contextualFlags & 0x40) == 64 && "!".equals(token) && last != null && "<".equals(last.content)) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                last.type = Token.COMMENT;
                continue;
            }
            if ((contextualFlags & 2) == 2 && ("rem".equalsIgnoreCase(token) || "rema".equalsIgnoreCase(token) || "remar".equalsIgnoreCase(token) || "remark".equalsIgnoreCase(token) || "pro".equalsIgnoreCase(token) || "prom".equalsIgnoreCase(token) || "promp".equalsIgnoreCase(token) || "prompt".equalsIgnoreCase(token)) && (last == null || "\n".equals(last.content) || "\r".equals(last.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                continue;
            }
            for (String pref : customLineCommentPrefixes) {
                if (pref.equalsIgnoreCase(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                    continue block2;
                }
                if (last == null || !pref.equalsIgnoreCase(last.content)) continue;
                last.content = last.content + token;
                last.end = last.begin + last.content.length() + token.length();
                last.type = Token.LINE_COMMENT;
                continue block2;
            }
            if ((contextualFlags & 0x100) == 256 && "#".equals(token)) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.LINE_COMMENT));
                continue;
            }
            if ("soda".equalsIgnoreCase(token) && (last == null || "\n".equals(last.content) || "\r".equals(last.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.DBTOOLS_COMMAND));
                continue;
            }
            if ((contextualFlags & 2) == 2 && Lexer.isSqlPlusPrefix(token) && (last == null || "\n".equals(last.content) || "\r".equals(last.content))) {
                ret.add(new LexerToken(token, pos - token.length(), -9, Token.SQLPLUS_COMMAND));
                continue;
            }
            if (isSqlPlusCmd && last != null && "-".equals(last.content) && ("\n".equals(token) || "\r".equals(token))) {
                last.type = Token.SQLPLUSLINECONTINUE_SKIP;
            }
            String lastUpper = "N/A";
            if (last != null) {
                lastUpper = last.content.toUpperCase();
            }
            if ((contextualFlags & 4) == 4 && ("$IF".equalsIgnoreCase(token) || "$ELSIF".equalsIgnoreCase(token) || "$ELSE".equalsIgnoreCase(token) || "$END".equalsIgnoreCase(token) || "$ERROR".equalsIgnoreCase(token))) {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.MACRO_SKIP));
                continue;
            }
            if (last != null && last.type == Token.MACRO_SKIP && lastUpper.startsWith("$IF") && lastUpper.endsWith("$THEN")) {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.MACRO_SKIP));
                continue;
            }
            if (last != null && last.type == Token.MACRO_SKIP && (lastUpper.startsWith("$IF") || lastUpper.startsWith("$ELSIF") || lastUpper.startsWith("$ELSE") || lastUpper.startsWith("$ERROR"))) {
                last.content = last.content + token;
                last.end += token.length();
                continue;
            }
            if (last != null && last.type == Token.IDENTIFIER && last.end == -11 && last.content.startsWith("@") && !"\n".equals(token) && !"\r".equals(token)) {
                last.content = last.content + token;
                continue;
            }
            if (last != null && last.type == Token.IDENTIFIER && last.end == -11 && last.content.startsWith("@") && ("\n".equals(token) || "\r".equals(token))) {
                last.end = pos - 1;
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if ((contextualFlags & 1) == 1 && "'".equals(token)) {
                if (last != null && ("q".equalsIgnoreCase(last.content) || "N".equalsIgnoreCase(last.content) || "u".equalsIgnoreCase(last.content) || "nq".equalsIgnoreCase(last.content) || "uq".equalsIgnoreCase(last.content))) {
                    last.content = last.content + token;
                    last.type = Token.QUOTED_STRING;
                    continue;
                }
                ret.add(new LexerToken(token, pos - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if ((contextualFlags & 1) == 1 && "\"".equals(token)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("`".equals(token) && 0 <= ((String)operation).indexOf(96)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.BQUOTED_STRING));
                continue;
            }
            if (token.length() == 1 && 0 <= " \n\r\t".indexOf(token.charAt(0))) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if (token.length() == 1 && 0 <= ((String)operation).indexOf(token.charAt(0))) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.OPERATION));
                continue;
            }
            if (!('0' > token.charAt(0) || token.charAt(0) > '9' || last != null && "#".equals(last.content))) {
                if (Lexer.isHexLiteral(token)) {
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                    continue;
                }
                if (Lexer.fixedExponent(token, ret, pos - token.length())) continue;
                if (Lexer.hasSciSuffix(token)) {
                    ret.add(new LexerToken(token.substring(0, token.length() - 1), pos - token.length(), pos - 1, Token.DIGITS));
                    ret.add(new LexerToken(token.substring(token.length() - 1), pos - 1, pos, Token.DIGITS));
                    continue;
                }
                try {
                    Long.parseLong(token);
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                }
                catch (NumberFormatException e) {
                    ret.add(new LexerToken(token, pos - token.length(), pos, Token.UNKNOWN));
                }
                continue;
            }
            if ("WRAPPED".equalsIgnoreCase(token) && last != null) {
                Iterator<LexerToken> descIter = ret.descendingIterator();
                boolean sawId = false;
                while (descIter.hasNext()) {
                    LexerToken t = descIter.next();
                    if (sawId && ".".equalsIgnoreCase(t.content)) {
                        sawId = false;
                        continue;
                    }
                    if (sawId && ("PROCEDURE".equalsIgnoreCase(t.content) || "FUNCTION".equalsIgnoreCase(t.content) || "TRIGGER".equalsIgnoreCase(t.content) || "TYPE".equalsIgnoreCase(t.content) || "PACKAGE".equalsIgnoreCase(t.content) || "BODY".equalsIgnoreCase(t.content))) {
                        isWrapped = true;
                        break;
                    }
                    if (t.type == Token.WS || t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) continue;
                    if (t.type != Token.IDENTIFIER && t.type != Token.DQUOTED_STRING) break;
                    sawId = true;
                }
            }
            ret.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
            if (contextualFlags != flags || (context = Lexer.inferContext(token)) == -1) continue;
            contextualFlags |= context;
        }
        if (ret.size() > 0) {
            LexerToken last = (LexerToken)ret.getLast();
            last.end = sourceExpr.length();
        }
        return ret;
    }

    static boolean hasSciSuffix(String token) {
        char suffix = token.charAt(token.length() - 1);
        if (suffix != 'K' && suffix != 'k' && suffix != 'M' && suffix != 'm' && suffix != 'G' && suffix != 'g' && suffix != 'T' && suffix != 't' && suffix != 'P' && suffix != 'p' && suffix != 'E' && suffix != 'e') {
            return false;
        }
        return ParseInt.isInt(token.substring(0, token.length() - 1));
    }

    private static int inferContext(String token) {
        if ("var".equals(token)) {
            return 937;
        }
        if ("const".equals(token)) {
            return 937;
        }
        if ("let".equals(token)) {
            return 937;
        }
        return -1;
    }

    private static boolean insideTemplateVar(String str) {
        StringTokenizer st = new StringTokenizer(str, "${}", true);
        int nesting = 0;
        String prior = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("{".equals(token) && "$".equals(prior)) {
                ++nesting;
            } else if ("}".equals(token)) {
                --nesting;
            }
            prior = token;
        }
        return 0 < nesting;
    }

    private static int terminatingSlash(String sourceExpr, int start, int end) {
        String input = null;
        input = end < 0 ? sourceExpr.substring(start) : sourceExpr.substring(start, end);
        StringTokenizer st = new StringTokenizer(input, "\\/ ()[]", true);
        String prior = null;
        String current = null;
        int pos = start;
        int parenBalance = 0;
        while (st.hasMoreTokens()) {
            current = st.nextToken();
            if ("[".equals(prior) && "]".equals(current)) {
                prior = null;
                pos += current.length();
                continue;
            }
            if ("[".equals(prior)) {
                pos += current.length();
                continue;
            }
            if ("\\".equals(prior)) {
                prior = null;
                pos += current.length();
                continue;
            }
            if (")".equals(prior)) {
                --parenBalance;
            }
            if ("(".equals(prior)) {
                ++parenBalance;
            }
            if ("/".equals(current)) {
                if (parenBalance != 0) {
                    return -1;
                }
                if (" ".equals(prior) && input.charAt(0) == ' ') {
                    if ("g".equalsIgnoreCase(st.nextToken())) {
                        return pos + 1;
                    }
                    return -1;
                }
                return pos;
            }
            prior = current;
            pos += current.length();
        }
        return -1;
    }

    private static boolean isSqlPlusPrefix(String token) {
        if ("@".equals(token)) {
            return true;
        }
        if ("INPUT".equalsIgnoreCase(token)) {
            return true;
        }
        if ("HOST".equalsIgnoreCase(token)) {
            return true;
        }
        return "PAUSE".equalsIgnoreCase(token);
    }

    static boolean fixedExponent(String iNput, List<LexerToken> ret, int pos) {
        LinkedList<LexerToken> tmp = new LinkedList<LexerToken>();
        StringTokenizer st = new StringTokenizer(iNput, "efdEFD", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            pos += token.length();
            if (ParseInt.isInt(token)) {
                tmp.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            if ("e".equalsIgnoreCase(token) || "f".equalsIgnoreCase(token) || "d".equalsIgnoreCase(token)) {
                tmp.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
                continue;
            }
            return false;
        }
        if (tmp.size() == 0) {
            return false;
        }
        ret.addAll(tmp);
        return true;
    }

    private static boolean isHexLiteral(String iNput) {
        if (iNput.length() < 3) {
            return false;
        }
        if (iNput.charAt(0) != '0') {
            return false;
        }
        String input = iNput.toLowerCase();
        if (input.charAt(1) != 'x') {
            return false;
        }
        for (int i = 2; i < input.length(); ++i) {
            if (Character.isDigit(input.charAt(i)) || input.charAt(i) == 'a' || input.charAt(i) == 'b' || input.charAt(i) == 'c' || input.charAt(i) == 'd' || input.charAt(i) == 'e' || input.charAt(i) == 'f') continue;
            return false;
        }
        return true;
    }

    public List<LexerToken> doParse(String input) {
        return this.doParse(input, false);
    }

    public List<LexerToken> doParse(String input, String extraOper) {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        try {
            this.doParse(input, false, 63, extraOper, ret);
        }
        catch (ParsingCancelled e) {
            throw new AssertionError((Object)"doParse(...) has been interrupted with lexer.stop=true");
        }
        return ret;
    }

    public List<LexerToken> doParse(String input, boolean keepWSandCOMMENTS) {
        return this.doParse(input, keepWSandCOMMENTS, 63);
    }

    public List<LexerToken> doParse(String input, boolean keepWSandCOMMENTS, int flags) {
        ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
        try {
            Object separators = "";
            if ((flags & 0x3F) == 63) {
                separators = (String)separators + "`";
            }
            this.doParse(input, keepWSandCOMMENTS, flags, (String)separators, ret);
        }
        catch (ParsingCancelled e) {
            throw new AssertionError((Object)"doParse(...) has been interrupted with lexer.stop=true");
        }
        return ret;
    }

    public List<LexerToken> doParse(String input, String extraOper, int flags) {
        try {
            ArrayList<LexerToken> ret = new ArrayList<LexerToken>();
            this.doParse(input, false, flags, extraOper, ret);
            return ret;
        }
        catch (ParsingCancelled e) {
            throw new AssertionError((Object)"doParse(...) has been interrupted with lexer.stop=true");
        }
    }

    void doParse(String input, boolean keepWSandCOMMENTS, int flags, String extraOper, ArrayList<LexerToken> ret) throws ParsingCancelled {
        LexerToken last = null;
        for (LexerToken token : this.tokenize(input, flags, extraOper)) {
            if (this.stop) {
                this.stop = false;
                throw new ParsingCancelled();
            }
            if (token.type == Token.IDENTIFIER && last != null && last.type == Token.DQUOTED_STRING && token.content.startsWith("___")) {
                last.content = last.content + token.content;
                last.end = token.end;
                continue;
            }
            if (token.type == Token.QUOTED_STRING) {
                if (last != null && last.type == Token.QUOTED_STRING) {
                    last.content = last.content + token.content;
                    last.end = token.end;
                    continue;
                }
                if (last != null && last.type == Token.IDENTIFIER && "n".equalsIgnoreCase(last.content) && last.end == token.begin) {
                    last.begin = token.begin;
                    last.end = token.end;
                    last.type = token.type;
                    last.content = token.content;
                    continue;
                }
            }
            if (token.content.startsWith("@")) {
                token.end = token.begin + token.content.length();
            }
            if ("#".equals(token.content) && last != null && last.type == Token.IDENTIFIER) {
                ++last.end;
                last.content = last.content + "#";
                continue;
            }
            if ((token.type == Token.IDENTIFIER || token.type == Token.DIGITS) && last != null && last.content.endsWith("#") && last.type == Token.IDENTIFIER) {
                last.end += token.content.length();
                last.content = last.content + token.content;
                continue;
            }
            if (keepWSandCOMMENTS || token.type != Token.WS && token.type != Token.COMMENT && token.type != Token.LINE_COMMENT && token.type != Token.MACRO_SKIP && token.type != Token.SQLPLUSLINECONTINUE_SKIP) {
                ret.add(token);
            }
            last = token;
        }
        if (Lexer.incomplete(ret)) {
            try {
                ArrayList<LexerToken> ter = new ArrayList<LexerToken>();
                this.rexel = new Rexel();
                this.rexel.doParse(input, keepWSandCOMMENTS, flags, extraOper, ter);
                this.rexel = null;
                int retPos = Lexer.brokenLiteralOrIdAt(ret, ter);
                int[] lineMap = Service.lineMap(input);
                int retNlCnt = Lexer.nlCnt(lineMap, ret);
                int terNlCnt = Lexer.nlCnt(lineMap, ter);
                if (retNlCnt <= terNlCnt) {
                    return;
                }
                if (0 < retPos) {
                    int i;
                    LexerToken brink = ret.get(retPos);
                    int terPos = -1;
                    for (LexerToken t : ter) {
                        ++terPos;
                        if (brink.begin >= t.begin) continue;
                        break;
                    }
                    LexerToken nextTer = ter.get(terPos);
                    if (keepWSandCOMMENTS) {
                        brink.end = nextTer.begin;
                        brink.content = input.substring(brink.begin, brink.end);
                        brink.type = Token.INCOMPLETE;
                    } else {
                        --retPos;
                    }
                    int terInd = terPos;
                    for (i = retPos + 1; i < ret.size() && terInd < ter.size(); ++i, ++terInd) {
                        LexerToken mod = ret.get(i);
                        LexerToken t = ter.get(terInd);
                        mod.begin = t.begin;
                        mod.end = t.end;
                        mod.content = t.content;
                        mod.type = t.type;
                    }
                    for (i = terInd; i < ter.size(); ++i) {
                        ret.add(ter.get(i));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void doParse(String input, int flags, String extraOper, ArrayList<LexerToken> src, ArrayList<LexerToken> fullSrc, InterruptedException interrupted) throws ParsingCancelled {
        LexerToken last = null;
        for (LexerToken token : this.tokenize(input, flags, extraOper)) {
            if (token.type == Token.IDENTIFIER && last != null && last.type == Token.DQUOTED_STRING && token.content.startsWith("___")) {
                last.content = last.content + token.content;
                last.end = token.end;
                continue;
            }
            if (token.type == Token.QUOTED_STRING) {
                if (last != null && last.type == Token.QUOTED_STRING) {
                    last.content = last.content + token.content;
                    last.end = token.end;
                    continue;
                }
                if (last != null && last.type == Token.IDENTIFIER && "n".equalsIgnoreCase(last.content) && last.end == token.begin) {
                    last.begin = token.begin;
                    last.end = token.end;
                    last.type = token.type;
                    last.content = token.content;
                    continue;
                }
            }
            if (token.content.startsWith("@")) {
                token.end = token.begin + token.content.length();
            }
            if ("#".equals(token.content) && last != null && last.type == Token.IDENTIFIER) {
                ++last.end;
                last.content = last.content + "#";
                continue;
            }
            if ((token.type == Token.IDENTIFIER || token.type == Token.DIGITS) && last != null && last.content.endsWith("#") && last.type == Token.IDENTIFIER) {
                last.end += token.content.length();
                last.content = last.content + token.content;
                continue;
            }
            fullSrc.add(token);
            if (token.type != Token.WS && token.type != Token.COMMENT && token.type != Token.LINE_COMMENT && token.type != Token.MACRO_SKIP && token.type != Token.SQLPLUSLINECONTINUE_SKIP) {
                src.add(token);
            }
            last = token;
        }
        if (Lexer.incomplete(src)) {
            try {
                ArrayList<LexerToken> ter = new ArrayList<LexerToken>();
                this.rexel = new Rexel();
                this.rexel.doParse(input, false, flags, extraOper, ter);
                this.rexel = null;
                int retPos = Lexer.brokenLiteralOrIdAt(src, ter);
                int[] lineMap = Service.lineMap(input);
                int retNlCnt = Lexer.nlCnt(lineMap, src);
                int terNlCnt = Lexer.nlCnt(lineMap, ter);
                if (retNlCnt <= terNlCnt) {
                    return;
                }
                if (0 < retPos) {
                    int i;
                    LexerToken brink = src.get(retPos);
                    int terPos = -1;
                    for (LexerToken t : ter) {
                        ++terPos;
                        if (brink.begin >= t.begin) continue;
                        break;
                    }
                    LexerToken nextTer = ter.get(terPos);
                    int terInd = terPos;
                    for (i = --retPos + 1; i < src.size() && terInd < ter.size(); ++i, ++terInd) {
                        LexerToken mod = src.get(i);
                        LexerToken t = ter.get(terInd);
                        mod.begin = t.begin;
                        mod.end = t.end;
                        mod.content = t.content;
                        mod.type = t.type;
                    }
                    for (i = terInd; i < ter.size(); ++i) {
                        src.add(ter.get(i));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static int nlCnt(int[] lineMap, ArrayList<LexerToken> src) {
        int ret = 0;
        for (LexerToken t : src) {
            if (t.type != Token.QUOTED_STRING && t.type != Token.DQUOTED_STRING && t.type != Token.COMMENT || t.end < 1) continue;
            int lineStart = Service.charPos2LineNo0(lineMap, t.begin);
            int lineEnd = Service.charPos2LineNo0(lineMap, t.end - 1);
            ret += lineEnd - lineStart;
        }
        return ret;
    }

    static int brokenLiteralOrIdAt(ArrayList<LexerToken> src, ArrayList<LexerToken> crs) throws Exception {
        int size = src.size();
        if (size == 0) {
            return -1;
        }
        int pos = -1;
        for (LexerToken t : src) {
            LexerToken crsEnd;
            ++pos;
            LexerToken crsBegin = LexerToken.getTokenAtCharOffset(crs, t.begin);
            if (crsBegin == (crsEnd = LexerToken.getTokenAtCharOffset(crs, t.end - 1))) continue;
            String content = t.content;
            if (pos >= size - 1) continue;
            return pos;
        }
        return -1;
    }

    public static boolean incomplete(ArrayList<LexerToken> src) {
        if (src.size() == 0) {
            return false;
        }
        LexerToken t = src.get(src.size() - 1);
        return t.incomplete();
    }

    public static int scanner2parserOffset(List<LexerToken> src, int start) {
        int offset = -1;
        for (LexerToken t : src) {
            ++offset;
            if (t.end <= start) continue;
            break;
        }
        return offset;
    }

    public static LexerToken getTokenAtCharOffset(List<LexerToken> src, int offset) throws Exception {
        for (LexerToken t : src) {
            if (t.begin <= offset && offset <= t.end) {
                return t;
            }
            if (offset > t.begin) continue;
            return t;
        }
        throw new Exception("VT: offset = " + offset);
    }

    public static int char2lex(List<LexerToken> src, int offset) {
        return Lexer.char2lex(src, offset, false);
    }

    public static int char2lex(List<LexerToken> src, int offset, boolean strict) {
        if (src.size() == 0) {
            return 0;
        }
        int pos = -1;
        for (LexerToken t : src) {
            ++pos;
            if (t.begin <= offset && offset < t.end || !strict && t.begin <= offset && offset == t.end) {
                return pos;
            }
            if (offset > t.begin) continue;
            return pos;
        }
        return pos + 1;
    }

    private static char matchingDelimiter(char ch) {
        if ('<' == ch) {
            return '>';
        }
        if ('[' == ch) {
            return ']';
        }
        if ('{' == ch) {
            return '}';
        }
        if ('(' == ch) {
            return ')';
        }
        return ch;
    }

    public void stop() {
        this.stop = true;
        if (this.rexel != null) {
            this.rexel.stop();
        }
    }
}

