/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import oracle.arbori.util.Array;
import oracle.arbori.util.IntegerMap;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.ParsingCancelled;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Yelrae;

public class Earley
extends Parser {
    public int identifier = (Integer)this.symbolIndexes.get("identifier");
    protected int string_literal = -1;
    protected int digits = -1;
    public boolean isCaseSensitive = false;
    private Yelrae yelrae = null;
    protected volatile boolean stop = false;
    protected PredictedTerminals[] terminalPredictions = null;
    public Map<Integer, long[]> predicts = null;
    public boolean skipRanges = true;

    public static void dumpHeap(String filePath, boolean live) throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        mxBean.dumpHeap(filePath, live);
    }

    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t = this.rules[i];
            String head = this.allSymbols[t.head];
            if (head.charAt(head.length() - 1) == ')') continue;
            content = Array.insert(content, Earley.makeMatrixCellElem(i, 0, t));
        }
        matrix.initCells(src.size());
        matrix.put(0, 0, new Parser.EarleyCell(this, content));
        matrix.allXs = Array.insert(matrix.allXs, 0);
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[0];
            lArray[0] = lArray[0] + (long)((int)(t2 - t1));
        }
    }

    public synchronized void parse(List<LexerToken> src, Matrix m) {
        try {
            this.doParse(src, m);
        }
        catch (ParsingCancelled e) {
            throw new AssertionError((Object)"doParse(...) has been interrupted with earley.stop=true");
        }
    }

    public synchronized void doParse(List<LexerToken> src, Matrix m) throws ParsingCancelled {
        if (src.size() == 0) {
            return;
        }
        this.stop = false;
        Matrix matrix = m;
        this.precomputePredictions();
        this.initCell00(src, matrix);
        this.predict(matrix, src);
        while (true) {
            if (this.stop) {
                this.stop = false;
                throw new ParsingCancelled();
            }
            if (!this.scan(matrix, src)) break;
            String lookahead = null;
            if (matrix.lastY() < src.size() - 2) {
                lookahead = src.get((int)matrix.lastY()).content.toUpperCase();
            }
            this.complete(matrix, lookahead);
            this.predict(matrix, src);
        }
    }

    public void stop() {
        this.stop = true;
    }

    @Override
    public ParseNode parse(List<LexerToken> src) {
        Matrix matrix = new Matrix(this);
        try {
            this.doParse(src, matrix);
        }
        catch (ParsingCancelled e) {
            throw new AssertionError((Object)"doParse(...) has been interrupted with earley.stop=true");
        }
        return this.forest(src, matrix);
    }

    public Earley(Set<RuleTuple> originalRules) {
        this(originalRules, true);
    }

    public Earley(Set<RuleTuple> originalRules, boolean precomputePredictions) {
        super(originalRules);
        try {
            this.string_literal = (Integer)this.symbolIndexes.get("string_literal");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.digits = (Integer)this.symbolIndexes.get("digits");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected Yelrae getYelrae() throws ClassNotFoundException, IOException {
        if (this.yelrae != null) {
            return this.yelrae;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bis);
        Earley copy = (Earley)in.readObject();
        copy.predicts = null;
        this.yelrae = new Yelrae(copy);
        return this.yelrae;
    }

    protected synchronized void precomputePredictions() {
        int before;
        Object tmp;
        if (this.predicts != null) {
            return;
        }
        this.predicts = new HashMap<Integer, long[]>();
        HashMap<Integer, int[]> closure = new HashMap<Integer, int[]>();
        HashMap<Integer, long[]> symbolHead2rules = new HashMap<Integer, long[]>();
        for (int i = 0; i < this.rules.length; ++i) {
            tmp = (int[])closure.get(this.rules[i].head);
            long[] tmp1 = (long[])symbolHead2rules.get(this.rules[i].head);
            tmp = Array.insert((int[])tmp, this.rules[i].rhs[0]);
            tmp1 = Array.insert(tmp1, Earley.makeMatrixCellElem(i, 0, this.rules[i]));
            closure.put(this.rules[i].head, (int[])tmp);
            symbolHead2rules.put(this.rules[i].head, tmp1);
        }
        do {
            before = this.size(closure);
            tmp = closure.keySet().iterator();
            while (tmp.hasNext()) {
                int k = (Integer)tmp.next();
                int[] v = (int[])closure.get(k);
                int[] tmp2 = Array.merge(v, new int[0]);
                for (int n : v) {
                    tmp2 = Array.merge(tmp2, (int[])closure.get(n));
                }
                closure.put(k, tmp2);
            }
        } while (before != this.size(closure));
        this.terminalPredictions = new PredictedTerminals[this.allSymbols.length];
        Iterator iterator = closure.keySet().iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            long[] tmp3 = (long[])symbolHead2rules.get(k);
            for (int n : (int[])closure.get(k)) {
                tmp3 = Array.merge(tmp3, (long[])symbolHead2rules.get(n));
                String rhs0 = this.allSymbols[n];
                if (rhs0.charAt(0) == '\'') {
                    if (this.terminalPredictions[k] == null) {
                        this.terminalPredictions[k] = new PredictedTerminals();
                    }
                    this.terminalPredictions[k].add(n);
                    continue;
                }
                if (n != this.identifier && n != this.digits && n != this.string_literal) continue;
                if (this.terminalPredictions[k] == null) {
                    this.terminalPredictions[k] = new PredictedTerminals();
                }
                this.terminalPredictions[k].invalidate();
            }
            this.predicts.put(k, tmp3);
        }
    }

    private int size(Map<Integer, int[]> closure) {
        int ret = 0;
        for (int[] tmp : closure.values()) {
            ret += tmp.length;
        }
        return ret;
    }

    protected boolean scan(Matrix matrix, List<LexerToken> src) {
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        LexerToken token = src.get(y);
        Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect) {
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        long[] content = null;
        Parser.EarleyCell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        String lookahead = null;
        if (y < src.size() - 2) {
            lookahead = src.get((int)(y + 1)).content.toUpperCase();
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Parser.Tuple t = this.rules[ruleNo];
            if (t.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t, suspect) || pos < t.size() - 2 && !this.lookaheadOK(t.rhs[pos + 1], lookahead)) continue;
            content = Array.insert(content, Earley.makeMatrixCellElem(ruleNo, pos + 1, t));
            if (t.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t.head));
        }
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[x];
            int n = y + 1;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Parser.EarleyCell(this, content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        return true;
    }

    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Parser.Tuple t, Integer suspect) {
        int symbol = t.content(pos);
        LexerToken token = src.get(y);
        if (symbol == this.digits && token.type == Token.DIGITS) {
            return true;
        }
        if (symbol == this.string_literal && token.type == Token.QUOTED_STRING) {
            return true;
        }
        return suspect != null && suspect == symbol || this.isIdentifier(y, src, symbol, suspect);
    }

    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        if (symbol != this.identifier) {
            return false;
        }
        LexerToken token = src.get(y);
        return token.type == Token.IDENTIFIER;
    }

    @Deprecated
    protected boolean notConfusedAsId(int symbol, int head, int pos) {
        return true;
    }

    protected void predict(Matrix matrix, List<LexerToken> src) {
        Parser.EarleyCell cell;
        long t1 = 0L;
        if (matrix.visual != null) {
            t1 = System.nanoTime();
        }
        int y = matrix.lastY();
        String lookahead = null;
        Integer LAsuspect = null;
        if (y + 2 < src.size()) {
            lookahead = src.get((int)y).content.toUpperCase();
            LAsuspect = (Integer)this.symbolIndexes.get("'" + lookahead + "'");
        }
        if ((cell = matrix.get(y, y)) == null) {
            cell = new Parser.EarleyCell(this);
        }
        HashSet<Integer> symbols = new HashSet<Integer>();
        IntegerMap xRange = matrix.getXRange(y);
        for (int mid : xRange.keySet()) {
            Parser.EarleyCell candidateRules = matrix.get(mid, y);
            for (int j = 0; j < candidateRules.size(); ++j) {
                int pos = candidateRules.getPosition(j);
                int ruleNo = candidateRules.getRule(j);
                Parser.Tuple t = this.rules[ruleNo];
                if (t.size() <= pos) continue;
                int symbol = t.content(pos);
                symbols.add(symbol);
            }
        }
        Object object = symbols.iterator();
        while (object.hasNext()) {
            PredictedTerminals terminal;
            int symbol = (Integer)object.next();
            if (LAsuspect != null && (terminal = this.terminalPredictions[symbol]) != null && !terminal.matches(LAsuspect)) continue;
            long[] ls = this.predicts.get(symbol);
            this.merge(cell, ls, matrix, lookahead);
        }
        if (matrix.visual != null) {
            long t2 = System.nanoTime();
            long[] lArray = matrix.visual.visited[y];
            int n = y;
            lArray[n] = lArray[n] + (long)((int)(t2 - t1));
        }
        if (cell.size() <= 0) {
            return;
        }
        matrix.put(y, y, cell);
    }

    protected void merge(Parser.EarleyCell cell, long[] ls, Matrix m, String lookahead) {
        cell.merge(ls);
    }

    protected void complete(Matrix matrix, String lookahead) {
        long completionCandidate;
        HashMap<Integer, Integer> skipIntervals = new HashMap<Integer, Integer>();
        while ((completionCandidate = matrix.dequeue()) != -1L) {
            int symbol = Service.lY(completionCandidate);
            int mid = Service.lX(completionCandidate);
            int y = matrix.lastY();
            int indexX = Array.indexOf(matrix.allXs, mid);
            if (matrix.allXs.length - 1 < indexX) {
                indexX = matrix.allXs.length - 1;
            }
            if (mid < matrix.allXs[indexX]) {
                // empty if block
            }
            for (int i = --indexX; 0 <= i; --i) {
                Integer predecessor;
                Parser.EarleyCell pres;
                int x = matrix.allXs[i];
                int skipTo = y;
                long t1 = 0L;
                if (matrix.visual != null) {
                    t1 = System.nanoTime();
                }
                if ((pres = matrix.get(x, mid)) == null) {
                    if (matrix.visual == null) continue;
                    long t2 = System.nanoTime();
                    matrix.visual.visited[x][y] = Service.addlY(matrix.visual.visited[x][y], (int)(t2 - t1));
                    continue;
                }
                long mask = (long)symbol << 48;
                int start = Array.indexOf(pres.getContent(), 0, pres.size() - 1, mask);
                int stop = Array.indexOf(pres.getContent(), 0, pres.size() - 1, mask | 0xFFFFFFFFFFFFL) + 1;
                Parser.EarleyCell content = matrix.get(x, y);
                for (int ii = start; ii < stop && ii < pres.size(); ++ii) {
                    int symPre;
                    int dotPre = pres.getPosition(ii);
                    int rulePre = pres.getRule(ii);
                    Parser.Tuple tPre = this.rules[rulePre];
                    if (tPre.size() == dotPre || (symPre = tPre.content(dotPre)) != symbol || dotPre < tPre.size() - 2 && !this.lookaheadOK(tPre.rhs[dotPre + 1], lookahead)) continue;
                    if (content == null) {
                        content = new Parser.EarleyCell(this);
                    }
                    long promotedRule = Earley.makeMatrixCellElem(rulePre, dotPre + 1, tPre);
                    int before = content.size();
                    content.insertContent(promotedRule);
                    int after = content.size();
                    if (before < after) {
                        matrix.put(x, y, content);
                        if (this.skipRanges && x + 3 < y && tPre.rhs.length == dotPre + 1 && mid < skipTo && this.isOptimizable(tPre, symPre, mid, y)) {
                            skipTo = mid;
                        }
                    }
                    if (tPre.size() != dotPre + 1 || before >= after) continue;
                    matrix.enqueue(Service.lPair(x, tPre.head));
                }
                if (matrix.visual != null) {
                    long t2 = System.nanoTime();
                    matrix.visual.visited[x][y] = Service.addlY(matrix.visual.visited[x][y], (int)(t2 - t1));
                }
                if (!this.skipRanges || x >= skipTo || skipTo >= y || (predecessor = (Integer)skipIntervals.get(x + 1)) != null && skipTo >= predecessor) continue;
                skipIntervals.put(x + 1, skipTo);
            }
        }
        Iterator iterator = skipIntervals.keySet().iterator();
        while (iterator.hasNext()) {
            int y;
            int x = (Integer)iterator.next();
            if (x >= (y = ((Integer)skipIntervals.get(x)).intValue())) continue;
            matrix.allXs = Array.delete(matrix.allXs, x, y);
        }
    }

    protected boolean isOptimizable(Parser.Tuple tuple, int preSym, int mid, int y) {
        return this.isOptimizable(tuple.head, preSym, mid, y);
    }

    protected boolean isOptimizable(int headSym, int preSym, int mid, int y) {
        return this.allSymbols[headSym].charAt(0) != '\"' && this.allSymbols[preSym].charAt(0) != '\"';
    }

    protected boolean lookaheadOK(int symbol, String lookahead) {
        return true;
    }

    @Override
    void toHtml(int ruleNo, int pos, boolean selected, int x, int mid, int y, Matrix matrix, StringBuffer sb) {
        block14: {
            Parser.Tuple rule = this.rules[ruleNo];
            String size = "+1";
            if (selected) {
                sb.append("<b>");
                size = "+2";
            }
            sb.append("<font size=" + size + " color=blue>" + this.allSymbols[rule.head] + ":</font> ");
            String greenish = "<font size=" + size + " bgcolor=rgb(150,200,150))>";
            String bluish = "<font size=" + size + " bgcolor=rgb(150,150,200))>";
            sb.append(greenish);
            for (int i = 0; i < rule.rhs.length; ++i) {
                if (pos == i) {
                    sb.append("</font>" + bluish);
                }
                sb.append(this.allSymbols[rule.rhs[i]] + " ");
            }
            sb.append("</font>");
            if (selected) {
                sb.append("</b>");
            }
            if (mid == -1) {
                return;
            }
            if (!selected || x + y == 0) break block14;
            if (mid < x || x == y) {
                sb.append("<i> predict from </i>");
                Parser.EarleyCell bc = matrix.get(mid, y);
                for (int j = 0; j < bc.size(); ++j) {
                    int bp = bc.getPosition(j);
                    int br = bc.getRule(j);
                    Parser.Tuple bt = this.rules[br];
                    if (bp >= bt.rhs.length || bt.rhs[bp] != rule.head) continue;
                    this.toHtml(br, bp, false, -1, -1, -1, null, sb);
                    return;
                }
            } else if (y < mid) {
                sb.append("<i> scan from </i>");
                Parser.EarleyCell bc = matrix.get(x, y - 1);
                for (int j = 0; j < bc.size(); ++j) {
                    int bp = bc.getPosition(j);
                    int br = bc.getRule(j);
                    Parser.Tuple bt = this.rules[br];
                    if (br != ruleNo || bp + 1 != pos) continue;
                    this.toHtml(br, bp, false, -1, -1, -1, null, sb);
                    return;
                }
            } else {
                sb.append("<i> complete from </i>");
                boolean secondTime = false;
                Parser.EarleyCell pre = matrix.get(x, mid);
                Parser.EarleyCell post = matrix.get(mid, y);
                for (int i = 0; i < pre.size(); ++i) {
                    for (int j = 0; j < post.size(); ++j) {
                        int symPre;
                        int dotPre = pre.getPosition(i);
                        int dotPost = post.getPosition(j);
                        int rulePre = pre.getRule(i);
                        int rulePost = post.getRule(j);
                        Parser.Tuple tPre = this.rules[rulePre];
                        Parser.Tuple tPost = this.rules[rulePost];
                        if (tPre.size() != dotPre && tPost.size() != dotPost || tPost.size() != dotPost || rulePre != ruleNo || dotPre + 1 != pos || (symPre = tPre.content(dotPre)) != tPost.head) continue;
                        if (secondTime) {
                            sb.append("<b> or </b>");
                        }
                        this.toHtml(rulePre, dotPre, false, -1, -1, -1, null, sb);
                        sb.append("<i> and </i>");
                        this.toHtml(rulePost, dotPost, false, -1, -1, -1, null, sb);
                        secondTime = true;
                    }
                }
            }
        }
    }

    public void toString(int ruleNo, int pos, StringBuffer sb) {
        Parser.Tuple rule = this.rules[ruleNo];
        sb.append(rule.toString(pos));
    }

    public void initCell(Matrix matrix, int[] heads, int pos, String lookahead) {
        Parser.EarleyCell cell = new Parser.EarleyCell(this);
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Parser.Tuple t = this.rules[i];
            for (int h : heads) {
                if (t.head != h) continue;
                cell.insertContent(Earley.makeMatrixCellElem(i, 0, t));
                continue block0;
            }
        }
        matrix.put(pos, pos, cell);
        matrix.allXs = Array.insert(matrix.allXs, pos);
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Parser.EarleyCell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            pos = cell.getPosition(i);
            if (this.rules[rule].rhs.length != pos) continue;
            return this.tree(src, m, x, y, rule, pos);
        }
        if (rule != -1 && pos != -1) {
            return this.tree(src, m, x, y, rule, pos);
        }
        return null;
    }

    protected ParseNode tree(List<LexerToken> src, Matrix m, int x, int y, int rule, int pos) {
        LinkedList<Integer> payload = new LinkedList<Integer>();
        block0: while (true) {
            Parser.EarleyCell pre;
            int h = this.rules[rule].head;
            if (pos != 0 && (pre = m.get(x, y - 1)) != null) {
                long demotedRule = Earley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
                int indexOfDemotedRule = Array.indexOf(pre.getContent(), 0, pre.size() - 1, demotedRule);
                long ruleAtTheIndex = pre.content[indexOfDemotedRule];
                if (ruleAtTheIndex == demotedRule) {
                    Parser.Tuple t = this.rules[rule];
                    LexerToken token = src.get(y - 1);
                    Integer suspect = (Integer)this.symbolIndexes.get("'" + (this.isCaseSensitive ? token.content : token.content.toUpperCase()) + "'");
                    if (this.isScannedSymbol(y - 1, src, pos - 1, t, suspect)) {
                        ParseNode branch = new ParseNode(y - 1, y, this.rules[rule].rhs[pos - 1], this);
                        if (x + 1 == y) {
                            if (this.rules[rule].rhs.length == 1) {
                                branch.addContent(h);
                            }
                            Iterator iterator = payload.iterator();
                            while (iterator.hasNext()) {
                                int s = (Integer)iterator.next();
                                branch.addContent(s);
                            }
                            return branch;
                        }
                        int head = h;
                        if (pos != this.rules[rule].rhs.length) {
                            head = -1;
                        }
                        ParseNode ret = new ParseNode(x, y, head, head, this);
                        ret.lft = this.tree(src, m, x, y - 1, rule, pos - 1);
                        ret.lft.parent = ret;
                        ret.rgt = branch;
                        ret.rgt.parent = ret;
                        Iterator iterator = payload.iterator();
                        while (iterator.hasNext()) {
                            int s = (Integer)iterator.next();
                            ret.addContent(s);
                        }
                        return ret;
                    }
                }
            }
            if (pos == 0) break;
            long demotedRule = Earley.makeMatrixCellElem(rule, pos - 1, this.rules[rule]);
            IntegerMap cellsAtY = m.getXRange(y);
            for (int mid : this.isAsc(h) ? cellsAtY.keySet() : cellsAtY.descendingKeySet()) {
                Parser.EarleyCell post;
                Parser.EarleyCell pre2 = m.get(x, mid);
                if (pre2 == null || (post = m.get(mid, y)) == null || pre2.content[Array.indexOf(pre2.content, 0, pre2.size() - 1, demotedRule)] != demotedRule) continue;
                for (int j = 0; j <= post.size() - 1; ++j) {
                    int rJ = post.getRule(j);
                    int pJ = post.getPosition(j);
                    if (this.rules[rJ].rhs.length != pJ || this.rules[rJ].head != this.rules[rule].rhs[pos - 1]) continue;
                    if (x != mid) {
                        ParseNode ret = new ParseNode(x, y, this.rules[rule].rhs.length != pos ? -1 : h, this);
                        ret.lft = this.tree(src, m, x, mid, rule, pos - 1);
                        ret.lft.parent = ret;
                        ret.rgt = this.tree(src, m, mid, y, rJ, pJ);
                        ret.rgt.parent = ret;
                        Iterator iterator = payload.iterator();
                        while (iterator.hasNext()) {
                            int s = (Integer)iterator.next();
                            ret.addContent(s);
                        }
                        return ret;
                    }
                    if (rJ == rule && pJ == pos) continue;
                    this.diagnose(m, x, y);
                    if (this.rules[rule].rhs.length == pos) {
                        payload.add(h);
                    }
                    rule = rJ;
                    pos = pJ;
                    continue block0;
                }
            }
            break;
        }
        throw new AssertionError((Object)("unwind " + this.rules[rule].toString(pos) + " @[" + x + "," + y + ")"));
    }

    protected void diagnose(Matrix m, int x, int y) {
    }

    public Set<Long> predict(int pos, Matrix matrix) {
        HashSet<Long> predictions = new HashSet<Long>();
        for (int x = 0; x <= pos; ++x) {
            Parser.EarleyCell cell = matrix.get(x, pos);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                int rule = cell.getRule(i);
                int p = cell.getPosition(i);
                if (p >= this.rules[rule].rhs.length) continue;
                String e = this.allSymbols[this.rules[rule].rhs[p]];
                predictions.add(Service.lPair(this.rules[rule].rhs[p], this.rules[rule].head));
            }
        }
        return predictions;
    }

    public class PredictedTerminals
    implements Serializable {
        private boolean isValid = true;
        int[] symbols = null;

        void add(int sym) {
            if (this.isValid) {
                this.symbols = Array.insert(this.symbols, sym);
            } else {
                this.invalidate();
            }
        }

        void invalidate() {
            this.symbols = null;
            this.isValid = false;
        }

        public boolean matches(Integer lookahead) {
            if (!this.isValid) {
                return true;
            }
            if (this.symbols == null) {
                return true;
            }
            return lookahead != null && this.symbols[Array.indexOf(this.symbols, lookahead)] == lookahead;
        }

        public String toString() {
            if (!this.isValid) {
                return "*invalid*";
            }
            if (this.symbols == null) {
                return "*symbols == null*";
            }
            StringBuilder ret = new StringBuilder("{");
            for (int s : this.symbols) {
                ret.append(Earley.this.allSymbols[s]);
                ret.append(',');
            }
            return ret.toString();
        }
    }
}

