/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.olapihelpers.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.ide.Ide;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.ceditor.options.S2Highlight;
import oracle.ide.ceditor.options.S2Style;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.ceditor.options.SyntaxColorsOptionsPanel;
import oracle.ide.ceditor.options.SyntaxHighlight;
import oracle.ide.ceditor.options.SyntaxSchemes;
import oracle.ide.ceditor.options.SyntaxStyle;
import oracle.ide.config.DTCache;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.SortedListModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FontHelper;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.UnderlinePainter;
import oracle.javatools.editor.language.AbstractDocumentRenderer;
import oracle.javatools.editor.language.AbstractLanguageSupport;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.StyledFragment;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.util.Copyable;
import oracle.olap.syntaxbuilder.olapihelpers.language.OLAPILanguageModule;

public final class OLAPISyntaxColorsOptionsPanel
extends DefaultTraversablePanel
implements ActionListener,
ApplyListener,
CaretListener,
ChangeListener,
ItemListener,
ListSelectionListener,
PropertyChangeListener,
ToolTipProvider {
    private static final String DEFAULT_SCHEME = "Default";
    private static final String DEFAULT_SCHEME_FILE = "default_schemes.xml";
    private SyntaxSchemes schemeMap;
    private CardPanel panel_card;
    private static final String STYLE_CARD = "style";
    private static final String HIGHLIGHT_CARD = "highlight";
    private JComboBox comboBox_scheme;
    private JButton button_saveAs;
    private JButton button_delete;
    private JList list_styles;
    private JLabel label_styleSample;
    private JTextField field_styleSample;
    private JLabel label_foreground;
    private CustomColorChoice colorChoice_specifyForeground;
    private JLabel label_background;
    private CustomColorChoice colorChoice_specifyBackground;
    private JLabel label_fontStyle;
    private JComboBox comboBox_fontStyle;
    private ComboBoxModel cbModel_extended;
    private ComboBoxModel cbModel_base;
    private JLabel label_highlightSample;
    private UnderlineField field_highlightSample;
    private JCheckBox checkBox_enableHighlight;
    private JLabel label_priority;
    private JSlider slider_priority;
    private JLabel label_priorityText;
    private JLabel label_highlightFG;
    private CustomColorChoice colorChoice_highlightFG;
    private JLabel label_highlightBG;
    private CustomColorChoice colorChoice_highlightBG;
    private JLabel label_highlightFont;
    private JComboBox comboBox_highlightFont;
    private ComboBoxModel cbModel_highlight;
    private JLabel label_underlineStyle;
    private ComboBoxModel cbModel_underline;
    private JComboBox comboBox_underlineStyle;
    private JLabel label_underlineColor;
    private CustomColorChoice colorChoice_underlineColor;
    private JScrollPane scrollPane_sampleText;
    private JLabel label_sampleText;
    private BasicEditorPane editor_sampleText;
    private StyleRegistry m_styleRegistry;
    private HighlightRegistry highlightRegistry;
    private HighlightLayer highlightLayer;
    private BaseStyle editedStyle;
    private HighlightStyle editedHighlight;
    private DefaultListModel styleListModel;
    private static final String FONT_STYLE_USE_DEFAULT = OptionsArb.getString((int)91);
    private static final String FONT_STYLE_NORMAL = OptionsArb.getString((int)92);
    private static final String FONT_STYLE_BOLD = OptionsArb.getString((int)93);
    private static final String FONT_STYLE_ITALIC = OptionsArb.getString((int)94);
    private static final String FONT_STYLE_BOLDITALIC = OptionsArb.getString((int)95);
    private static final String CATEGORY_ALL = OptionsArb.getString((int)75);
    private static final String UNDERLINE_STYLE_NONE = OptionsArb.getString((int)98);
    private static final String UNDERLINE_STYLE_SINGLE = OptionsArb.getString((int)101);
    private static final String UNDERLINE_STYLE_DOUBLE = OptionsArb.getString((int)102);
    private static final String UNDERLINE_STYLE_SINGLE_DOTTED = OptionsArb.getString((int)103);
    private static final String UNDERLINE_STYLE_DOUBLE_DOTTED = OptionsArb.getString((int)104);
    private static final String UNDERLINE_STYLE_WAVY = OptionsArb.getString((int)105);
    private static final String SEPARATOR_STYLE_SINGLE = OptionsArb.getString((int)106);
    private static final String SEPARATOR_STYLE_DOUBLE = OptionsArb.getString((int)107);
    private static final String SEPARATOR_STYLE_SINGLE_DOTTED = OptionsArb.getString((int)108);
    private static final String SEPARATOR_STYLE_DOUBLE_DOTTED = OptionsArb.getString((int)109);
    private static final String SEPARATOR_STYLE_PERFORATED = OptionsArb.getString((int)110);
    private static final String STRIKETHRU_STYLE_SINGLE = OptionsArb.getString((int)99);
    private static final String STRIKETHRU_STYLE_DOUBLE = OptionsArb.getString((int)100);
    private static final String SCHEME_CUSTOM = " ";
    private static boolean SHOW_PRIORITY_CONTROLS = false;
    private boolean inUpdate;

    public OLAPISyntaxColorsOptionsPanel() {
        this.setHelpID("olap_preferences_dml_syntax_colors");
        this.setLayout(new GridBagLayout());
        this.inUpdate = false;
        DTCache dTCache = Ide.getDTCache();
        this.schemeMap = (SyntaxSchemes)dTCache.getData("SyntaxSchemes");
        if (this.schemeMap == null) {
            this.schemeMap = OLAPISyntaxColorsOptionsPanel.loadDefaultSchemes();
            dTCache.putData("SyntaxSchemes", (Copyable)this.schemeMap);
        }
        this.addOLAPStyles(this.schemeMap);
        this.initializeComponent();
    }

    private void addOLAPStyles(SyntaxSchemes syntaxSchemes) {
        String[] stringArray = syntaxSchemes.getSchemeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            S2Style s2Style;
            String string = stringArray[i];
            List list = syntaxSchemes.getScheme(string);
            ArrayList<S2Style> arrayList = new ArrayList<S2Style>();
            boolean bl = false;
            for (Copyable copyable : list) {
                if (!(copyable instanceof S2Style) || !(s2Style = (S2Style)copyable).getStyleName().equalsIgnoreCase("olapi-comment-style")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            for (Copyable copyable : list) {
                s2Style = (Copyable)copyable.copyTo(null);
                arrayList.add(s2Style);
            }
            for (Copyable copyable : list) {
                S2Style s2Style2;
                if (!(copyable instanceof S2Style)) continue;
                s2Style = (S2Style)copyable;
                if (s2Style.getStyleName().equalsIgnoreCase("plsql-brace-style")) {
                    s2Style2 = (S2Style)copyable.copyTo(null);
                    s2Style2.setStyleName("olapi-brace-style");
                    arrayList.add(s2Style2);
                }
                if (s2Style.getStyleName().equalsIgnoreCase("plsql-comment-style")) {
                    s2Style2 = (S2Style)copyable.copyTo(null);
                    s2Style2.setStyleName("olapi-comment-style");
                    arrayList.add(s2Style2);
                }
                if (s2Style.getStyleName().equalsIgnoreCase("plsql-identifier-style")) {
                    s2Style2 = (S2Style)copyable.copyTo(null);
                    s2Style2.setStyleName("olapi-identifier-style");
                    arrayList.add(s2Style2);
                }
                if (s2Style.getStyleName().equalsIgnoreCase("plsql-keyword-style")) {
                    s2Style2 = (S2Style)copyable.copyTo(null);
                    s2Style2.setStyleName("olapi-keyword-style");
                    arrayList.add(s2Style2);
                }
                if (s2Style.getStyleName().equalsIgnoreCase("plsql-number-style")) {
                    s2Style2 = (S2Style)copyable.copyTo(null);
                    s2Style2.setStyleName("olapi-number-style");
                    arrayList.add(s2Style2);
                }
                if (s2Style.getStyleName().equalsIgnoreCase("plsql-string-style")) {
                    s2Style2 = (S2Style)copyable.copyTo(null);
                    s2Style2.setStyleName("olapi-string-style");
                    arrayList.add(s2Style2);
                }
                if (!s2Style.getStyleName().equalsIgnoreCase("plsql-operator-style")) continue;
                s2Style2 = (S2Style)copyable.copyTo(null);
                s2Style2.setStyleName("olapi-operator-style");
                arrayList.add(s2Style2);
            }
            syntaxSchemes.putScheme(string, arrayList);
        }
    }

    private static SyntaxSchemes loadDefaultSchemes() {
        SyntaxSchemes syntaxSchemes = new SyntaxSchemes();
        try {
            URL uRL = SyntaxColorsOptionsPanel.class.getResource(DEFAULT_SCHEME_FILE);
            Object2Dom object2Dom = Object2Dom.newInstance();
            SyntaxSchemes syntaxSchemes2 = (SyntaxSchemes)object2Dom.toObject(uRL);
            syntaxSchemes2.copyTo((Object)syntaxSchemes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return syntaxSchemes;
    }

    public void onEntry(TraversableContext traversableContext) {
        SyntaxColorsOptions syntaxColorsOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(syntaxColorsOptions);
        FontSizeOptions fontSizeOptions = FontSizeOptions.getInstance((PropertyStorage)traversableContext.getPropertyStorage());
        String string = fontSizeOptions.getFontFamily();
        int n = fontSizeOptions.getFontSize();
        this.editor_sampleText.setBaseFont(string, n);
        FontHelper fontHelper = this.editor_sampleText.getFontHelper();
        Font font = fontHelper.getBaseFont();
        this.field_styleSample.setFont(font);
        this.field_highlightSample.setFont(font);
        this.updateStyleSample();
        this.updateHighlightSample();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SyntaxColorsOptions syntaxColorsOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(syntaxColorsOptions);
    }

    private SyntaxColorsOptions findOptions(TraversableContext traversableContext) {
        SyntaxColorsOptions syntaxColorsOptions = SyntaxColorsOptions.getInstance((PropertyStorage)traversableContext.getPropertyStorage());
        return syntaxColorsOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        SyntaxColorsOptions syntaxColorsOptions = this.findOptions(traversableContext);
        OLAPISyntaxColorsOptionsPanel.applyOptions(syntaxColorsOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(SyntaxColorsOptions syntaxColorsOptions) {
        SyntaxStyle syntaxStyle;
        Object object;
        List list;
        Object object2;
        Object object3;
        EditorProperties editorProperties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
        StyleRegistry styleRegistry2 = (StyleRegistry)styleRegistry.clone();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        HighlightRegistry highlightRegistry2 = (HighlightRegistry)highlightRegistry.clone();
        if (syntaxColorsOptions.getFirstTime()) {
            syntaxColorsOptions.setFirstTime(false);
            object3 = Ide.getDTCache();
            object2 = OLAPISyntaxColorsOptionsPanel.loadDefaultSchemes();
            object3.putData("SyntaxSchemes", (Copyable)object2);
            list = object2.getScheme(DEFAULT_SCHEME);
            object = new ArrayList();
            for (String[] stringArray : list) {
                Copyable copyable = (Copyable)stringArray.copyTo(null);
                object.add((Copyable)copyable);
            }
            syntaxColorsOptions.setStyleList(object);
            syntaxColorsOptions.setSelectedScheme(DEFAULT_SCHEME);
        }
        if (!syntaxColorsOptions.getMigrated()) {
            syntaxColorsOptions.setMigrated(true);
            object3 = syntaxColorsOptions.getStyleList();
            object2 = OLAPISyntaxColorsOptionsPanel.migrateStyleList((List)object3);
            syntaxColorsOptions.setStyleList((List)object2);
            list = Ide.getDTCache();
            object = (SyntaxSchemes)list.getData("SyntaxSchemes");
            if (object != null) {
                String[] stringArray;
                syntaxStyle = new SyntaxSchemes();
                stringArray = object.getSchemeNames();
                int n = stringArray != null ? stringArray.length : 0;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    object3 = object.getScheme(string);
                    object2 = OLAPISyntaxColorsOptionsPanel.migrateStyleList((List)object3);
                    syntaxStyle.putScheme(string, (List)object2);
                }
                list.putData("SyntaxSchemes", (Copyable)syntaxStyle);
            }
        }
        object3 = syntaxColorsOptions.getStyleList();
        int n = object3.size();
        for (int i = 0; i < n; ++i) {
            object = object3.get(i);
            if (object instanceof SyntaxStyle) {
                syntaxStyle = (SyntaxStyle)object;
                OLAPISyntaxColorsOptionsPanel.copySyntaxStyleToStyleRegistry(syntaxStyle, styleRegistry2);
                continue;
            }
            if (!(object instanceof SyntaxHighlight)) continue;
            syntaxStyle = (SyntaxHighlight)object;
            OLAPISyntaxColorsOptionsPanel.copySyntaxHighlightToHighlightRegistry((SyntaxHighlight)syntaxStyle, highlightRegistry2);
        }
        editorProperties.setStyleRegistry(styleRegistry2);
        editorProperties.setHighlightRegistry(highlightRegistry2);
    }

    private static List migrateStyleList(List list) {
        int n = list.size();
        ArrayList<Copyable> arrayList = new ArrayList<Copyable>(n);
        for (int i = 0; i < n; ++i) {
            Copyable copyable = (Copyable)list.get(i);
            if (copyable == null) continue;
            if (copyable instanceof SyntaxHighlight) {
                copyable = (Copyable)copyable.copyTo((Object)new S2Highlight());
            } else if (copyable instanceof SyntaxStyle) {
                copyable = (Copyable)copyable.copyTo((Object)new S2Style());
            }
            arrayList.add(copyable);
        }
        return arrayList;
    }

    void loadSettingsFrom(SyntaxColorsOptions syntaxColorsOptions) {
        List list = syntaxColorsOptions.getStyleList();
        OLAPISyntaxColorsOptionsPanel.copyStyleListToRegistries(list, this.m_styleRegistry, this.highlightRegistry);
        String string = syntaxColorsOptions.getSelectedScheme();
        if (string == null) {
            string = SCHEME_CUSTOM;
        }
        this.selectSchemeName(string);
    }

    void saveSettingsTo(SyntaxColorsOptions syntaxColorsOptions) {
        List list = syntaxColorsOptions.getStyleList();
        OLAPISyntaxColorsOptionsPanel.copyRegistriesToStyleList(this.m_styleRegistry, this.highlightRegistry, list);
        syntaxColorsOptions.setStyleList(list);
        String string = (String)this.comboBox_scheme.getSelectedItem();
        syntaxColorsOptions.setSelectedScheme(string);
    }

    private static void copyStyleListToRegistries(List list, StyleRegistry styleRegistry, HighlightRegistry highlightRegistry) {
        String string = "base-lf-style";
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SyntaxStyle syntaxStyle;
            Object e = list.get(i);
            if (e == null) continue;
            if (e instanceof SyntaxStyle) {
                syntaxStyle = (SyntaxStyle)e;
                if (syntaxStyle.getStyleName().equals(string)) continue;
                OLAPISyntaxColorsOptionsPanel.copySyntaxStyleToStyleRegistry(syntaxStyle, styleRegistry);
                continue;
            }
            if (!(e instanceof SyntaxHighlight)) continue;
            syntaxStyle = (SyntaxHighlight)e;
            OLAPISyntaxColorsOptionsPanel.copySyntaxHighlightToHighlightRegistry((SyntaxHighlight)syntaxStyle, highlightRegistry);
        }
    }

    private static void copyRegistriesToStyleList(StyleRegistry styleRegistry, HighlightRegistry highlightRegistry, List list) {
        S2Highlight s2Highlight;
        BaseStyle baseStyle;
        String string = "base-lf-style";
        Iterator iterator = styleRegistry.getStyleIterator();
        while (iterator.hasNext()) {
            baseStyle = (BaseStyle)iterator.next();
            if (baseStyle == null || baseStyle.getName().equals(string)) continue;
            s2Highlight = new S2Style();
            OLAPISyntaxColorsOptionsPanel.copyBaseStyleToSyntaxStyle(baseStyle, (SyntaxStyle)s2Highlight);
            OLAPISyntaxColorsOptionsPanel.addSyntaxStyleToStyleList((SyntaxStyle)s2Highlight, list);
        }
        iterator = highlightRegistry.getStyleIterator();
        while (iterator.hasNext()) {
            baseStyle = (HighlightStyle)iterator.next();
            s2Highlight = new S2Highlight();
            OLAPISyntaxColorsOptionsPanel.copyHighlightStyleToSyntaxHighlight((HighlightStyle)baseStyle, (SyntaxHighlight)s2Highlight);
            OLAPISyntaxColorsOptionsPanel.addSyntaxHighlightToStyleList((SyntaxHighlight)s2Highlight, list);
        }
    }

    private static void copyHighlightStyleToSyntaxHighlight(HighlightStyle highlightStyle, SyntaxHighlight syntaxHighlight) {
        String string = highlightStyle.getName();
        Color color = highlightStyle.getForegroundColor();
        Color color2 = highlightStyle.getBackgroundColor();
        int n = highlightStyle.getPriority();
        boolean bl = highlightStyle.getEnabled();
        int n2 = highlightStyle.getFontStyle();
        UnderlinePainter underlinePainter = highlightStyle.getUnderlinePainter();
        int n3 = HighlightRegistry.lookupPredefinedPainter((UnderlinePainter)underlinePainter);
        Color color3 = highlightStyle.getUnderlineColor();
        syntaxHighlight.setStyleName(string);
        syntaxHighlight.setEnabled(bl);
        syntaxHighlight.setPriority(n);
        boolean bl2 = color != null;
        int n4 = color != null ? color.getRGB() : 0;
        syntaxHighlight.setUseFG(bl2);
        syntaxHighlight.setForegroundRGB(n4);
        boolean bl3 = color2 != null;
        int n5 = color2 != null ? color2.getRGB() : 0;
        syntaxHighlight.setUseBG(bl3);
        syntaxHighlight.setBackgroundRGB(n5);
        syntaxHighlight.setFontStyle(n2);
        syntaxHighlight.setUnderlineStyle(n3);
        int n6 = color3 != null ? color3.getRGB() : 0;
        syntaxHighlight.setUnderlineRGB(n6);
    }

    private static void copyBaseStyleToSyntaxStyle(BaseStyle baseStyle, SyntaxStyle syntaxStyle) {
        String string = baseStyle.getName();
        Color color = baseStyle.getForegroundColor();
        boolean bl = baseStyle.getUsesParentForegroundColor();
        Color color2 = baseStyle.getBackgroundColor();
        boolean bl2 = baseStyle.getUsesParentBackgroundColor();
        int n = baseStyle.getFontStyle();
        boolean bl3 = baseStyle.getUsesParentFontStyle();
        syntaxStyle.setStyleName(string);
        syntaxStyle.setForegroundRGB(color.getRGB());
        syntaxStyle.setUseParentFG(bl);
        syntaxStyle.setBackgroundRGB(color2.getRGB());
        syntaxStyle.setUseParentBG(bl2);
        syntaxStyle.setFontStyle(n);
        syntaxStyle.setUseParentFontStyle(bl3);
    }

    private static void copySyntaxHighlightToHighlightRegistry(SyntaxHighlight syntaxHighlight, HighlightRegistry highlightRegistry) {
        String string = syntaxHighlight.getStyleName();
        boolean bl = syntaxHighlight.getUseFG();
        Color color = bl ? new Color(syntaxHighlight.getForegroundRGB()) : null;
        boolean bl2 = syntaxHighlight.getUseBG();
        Color color2 = bl2 ? new Color(syntaxHighlight.getBackgroundRGB()) : null;
        int n = syntaxHighlight.getPriority();
        boolean bl3 = syntaxHighlight.getEnabled();
        int n2 = syntaxHighlight.getFontStyle();
        int n3 = syntaxHighlight.getUnderlineStyle();
        int n4 = syntaxHighlight.getUnderlineRGB();
        Color color3 = n4 == 0 ? null : new Color(n4);
        highlightRegistry.modifyStyle(string, bl3, n, color, color2, n2, n3, color3);
    }

    private static void copySyntaxStyleToStyleRegistry(SyntaxStyle syntaxStyle, StyleRegistry styleRegistry) {
        String string = syntaxStyle.getStyleName();
        Color color = new Color(syntaxStyle.getForegroundRGB());
        boolean bl = syntaxStyle.getUseParentFG();
        Color color2 = new Color(syntaxStyle.getBackgroundRGB());
        boolean bl2 = syntaxStyle.getUseParentBG();
        int n = syntaxStyle.getFontStyle();
        boolean bl3 = syntaxStyle.getUseParentFontStyle();
        styleRegistry.modifyStyle(string, bl, color, bl2, color2, bl3, n);
    }

    private static void addSyntaxHighlightToStyleList(SyntaxHighlight syntaxHighlight, List list) {
        if (syntaxHighlight == null) {
            return;
        }
        int n = OLAPISyntaxColorsOptionsPanel.findSyntaxHighlightInStyleList(syntaxHighlight, list);
        if (n != -1) {
            SyntaxHighlight syntaxHighlight2 = (SyntaxHighlight)list.get(n);
            syntaxHighlight.copyTo((Object)syntaxHighlight2);
        } else {
            list.add(syntaxHighlight);
        }
    }

    private static void addSyntaxStyleToStyleList(SyntaxStyle syntaxStyle, List list) {
        if (syntaxStyle == null) {
            return;
        }
        int n = OLAPISyntaxColorsOptionsPanel.findSyntaxStyleInStyleList(syntaxStyle, list);
        if (n != -1) {
            SyntaxStyle syntaxStyle2 = (SyntaxStyle)list.get(n);
            syntaxStyle.copyTo((Object)syntaxStyle2);
        } else {
            list.add(syntaxStyle);
        }
    }

    private static int findSyntaxHighlightInStyleList(SyntaxHighlight syntaxHighlight, List list) {
        String string = syntaxHighlight.getStyleName();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SyntaxHighlight syntaxHighlight2;
            Object e = list.get(i);
            if (!(e instanceof SyntaxHighlight) || !(syntaxHighlight2 = (SyntaxHighlight)e).getStyleName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static int findSyntaxStyleInStyleList(SyntaxStyle syntaxStyle, List list) {
        String string = syntaxStyle.getStyleName();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SyntaxStyle syntaxStyle2;
            Object e = list.get(i);
            if (!(e instanceof SyntaxStyle) || !(syntaxStyle2 = (SyntaxStyle)e).getStyleName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private ComboBoxModel createSchemeModel() {
        Object[] objectArray = this.schemeMap.getSchemeNames();
        Arrays.sort(objectArray, String.CASE_INSENSITIVE_ORDER);
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        return nonNullableComboBoxModel;
    }

    private void addSchemeName(String string) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboBox_scheme.getModel();
        if (defaultComboBoxModel.getIndexOf(string) == -1) {
            int n;
            int n2 = n = defaultComboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)defaultComboBoxModel.getElementAt(i);
                if (string2.equals(SCHEME_CUSTOM) || string2.compareToIgnoreCase(string) <= 0) continue;
                n2 = i;
                break;
            }
            this.beginUIUpdate();
            defaultComboBoxModel.insertElementAt(string, n2);
            this.endUIUpdate();
        }
        this.selectSchemeName(string);
    }

    private void selectSchemeName(String string) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboBox_scheme.getModel();
        if (defaultComboBoxModel.getIndexOf(string) == -1 || string != null && string.equals(SCHEME_CUSTOM)) {
            if (defaultComboBoxModel.getIndexOf(SCHEME_CUSTOM) == -1) {
                this.beginUIUpdate();
                defaultComboBoxModel.insertElementAt(SCHEME_CUSTOM, 0);
                this.endUIUpdate();
            }
            this.comboBox_scheme.setSelectedItem(SCHEME_CUSTOM);
            return;
        }
        this.comboBox_scheme.setSelectedItem(string);
        int n = defaultComboBoxModel.getIndexOf(SCHEME_CUSTOM);
        if (n != -1) {
            this.beginUIUpdate();
            defaultComboBoxModel.removeElementAt(n);
            this.endUIUpdate();
        }
    }

    private void deleteSchemeName(String string) {
        this.selectSchemeName(SCHEME_CUSTOM);
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.comboBox_scheme.getModel();
        int n = defaultComboBoxModel.getIndexOf(string);
        if (n != -1) {
            this.beginUIUpdate();
            defaultComboBoxModel.removeElementAt(n);
            this.endUIUpdate();
        }
    }

    private void showErrorDialog(String string, String string2) {
        JOptionPane.showMessageDialog((Component)((Object)this), string, string2, 2);
    }

    private void initializeComponent() {
        Insets insets = new Insets(0, 0, 0, 0);
        ComboBoxModel comboBoxModel = this.createSchemeModel();
        this.comboBox_scheme = new JComboBox(comboBoxModel);
        this.comboBox_scheme.setEditable(false);
        this.comboBox_scheme.addItemListener(this);
        String string = OptionsArb.getString((int)71);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.comboBox_scheme, (String)string);
        String string2 = OptionsArb.getString((int)72);
        this.button_saveAs = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_saveAs, (String)string2);
        this.button_saveAs.addActionListener(this);
        String string3 = OptionsArb.getString((int)73);
        this.button_delete = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_delete, (String)string3);
        this.button_delete.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)jLabel, "Before");
        jPanel.add(this.comboBox_scheme);
        ButtonBar buttonBar = new ButtonBar(0);
        buttonBar.add((Component)this.button_saveAs);
        buttonBar.add((Component)this.button_delete);
        jPanel.add((Component)buttonBar, "After");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        ArrayList arrayList = new ArrayList();
        Iterator iterator = LanguageModule.getLanguageIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        arrayList.add(CATEGORY_ALL);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        Object[] objectArray = arrayList.toArray();
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.list_styles = new JList();
        ListSelectionModel listSelectionModel = this.list_styles.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.list_styles);
        this.list_styles.addListSelectionListener(this);
        String string4 = OptionsArb.getString((int)76);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.list_styles, (String)string4);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        String string5 = OptionsArb.getString((int)77);
        String string6 = OptionsArb.getString((int)78);
        this.label_styleSample = new JLabel();
        this.field_styleSample = new JTextField(string6);
        this.field_styleSample.setCaretPosition(0);
        ResourceUtils.resLabel((JLabel)this.label_styleSample, (Component)this.field_styleSample, (String)string5);
        String string7 = OptionsArb.getString((int)79);
        this.label_fontStyle = new JLabel();
        Object[] objectArray2 = new String[]{FONT_STYLE_USE_DEFAULT, FONT_STYLE_NORMAL, FONT_STYLE_BOLD, FONT_STYLE_ITALIC, FONT_STYLE_BOLDITALIC};
        Object[] objectArray3 = new String[]{FONT_STYLE_NORMAL};
        this.cbModel_extended = new NonNullableComboBoxModel(objectArray2);
        this.cbModel_base = new NonNullableComboBoxModel(objectArray3);
        this.comboBox_fontStyle = new JComboBox(this.cbModel_extended);
        this.comboBox_fontStyle.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.label_fontStyle, (Component)this.comboBox_fontStyle, (String)string7);
        String string8 = OptionsArb.getString((int)80);
        this.label_foreground = new JLabel();
        this.colorChoice_specifyForeground = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)this.label_foreground, (Component)this.colorChoice_specifyForeground, (String)string8);
        this.colorChoice_specifyForeground.addPropertyChangeListener((PropertyChangeListener)this);
        String string9 = OptionsArb.getString((int)81);
        this.label_background = new JLabel(string9);
        this.colorChoice_specifyBackground = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)this.label_background, (Component)this.colorChoice_specifyBackground, (String)string9);
        this.colorChoice_specifyBackground.addPropertyChangeListener((PropertyChangeListener)this);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.label_styleSample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.8, 0.0, 17, 2, insets, 0, 0);
        jPanel4.add((Component)this.field_styleSample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel4.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.label_fontStyle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.8, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.comboBox_fontStyle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel4.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.label_foreground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 4, 1, 1, 0.8, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.colorChoice_specifyForeground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel4.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.label_background, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 6, 1, 1, 0.8, 0.0, 17, 0, insets, 0, 0);
        jPanel4.add((Component)this.colorChoice_specifyBackground, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        jPanel4.add(Box.createGlue(), gridBagConstraints);
        String string10 = OptionsArb.getString((int)82);
        this.label_highlightSample = new JLabel();
        String string11 = OptionsArb.getString((int)83);
        this.field_highlightSample = new UnderlineField(string11);
        this.field_highlightSample.setCaretPosition(0);
        ResourceUtils.resLabel((JLabel)this.label_highlightSample, (Component)this.field_highlightSample, (String)string10);
        String string12 = OptionsArb.getString((int)84);
        this.checkBox_enableHighlight = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkBox_enableHighlight, (String)string12);
        this.checkBox_enableHighlight.addItemListener(this);
        String string13 = OptionsArb.getString((int)85);
        this.label_priority = new JLabel();
        this.slider_priority = new JSlider(1, 100);
        this.slider_priority.addChangeListener(this);
        this.label_priorityText = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_priority, (Component)this.slider_priority, (String)string13);
        String string14 = "1";
        String string15 = "100";
        JLabel jLabel3 = new JLabel(string14);
        JLabel jLabel4 = new JLabel(string15);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(1, jLabel3);
        hashtable.put(100, jLabel4);
        this.slider_priority.setLabelTable(hashtable);
        this.slider_priority.setPaintLabels(true);
        this.slider_priority.setPaintTicks(true);
        this.slider_priority.setMajorTickSpacing(20);
        this.slider_priority.setMinorTickSpacing(10);
        this.colorChoice_highlightFG = new CustomColorChoice();
        this.colorChoice_highlightFG.addPropertyChangeListener((PropertyChangeListener)this);
        this.colorChoice_highlightFG.setTransparentAllowed(true);
        String string16 = OptionsArb.getString((int)86);
        this.label_highlightFG = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_highlightFG, (Component)this.colorChoice_highlightFG, (String)string16);
        this.colorChoice_highlightBG = new CustomColorChoice();
        this.colorChoice_highlightBG.addPropertyChangeListener((PropertyChangeListener)this);
        this.colorChoice_highlightBG.setTransparentAllowed(true);
        String string17 = OptionsArb.getString((int)87);
        this.label_highlightBG = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_highlightBG, (Component)this.colorChoice_highlightBG, (String)string17);
        String string18 = OptionsArb.getString((int)89);
        this.label_highlightFont = new JLabel();
        Object[] objectArray4 = new String[]{FONT_STYLE_USE_DEFAULT, FONT_STYLE_BOLD, FONT_STYLE_ITALIC, FONT_STYLE_BOLDITALIC};
        this.cbModel_highlight = new NonNullableComboBoxModel(objectArray4);
        this.comboBox_highlightFont = new JComboBox(this.cbModel_highlight);
        this.comboBox_highlightFont.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.label_highlightFont, (Component)this.comboBox_highlightFont, (String)string18);
        String string19 = OptionsArb.getString((int)96);
        this.label_underlineStyle = new JLabel();
        Object[] objectArray5 = new String[]{UNDERLINE_STYLE_NONE, STRIKETHRU_STYLE_SINGLE, STRIKETHRU_STYLE_DOUBLE, UNDERLINE_STYLE_SINGLE, UNDERLINE_STYLE_DOUBLE, UNDERLINE_STYLE_SINGLE_DOTTED, UNDERLINE_STYLE_DOUBLE_DOTTED, UNDERLINE_STYLE_WAVY, SEPARATOR_STYLE_SINGLE, SEPARATOR_STYLE_DOUBLE, SEPARATOR_STYLE_SINGLE_DOTTED, SEPARATOR_STYLE_DOUBLE_DOTTED, SEPARATOR_STYLE_PERFORATED};
        this.cbModel_underline = new NonNullableComboBoxModel(objectArray5);
        this.comboBox_underlineStyle = new JComboBox(this.cbModel_underline);
        this.comboBox_underlineStyle.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.label_underlineStyle, (Component)this.comboBox_underlineStyle, (String)string19);
        this.colorChoice_underlineColor = new CustomColorChoice();
        this.colorChoice_underlineColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.colorChoice_underlineColor.setTransparentAllowed(true);
        String string20 = OptionsArb.getString((int)97);
        this.label_underlineColor = new JLabel();
        ResourceUtils.resLabel((JLabel)this.label_underlineColor, (Component)this.colorChoice_underlineColor, (String)string20);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        Insets insets2 = new Insets(0, 25, 0, 0);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        if (SHOW_PRIORITY_CONTROLS) {
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, insets, 0, 0);
            jPanel6.add((Component)this.label_priority, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.6, 0.0, 17, 2, insets, 0, 0);
            jPanel6.add((Component)this.slider_priority, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(2, 0, 1, 1, 0.3, 0.0, 17, 0, insets, 0, 0);
            jPanel6.add((Component)this.label_priorityText, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
            jPanel6.add(Box.createVerticalStrut(2), gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.1, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.label_highlightFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 2, 1, 0.9, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.comboBox_highlightFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel6.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.label_highlightFG, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 4, 2, 1, 0.9, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.colorChoice_highlightFG, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel6.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 0.1, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.label_highlightBG, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 6, 2, 1, 0.9, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.colorChoice_highlightBG, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel6.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 0.1, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.label_underlineStyle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 8, 2, 1, 0.9, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.comboBox_underlineStyle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 9, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel6.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 10, 1, 1, 0.1, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.label_underlineColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 10, 2, 1, 0.9, 0.0, 17, 0, insets, 0, 0);
        jPanel6.add((Component)this.colorChoice_underlineColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel5.add((Component)this.label_highlightSample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel5.add((Component)this.field_highlightSample, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel5.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel5.add((Component)this.checkBox_enableHighlight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel5.add(Box.createVerticalStrut(2), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, insets2, 0, 0);
        jPanel5.add((Component)jPanel6, gridBagConstraints);
        String string21 = OptionsArb.getString((int)90);
        this.label_sampleText = new JLabel();
        this.editor_sampleText = new BasicEditorPane();
        this.editor_sampleText.setProtected(true);
        this.editor_sampleText.addToolTipProvider((ToolTipProvider)this);
        this.editor_sampleText.addCaretListener((CaretListener)this);
        this.highlightLayer = this.editor_sampleText.createHighlightLayer();
        this.scrollPane_sampleText = new JScrollPane((Component)this.editor_sampleText);
        ResourceUtils.resLabel((JLabel)this.label_sampleText, (Component)this.editor_sampleText, (String)string21);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel7.add((Component)this.label_sampleText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
        jPanel7.add((Component)this.scrollPane_sampleText, gridBagConstraints);
        this.panel_card = new CardPanel();
        this.panel_card.add((Component)jPanel4, STYLE_CARD);
        this.panel_card.add((Component)jPanel5, HIGHLIGHT_CARD);
        Insets insets3 = new Insets(1, 3, 1, 3);
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        this.add(Box.createVerticalStrut(1), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 2, insets3, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 17, 1, insets3, 0, 0);
        this.add(jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 2, 0.5, 0.0, 17, 1, insets3, 0, 0);
        this.add(this.panel_card, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, insets3, 0, 0);
        this.add(jPanel7, gridBagConstraints);
        EditorProperties editorProperties = EditorProperties.getProperties();
        StyleRegistry styleRegistry = editorProperties.getStyleRegistry();
        this.m_styleRegistry = (StyleRegistry)styleRegistry.clone();
        this.editor_sampleText.setStyleRegistry(this.m_styleRegistry);
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        this.highlightRegistry = (HighlightRegistry)highlightRegistry.clone();
        this.editor_sampleText.setHighlightRegistry(this.highlightRegistry);
        this.initOLAPI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getToolTipText(BasicEditorPane basicEditorPane, MouseEvent mouseEvent, int n) {
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        String string = null;
        try {
            basicDocument.readLock();
            LineMap lineMap = basicDocument.getLineMap();
            int n2 = lineMap.getLineFromOffset(n);
            DocumentRenderer documentRenderer = basicDocument.getDocumentRenderer();
            if (documentRenderer instanceof SCOPDR) {
                if (n2 >= this.styleListModel.getSize()) return string;
                Object e = this.styleListModel.getElementAt(n2);
                if (e instanceof BaseStyle) {
                    BaseStyle baseStyle = (BaseStyle)e;
                    String string2 = baseStyle.getPresentationName();
                    string = OptionsArb.format((int)111, (Object)string2);
                    return string;
                } else {
                    if (!(e instanceof HighlightStyle)) throw new IllegalStateException("bad style type");
                    HighlightStyle highlightStyle = (HighlightStyle)e;
                    String string3 = highlightStyle.getPresentationName();
                    string = OptionsArb.format((int)112, (Object)string3);
                }
                return string;
            } else {
                StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n2, n2);
                StyleRegistry styleRegistry = basicEditorPane.getStyleRegistry();
                int n3 = styledFragmentsList.size();
                for (int i = 0; i < n3; ++i) {
                    StyledFragment styledFragment = styledFragmentsList.get(i);
                    if (styledFragment.startOffset > n || n >= styledFragment.endOffset) continue;
                    BaseStyle baseStyle = styleRegistry.lookupStyle(styledFragment.styleName);
                    if (baseStyle == null) {
                        throw new IllegalStateException("style not found: " + styledFragment.styleName);
                    }
                    String string4 = baseStyle.getPresentationName();
                    string = OptionsArb.format((int)111, (Object)string4);
                }
                documentRenderer.recycleFragmentsList(styledFragmentsList);
            }
            return string;
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.isInUIUpdate()) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("selectedColor")) {
            this.beginUIUpdate();
            Object object = propertyChangeEvent.getSource();
            if (object == this.colorChoice_specifyForeground || object == this.colorChoice_specifyBackground) {
                CustomColorChoice customColorChoice = (CustomColorChoice)object;
                boolean bl = false;
                if (customColorChoice.isDefaultAllowed()) {
                    bl = customColorChoice.isDefaultSelected();
                }
                Color color = customColorChoice.getSelectedColor();
                if (object == this.colorChoice_specifyForeground) {
                    this.m_styleRegistry.modifyStyleForeground(this.editedStyle.getName(), bl, color);
                } else {
                    this.m_styleRegistry.modifyStyleBackground(this.editedStyle.getName(), bl, color);
                }
            } else if (object == this.colorChoice_highlightFG) {
                Color color = this.colorChoice_highlightFG.getSelectedColor();
                this.highlightRegistry.modifyStyleForeground(this.editedHighlight.getName(), color);
            } else if (object == this.colorChoice_highlightBG) {
                Color color = this.colorChoice_highlightBG.getSelectedColor();
                this.highlightRegistry.modifyStyleBackground(this.editedHighlight.getName(), color);
            } else if (object == this.colorChoice_underlineColor) {
                Color color = this.colorChoice_underlineColor.getSelectedColor();
                this.highlightRegistry.modifyStyleUnderline(this.editedHighlight.getName(), this.editedHighlight.getUnderlinePainter(), color);
            }
            this.selectSchemeName(SCHEME_CUSTOM);
            this.endUIUpdate();
            this.updateStyleSample();
            this.updateHighlightSample();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.isInUIUpdate()) {
            return;
        }
        Object object = listSelectionEvent.getSource();
        if (object == this.list_styles) {
            Object e = this.list_styles.getSelectedValue();
            if (e instanceof BaseStyle) {
                this.editedStyle = (BaseStyle)e;
                this.panel_card.showCard(STYLE_CARD);
                this.updateStylePanel();
            } else if (e instanceof HighlightStyle) {
                this.editedHighlight = (HighlightStyle)e;
                this.panel_card.showCard(HIGHLIGHT_CARD);
                this.updateHighlightPanel();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button_saveAs) {
            Object object2;
            String string;
            String string2 = OptionsArb.getString((int)65);
            JLabel jLabel = new JLabel();
            JTextField jTextField = new JTextField();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)string2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            Insets insets = new Insets(2, 2, 2, 2);
            HelpSystem helpSystem = HelpSystem.getHelpSystem();
            if (helpSystem != null) {
                helpSystem.registerTopic((JComponent)jPanel, "f1_idedsavescheme_html");
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, insets, 0, 0);
            jPanel.add((Component)jTextField, gridBagConstraints);
            String string3 = OptionsArb.getString((int)66);
            while (true) {
                jTextField.selectAll();
                boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)string3);
                if (!bl) return;
                string = jTextField.getText().trim();
                if (string.length() != 0) break;
                object2 = OptionsArb.getString((int)67);
                String string4 = OptionsArb.getString((int)68);
                this.showErrorDialog((String)object2, string4);
            }
            object2 = new ArrayList();
            OLAPISyntaxColorsOptionsPanel.copyRegistriesToStyleList(this.m_styleRegistry, this.highlightRegistry, (List)object2);
            this.schemeMap.putScheme(string, (List)object2);
            this.addSchemeName(string);
            return;
        } else {
            if (object != this.button_delete) return;
            String string = (String)this.comboBox_scheme.getSelectedItem();
            if (string.equals(SCHEME_CUSTOM)) {
                String string5 = OptionsArb.getString((int)69);
                String string6 = OptionsArb.getString((int)70);
                this.showErrorDialog(string5, string6);
                return;
            } else {
                this.schemeMap.removeScheme(string);
                this.deleteSchemeName(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.isInUIUpdate()) {
            return;
        }
        BasicEditorPane basicEditorPane = this.editor_sampleText;
        int n = basicEditorPane.getCaretPosition();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = -1;
        basicDocument.readLock();
        try {
            int n3 = lineMap.getLineFromOffset(n);
            DocumentRenderer documentRenderer = basicDocument.getDocumentRenderer();
            if (documentRenderer instanceof SCOPDR) {
                int n4 = this.styleListModel.getSize();
                if (n3 < n4) {
                    n2 = n3;
                }
            } else {
                StyledFragmentsList styledFragmentsList = documentRenderer.renderLines(n3, n3);
                StyleRegistry styleRegistry = basicEditorPane.getStyleRegistry();
                int n5 = styledFragmentsList.size();
                for (int i = 0; i < n5; ++i) {
                    StyledFragment styledFragment = styledFragmentsList.get(i);
                    if (styledFragment.startOffset > n || n >= styledFragment.endOffset) continue;
                    BaseStyle baseStyle = styleRegistry.lookupStyle(styledFragment.styleName);
                    n2 = this.styleListModel.indexOf(baseStyle);
                    break;
                }
                documentRenderer.recycleFragmentsList(styledFragmentsList);
            }
        }
        finally {
            basicDocument.readUnlock();
        }
        if (n2 != -1) {
            this.list_styles.setSelectedIndex(n2);
            this.list_styles.ensureIndexIsVisible(n2);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isInUIUpdate()) {
            return;
        }
        this.beginUIUpdate();
        Object object = changeEvent.getSource();
        if (object == this.slider_priority) {
            int n = this.slider_priority.getValue();
            this.highlightRegistry.modifyStylePriority(this.editedHighlight.getName(), n);
            this.selectSchemeName(SCHEME_CUSTOM);
        }
        this.endUIUpdate();
        this.updateHighlightSample();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInUIUpdate()) {
            return;
        }
        this.beginUIUpdate();
        Object object = itemEvent.getSource();
        if (object == this.comboBox_fontStyle) {
            int n;
            boolean bl;
            String string = (String)this.comboBox_fontStyle.getSelectedItem();
            if (string.equals(FONT_STYLE_USE_DEFAULT)) {
                bl = true;
                n = 0;
            } else if (string.equals(FONT_STYLE_NORMAL)) {
                bl = false;
                n = 0;
            } else if (string.equals(FONT_STYLE_BOLD)) {
                bl = false;
                n = 1;
            } else if (string.equals(FONT_STYLE_ITALIC)) {
                bl = false;
                n = 2;
            } else if (string.equals(FONT_STYLE_BOLDITALIC)) {
                bl = false;
                n = 3;
            } else {
                throw new IllegalStateException("unknown style: " + string);
            }
            this.m_styleRegistry.modifyStyleFontStyle(this.editedStyle.getName(), bl, n);
            this.selectSchemeName(SCHEME_CUSTOM);
        } else if (object == this.comboBox_underlineStyle) {
            int n;
            String string = (String)this.comboBox_underlineStyle.getSelectedItem();
            if (string.equals(UNDERLINE_STYLE_NONE)) {
                n = -1;
            } else if (string.equals(UNDERLINE_STYLE_SINGLE)) {
                n = 0;
            } else if (string.equals(UNDERLINE_STYLE_DOUBLE)) {
                n = 1;
            } else if (string.equals(UNDERLINE_STYLE_SINGLE_DOTTED)) {
                n = 2;
            } else if (string.equals(UNDERLINE_STYLE_DOUBLE_DOTTED)) {
                n = 3;
            } else if (string.equals(UNDERLINE_STYLE_WAVY)) {
                n = 4;
            } else if (string.equals(SEPARATOR_STYLE_SINGLE)) {
                n = 5;
            } else if (string.equals(SEPARATOR_STYLE_DOUBLE)) {
                n = 6;
            } else if (string.equals(SEPARATOR_STYLE_SINGLE_DOTTED)) {
                n = 7;
            } else if (string.equals(SEPARATOR_STYLE_DOUBLE_DOTTED)) {
                n = 8;
            } else if (string.equals(SEPARATOR_STYLE_PERFORATED)) {
                n = 9;
            } else if (string.equals(STRIKETHRU_STYLE_SINGLE)) {
                n = 10;
            } else if (string.equals(STRIKETHRU_STYLE_DOUBLE)) {
                n = 11;
            } else {
                throw new IllegalStateException("unknown style: " + string);
            }
            this.highlightRegistry.modifyStyleUnderline(this.editedHighlight.getName(), n, this.editedHighlight.getUnderlineColor());
            this.selectSchemeName(SCHEME_CUSTOM);
        } else if (object == this.comboBox_highlightFont) {
            int n;
            String string = (String)this.comboBox_highlightFont.getSelectedItem();
            if (string.equals(FONT_STYLE_USE_DEFAULT)) {
                n = 0;
            } else if (string.equals(FONT_STYLE_BOLD)) {
                n = 1;
            } else if (string.equals(FONT_STYLE_ITALIC)) {
                n = 2;
            } else if (string.equals(FONT_STYLE_BOLDITALIC)) {
                n = 3;
            } else {
                throw new IllegalStateException("unknown style: " + string);
            }
            this.highlightRegistry.modifyStyleFont(this.editedHighlight.getName(), n);
            this.selectSchemeName(SCHEME_CUSTOM);
        } else {
            if (object == this.checkBox_enableHighlight) {
                boolean bl = this.checkBox_enableHighlight.isSelected();
                this.highlightRegistry.modifyStyleEnabled(this.editedHighlight.getName(), bl);
                this.selectSchemeName(SCHEME_CUSTOM);
                this.endUIUpdate();
                this.updateHighlightPanel();
                return;
            }
            if (object == this.comboBox_scheme) {
                String string = (String)this.comboBox_scheme.getSelectedItem();
                if (string.equals(SCHEME_CUSTOM)) {
                    this.endUIUpdate();
                    return;
                }
                this.selectSchemeName(string);
                List list = this.schemeMap.getScheme(string);
                if (list != null) {
                    OLAPISyntaxColorsOptionsPanel.copyStyleListToRegistries(list, this.m_styleRegistry, this.highlightRegistry);
                    this.endUIUpdate();
                    this.updateStylePanel();
                    this.updateHighlightPanel();
                } else {
                    this.endUIUpdate();
                }
                return;
            }
        }
        this.endUIUpdate();
        this.updateStyleSample();
        this.updateHighlightSample();
    }

    private void initOLAPI() {
        UnderlinePainter underlinePainter;
        Object object;
        Object object2;
        LanguageModule languageModule;
        OLAPILanguageModule oLAPILanguageModule = new OLAPILanguageModule();
        LanguageModule languageModule2 = languageModule = LanguageModule.getDefaultModule();
        SortedListModel sortedListModel = new SortedListModel();
        sortedListModel.setComparator(new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        this.styleListModel = sortedListModel;
        languageModule2 = oLAPILanguageModule;
        String[] stringArray = languageModule2.getStyleNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            object2 = this.m_styleRegistry.lookupStyle(stringArray[i]);
            if (object2 == null) continue;
            this.styleListModel.addElement(object2);
        }
        SortedListModel sortedListModel2 = new SortedListModel();
        object2 = this.highlightRegistry.getStyleIterator();
        while (object2.hasNext()) {
            HighlightStyle highlightStyle = (HighlightStyle)object2.next();
            String string = highlightStyle.getName();
            if (!string.equalsIgnoreCase("syntaxbuilder.squiggly") && !string.equalsIgnoreCase("syntaxbuilder.inner_selection") || (object = this.highlightRegistry.lookupStyle(string)) == null || (underlinePainter = object.getUnderlinePainter()) != null && HighlightRegistry.lookupPredefinedPainter((UnderlinePainter)underlinePainter) == -1) continue;
            sortedListModel2.addElement(object);
        }
        int n2 = sortedListModel2.getSize();
        for (int i = 0; i < n2; ++i) {
            object = sortedListModel2.getElementAt(i);
            this.styleListModel.addElement(object);
        }
        this.list_styles.setModel(this.styleListModel);
        String string = null;
        object = null;
        object = languageModule2.createLanguageSupport();
        string = languageModule2.getContentSample();
        this.highlightLayer.removeAllHighlights();
        underlinePainter = (BasicDocument)this.editor_sampleText.getDocument();
        if (object != null) {
            underlinePainter.setLanguageSupport((LanguageSupport)object);
        }
        if (string != null) {
            char[] cArray = string.toCharArray();
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            try {
                TextBuffer textBuffer = underlinePainter.getTextBuffer();
                textBuffer.read((Reader)charArrayReader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.endUIUpdate();
        n = this.styleListModel.getSize();
        if (n > 0) {
            this.list_styles.setSelectedIndex(0);
        }
    }

    private void updateStylePanel() {
        this.beginUIUpdate();
        boolean bl = this.editedStyle != null;
        Component[] componentArray = new Component[]{this.label_styleSample, this.field_styleSample, this.label_foreground, this.colorChoice_specifyForeground, this.label_background, this.colorChoice_specifyBackground, this.label_fontStyle, this.comboBox_fontStyle};
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            componentArray[i].setEnabled(bl);
        }
        if (this.editedStyle != null) {
            Color color = this.editedStyle.getForegroundColor();
            boolean bl2 = this.editedStyle.getUsesParentForegroundColor();
            Color color2 = this.editedStyle.getBackgroundColor();
            boolean bl3 = this.editedStyle.getUsesParentBackgroundColor();
            int n2 = this.editedStyle.getFontStyle();
            boolean bl4 = this.editedStyle.getUsesParentFontStyle();
            BaseStyle baseStyle = this.m_styleRegistry.lookupStyle(this.editedStyle.getParentName());
            if (baseStyle == null) {
                baseStyle = this.editedStyle;
            }
            Color color3 = baseStyle.getForegroundColor();
            Color color4 = baseStyle.getBackgroundColor();
            if (this.editedStyle.getName().equals("base-plain-style")) {
                this.comboBox_fontStyle.setEnabled(false);
                this.label_fontStyle.setEnabled(false);
                this.comboBox_fontStyle.setModel(this.cbModel_base);
            } else {
                this.comboBox_fontStyle.setModel(this.cbModel_extended);
            }
            String string = FONT_STYLE_USE_DEFAULT;
            if (!bl4) {
                switch (n2) {
                    case 0: {
                        string = FONT_STYLE_NORMAL;
                        break;
                    }
                    case 1: {
                        string = FONT_STYLE_BOLD;
                        break;
                    }
                    case 2: {
                        string = FONT_STYLE_ITALIC;
                        break;
                    }
                    case 3: {
                        string = FONT_STYLE_BOLDITALIC;
                    }
                }
            }
            this.comboBox_fontStyle.setSelectedItem(string);
            this.colorChoice_specifyForeground.setClosestSelectedColor(color);
            this.colorChoice_specifyBackground.setClosestSelectedColor(color2);
            if (!this.editedStyle.getHasParent()) {
                this.colorChoice_specifyForeground.setDefaultAllowed(false);
                this.colorChoice_specifyBackground.setDefaultAllowed(false);
            } else {
                this.colorChoice_specifyForeground.setDefaultAllowed(true);
                Color color5 = this.colorChoice_specifyForeground.getClosestColor(color3);
                this.colorChoice_specifyForeground.setDefaultColor(color5);
                this.colorChoice_specifyForeground.setDefaultSelected(bl2);
                this.colorChoice_specifyBackground.setDefaultAllowed(true);
                Color color6 = this.colorChoice_specifyBackground.getClosestColor(color4);
                this.colorChoice_specifyBackground.setDefaultColor(color6);
                this.colorChoice_specifyBackground.setDefaultSelected(bl3);
            }
            this.updateStyleSample();
        }
        this.endUIUpdate();
    }

    private void updateHighlightPanel() {
        this.beginUIUpdate();
        boolean bl = this.editedHighlight != null;
        Component[] componentArray = new Component[]{this.label_highlightSample, this.field_highlightSample, this.checkBox_enableHighlight, this.label_priority, this.slider_priority, this.label_priorityText, this.label_highlightFG, this.colorChoice_highlightFG, this.label_highlightBG, this.colorChoice_highlightBG, this.label_highlightFont, this.comboBox_highlightFont, this.label_underlineStyle, this.comboBox_underlineStyle, this.label_underlineColor, this.colorChoice_underlineColor};
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            componentArray[i].setEnabled(bl);
        }
        if (this.editedHighlight != null) {
            Color color = this.editedHighlight.getForegroundColor();
            Color color2 = this.editedHighlight.getBackgroundColor();
            int n2 = this.editedHighlight.getPriority();
            boolean bl2 = this.editedHighlight.getEnabled();
            int n3 = this.editedHighlight.getFontStyle();
            UnderlinePainter underlinePainter = this.editedHighlight.getUnderlinePainter();
            int n4 = HighlightRegistry.lookupPredefinedPainter((UnderlinePainter)underlinePainter);
            if (underlinePainter != null && n4 == -1) {
                System.out.println("WARNING: Unknown painter received");
            }
            Color color3 = this.editedHighlight.getUnderlineColor();
            this.checkBox_enableHighlight.setSelected(bl2);
            if (!bl2) {
                this.label_priority.setEnabled(false);
                this.slider_priority.setEnabled(false);
                this.label_priorityText.setEnabled(false);
                this.label_highlightFG.setEnabled(false);
                this.colorChoice_highlightFG.setEnabled(false);
                this.label_highlightBG.setEnabled(false);
                this.colorChoice_highlightBG.setEnabled(false);
                this.label_highlightFont.setEnabled(false);
                this.comboBox_highlightFont.setEnabled(false);
                this.label_underlineStyle.setEnabled(false);
                this.comboBox_underlineStyle.setEnabled(false);
                this.label_underlineColor.setEnabled(false);
                this.colorChoice_underlineColor.setEnabled(false);
            }
            this.slider_priority.setValue(n2);
            this.colorChoice_highlightFG.setClosestSelectedColor(color);
            this.colorChoice_highlightBG.setClosestSelectedColor(color2);
            String string = FONT_STYLE_USE_DEFAULT;
            switch (n3) {
                case 0: {
                    string = FONT_STYLE_USE_DEFAULT;
                    break;
                }
                case 1: {
                    string = FONT_STYLE_BOLD;
                    break;
                }
                case 2: {
                    string = FONT_STYLE_ITALIC;
                    break;
                }
                case 3: {
                    string = FONT_STYLE_BOLDITALIC;
                }
            }
            this.comboBox_highlightFont.setSelectedItem(string);
            this.comboBox_underlineStyle.setSelectedItem(switch (n4) {
                default -> UNDERLINE_STYLE_NONE;
                case 0 -> UNDERLINE_STYLE_SINGLE;
                case 1 -> UNDERLINE_STYLE_DOUBLE;
                case 2 -> UNDERLINE_STYLE_SINGLE_DOTTED;
                case 3 -> UNDERLINE_STYLE_DOUBLE_DOTTED;
                case 4 -> UNDERLINE_STYLE_WAVY;
                case 5 -> SEPARATOR_STYLE_SINGLE;
                case 6 -> SEPARATOR_STYLE_DOUBLE;
                case 7 -> SEPARATOR_STYLE_SINGLE_DOTTED;
                case 8 -> SEPARATOR_STYLE_DOUBLE_DOTTED;
                case 9 -> SEPARATOR_STYLE_PERFORATED;
                case 10 -> STRIKETHRU_STYLE_SINGLE;
                case 11 -> STRIKETHRU_STYLE_DOUBLE;
            });
            this.colorChoice_underlineColor.setClosestSelectedColor(color3);
            this.updateHighlightSample();
        }
        this.endUIUpdate();
    }

    private void updateStyleSample() {
        if (this.editedStyle == null) {
            return;
        }
        int n = this.editedStyle.getFontStyle();
        Color color = this.editedStyle.getForegroundColor();
        Color color2 = this.editedStyle.getBackgroundColor();
        Font font = this.field_styleSample.getFont();
        Font font2 = font.deriveFont(n);
        this.field_styleSample.setFont(font2);
        this.field_styleSample.setForeground(color);
        this.field_styleSample.setBackground(color2);
    }

    private void updateHighlightSample() {
        if (this.editedHighlight == null) {
            return;
        }
        BaseStyle baseStyle = this.m_styleRegistry.lookupStyle("base-plain-style");
        Color color = baseStyle.getForegroundColor();
        Color color2 = baseStyle.getBackgroundColor();
        int n = 0;
        if (this.editedHighlight.getEnabled()) {
            if (this.editedHighlight.getUseForegroundColor()) {
                color = this.editedHighlight.getForegroundColor();
            }
            if (this.editedHighlight.getUseBackgroundColor()) {
                color2 = this.editedHighlight.getBackgroundColor();
            }
            n = this.editedHighlight.getFontStyle();
        }
        this.field_highlightSample.setForeground(color);
        this.field_highlightSample.setBackground(color2);
        Font font = this.field_highlightSample.getFont();
        Font font2 = font.deriveFont(n);
        this.field_highlightSample.setFont(font2);
        this.field_highlightSample.setUnderline(this.editedHighlight.getUnderlinePainter(), this.editedHighlight.getUnderlineColor());
        int n2 = this.editedHighlight.getPriority();
        this.label_priorityText.setText(Integer.toString(n2));
    }

    private void beginUIUpdate() {
        this.inUpdate = true;
    }

    private boolean isInUIUpdate() {
        return this.inUpdate;
    }

    private void endUIUpdate() {
        this.inUpdate = false;
    }

    static {
        String string = System.getProperty("ceditor.syntaxcolors.show.priority", "false");
        SHOW_PRIORITY_CONTROLS = string != null && Boolean.valueOf(string.toString()) != false;
    }

    private final class UnderlineField
    extends JTextField {
        private UnderlinePainter _underlinePainter;
        private Color _underlineColor;

        private UnderlineField(String string) {
            super(string);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this._underlinePainter != null && this._underlineColor != null) {
                try {
                    Rectangle rectangle = this.modelToView(0);
                    int n = this.getText().length();
                    Rectangle rectangle2 = this.modelToView(n);
                    Font font = this.getFont();
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int n2 = fontMetrics.getAscent();
                    int n3 = fontMetrics.getDescent();
                    int n4 = rectangle.x;
                    int n5 = rectangle.y;
                    int n6 = rectangle2.x - n4;
                    int n7 = n5 + n2;
                    this._underlinePainter.paintUnderline(graphics, this._underlineColor, n5, n6, n5, n7, n3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        private void setUnderline(UnderlinePainter underlinePainter, Color color) {
            this._underlinePainter = underlinePainter;
            this._underlineColor = color;
            this.repaint();
        }
    }

    private static final class CardPanel
    extends JPanel
    implements LayoutManager {
        public CardPanel() {
            this.setLayout(this);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (string != null) {
                component.setName(string);
            }
            component.setVisible(component.getParent().getComponentCount() == 1);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            Container container;
            if (component.isVisible() && (container = component.getParent()).getComponentCount() > 0) {
                container.getComponent(0).setVisible(true);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            for (int i = 0; i < n; ++i) {
                Dimension dimension = container.getComponent(i).getPreferredSize();
                if (dimension.width + insets.left + insets.right > n2) {
                    n2 = dimension.width + insets.left + insets.right;
                }
                if (dimension.height + insets.top + insets.bottom <= n3) continue;
                n3 = dimension.height + insets.top + insets.bottom;
            }
            return new Dimension(n2, n3);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            for (int i = 0; i < n; ++i) {
                Dimension dimension = container.getComponent(i).getMinimumSize();
                if (dimension.width + insets.left + insets.right > n2) {
                    n2 = dimension.width + insets.left + insets.right;
                }
                if (dimension.height + insets.top + insets.bottom <= n3) continue;
                n3 = dimension.height + insets.top + insets.bottom;
            }
            return new Dimension(n2, n3);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Rectangle rectangle = container.getBounds();
                int n2 = rectangle.width - insets.left + insets.right;
                int n3 = rectangle.height - insets.top + insets.bottom;
                Dimension dimension = component.getPreferredSize();
                if (dimension.height < n3) {
                    n3 = dimension.height;
                }
                component.setBounds(insets.left, insets.top, n2, n3);
                break;
            }
        }

        public void showCard(String string) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = this.getComponent(i);
                if (component.getName().equals(string)) {
                    component.setVisible(true);
                    continue;
                }
                if (!component.isVisible()) continue;
                component.setVisible(false);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static final class SCOPDR
    extends AbstractDocumentRenderer {
        private Object[] styles;

        private SCOPDR(LanguageSupport languageSupport, Object[] objectArray) {
            super(languageSupport);
            this.styles = objectArray;
        }

        public void renderRegion(StyledFragmentsList styledFragmentsList, int n, int n2) {
            LineMap lineMap = this.getLineMap();
            int n3 = lineMap.getLineCount() - 1;
            for (int i = 0; i < n3; ++i) {
                boolean bl;
                int n4 = lineMap.getLineStartOffset(i);
                int n5 = lineMap.getLineEndOffset(i);
                boolean bl2 = bl = i != n3;
                if (bl) {
                    --n5;
                }
                String string = "base-plain-style";
                if (this.styles[i] instanceof BaseStyle) {
                    BaseStyle baseStyle = (BaseStyle)this.styles[i];
                    string = baseStyle.getName();
                }
                styledFragmentsList.add(string, n4, n5);
                if (!bl) continue;
                styledFragmentsList.add("base-plain-style", n5, n5 + 1);
            }
        }

        public void calculateDamage(DocumentEvent documentEvent, NumberRange numberRange) {
        }
    }

    private static final class SCOPLS
    extends AbstractLanguageSupport {
        private Object[] styles;

        private SCOPLS(Object[] objectArray) {
            this.styles = objectArray;
        }

        private String getContentSample() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.styles.length;
            for (int i = 0; i < n; ++i) {
                String string;
                if (this.styles[i] instanceof BaseStyle) {
                    var5_5 = (BaseStyle)this.styles[i];
                    string = var5_5.getPresentationName();
                } else if (this.styles[i] instanceof HighlightStyle) {
                    var5_5 = (HighlightStyle)this.styles[i];
                    string = var5_5.getPresentationName();
                } else {
                    throw new IllegalStateException("bad style type");
                }
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        protected DocumentRenderer createDocumentRenderer() {
            return new SCOPDR((LanguageSupport)this, this.styles);
        }
    }
}

