/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.map;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.actions.BaseRunnable;
import oracle.olap.app.db.Column;
import oracle.olap.app.db.DatabaseObject;
import oracle.olap.app.db.Table;
import oracle.olap.db.IdentifierElement;
import oracle.olap.util.SourceMetadata;

public class ColumnListRunnable
extends BaseRunnable {
    private OracleDatabaseImpl db;
    private Schema schema;
    private String tableNames;
    private List<DatabaseObject> sources;

    public ColumnListRunnable(OracleDatabaseImpl oracleDatabaseImpl, Schema schema, String string) {
        this.db = oracleDatabaseImpl;
        this.schema = schema;
        this.tableNames = string;
        this.sources = new ArrayList<DatabaseObject>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
            if (this.tableNames == null || this.tableNames.length() == 0) {
                return;
            }
            String[] stringArray = this.tableNames.split(",");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", this.schema.getName());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                string = !string.startsWith("\"") ? string.toUpperCase() : string.substring(1, string.length() - 1);
                if (string.indexOf(".") == -1) {
                    string = String.format("%s.%s", this.schema.getName(), string);
                }
                stringBuffer.append("'" + string + "'");
                stringBuffer.append(",");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
            }
            this.fetchSourceColumns(stringBuffer.toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = false;
                for (DatabaseObject databaseObject : this.sources) {
                    if (!stringArray[i].equals(databaseObject.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(stringArray[i]);
            }
            if (arrayList.size() > 0) {
                Object object;
                String string;
                String string2;
                Object object2;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (String string3 : arrayList) {
                    stringBuffer2.append("'" + string3 + "'");
                    stringBuffer2.append(",");
                }
                stringBuffer2.delete(stringBuffer2.length() - 1, stringBuffer2.length());
                String string3 = String.format("select owner, synonym_name, table_owner, table_name from all_synonyms where synonym_name in (%s)", stringBuffer2.toString());
                List list = dBUtil.executeReturnList(string3, null);
                stringBuffer = new StringBuffer();
                HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
                for (Object object3 : list) {
                    String string4 = (String)object3.get("OWNER");
                    object2 = (String)object3.get("SYNONYM_NAME");
                    string2 = (String)object3.get("TABLE_OWNER");
                    string = (String)object3.get("TABLE_NAME");
                    object = String.format("%s.%s", string4, object2);
                    string = String.format("%s.%s", string2, string);
                    hashMap2.put(object, string);
                    stringBuffer.append("'" + string + "'");
                    stringBuffer.append(",");
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                }
                if (stringBuffer.length() > 0) {
                    List<DatabaseObject> list2 = this.fetchSourceColumns(stringBuffer.toString());
                    for (String string4 : hashMap2.keySet()) {
                        object2 = new IdentifierElement(string4);
                        string2 = ((IdentifierElement)object2).getFirst();
                        if (((IdentifierElement)object2).getCount() == 2) {
                            string2 = ((IdentifierElement)object2).getSecond();
                        }
                        string = (String)hashMap2.get(string4);
                        object = list2.iterator();
                        while (object.hasNext()) {
                            DatabaseObject databaseObject = (DatabaseObject)object.next();
                            String string5 = String.format("%s.%s", databaseObject.getSchemaName(), databaseObject.getName());
                            if (!string5.equals(string)) continue;
                            databaseObject.setName(string2);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.setException(exception);
        }
        finally {
            this.getProgressBar().setDoneStatus();
        }
    }

    private List<DatabaseObject> fetchSourceColumns(String string) throws SQLException {
        ArrayList<DatabaseObject> arrayList = new ArrayList<DatabaseObject>();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", this.schema.getName());
        String string2 = String.format("select owner, table_name, column_name, data_type from all_tab_columns where owner || '.' || table_name in (%s) order by owner, table_name, column_name", string);
        SourceMetadata sourceMetadata = new SourceMetadata();
        string2 = sourceMetadata.getQueries().getSQL("GET_COLUMNS_BY_OBJECTS");
        string2 = String.format(string2, string);
        List list = dBUtil.executeReturnList(string2, hashMap);
        DatabaseObject object = null;
        ArrayList<Column> arrayList2 = null;
        for (Map map : list) {
            String string3 = (String)map.get("OWNER");
            String string4 = (String)map.get("TABLE_NAME");
            boolean bl = false;
            for (DatabaseObject databaseObject : this.sources) {
                if (!databaseObject.getSchemaName().equals(string3) || !databaseObject.getName().equals(string4)) continue;
                object = databaseObject;
                bl = true;
                break;
            }
            if (!bl) {
                if (object != null) {
                    object.setColumns(arrayList2);
                }
                object = new Table(string3, string4);
                this.sources.add(object);
                arrayList.add(object);
                arrayList2 = new ArrayList<Column>();
            }
            String string5 = (String)map.get("COLUMN_NAME");
            String object22 = (String)map.get("DATA_TYPE");
            Column column = new Column(string5, object22);
            arrayList2.add(column);
        }
        if (object != null) {
            object.setColumns(arrayList2);
        }
        return arrayList;
    }

    public List<DatabaseObject> getSources() {
        return this.sources;
    }
}

