/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import oracle.olap.app.Resources;
import oracle.olap.cubetemplate.ConflictRenameMap;
import oracle.olap.cubetemplate.NamespaceValidator;

public class ConflictTableModel
extends DefaultTableModel
implements TableModelListener {
    private final ConflictRenameMap renamer;
    private final NamespaceValidator validator;
    public static final int STATUS = 0;
    public static final int OBJECT = 1;
    public static final int PARENT = 2;
    public static final int NAME = 3;
    public static final int DETAILS = 4;
    public static final int ORIGINAL = 5;
    public static final int OLDPARENT = 6;
    private final Resources resources;

    public ConflictTableModel(ConflictRenameMap conflictRenameMap, NamespaceValidator namespaceValidator, Resources resources) throws SQLException {
        super(new Object[]{resources.getString("NAMESPACE_CONFLICT_PANEL_STATUS_LABEL"), resources.getString("NAMESPACE_CONFLICT_PANEL_OBJECT_LABEL"), resources.getString("NAMESPACE_CONFLICT_PANEL_PARENT_LABEL"), resources.getString("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), resources.getString("NAMESPACE_CONFLICT_PANEL_CONFLICT.DETAILS_LABEL"), "ORIGINAL", "OLDPARENT"}, 0);
        this.resources = resources;
        this.renamer = conflictRenameMap;
        this.validator = namespaceValidator;
        conflictRenameMap.resetIterator();
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
        while (conflictRenameMap.getNextObjectName() != null) {
            NamespaceValidator.Collision collision = this.validator.checkForCollisions(conflictRenameMap.getCurrentObjectName(), conflictRenameMap.getParent());
            this.addRow(new Object[]{collision == NamespaceValidator.Collision.NONE, conflictRenameMap.getType(), conflictRenameMap.getParent(), conflictRenameMap.getCurrentObjectName(), this.getDetails(collision), conflictRenameMap.getCurrentObjectName(), conflictRenameMap.getParent()});
        }
        this.addTableModelListener(this);
    }

    private String getDetails(NamespaceValidator.Collision collision) {
        return this.getDetails(collision, this.renamer.getCurrentObjectName());
    }

    private String getDetails(NamespaceValidator.Collision collision, String string) {
        if (collision == NamespaceValidator.Collision.NONE) {
            return "";
        }
        return this.resources.getString(collision.getKey(), string, string);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0 && (tableModelEvent.getColumn() == 3 || tableModelEvent.getColumn() == 2)) {
            int n = tableModelEvent.getFirstRow();
            String string = (String)this.getValueAt(n, 3);
            String string2 = (String)this.getValueAt(n, 2);
            String string3 = (String)this.getValueAt(n, 5);
            String string4 = (String)this.getValueAt(n, 6);
            int n2 = (Integer)((Vector)this.dataVector.get(n)).get(1);
            NamespaceValidator.Collision collision = this.validator.checkForCollisions(string, string2);
            if (collision == NamespaceValidator.Collision.NONE && this.hasInternalDuplicates(string2 + "." + string)) {
                collision = NamespaceValidator.Collision.RENAMED;
            }
            this.setValueAt(collision == NamespaceValidator.Collision.NONE, n, 0);
            this.setValueAt(this.getDetails(collision, string), n, 4);
            this.renamer.updateEntryWithRename(n2, string4, string3, string, string2);
            if (tableModelEvent.getColumn() == 3 && n2 == 2) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    string2 = (String)this.getValueAt(i, 2);
                    if (string2 == null || !string2.equals(string3)) continue;
                    this.setValueAt(string, i, 2);
                }
            }
        }
    }

    private boolean hasInternalDuplicates(String string) {
        HashSet<CallSite> hashSet = new HashSet<CallSite>();
        int n = 0;
        for (Object e : this.dataVector) {
            String string2 = (String)((Vector)e).get(2) + "." + (String)((Vector)e).get(3);
            if (!(string == null ? !hashSet.add((CallSite)((Object)string2)) : string.equals(string2) && ++n == 2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 3;
    }

    boolean isFixed() {
        if (this.hasInternalDuplicates(null)) {
            return false;
        }
        for (Object e : this.dataVector) {
            if (((Boolean)((Vector)e).get(0)).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

