/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.app.olapixml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import oracle.olap.app.cubeddl.model.AttributeColLevel;
import oracle.olap.app.cubeddl.model.CubeDimColumn;
import oracle.olap.app.cubeddl.model.CubeDimensionCreate;
import oracle.olap.app.cubeddl.model.Hierarchy;
import oracle.olap.app.olapixml.NamedObjectWithDescX;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.NamedObjectWithDesc;

public class CubeDimensionX
extends NamedObjectWithDescX {
    public CubeDimensionX(Dimension dimension) {
        super(dimension);
    }

    public CubeDimensionX(CubeDimensionCreate cubeDimensionCreate) {
        super(cubeDimensionCreate);
    }

    public CubeDimensionCreate getCubeDimension() {
        return (CubeDimensionCreate)this.getNamedObject();
    }

    public boolean isTime() {
        NamedObjectWithDesc namedObjectWithDesc;
        if (this.getNamedObject() instanceof CubeDimensionCreate && ((CubeDimensionCreate)(namedObjectWithDesc = (CubeDimensionCreate)this.getNamedObject())).isTime()) {
            return true;
        }
        return this.getNamedObject() instanceof Dimension && ((Dimension)(namedObjectWithDesc = (Dimension)this.getNamedObject())).isTime();
    }

    @Override
    public String getStartX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTime()) {
            stringBuffer.append("  <TimeDimension\n");
        } else {
            stringBuffer.append("  <StandardDimension\n");
        }
        stringBuffer.append("    Name=\"" + this.getName().toUpperCase() + "\">\n");
        return stringBuffer.toString();
    }

    @Override
    public String getEndX() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTime()) {
            stringBuffer.append("  </TimeDimension>\n");
        } else {
            stringBuffer.append("  </StandardDimension>\n");
        }
        return stringBuffer.toString();
    }

    public String drop() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer();
        if (this.getCubeDimension().isTime()) {
            stringBuffer.append(this.getStartX());
        } else {
            stringBuffer.append("  <StandardDimension\n");
        }
        stringBuffer.append("    Action=\"REMOVE\"\n");
        stringBuffer.append("    Name=\"" + this.getName().toUpperCase() + "\">\n");
        stringBuffer.append(this.getEndX());
        return stringBuffer.toString();
    }

    public String toString() {
        HashSet<String> hashSet;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartX());
        CubeDimensionCreate cubeDimensionCreate = this.getCubeDimension();
        if (this.isTime()) {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
            object = cubeDimensionCreate.getEndDateAttribute();
            hashSet = cubeDimensionCreate.getTimeSpanAttribute();
            stringBuffer.append("\n");
            if (object != null) {
                stringBuffer.append("    EndDateAttribute=\"" + ((CubeDimColumn)object).getName() + "\"\n");
            }
            if (hashSet != null) {
                stringBuffer.append("    TimeSpanAttribute=\"" + ((CubeDimColumn)((Object)hashSet)).getName() + "\"");
            }
            stringBuffer.append(">\n");
        }
        object = "DEFAULTAW";
        if (cubeDimensionCreate.getAWSpecification() != null) {
            object = cubeDimensionCreate.getAWSpecification().getName();
        }
        object = ((String)object).toUpperCase();
        stringBuffer.append("    <Organization>\n");
        stringBuffer.append("      <AWPrimaryDimensionOrganization\n");
        stringBuffer.append("        AW=\"" + (String)object + "\"\n");
        stringBuffer.append("        AddUniqueKeyPrefix=\"False\"\n");
        stringBuffer.append("        MVOption=\"NONE\">\n");
        stringBuffer.append("      </AWPrimaryDimensionOrganization>\n");
        stringBuffer.append("    </Organization>\n");
        if (cubeDimensionCreate.isFlat() && (hashSet = cubeDimensionCreate.getDimensionKey()) != null) {
            stringBuffer.append("    <MemberListMap\n");
            stringBuffer.append("        KeyExpression=\"" + cubeDimensionCreate.getShadowTableName() + "." + ((CubeDimColumn)((Object)hashSet)).getName() + "\"\n");
            stringBuffer.append("        Query=\"" + cubeDimensionCreate.getShadowTableName() + "\">\n");
            stringBuffer.append("    </MemberListMap>\n");
        }
        if (cubeDimensionCreate.getAttributes().size() > 0) {
            stringBuffer.append("    <Attribute\n");
            stringBuffer.append("      Action=\"ADD\">\n");
        }
        for (CubeDimColumn iterator : cubeDimensionCreate.getAttributes()) {
            stringBuffer.append("      <BaseAttribute\n");
            stringBuffer.append("        Name=\"" + iterator.getName() + "\"\n");
            if (iterator.isEndDate() || iterator.isTimeSpan()) {
                stringBuffer.append("        IsVisibleForAll=\"True\"\n");
            }
            stringBuffer.append("        SQLDataType=\"" + iterator.getDataType() + "\">\n");
            stringBuffer.append("      </BaseAttribute>\n");
        }
        if (cubeDimensionCreate.getAttributes().size() > 0) {
            stringBuffer.append("    </Attribute>\n");
        }
        hashSet = new HashSet<String>();
        if (cubeDimensionCreate.getHierarchies().size() > 0) {
            stringBuffer.append("    <Hierarchy\n");
            stringBuffer.append("      Action=\"ADD\">\n");
        }
        for (Hierarchy hierarchy : cubeDimensionCreate.getHierarchies()) {
            List<String> list = hierarchy.getLevels();
            if (list.size() == 0) {
                stringBuffer.append("      <ValueHierarchy\n");
                stringBuffer.append("        Name=\"" + hierarchy.getName() + "\">\n");
                stringBuffer.append("      </ValueHierarchy>\n");
                continue;
            }
            stringBuffer.append("      <LevelHierarchy\n");
            stringBuffer.append("        Name=\"" + hierarchy.getName() + "\"\n");
            stringBuffer.append("        IsSkipLevel=\"True\"\n");
            stringBuffer.append("        IsRagged=\"True\">\n");
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(list);
            Collections.reverse(arrayList);
            for (String string : arrayList) {
                hashSet.add(string);
                stringBuffer.append("       <HierarchyLevel\n");
                stringBuffer.append("          Action=\"ADD\"\n");
                stringBuffer.append("          ListPosition=\"" + n + "\"\n");
                stringBuffer.append("          DimensionLevel=\"" + string + "\">\n");
                StringBuffer stringBuffer2 = new StringBuffer();
                for (CubeDimColumn cubeDimColumn : cubeDimensionCreate.getAttributes()) {
                    if (!cubeDimensionCreate.isAttributeVisibleForLevel(cubeDimColumn, string)) continue;
                    if (!cubeDimColumn.isEndDate() && !cubeDimColumn.isTimeSpan()) {
                        stringBuffer.append("          <VisibleAttribute\n");
                        stringBuffer.append("              Name=\"" + cubeDimColumn.getName() + "\"/>\n");
                    }
                    AttributeColLevel attributeColLevel = cubeDimensionCreate.getAttributeVisibleForLevel(cubeDimColumn, string);
                    String string2 = cubeDimensionCreate.getAttributeMap(cubeDimColumn, string);
                    if (string2 == null) continue;
                    stringBuffer2.append("             <AttributeMap\n");
                    stringBuffer2.append("               Action=\"ADD\"\n");
                    stringBuffer2.append("               Name=\"" + cubeDimColumn.getName() + "\"\n");
                    stringBuffer2.append("               Attribute=\"" + cubeDimColumn.getName() + "\"\n");
                    stringBuffer2.append("               Expression=\"" + string2 + "\">\n");
                    stringBuffer2.append("             </AttributeMap>\n");
                }
                if (cubeDimensionCreate.isMapped()) {
                    String string3 = cubeDimensionCreate.getLevelMap(string);
                    stringBuffer.append("          <HierarchyLevelMap\n");
                    stringBuffer.append("             KeyExpression=\"" + (String)string3 + "\"\n");
                    stringBuffer.append("             Query=\"" + cubeDimensionCreate.getFrom() + "\">\n");
                    if (stringBuffer2.length() > 0) {
                        stringBuffer.append(stringBuffer2);
                    }
                    stringBuffer.append("          </HierarchyLevelMap>\n");
                }
                stringBuffer.append("       </HierarchyLevel>\n");
                ++n;
            }
            stringBuffer.append("      </LevelHierarchy>\n");
        }
        if (cubeDimensionCreate.getHierarchies().size() > 0) {
            stringBuffer.append("    </Hierarchy>\n");
        }
        for (String string : hashSet) {
            stringBuffer.append("    <DimensionLevel\n");
            stringBuffer.append("        Action=\"ADD\"\n");
            stringBuffer.append("        Name=\"" + string + "\">\n");
            stringBuffer.append("    </DimensionLevel>\n");
        }
        stringBuffer.append(this.getEndX());
        return stringBuffer.toString();
    }
}

