/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.SQLErrorPanel;
import oracle.dbtools.raptor.proxy.ProxyRegistry;
import oracle.dbtools.util.Logger;
import oracle.ide.controls.JMultiLineLabel;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.AdditionalDatabaseMetaData;

public class LoginMessagePanel {
    private static final String AUDIT_METHOD = "getAuditBanner";
    private static final String ACCESS_METHOD = "getAccessBanner";
    private static final Invoker AUDIT_INVOKER;
    private static final Invoker ACCESS_INVOKER;

    public static void displayLoginMessages(final String string, Connection connection) throws SQLException {
        SQLWarning sQLWarning;
        final String string2 = AUDIT_INVOKER.invoke(connection);
        final String string3 = ACCESS_INVOKER.invoke(connection);
        for (sQLWarning = connection.getWarnings(); sQLWarning != null && sQLWarning.getErrorCode() == 17110; sQLWarning = sQLWarning.getNextWarning()) {
        }
        final SQLWarning sQLWarning2 = sQLWarning;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                JPanel jPanel = null;
                if (ModelUtil.hasLength((String)string3)) {
                    bl = true;
                    jPanel = new JPanel(new BorderLayout());
                    jPanel.setBorder(BorderFactory.createEtchedBorder(1));
                    jPanel.add((Component)new JMultiLineLabel(string3), "Center");
                }
                JPanel jPanel2 = null;
                if (ModelUtil.hasLength((String)string2)) {
                    bl = true;
                    jPanel2 = new JPanel(new BorderLayout());
                    jPanel2.setBorder(BorderFactory.createEtchedBorder(1));
                    jPanel2.add((Component)new JMultiLineLabel(string2), "Center");
                }
                SQLErrorPanel sQLErrorPanel = null;
                if (sQLWarning2 != null) {
                    bl = true;
                    sQLErrorPanel = SQLErrorPanel.createBuilder(string).warning(sQLWarning2).build();
                }
                if (bl) {
                    Box box = Box.createVerticalBox();
                    if (jPanel != null) {
                        box.add(jPanel);
                    }
                    if (jPanel2 != null) {
                        box.add(jPanel2);
                    }
                    if (sQLErrorPanel != null) {
                        box.add(sQLErrorPanel);
                    }
                    MessageDialog.information(null, (Object)box, (String)DialogResources.getString("LOGIN_MESSAGE_TITLE"), null);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static {
        Object object;
        Method method = null;
        Method method2 = null;
        try {
            object = Class.forName("oracle.jdbc.AdditionalDatabaseMetaData");
            method = ((Class)object).getMethod(AUDIT_METHOD, new Class[0]);
            method2 = ((Class)object).getMethod(ACCESS_METHOD, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (method != null && method2 != null) {
            AUDIT_INVOKER = new OracleInvoker(method);
            ACCESS_INVOKER = new OracleInvoker(method2);
        } else {
            AUDIT_INVOKER = object = new NullInvoker();
            ACCESS_INVOKER = object;
        }
    }

    private static interface Invoker {
        public String invoke(Connection var1) throws SQLException;
    }

    private static class OracleInvoker
    implements Invoker {
        private Method m;

        OracleInvoker(Method method) {
            this.m = method;
        }

        @Override
        public String invoke(Connection connection) throws SQLException {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (!(databaseMetaData instanceof AdditionalDatabaseMetaData)) {
                databaseMetaData = (DatabaseMetaData)ProxyRegistry.unwrap((Object)databaseMetaData);
            }
            String string = null;
            try {
                string = (String)this.m.invoke((Object)databaseMetaData, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                Logger.warn(LoginMessagePanel.class, (Throwable)exception);
            }
            return string;
        }
    }

    private static class NullInvoker
    implements Invoker {
        private NullInvoker() {
        }

        @Override
        public String invoke(Connection connection) {
            return null;
        }
    }
}

