/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.servlet;

import java.io.IOException;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import oracle.jrf.JrfUtils;
import oracle.jrf.servlet.GlobalFilterCallback;

public class ExtensibleGlobalFilter
implements Filter {
    private Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);
    private static ServiceLoader<GlobalFilterCallback> globalFilterCallbackLoader;

    public void init(FilterConfig config) throws ServletException {
        globalFilterCallbackLoader = ServiceLoader.load(GlobalFilterCallback.class);
    }

    public void destroy() {
        globalFilterCallbackLoader = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        int i = 0;
        try {
            if (globalFilterCallbackLoader != null) {
                for (GlobalFilterCallback cb : globalFilterCallbackLoader) {
                    cb.preDoFilter(req, res);
                    ++i;
                }
            }
        }
        catch (Error | Exception e) {
            if (globalFilterCallbackLoader != null) {
                int j = 0;
                for (GlobalFilterCallback cb : globalFilterCallbackLoader) {
                    if (j > i) break;
                    try {
                        cb.postDoFilter(req, res, e);
                        ++j;
                    }
                    catch (IOException | ServletException e2) {
                        this.logger.log(Level.WARNING, "Exception spotted in class ExtensibleGlobalFilter: ", e2);
                    }
                }
            }
            this.logger.log(Level.WARNING, "Exception spotted in class ExtensibleGlobalFilter: ", e);
            throw e;
        }
        try {
            chain.doFilter(req, res);
        }
        catch (Error | Exception e) {
            if (globalFilterCallbackLoader != null) {
                for (GlobalFilterCallback cb : globalFilterCallbackLoader) {
                    try {
                        cb.postDoFilter(req, res, e);
                    }
                    catch (IOException | ServletException e2) {
                        this.logger.log(Level.WARNING, "Exception spotted in class ExtensibleGlobalFilter: ", e2);
                    }
                }
            }
            throw e;
        }
        i = 0;
        try {
            if (globalFilterCallbackLoader != null) {
                for (GlobalFilterCallback cb : globalFilterCallbackLoader) {
                    cb.postDoFilter(req, res, null);
                    ++i;
                }
            }
        }
        catch (Error | Exception e) {
            int j = 0;
            for (GlobalFilterCallback cb : globalFilterCallbackLoader) {
                if (j++ <= i) continue;
                try {
                    cb.postDoFilter(req, res, e);
                }
                catch (IOException | ServletException e2) {
                    this.logger.log(Level.WARNING, "Exception spotted in class ExtensibleGlobalFilter: ", e2);
                }
            }
            this.logger.log(Level.WARNING, "Exception spotted in class ExtensibleGlobalFilter: ", e);
            throw e;
        }
    }
}

