/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import com.oracle.jdeveloper.nbwindowsystem.plaf.AttentionSupport;
import com.oracle.jdeveloper.nbwindowsystem.plaf.OracleViewTabDisplayerUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

class OracleEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final String IMAGE_PREFIX = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/editortabs/";
    private static final Image[] normal = new Image[6];
    private static final Image[] normalRollover = new Image[6];
    private static final Image[] selected = new Image[6];
    private static final Image[] selectedRollover = new Image[6];
    private static final Image[] focused = new Image[6];
    private static final int BORDER_SIZE = 4;
    private static final OracleTabPainter defaultPainter = new OracleTabPainter();
    private static final OracleRightClippedTabPainter rightPainter = new OracleRightClippedTabPainter();
    private static final OracleLeftClippedTabPainter leftPainter = new OracleLeftClippedTabPainter();
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);

    public OracleEditorTabCellRenderer() {
        super((TabPainter)leftPainter, (TabPainter)defaultPainter, (TabPainter)rightPainter, new Dimension(34, 29));
        this.setIconTextGap(4);
    }

    protected void paintIconAndText(Graphics g) {
        if (this.isBusy()) {
            this.setIcon(BusyTabsSupport.getDefault().getBusyIcon(this.isSelected()));
        }
        super.paintIconAndText(g);
    }

    protected int getCaptionYAdjustment() {
        return 1;
    }

    public int getIconYAdjustment() {
        return -2;
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        d.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 30 : 20;
        return d;
    }

    public String getCommandAtPoint(Point p, int tabState, Rectangle bounds, int mouseButton, int eventType, int modifiers) {
        String result = super.getCommandAtPoint(p, tabState, bounds, mouseButton, eventType, modifiers);
        if ("select".equals(result) && (modifiers & 0x80) > 0) {
            result = "close";
        }
        return result;
    }

    private static void initImages() {
        OracleViewTabDisplayerUI.initImages(normal, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/editortabs/normal/");
        OracleViewTabDisplayerUI.initImages(selected, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/editortabs/selected/");
        OracleViewTabDisplayerUI.initImages(normalRollover, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/editortabs/normal-rollover/");
        OracleViewTabDisplayerUI.initImages(selectedRollover, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/editortabs/selected-rollover/");
        OracleViewTabDisplayerUI.initImages(focused, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/editortabs/focused/");
    }

    static {
        OracleEditorTabCellRenderer.initImages();
    }

    private static class OracleLeftClippedTabPainter
    implements TabPainter {
        private OracleLeftClippedTabPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 4, 0, 5);
        }

        public Polygon getInteriorPolygon(Component c) {
            OracleEditorTabCellRenderer mtr = (OracleEditorTabCellRenderer)((Object)c);
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = -1;
            int y = ins.top;
            int width = c.getWidth();
            int height = mtr.isSelected() ? c.getHeight() + 3 : c.getHeight();
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public void paintInterior(Graphics g, Component c) {
            OracleEditorTabCellRenderer ren = (OracleEditorTabCellRenderer)((Object)c);
            boolean mouseOver = ren.isArmed();
            boolean selection = ren.isSelected();
            boolean focus = ren.isActive();
            Image[] images = normal;
            if (selection) {
                images = focus ? focused : (mouseOver ? selectedRollover : selected);
            } else if (mouseOver) {
                images = normalRollover;
            }
            int borderSize = 4;
            g.drawImage(images[2], c.getWidth() - borderSize, 0, null);
            g.drawImage(images[0], 0, 0, c.getWidth() - borderSize, borderSize, null);
            g.drawImage(images[4], c.getWidth() - borderSize, borderSize, borderSize, c.getHeight() - borderSize, null);
            g.drawImage(images[5], 0, borderSize, c.getWidth() - borderSize, c.getHeight() - borderSize, null);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            bounds.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class OracleTabPainter
    implements TabPainter {
        private OracleTabPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 4, 0, 22);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return ((AbstractTabCellRenderer)renderer).isShowCloseButton();
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public Polygon getInteriorPolygon(Component c) {
            Insets ins = this.getBorderInsets(c);
            int x = ins.left;
            int y = ins.top;
            int width = c.getWidth() - ins.left - ins.right;
            int height = c.getHeight() - ins.top - ins.bottom;
            Rectangle rect = new Rectangle(x, y, width, height);
            return new EqualPolygon(rect);
        }

        public void paintInterior(Graphics g, Component c) {
            OracleEditorTabCellRenderer ren = (OracleEditorTabCellRenderer)((Object)c);
            boolean mouseOver = ren.isArmed();
            boolean selection = ren.isSelected();
            boolean focus = ren.isActive();
            Image[] images = normal;
            if (selection) {
                images = focus ? focused : (mouseOver ? selectedRollover : selected);
            } else if (mouseOver) {
                images = normalRollover;
            }
            OracleViewTabDisplayerUI.drawTabBackground(g, images, 0, 0, c.getWidth() - 1, c.getHeight(), 4);
            if (ren.isAttention()) {
                AttentionSupport.paintAttention(g, 0, 0, c.getWidth() - 1, c.getHeight());
            }
            Rectangle r = new Rectangle();
            this.getCloseButtonRectangle((JComponent)((Object)ren), r, new Rectangle(0, 0, ren.getWidth() - 1, ren.getHeight()));
            if (!g.hitClip(r.x, r.y, r.width, r.height)) {
                return;
            }
            this.paintCloseButton(g, (JComponent)c);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            if (!((AbstractTabCellRenderer)jc).isShowCloseButton()) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
                return;
            }
            String iconPath = this.findIconPath((OracleEditorTabCellRenderer)((Object)jc));
            Icon icon = TabControlButtonFactory.getIcon((String)iconPath);
            int iconWidth = icon.getIconWidth();
            int iconHeight = icon.getIconHeight();
            rect.x = bounds.x + bounds.width - iconWidth - 5;
            rect.y = bounds.y + Math.max(0, bounds.height / 2 - iconHeight / 2) - 1;
            rect.width = iconWidth;
            rect.height = iconHeight;
        }

        private void paintCloseButton(Graphics g, JComponent c) {
            if (((AbstractTabCellRenderer)c).isShowCloseButton()) {
                Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
                Rectangle cbRect = new Rectangle();
                this.getCloseButtonRectangle(c, cbRect, r);
                String iconPath = this.findIconPath((OracleEditorTabCellRenderer)((Object)c));
                Icon icon = TabControlButtonFactory.getIcon((String)iconPath);
                icon.paintIcon(c, g, cbRect.x, cbRect.y);
            }
        }

        private String findIconPath(OracleEditorTabCellRenderer renderer) {
            if (renderer.inCloseButton() && renderer.isPressed()) {
                return "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_pressed.png";
            }
            if (renderer.inCloseButton()) {
                return "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_rollover.png";
            }
            if (renderer.isSelected()) {
                return "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_enabled.png";
            }
            return "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_enabled_notselected.png";
        }
    }

    private static class OracleRightClippedTabPainter
    implements TabPainter {
        private OracleRightClippedTabPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(0, 4, 0, 3);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component c) {
            OracleEditorTabCellRenderer mtr = (OracleEditorTabCellRenderer)((Object)c);
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = mtr.isLeftmost() ? 1 : 0;
            int y = 0;
            int width = c.getWidth() + 2;
            int height = mtr.isSelected() ? c.getHeight() + 3 : c.getHeight();
            p.addPoint(x, y + ins.top + 6);
            p.addPoint(x + 6, y + ins.top);
            p.addPoint(x + width, y + ins.top);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public void paintInterior(Graphics g, Component c) {
            OracleEditorTabCellRenderer ren = (OracleEditorTabCellRenderer)((Object)c);
            boolean mouseOver = ren.isArmed();
            boolean selection = ren.isSelected();
            boolean focus = ren.isActive();
            Image[] images = normal;
            if (selection) {
                images = focus ? focused : (mouseOver ? selectedRollover : selected);
            } else if (mouseOver) {
                images = normalRollover;
            }
            int borderSize = 4;
            g.drawImage(images[1], 0, 0, null);
            g.drawImage(images[0], borderSize, 0, c.getWidth() - borderSize, borderSize, null);
            g.drawImage(images[3], 0, borderSize, borderSize, c.getHeight() - borderSize, null);
            g.drawImage(images[5], borderSize, borderSize, c.getWidth() - borderSize, c.getHeight() - borderSize, null);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            bounds.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }
    }
}

