/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import java.awt.Component;
import java.awt.EventQueue;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class MenuWarmUpTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(MenuWarmUpTask.class.getName());
    private NbMainWindow mw;
    private LinkedList<Component> comps;

    private MenuWarmUpTask(NbMainWindow mw) {
        LOG.log(Level.FINE, "MenuWarmUpTask created");
        this.mw = mw;
    }

    static void initialize(NbMainWindow mw) {
        WindowManager.getDefault().invokeWhenUIReady((Runnable)new MenuWarmUpTask(mw));
        LOG.fine("MenuWarmUpTask initialized");
    }

    public void walk() {
        if (!EventQueue.isDispatchThread()) {
            this.comps = new LinkedList();
            LOG.fine("Computing menu elements to refresh");
            this.comps.addAll(Arrays.asList(this.mw.getJMenuBar().getComponents()));
            LOG.log(Level.FINE, "Menu elements computed: {0}", this.comps.size());
            for (Component c : this.comps) {
                if (!(c instanceof JMenu)) continue;
                JMenu m = (JMenu)c;
                LOG.log(Level.FINE, "doInitialize for {0}", c);
                try {
                    Class<?> cls = m.getClass();
                    Method method = cls.getDeclaredMethod("doInitialize", new Class[0]);
                    method.setAccessible(true);
                    method.invoke((Object)m, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOG.log(Level.FINE, "doInitialize finished for {0}", c);
            }
            EventQueue.invokeLater(this);
            return;
        }
        if (this.comps == null) {
            LOG.fine("Initial run, post to non EDT");
            RequestProcessor.getDefault().post((Runnable)this);
            return;
        }
        LOG.fine("Doing the refresh");
        for (int i = 0; i < 5; ++i) {
            LOG.log(Level.FINE, "Still remains {0} componenets", this.comps.size());
            if (this.comps.isEmpty()) {
                LOG.fine("Refresh finished");
                return;
            }
            Component c = this.comps.removeFirst();
            if (!(c instanceof JMenu)) continue;
            JMenu m = (JMenu)c;
            this.comps.addAll(Arrays.asList(m.getMenuComponents()));
        }
        LOG.fine("Pausing the refresh");
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        this.walk();
    }
}

