/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.LayoutGroup;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import oracle.ide.layout.Layout;
import org.openide.util.Exceptions;

class LayoutGroupManager {
    private final Preferences prefs;
    private final Map<Layout, LayoutGroup> cache = new HashMap<Layout, LayoutGroup>(5);

    public LayoutGroupManager(Preferences prefsRoot) {
        this.prefs = prefsRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LayoutGroup getLayout(Layout layout) {
        boolean isTaskLayout = NbDockStation.isTaskLayout(layout);
        Map<Layout, LayoutGroup> map = this.cache;
        synchronized (map) {
            LayoutGroup res = this.cache.get(layout);
            if (null == res) {
                String layoutName = layout.getName();
                Preferences layoutPrefs = this.prefs.node(isTaskLayout ? "task" : "editor");
                res = new LayoutGroup(layoutName, layoutPrefs, isTaskLayout);
                res.setLayout(layout);
                res.load();
                this.cache.put(layout, res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<LayoutGroup> list(boolean taskLayoutsOnly) {
        Map<Layout, LayoutGroup> map = this.cache;
        synchronized (map) {
            Preferences layoutPrefs = this.prefs.node(taskLayoutsOnly ? "task" : "editor");
            HashMap<String, LayoutGroup> res = new HashMap<String, LayoutGroup>(10);
            for (LayoutGroup lg : this.cache.values()) {
                if (lg.isTaskLayout() != taskLayoutsOnly) continue;
                res.put(lg.getName(), lg);
            }
            try {
                for (String nodeName : layoutPrefs.childrenNames()) {
                    Preferences child = layoutPrefs.node(nodeName);
                    String layoutName = child.get("layout-name", null);
                    if (null == layoutName || null != res.get(layoutName)) continue;
                    LayoutGroup lg = new LayoutGroup(layoutName, layoutPrefs, taskLayoutsOnly);
                    lg.load();
                    res.put(layoutName, lg);
                }
            }
            catch (BackingStoreException bsE) {
                Exceptions.printStackTrace((Throwable)bsE);
            }
            return res.values();
        }
    }
}

