/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.producer;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;

public abstract class AbstractDataSetProducer
implements GeoDataProducer {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected BufferedImage img = null;
    protected Area loadedArea = new Area();
    protected Area loadingArea = new Area();
    protected AbstractDataSetLayer layer = null;
    protected final Vector<AbstractFeature> readyFeatures = new Vector(1);

    protected AbstractDataSetProducer(AbstractDataSetLayer layer) {
        this.layer = layer;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer = (AbstractDataSetLayer)layer;
    }

    @Override
    public GeoObject[] getData() {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public void abortLoad() {
    }

    @Override
    public void setTargetSRID(int srid) {
    }

    @Override
    public int getTargetSRID() {
        return this.layer.getCanvas().getMapRegion().getDataWindowSrid();
    }

    @Override
    public Rectangle2D getDataMBR() {
        return null;
    }

    @Override
    public void loadData(Rectangle2D qw, int srid) {
        this.loadData(new Area(qw), srid);
    }

    @Override
    public synchronized void loadData(Area qa, int srid) {
        AbstractDataAccessObject dao = this.layer.getDataSource().getDataAccessObject();
        if (dao == null) {
            return;
        }
        Area queryArea = new Area(qa);
        queryArea.subtract(this.loadedArea);
        queryArea.subtract(this.loadingArea);
        if (queryArea.isEmpty()) {
            return;
        }
        this.loadingArea.add(queryArea);
        DataGetterWorker worker = new DataGetterWorker(queryArea, srid, dao);
        worker.addPropertyChangeListener(this.layer.getCanvas());
        worker.execute();
    }

    public synchronized Area getLoadedArea() {
        return this.loadedArea;
    }

    public synchronized Area getLoadingArea() {
        return this.loadingArea;
    }

    protected abstract String buildQuery(Area var1, int var2);

    protected abstract String getSpatialType();

    protected void doLoad(Callable callable, PropertyChangeSupport propSupport, Area queryArea, int srid, AbstractDataAccessObject dao) throws Exception, MDSException {
        WorkSpace workspace = this.layer.getWorkspace();
        String spatialType = this.getSpatialType();
        String query = this.buildQuery(queryArea, srid);
        String table = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String spatialCol = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        log.info(this.layer.getName() + "(" + this.layer.getClass().getSimpleName() + ")" + ": Data loading: started\n\tQuery:" + query);
        long t1 = System.currentTimeMillis();
        dao.openConnection();
        dao.loadDataInto(this.readyFeatures, callable, propSupport, null, workspace, spatialType, query, table, spatialCol, 0L, false);
        long t2 = System.currentTimeMillis();
        log.info(this.layer.getName() + "(" + this.layer.getClass().getSimpleName() + ")" + ": Data loading: finished after " + (t2 - t1) + " ms.");
    }

    private class DataGetterWorker
    extends SwingWorker<Void, AbstractFeature> {
        private Area queryArea = null;
        private int srid = 0;
        private AbstractDataAccessObject dao = null;

        public DataGetterWorker(Area queryArea, int srid, AbstractDataAccessObject dao) {
            this.queryArea = queryArea;
            this.srid = srid;
            this.dao = dao;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() {
            Callable callable = new Callable(){

                public Object call() {
                    DataGetterWorker.this.publish(new AbstractFeature[]{AbstractDataSetProducer.this.readyFeatures.remove(0)});
                    return null;
                }
            };
            Throwable exception = null;
            try {
                AbstractDataSetProducer.this.doLoad(callable, this.getPropertyChangeSupport(), this.queryArea, this.srid, this.dao);
            }
            catch (MDSException ex) {
                exception = ex;
            }
            catch (Exception ex) {
                exception = ex;
            }
            finally {
                if (this.dao != null) {
                    try {
                        this.dao.closeConnection();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            AbstractDataSetProducer ex = AbstractDataSetProducer.this;
            synchronized (ex) {
                AbstractDataSetProducer.this.loadingArea.subtract(this.queryArea);
                if (exception == null) {
                    AbstractDataSetProducer.this.loadedArea.add(this.queryArea);
                }
            }
            if (exception != null) {
                this.setProgress(0);
                this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getFormattedMessage("Progressbar_error", exception.getMessage()));
                AbstractDataSetProducer.this.layer.onDataException(AbstractDataSetProducer.this, exception);
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        protected void process(List<AbstractFeature> list) {
            AbstractDataSetProducer.this.layer.onDataReady(AbstractDataSetProducer.this, new ArrayList<AbstractFeature>(list));
        }
    }
}

