/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.maps.core.Layer;
import oracle.maps.core.MVImageLayerProvider;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.MVVectorLayerProvider;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.ui.MVServerConnectionPanel;
import oracle.spatial.edit.util.MVConnection;
import org.w3c.dom.Element;

public class MVLayerProvider
implements LayerProvider {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected MainAppPanel mainApp = null;
    protected ArrayList<MVConnection> connections = null;
    protected static final String ADDCONNECTION = MessagesBundle.getMessage("Connect_to_server");
    protected static final String NEWLAYER = MessagesBundle.getMessage("Create_edit_session");
    public static final String GEOMLAYERS = "Geometry layers";
    public static final String PREDEFTHEMES = "Predefined Themes";
    public static final String BASEMAPS = "Base Maps";
    public static final String TILECACHES = "Tile Cache";
    protected String[] layerTypes = new String[]{"Geometry layers", "Predefined Themes", "Base Maps", "Tile Cache"};

    public MVLayerProvider(MainAppPanel mainApp) {
        this(mainApp, new ArrayList<MVConnection>());
    }

    public MVLayerProvider(MainAppPanel mainApp, ArrayList<MVConnection> connections) {
        this.mainApp = mainApp;
        this.connections = connections;
    }

    @Override
    public String getProviderName() {
        return "MapViewer layers";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public Layer createLayer(Element xmlElement) {
        Layer layer = null;
        String className = xmlElement.getAttribute("class");
        if (className != null && !className.trim().isEmpty()) {
            try {
                Constructor<?> c = Class.forName(className).getConstructor(MapCanvas.class);
                layer = (Layer)c.newInstance(new Object[]{null});
                if (className.indexOf("GeometrySetLayer") > -1 && this.connections != null) {
                    BasicLayer bl = new BasicLayer(null);
                    bl.fromXMLElement(xmlElement);
                    String lyName = bl.getProperty("oracle.maps.core.Layer.name");
                    String dsrc = bl.getProperty("oracle.lbs.mapviewer.dataSource");
                    String serverURL = bl.getProperty("oracle.lbs.mapviewer.serverURL");
                    String editor = bl.getProperty("oracle.lbs.mapviewer.editor");
                    if (dsrc != null && serverURL != null && editor != null) {
                        for (MVConnection conn : this.connections) {
                            if (!serverURL.equalsIgnoreCase(conn.getServerURL()) && !this.areSameLocalHosts(serverURL, conn.getServerURL()) || !editor.equalsIgnoreCase(conn.getEditor())) continue;
                            ArrayList<MVConnection.DataSource> dsList = conn.getDataSources();
                            boolean foundDS = false;
                            if (dsList != null) {
                                for (MVConnection.DataSource ds : dsList) {
                                    if (!dsrc.equalsIgnoreCase(ds.getName())) continue;
                                    String jsessionid = ds.getDataSource().getConnectionProperties().getProperty("jsessionID");
                                    if (jsessionid != null && !jsessionid.trim().isEmpty()) {
                                        layer.setProperty("oracle.lbs.mapviewer.jsessionID", jsessionid);
                                        log.info("Java session id assigned to layer [" + lyName + "].");
                                    }
                                    foundDS = true;
                                    break;
                                }
                            }
                            if (!foundDS) continue;
                            break;
                        }
                    }
                }
                layer.fromXMLElement(xmlElement);
            }
            catch (InvocationTargetException ex) {
                ex.getTargetException().printStackTrace();
                System.err.println("on " + className);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("on " + className);
            }
        }
        return layer;
    }

    @Override
    public Layer getEditorObject(TreePath path) {
        DefaultMutableTreeNode layerNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode dsNode = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2);
        DefaultMutableTreeNode typeNode = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 3);
        Object layerDesc = layerNode.getUserObject();
        MVConnection.DataSource ds = (MVConnection.DataSource)dsNode.getUserObject();
        String type = (String)typeNode.getUserObject();
        Hashtable<String, LayerProvider> lps = ds.getLayerProviders();
        LayerProvider prov = lps.get(type);
        if (prov instanceof MVVectorLayerProvider) {
            return ((MVVectorLayerProvider)prov).getEditorObject(layerDesc);
        }
        if (prov instanceof MVImageLayerProvider) {
            return ((MVImageLayerProvider)prov).getEditorObject(layerDesc);
        }
        return null;
    }

    @Override
    public Layer removeEditorObject(TreePath layerDesc) {
        return null;
    }

    @Override
    public DefaultMutableTreeNode getProviderRootNode() {
        return new EmptyNonLeaf(this);
    }

    private void populate(TreePath path, JTree tree) {
        EmptyNonLeaf root = (EmptyNonLeaf)path.getLastPathComponent();
        Object obj = root.getUserObject();
        if (obj instanceof MVLayerProvider) {
            this.populate((MVLayerProvider)obj, (DefaultMutableTreeNode)root, tree);
        } else if (obj instanceof MVConnection) {
            this.populate((MVConnection)obj, root, tree);
        } else if (obj instanceof MVConnection.DataSource) {
            this.populateDataSource(path, tree);
        }
    }

    private void populate(MVLayerProvider prov, DefaultMutableTreeNode root, JTree tree) {
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        root.removeAllChildren();
        String serverURL = null;
        String editor = null;
        EditSession ed = this.mainApp.getEditSessionPanel().getEditSession();
        if (ed instanceof MDSEditSession) {
            AbstractDataSource sessionDS = ((MDSEditSession)ed).getDataSource();
            serverURL = sessionDS.getConnectionProperties().getProperty("serverURL");
            editor = sessionDS.getConnectionProperties().getProperty("editor");
        }
        model.insertNodeInto(new DefaultMutableTreeNode(ADDCONNECTION), root, root.getChildCount());
        for (MVConnection conn : this.connections) {
            if (!conn.getServerURL().equalsIgnoreCase(serverURL) || !conn.getEditor().equalsIgnoreCase(editor)) continue;
            EmptyNonLeaf connectionNode = new EmptyNonLeaf(conn);
            model.insertNodeInto(connectionNode, root, root.getChildCount());
        }
        model.nodeStructureChanged(root);
    }

    private void populate(MVConnection conn, EmptyNonLeaf root, JTree tree) {
        root.removeAllChildren();
        if (!root.isWorking()) {
            new GetDataSourcesWorker(conn, root, tree).execute();
        }
    }

    private void populateDataSource(TreePath path, JTree tree) {
        EmptyNonLeaf root = (EmptyNonLeaf)path.getLastPathComponent();
        root.removeAllChildren();
        if (!root.isWorking()) {
            new GetLayersWorker(path, tree).execute();
        }
    }

    private void addConnection(TreePath path, JTree tree, String serverURL, String editor) {
        String jSessionID;
        block15: {
            String authUser = null;
            String authPwd = null;
            if (serverURL == null || editor == null) {
                MVServerConnectionPanel connPanel = new MVServerConnectionPanel(serverURL, editor);
                OlafDialog connDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Select_data_source"), connPanel);
                connDlg.getHelpButton().setVisible(false);
                connDlg.setVisible(true);
                if (connDlg.isCancelled()) {
                    return;
                }
                serverURL = connPanel.getMapViewerServer();
                editor = connPanel.getEditorName();
                authUser = connPanel.getUser();
                authPwd = connPanel.getPassword();
            }
            if (serverURL == null || serverURL.trim().isEmpty()) {
                ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            if (editor == null || editor.trim().isEmpty()) {
                ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_editor_name"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            URL url = null;
            jSessionID = null;
            HttpURLConnection connection = null;
            try {
                if (authUser == null || authPwd == null) {
                    url = new URL(serverURL);
                    break block15;
                }
                url = serverURL.endsWith("/") ? new URL(serverURL + "dataserver/j_security_check?j_username=" + authUser + "&j_password=" + authPwd) : new URL(serverURL + "/dataserver/j_security_check?j_username=" + authUser + "&j_password=" + authPwd);
                connection = (HttpURLConnection)url.openConnection();
                int idx = -1;
                int connResponse = connection.getResponseCode();
                if (connResponse == 200) {
                    if (connection.getHeaderField("Set-Cookie") != null) {
                        jSessionID = connection.getHeaderField("Set-Cookie").split(";", 2)[0];
                        if (jSessionID != null) {
                            jSessionID = jSessionID.replace("JSESSIONID=", "");
                        }
                    } else {
                        String urlString = connection.getURL().toString();
                        if (urlString != null) {
                            idx = urlString.indexOf("jsessionid");
                        }
                        if (idx > -1) {
                            jSessionID = urlString.substring(idx + 11);
                        }
                    }
                    break block15;
                }
                ErrorDialog.showErrorDialog(new Exception("Unauthorized code: " + connResponse), this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            catch (MalformedURLException ex) {
                ErrorDialog.showErrorDialog(ex, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            catch (IOException ioex) {
                ErrorDialog.showErrorDialog(ioex, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
        }
        for (MVConnection c : this.connections) {
            if (!serverURL.equalsIgnoreCase(c.getServerURL()) || !editor.equalsIgnoreCase(c.getEditor())) continue;
            ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Connection_exists"), MessagesBundle.getMessage("Error"), 0);
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2);
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        MVConnection conn = new MVConnection(serverURL, editor, this.mainApp, jSessionID);
        EmptyNonLeaf placeHolderNode = new EmptyNonLeaf(conn);
        placeHolderNode.setWorking(true);
        model.insertNodeInto(placeHolderNode, root, 1);
        new GetDataSourcesWorker(conn, placeHolderNode, tree).execute();
    }

    @Override
    public TreeCellRenderer getTreeCellRenderer() {
        return new MyTreeCellRenderer();
    }

    @Override
    public TreeExpansionListener getTreeExpansionListener() {
        return null;
    }

    @Override
    public TreeWillExpandListener getTreeWillExpandListener() {
        return new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                MVLayerProvider.this.populate(evt.getPath(), (JTree)evt.getSource());
                throw new ExpandVetoException(evt);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }
        };
    }

    @Override
    public TreeSelectionListener getTreeSelectionListener() {
        return new TreeSelectionListener(){
            boolean supressEvent = false;

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreePath newSel = evt.getNewLeadSelectionPath();
                if (!this.supressEvent && newSel != null && newSel.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)newSel.getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (node instanceof EmptyNonLeaf || ADDCONNECTION == obj || NEWLAYER == obj) {
                        TreeSelectionModel selModel = ((JTree)evt.getSource()).getSelectionModel();
                        if (ADDCONNECTION == obj) {
                            MVLayerProvider.this.addConnection(newSel, (JTree)evt.getSource(), null, null);
                        } else if (NEWLAYER == obj) {
                            // empty if block
                        }
                        this.supressEvent = true;
                        selModel.removeSelectionPath(newSel);
                        this.supressEvent = false;
                    }
                }
            }
        };
    }

    @Override
    public MouseListener getMouseListener() {
        return null;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }

    private boolean areSameLocalHosts(String serverURL, String mvconnServerURL) {
        if (serverURL == null || mvconnServerURL == null) {
            return false;
        }
        String tempServerURL = serverURL.toLowerCase();
        String tempMVconnURL = mvconnServerURL.toLowerCase();
        try {
            InetAddress ownIP = InetAddress.getLocalHost();
            String ip = ownIP.getHostAddress();
            boolean svIsLocalHost = false;
            if (serverURL.toLowerCase().indexOf("localhost:") > -1) {
                svIsLocalHost = true;
            } else if (serverURL.toLowerCase().indexOf("127.0.0.1:") > -1) {
                svIsLocalHost = true;
                tempServerURL = tempServerURL.replaceFirst("127.0.0.1:", "localhost:");
            } else if (serverURL.toLowerCase().indexOf(ip + ":") > -1) {
                svIsLocalHost = true;
                tempServerURL = tempServerURL.replaceFirst(ip + ":", "localhost:");
            }
            boolean mvconnIsLocalHost = false;
            if (mvconnServerURL.toLowerCase().indexOf("localhost:") > -1) {
                mvconnIsLocalHost = true;
            } else if (mvconnServerURL.toLowerCase().indexOf("127.0.0.1:") > -1) {
                mvconnIsLocalHost = true;
                tempMVconnURL = tempMVconnURL.replaceFirst("127.0.0.1:", "localhost:");
            } else if (mvconnServerURL.toLowerCase().indexOf(ip + ":") > -1) {
                mvconnIsLocalHost = true;
                tempMVconnURL = tempMVconnURL.replaceFirst(ip + ":", "localhost:");
            }
            if (svIsLocalHost && mvconnIsLocalHost && tempServerURL.equalsIgnoreCase(tempMVconnURL)) {
                return true;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return false;
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            String txt = "";
            ImageIcon icon = null;
            if (value instanceof EmptyNonLeaf && ((EmptyNonLeaf)value).isWorking()) {
                txt = "Working...";
                icon = Icons.getIcon("refresh.png");
            } else if (obj instanceof MVLayerProvider) {
                txt = ((MVLayerProvider)obj).getProviderName();
            } else if (obj instanceof MVConnection) {
                MVConnection conn = (MVConnection)obj;
                txt = conn.getServerURL();
                icon = Icons.getIcon("db_connected.png");
            } else if (obj instanceof MVConnection.DataSource) {
                txt = ((MVConnection.DataSource)obj).getName().toUpperCase();
                icon = Icons.getIcon("dbuser.gif");
            } else if (obj instanceof String) {
                if (ADDCONNECTION == obj) {
                    icon = Icons.getIcon("connect_ena.png");
                } else if (NEWLAYER == obj) {
                    icon = Icons.getIcon("add_sm_ena.png");
                }
                txt = obj.toString();
            } else {
                EmptyNonLeaf dsNode = (EmptyNonLeaf)((TreeNode)value).getParent();
                EmptyNonLeaf typeNode = (EmptyNonLeaf)dsNode.getParent();
                MVConnection.DataSource ds = (MVConnection.DataSource)dsNode.getUserObject();
                String type = (String)typeNode.getUserObject();
                return ds.getLayerProviders().get(type).getTreeCellRenderer().getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, txt, selected, expanded, leaf, row, hasFocus);
            if (icon != null) {
                label.setIcon(icon);
            }
            return label;
        }
    }

    private class EmptyNonLeaf
    extends DefaultMutableTreeNode {
        private boolean working;

        public EmptyNonLeaf(Object userObject) {
            super(userObject);
            this.working = false;
        }

        @Override
        public boolean isLeaf() {
            return this.isWorking();
        }

        public void setWorking(boolean working) {
            this.working = working;
        }

        public boolean isWorking() {
            return this.working;
        }
    }

    private class GetLayersWorker
    extends SwingWorker {
        private TreePath path = null;
        private JTree tree = null;
        private Object[] layerDescs = null;

        public GetLayersWorker(TreePath path, JTree tree) {
            this.path = path;
            this.tree = tree;
        }

        public Object doInBackground() {
            EmptyNonLeaf dsNode = (EmptyNonLeaf)this.path.getLastPathComponent();
            EmptyNonLeaf typeNode = (EmptyNonLeaf)this.path.getPathComponent(this.path.getPathCount() - 2);
            MVConnection.DataSource ds = (MVConnection.DataSource)dsNode.getUserObject();
            String type = (String)typeNode.getUserObject();
            Hashtable<String, LayerProvider> lps = ds.getLayerProviders();
            LayerProvider prov = lps.get(type);
            dsNode.setWorking(true);
            try {
                if (prov instanceof MVVectorLayerProvider) {
                    this.layerDescs = ((MVVectorLayerProvider)prov).getEditorObjects();
                } else if (prov instanceof MVImageLayerProvider) {
                    this.layerDescs = ((MVImageLayerProvider)prov).getEditorObjects();
                }
            }
            catch (Exception ex) {
                ErrorDialog.showErrorDialog(ex, MVLayerProvider.this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Unable_toload_edit_session"), MessagesBundle.getMessage("Error"), 0);
            }
            dsNode.setWorking(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)GetLayersWorker.this.tree.getModel();
                    EmptyNonLeaf dsNode = (EmptyNonLeaf)GetLayersWorker.this.path.getLastPathComponent();
                    if (GetLayersWorker.this.layerDescs != null) {
                        for (Object layerDesc : GetLayersWorker.this.layerDescs) {
                            DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(layerDesc);
                            model.insertNodeInto(layerNode, dsNode, dsNode.getChildCount());
                        }
                    }
                    model.nodeStructureChanged(dsNode);
                    GetLayersWorker.this.tree.expandPath(new TreePath(dsNode.getPath()));
                }
            });
            return null;
        }
    }

    private class GetDataSourcesWorker
    extends SwingWorker {
        private MVConnection conn = null;
        private EmptyNonLeaf root = null;
        private JTree tree = null;
        private ArrayList<MVConnection.DataSource> dataSources = null;

        public GetDataSourcesWorker(MVConnection conn, EmptyNonLeaf root, JTree tree) {
            this.conn = conn;
            this.root = root;
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInBackground() {
            boolean success = true;
            this.root.setWorking(true);
            try {
                log.info("Loading data sources ...");
                this.dataSources = this.conn.getDataSources();
            }
            catch (Exception ex) {
                success = false;
                log.warning(ex.getMessage());
                ErrorDialog.showErrorDialog(ex, MVLayerProvider.this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Unable_toload_connection"), MessagesBundle.getMessage("Error"), 0);
                Object var3_3 = null;
                return var3_3;
            }
            finally {
                this.root.setWorking(false);
                if (!success) {
                    ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(this.root);
                }
                this.tree.repaint();
                log.info("Done with loading data sources.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)GetDataSourcesWorker.this.tree.getModel();
                    boolean added = false;
                    if (GetDataSourcesWorker.this.dataSources != null && GetDataSourcesWorker.this.dataSources.size() > 0) {
                        for (String layerType : MVLayerProvider.this.layerTypes) {
                            EmptyNonLeaf typeNode = new EmptyNonLeaf(layerType);
                            model.insertNodeInto(typeNode, GetDataSourcesWorker.this.root, GetDataSourcesWorker.this.root.getChildCount());
                            for (MVConnection.DataSource dataSource : GetDataSourcesWorker.this.dataSources) {
                                EmptyNonLeaf dsNode = new EmptyNonLeaf(dataSource);
                                model.insertNodeInto(dsNode, typeNode, typeNode.getChildCount());
                                added = true;
                            }
                        }
                    }
                    model.nodeStructureChanged(GetDataSourcesWorker.this.root);
                    if (added) {
                        GetDataSourcesWorker.this.tree.expandPath(new TreePath(GetDataSourcesWorker.this.root.getPath()));
                    }
                }
            });
            return null;
        }
    }
}

