/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.index.annotationtext;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.sdovis.edit.util.AnnotationTextUtil;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.spatial.edit.index.AbstractIndexedDataSet;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.annotationtext.AnnotationTextSet;
import oracle.spatial.geometry.JGeometry;

public class IndexedAnnotationTextSet
extends AbstractIndexedDataSet {
    public IndexedAnnotationTextSet(AnnotationTextSet aset) {
        this.dataSet = aset;
        this.dataSet.setIndexedSet(this);
        RTreeIndex rtree = new RTreeIndex();
        rtree.create(null);
        this.sptIndex = rtree;
    }

    public AnnotationTextSet getAnnotationTextSet() {
        return (AnnotationTextSet)this.dataSet;
    }

    public boolean addTextElement(String featKey, AnnotationTextElement textElem) throws Exception {
        if (textElem == null) {
            throw new Exception("null");
        }
        AnnotationTextFeature atfeat = this.getFeature(featKey);
        if (atfeat == null) {
            throw new Exception("null");
        }
        AnnotationText atext = atfeat.getSpatialAttribute();
        if (atext == null) {
            throw new Exception("null");
        }
        AnnotationText change = (AnnotationText)atext.clone();
        if (change == null) {
            throw new Exception("null");
        }
        change.addElement(textElem);
        this.updateEnvelope(change);
        return this.updateSpatialAttribute(featKey, change);
    }

    public void updateEnvelope(AnnotationText change) {
        if (change == null) {
            return;
        }
        String value = ((AnnotationTextSet)this.dataSet).getMetadata().getTextExpression();
        double scale = ((AnnotationTextSet)this.dataSet).getMetadata().getMapBaseScale();
        TextAttributesType attrs = AnnotationTextUtil.getTextAttributes((String)((AnnotationTextSet)this.dataSet).getMetadata().getTextAtttributes());
        change.updateEnvelope(value, scale, attrs, this.dataSet.hasGeodeticSRID(), (int)this.dataSet.getGeometrySrid());
    }

    public boolean removeTextElement(String featKey, int elemIndex) throws Exception {
        AnnotationTextFeature atfeat = this.getFeature(featKey);
        if (atfeat == null) {
            throw new Exception("null");
        }
        AnnotationText atext = atfeat.getSpatialAttribute();
        if (atext == null) {
            throw new Exception("null");
        }
        AnnotationText change = (AnnotationText)atext.clone();
        if (change == null) {
            throw new Exception("null");
        }
        if (!change.removeElement(elemIndex)) {
            throw new Exception("null");
        }
        this.updateEnvelope(change);
        return this.updateSpatialAttribute(featKey, change);
    }

    public AnnotationTextFeature getFeature(String featKey) {
        return (AnnotationTextFeature)this.getAbstractFeature(featKey);
    }

    public boolean updateTextElementLocation(String featKey, int elemIndex, JGeometry location) throws Exception {
        if (location == null) {
            throw new Exception("null");
        }
        AnnotationTextFeature atfeat = this.getFeature(featKey);
        if (atfeat == null) {
            throw new Exception("null");
        }
        AnnotationText atext = atfeat.getSpatialAttribute();
        if (atext == null) {
            throw new Exception("null");
        }
        AnnotationText change = (AnnotationText)atext.clone();
        if (change == null) {
            throw new Exception("null");
        }
        if (!change.setElementLocation(elemIndex, location)) {
            throw new Exception("null");
        }
        this.updateEnvelope(change);
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean updateTextElementLeaderLine(String featKey, int elemIndex, JGeometry leaderline) throws Exception {
        AnnotationTextFeature atfeat = this.getFeature(featKey);
        if (atfeat == null) {
            throw new Exception("null");
        }
        AnnotationText atext = atfeat.getSpatialAttribute();
        if (atext == null) {
            throw new Exception("null");
        }
        AnnotationText change = (AnnotationText)atext.clone();
        if (change == null) {
            throw new Exception("null");
        }
        if (!change.setElementLeaderLine(elemIndex, leaderline)) {
            throw new Exception("null");
        }
        this.updateEnvelope(change);
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean updateTextElementAttributes(String featKey, int elemIndex, TextAttributesType attrs) throws Exception {
        AnnotationTextFeature atfeat = this.getFeature(featKey);
        if (atfeat == null) {
            throw new Exception("null");
        }
        AnnotationText atext = atfeat.getSpatialAttribute();
        if (atext == null) {
            throw new Exception("null");
        }
        AnnotationText change = (AnnotationText)atext.clone();
        if (change == null) {
            throw new Exception("null");
        }
        if (!change.setElementAttributes(elemIndex, attrs)) {
            throw new Exception("null");
        }
        this.updateEnvelope(change);
        return this.updateSpatialAttribute(featKey, change);
    }

    @Override
    public AbstractFeature identify(Point2D point, double tolerance, int granularity) {
        AnnotationTextFeature atfeat = null;
        List<GeoObject> feats = this.getFeatures(point, tolerance);
        if (feats == null || feats.size() == 0) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        int index = -1;
        block0: for (int i = 0; i < feats.size(); ++i) {
            AnnotationTextElement[] elems;
            AnnotationTextFeature pf = (AnnotationTextFeature)feats.get(i);
            if (pf == null || pf.getSpatialAttribute() == null || (elems = pf.getSpatialAttribute().getElements()) == null || elems.length <= 0) continue;
            for (int j = 0; j < elems.length; ++j) {
                Point2D[][] boundary;
                JGeometry leaderline;
                JGeometry location = elems[j].getLocation();
                if (location != null) {
                    Point2D[][] boundary2;
                    if (location.getType() == 1) {
                        double dy;
                        Point2D pt = location.getJavaPoint();
                        double dx = pt.getX() - point.getX();
                        double distance = Math.sqrt(dx * dx + (dy = pt.getY() - point.getY()) * dy);
                        if (distance <= tolerance && distance < minDist) {
                            minDist = distance;
                            atfeat = pf;
                            atfeat.setSubElementInfo(granularity, j, AnnotationTextFeature.COMP_LOCATION, -1);
                            continue block0;
                        }
                    } else if (location.getType() == 2 && (boundary2 = JGeometryUtil.getBoundary((JGeometry)location)) != null) {
                        Point2D[] bounds = boundary2[0];
                        for (int m = 0; m < bounds.length - 1; ++m) {
                            Point2D p1 = bounds[m];
                            Point2D p2 = bounds[m + 1];
                            double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                            if (!(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                            minDist = dist[0];
                            atfeat = pf;
                            atfeat.setSubElementInfo(granularity, j, AnnotationTextFeature.COMP_LOCATION, -1);
                            break;
                        }
                    }
                }
                if ((leaderline = elems[j].getLeaderLine()) != null && leaderline.getType() == 2 && (boundary = JGeometryUtil.getBoundary((JGeometry)leaderline)) != null) {
                    Point2D[] bounds = boundary[0];
                    for (int m = 0; m < bounds.length - 1; ++m) {
                        Point2D p1 = bounds[m];
                        Point2D p2 = bounds[m + 1];
                        double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                        if (!(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                        minDist = dist[0];
                        atfeat = pf;
                        atfeat.setSubElementInfo(granularity, j, AnnotationTextFeature.COMP_LEADERLINE, -1);
                        break;
                    }
                }
                if (atfeat != null) continue;
                String value = this.getAnnotationTextSet().getMetadata().getTextExpression();
                double scale = this.getAnnotationTextSet().getMetadata().getMapBaseScale();
                TextAttributesType attrs = AnnotationTextUtil.getTextAttributes((String)this.getAnnotationTextSet().getMetadata().getTextAtttributes());
                Rectangle2D elemRect = pf.getSpatialAttribute().getElementMBR(j, value, scale, attrs, this.getAnnotationTextSet().hasGeodeticSRID());
                if (elemRect == null || !elemRect.contains(point)) continue;
                atfeat = pf;
                atfeat.setSubElementInfo(granularity, j, AnnotationTextFeature.COMP_LOCATION, -1);
                return atfeat;
            }
        }
        return atfeat;
    }

    public int getTextElementIndex(AnnotationTextFeature atfeat, Point2D point, double tolerance) {
        if (atfeat == null || atfeat.getSpatialAttribute() == null) {
            return -1;
        }
        AnnotationTextElement[] elems = atfeat.getSpatialAttribute().getElements();
        if (elems != null && elems.length > 0) {
            for (int j = 0; j < elems.length; ++j) {
                Point2D[][] boundary;
                JGeometry leaderline;
                JGeometry location = elems[j].getLocation();
                if (location != null) {
                    Point2D[][] boundary2;
                    if (location.getType() == 1) {
                        double dy;
                        Point2D pt = location.getJavaPoint();
                        double dx = pt.getX() - point.getX();
                        double distance = Math.sqrt(dx * dx + (dy = pt.getY() - point.getY()) * dy);
                        if (distance <= tolerance) {
                            return j;
                        }
                    } else if (location.getType() == 2 && (boundary2 = JGeometryUtil.getBoundary((JGeometry)location)) != null) {
                        Point2D[] bounds = boundary2[0];
                        for (int m = 0; m < bounds.length - 1; ++m) {
                            Point2D p1 = bounds[m];
                            Point2D p2 = bounds[m + 1];
                            double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                            if (!(dist[0] <= tolerance)) continue;
                            return j;
                        }
                    }
                }
                if ((leaderline = elems[j].getLeaderLine()) != null && leaderline.getType() == 2 && (boundary = JGeometryUtil.getBoundary((JGeometry)leaderline)) != null) {
                    Point2D[] bounds = boundary[0];
                    for (int m = 0; m < bounds.length - 1; ++m) {
                        Point2D p1 = bounds[m];
                        Point2D p2 = bounds[m + 1];
                        double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                        if (!(dist[0] <= tolerance)) continue;
                        return j;
                    }
                }
                String value = ((AnnotationTextSet)this.dataSet).getMetadata().getTextExpression();
                double scale = ((AnnotationTextSet)this.dataSet).getMetadata().getMapBaseScale();
                TextAttributesType attrs = AnnotationTextUtil.getTextAttributes((String)((AnnotationTextSet)this.dataSet).getMetadata().getTextAtttributes());
                Rectangle2D elemRect = atfeat.getSpatialAttribute().getElementMBR(j, value, scale, attrs, this.dataSet.hasGeodeticSRID());
                if (elemRect == null || !elemRect.contains(point)) continue;
                return j;
            }
        }
        return -1;
    }

    public boolean moveFeature(String featKey, double offsetX, double offsetY) throws Exception {
        AnnotationTextFeature atfeat = this.getFeature(featKey);
        if (atfeat == null) {
            throw new Exception("null");
        }
        AnnotationText atext = atfeat.getSpatialAttribute();
        if (atext == null) {
            throw new Exception("null");
        }
        AnnotationText change = (AnnotationText)atext.clone();
        if (change == null) {
            throw new Exception("null");
        }
        AnnotationTextElement[] elems = change.getElements();
        if (elems != null && elems.length > 0) {
            for (int j = 0; j < elems.length; ++j) {
                JGeometry leaderline;
                JGeometry location = elems[j].getLocation();
                if (location != null) {
                    JGeometry newLoc = JGeometryUtil.moveGeometry((JGeometry)location, (double)offsetX, (double)offsetY);
                    elems[j].setLocation(newLoc);
                }
                if ((leaderline = elems[j].getLeaderLine()) == null) continue;
                JGeometry newLL = JGeometryUtil.moveGeometry((JGeometry)leaderline, (double)offsetX, (double)offsetY);
                elems[j].setLeaderLine(newLL);
            }
            this.updateEnvelope(change);
        }
        return this.updateSpatialAttribute(featKey, change);
    }
}

