/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.PropertySupportObject;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.AnnotationTextUtil;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.annotationtext.AnnotationTextSet;
import oracle.spatial.geometry.JGeometry;

public class PenTool
extends BasicTool {
    public static final String PENPOINT = "penpoint";
    public static final String PENLINE = "penline";
    public static final String PENPOLYGON = "penpolygon";
    public static final String KNIFE = "knife";
    public static final String ADDFACE = "addface";
    public static final String ADDLINKOREDGE = "addlinkoredge";
    private String modifier = null;
    private static int CLICKED_MODE = 0;
    private static int PRESSED_MODE = 1;
    private static int LINEAR_SEGMENT = 0;
    private static int ARC_SEGMENT = 1;
    private AnimatedStroke ghostAnimatedStroke = new AnimatedStroke();
    private Vector<Point2D> points = new Vector();
    private Point2D cursorPoint = null;
    private boolean snapped = false;
    private int polygonIndex = -1;
    private boolean closePath = false;
    private boolean voidPolygon = false;
    private int digitizeMode = CLICKED_MODE;
    private int segmentType = LINEAR_SEGMENT;
    private PenFirstChange firstChange = null;
    private MainAppPanel mainApp = null;

    public PenTool(MapCanvas canvas) {
        super(canvas);
        Layer l;
        if (canvas != null && (l = canvas.getLayerManager().getLayerByTag("drawingToolsConfigLayer")) != null && l.getProperties() instanceof PropertySupportObject) {
            this.properties = (PropertySupportObject)l.getProperties();
        }
        this.ghostAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.ghostAnimatedStroke.setWidth(3.0f);
    }

    @Override
    public void update(long elapsedTime) {
        this.ghostAnimatedStroke.update(elapsedTime);
    }

    private Color getColorProperty(String property) {
        try {
            Integer i = Integer.decode(this.getProperty(property));
            return new Color(i);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public long render(Graphics2D g) {
        long t1 = System.currentTimeMillis();
        AffineTransform at = this.canvas.getMapRegion().getViewportTransform();
        GeneralPath gp = this.createPath(at);
        if (gp != null) {
            Point2D lp;
            g.setColor(this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.lineSegmentColor"));
            g.setStroke(new BasicStroke(Float.parseFloat(this.getProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.lineSegmentSize"))));
            g.draw(gp);
            if (this.cursorPoint != null && (lp = this.points.get(this.points.size() - 1)) != null) {
                Point2D.Double lpt = new Point2D.Double();
                at.transform(lp, lpt);
                Point2D.Double cpt = new Point2D.Double();
                at.transform(this.cursorPoint, cpt);
                g.setColor(this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.rubberbandSegmentColor"));
                this.ghostAnimatedStroke.setWidth(Float.parseFloat(this.getProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.rubberbandSegmentSize")));
                g.setStroke(this.ghostAnimatedStroke.getStroke());
                g.drawLine((int)((Point2D)lpt).getX(), (int)((Point2D)lpt).getY(), (int)((Point2D)cpt).getX(), (int)((Point2D)cpt).getY());
            }
            for (Point2D vertex : this.points) {
                Point2D.Double p = new Point2D.Double();
                at.transform(vertex, p);
                this.drawPoint(g, p, false);
            }
        }
        if (this.cursorPoint != null) {
            Point2D.Double p = new Point2D.Double();
            at.transform(this.cursorPoint, p);
            this.drawPoint(g, p, this.snapped);
        }
        return System.currentTimeMillis() - t1;
    }

    private void drawPoint(Graphics2D g, Point2D point, boolean isSnapPoint) {
        double w;
        if (point == null) {
            return;
        }
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color borderColor = isSnapPoint ? this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.snapBorderColor") : this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointBorderColor");
        g.setColor(borderColor);
        g.setStroke(new BasicStroke(2.0f));
        double cx = point.getX();
        double cy = point.getY();
        double h = w = Double.parseDouble(this.getProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointSize"));
        g.drawOval((int)(cx - w * 0.5), (int)(cy - h * 0.5), (int)w, (int)h);
        Color centerColor = isSnapPoint ? this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.snapCenterColor") : this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.cursorPointCenterColor");
        double gap = 2.5;
        g.setColor(centerColor);
        g.setStroke(new BasicStroke(2.0f));
        g.drawLine((int)(cx - w * 0.5 + gap), (int)cy, (int)(cx + w * 0.5 - gap), (int)cy);
        g.drawLine((int)cx, (int)(cy - h * 0.5 + gap), (int)cx, (int)(cy + h * 0.5 - gap));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
    }

    @Override
    public void clear() {
        if (this.firstChange != null) {
            this.canvas.getUndoManager().trimEdits((UndoableEdit)this.firstChange, this.firstChange.getLastChange());
            this.firstChange = null;
        }
        this.cursorPoint = null;
        this.snapped = false;
        this.polygonIndex = -1;
        this.points.clear();
    }

    private void mouseClicked(MouseEvent e) {
        if (e.getButton() == 3 && this.points.size() == 0) {
            return;
        }
        Point2D pt = this.cursorPoint;
        if (pt == null) {
            try {
                pt = new Point2D.Double();
                this.canvas.getViewportTransform().inverseTransform(e.getPoint(), pt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (this.points.size() == 0) {
            if (this.voidPolygon) {
                this.polygonIndex = -1;
                Layer editLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
                if (editLayer == null || !(editLayer instanceof GeometrySetLayer)) {
                    return;
                }
                List<GeoObject> selObj = ((GeometrySetLayer)editLayer).getSelection();
                if (selObj == null || selObj.size() != 1) {
                    return;
                }
                this.polygonIndex = JGeometryUtil.identifyPolygonElement((JGeometry)((GeometryFeature)selObj.get(0)).getSpatialAttribute(), (Point2D)pt);
                if (this.polygonIndex == -1) {
                    return;
                }
            }
            this.points.add(pt);
        } else {
            Point2D lastPoint = this.points.get(this.points.size() - 1);
            if (pt.getX() != lastPoint.getX() || pt.getY() != lastPoint.getY()) {
                this.points.add(pt);
            }
        }
        this.registerUndoEvent();
        if (this.modifier.equals(PENPOINT)) {
            this.finish();
        }
    }

    private void mouseDragged(MouseEvent e) {
        if (this.digitizeMode != PRESSED_MODE) {
            return;
        }
        try {
            Point2D.Double wcPT = new Point2D.Double();
            this.canvas.getViewportTransform().inverseTransform(e.getPoint(), wcPT);
            this.points.add(wcPT);
            this.registerUndoEvent();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    private void mouseMoved(MouseEvent e) {
        this.snapped = false;
        Point2D snapPoint = this.findSnapPoint(e.getPoint());
        if (snapPoint != null) {
            this.cursorPoint = snapPoint;
            this.snapped = true;
        } else {
            try {
                this.cursorPoint = new Point2D.Double();
                this.canvas.getViewportTransform().inverseTransform(e.getPoint(), this.cursorPoint);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    private boolean mouseReleased(MouseEvent e) {
        if (e.getButton() == 3 && this.points.size() > 0) {
            this.finish();
            return false;
        }
        return true;
    }

    private Point2D findSnapPoint(Point2D cursor) {
        LayerManager snapLayers = this.canvas.getLayerManager().filterSetByTags(new String[]{"snapLayer"});
        if (snapLayers.size() == 0) {
            return null;
        }
        for (Layer snapLayer : snapLayers) {
            BasicLayer l;
            if (!(snapLayer instanceof GeometrySetLayer) && !(snapLayer instanceof TopologySetLayer) && !(snapLayer instanceof TopologyPrimitiveLayer)) continue;
            AffineTransform at = this.canvas.getViewportTransform();
            Point2D.Double pt = new Point2D.Double();
            try {
                at.inverseTransform(cursor, pt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            double wcTolerance = TransformUtils.getWCTolerance(pt, 3, at);
            JGeometrySegmentPoint segPt = null;
            if (snapLayer instanceof GeometrySetLayer) {
                l = (GeometrySetLayer)snapLayer;
                segPt = ((IndexedGeometrySet)((AbstractDataSetLayer)l).getIndexedDataSet()).getSegmentPoint(pt, wcTolerance, true, true, true, true);
            } else if (snapLayer instanceof TopologySetLayer) {
                l = (TopologySetLayer)snapLayer;
                segPt = ((TopologySetLayer)l).getIndexedTopologyModel().getEdgeSegmentPoint(pt, wcTolerance);
            } else if (snapLayer instanceof TopologyPrimitiveLayer) {
                l = (TopologyPrimitiveLayer)snapLayer;
                segPt = ((TopologyPrimitiveLayer)l).getIndexedTopologyModel().getEdgeSegmentPoint(pt, wcTolerance);
            }
            if (segPt == null) continue;
            return segPt.getPoint();
        }
        return null;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        Layer targetLayer = this.getTargetLayer();
        if (targetLayer != null && evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            switch (id) {
                case 500: {
                    this.mouseClicked(e);
                    propagate = false;
                    break;
                }
                case 503: {
                    this.mouseMoved(e);
                    break;
                }
                case 501: {
                    break;
                }
                case 502: {
                    propagate = this.mouseReleased(e);
                    break;
                }
                case 506: {
                    this.mouseDragged(e);
                    break;
                }
                case 505: {
                    this.cursorPoint = null;
                }
            }
        }
        return propagate;
    }

    @Override
    public boolean isInAction() {
        return this.points.size() > 0;
    }

    public void setAsClosedPath(boolean closed) {
        this.closePath = closed;
        this.voidPolygon = false;
    }

    public void setAsClosedPathAndIsVoid() {
        this.closePath = true;
        this.voidPolygon = true;
    }

    public void setVoidPolygon(boolean isVoid) {
        this.voidPolygon = isVoid;
    }

    public int getPolygonIndex() {
        return this.polygonIndex;
    }

    private void finish() {
        block50: {
            this.cursorPoint = null;
            if (this.firstChange != null) {
                this.canvas.getUndoManager().trimEdits((UndoableEdit)this.firstChange, this.firstChange.getLastChange());
                this.firstChange = null;
            }
            if (this.closePath && this.points.size() > 0) {
                this.points.add(new Point2D.Double(this.points.get(0).getX(), this.points.get(0).getY()));
            }
            if (this.modifier.equals(PENPOLYGON) && this.points.size() < 4 || this.modifier.equals(KNIFE) && this.points.size() < 4 || this.modifier.equals(ADDFACE) && this.points.size() < 4 || this.modifier.equals(PENLINE) && this.points.size() < 2 || this.modifier.equals(ADDLINKOREDGE) && this.points.size() < 2 || this.modifier.equals(PENPOINT) && this.points.size() != 1) {
                JOptionPane.showMessageDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Not_enough_points"), MessagesBundle.getMessage("Warning"), 2);
                this.clear();
                return;
            }
            if (this.modifier.equals(PENPOINT)) {
                Point2D wcPoint = this.points.get(0);
                try {
                    int sel;
                    Layer targetLayer = this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
                    if (targetLayer instanceof TopologySetLayer || targetLayer instanceof TopologyPrimitiveLayer) {
                        int geomDim = 2;
                        double[] oords = new double[geomDim];
                        oords[0] = wcPoint.getX();
                        oords[1] = wcPoint.getY();
                        int srid = targetLayer.getSRID();
                        JGeometry geom = JGeometry.createPoint((double[])oords, (int)geomDim, (int)srid);
                        try {
                            if (targetLayer instanceof TopologySetLayer) {
                                ((TopologySetLayer)targetLayer).addPrimitiveGeometry(geom);
                            } else {
                                ((TopologyPrimitiveLayer)targetLayer).addPrimitive(geom);
                            }
                        }
                        catch (Exception ex) {
                            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toadd_spatial_element") + "\n" + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                        }
                        this.clear();
                        return;
                    }
                    AbstractDataSetLayer gl = (AbstractDataSetLayer)targetLayer;
                    List<GeoObject> selected = gl.getSelection();
                    boolean newFeature = true;
                    if (selected != null && selected.size() > 0 && (sel = JOptionPane.showConfirmDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Question_append_spatial_element"), MessagesBundle.getMessage("Append_spatial_element"), 0)) == 0) {
                        newFeature = false;
                    }
                    Field[] fields = null;
                    if (newFeature && ((fields = gl.getFieldsForFeature(null, false)) == null || fields.length == 0)) {
                        this.clear();
                        return;
                    }
                    int geomDim = gl.getIndexedDataSet().getDataSet().getGeometryDimensions();
                    if (geomDim == -1) {
                        geomDim = 2;
                    }
                    double[] oords = new double[geomDim];
                    oords[0] = wcPoint.getX();
                    oords[1] = wcPoint.getY();
                    int srid = gl.getSRID();
                    JGeometry geom = JGeometry.createPoint((double[])oords, (int)geomDim, (int)srid);
                    String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
                    if (gl instanceof GeometrySetLayer) {
                        if (newFeature) {
                            GeometryFeature gfeat = new GeometryFeature();
                            gfeat.setSpatialAttribute(geom);
                            gfeat.setAttributes(fields);
                            String fkey = gfeat.getAttribute(keyColumn).getValue().toString();
                            gfeat.setKey(fkey);
                            gfeat.setLayer(gl);
                            gl.insertObject(fkey, gfeat);
                        } else {
                            ((GeometrySetLayer)gl).addPointElement(selected.get(0).getKey().toString(), geom);
                        }
                        break block50;
                    }
                    if (!(gl instanceof AnnotationTextSetLayer)) break block50;
                    AnnotationTextElement atelem = new AnnotationTextElement();
                    atelem.setLocation(geom);
                    if (newFeature) {
                        AnnotationTextFeature atfeat = new AnnotationTextFeature();
                        AnnotationText atext = new AnnotationText();
                        atext.addElement(atelem);
                        AnnotationTextSet dataSet = (AnnotationTextSet)gl.getIndexedDataSet().getDataSet();
                        double scale = dataSet.getMetadata().getMapBaseScale();
                        String value = dataSet.getMetadata().getTextExpression();
                        TextAttributesType attrs = AnnotationTextUtil.getTextAttributes((String)dataSet.getMetadata().getTextAtttributes());
                        atext.updateEnvelope(value, scale, attrs, dataSet.hasGeodeticSRID(), (int)dataSet.getGeometrySrid());
                        atfeat.setSpatialAttribute(atext);
                        atfeat.setAttributes(fields);
                        String fkey = atfeat.getAttribute(keyColumn).getValue().toString();
                        atfeat.setKey(fkey);
                        atfeat.setLayer(gl);
                        gl.insertObject(fkey, atfeat);
                        break block50;
                    }
                    ((AnnotationTextSetLayer)gl).addTextElement(selected.get(0).getKey().toString(), atelem);
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toadd_point") + "\n" + ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
                }
            } else {
                AnnotationTextSetLayer gl;
                List<GeoObject> selected;
                int elemIndex;
                Layer targetLayer = this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
                if (targetLayer instanceof GeometrySetLayer) {
                    int sel;
                    GeometrySetLayer gl2 = (GeometrySetLayer)targetLayer;
                    List<GeoObject> selected2 = gl2.getSelection();
                    boolean newFeature = true;
                    if (this.getModifier().equals(KNIFE)) {
                        newFeature = false;
                    }
                    if (selected2 != null && selected2.size() > 0 && !this.getModifier().equals(KNIFE) && (sel = JOptionPane.showConfirmDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Question_append_spatial_element"), MessagesBundle.getMessage("Append_spatial_element"), 0)) == 0) {
                        newFeature = false;
                    }
                    Field[] fields = null;
                    if (newFeature) {
                        try {
                            fields = gl2.getFieldsForFeature(null, false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (fields == null || fields.length == 0) {
                            this.clear();
                            return;
                        }
                    }
                    int srid = gl2.getSRID();
                    String keyColumn = gl2.getIndexedDataSet().getDataSet().getKeyColumn();
                    int geomDim = gl2.getIndexedDataSet().getDataSet().getGeometryDimensions();
                    if (geomDim == -1) {
                        geomDim = 2;
                    }
                    double[] oords = new double[this.points.size() * geomDim];
                    JGeometry geom = null;
                    for (int i = 0; i < this.points.size(); ++i) {
                        Point2D pt = this.points.get(i);
                        oords[i * geomDim] = pt.getX();
                        oords[i * geomDim + 1] = pt.getY();
                    }
                    if (this.getModifier().equals(PENPOLYGON) || this.getModifier().equals(KNIFE)) {
                        boolean isClockwise = GeometryUtil.isClockwise((double[])oords);
                        boolean ccwOrientation = true;
                        String outerRingOrientation = targetLayer.getProperty("oracle.spatial.edit.layer.GeometrySetLayer.polygonOuterRingOrientation");
                        if (outerRingOrientation != null && outerRingOrientation.equalsIgnoreCase("clockwise")) {
                            ccwOrientation = false;
                        }
                        geom = isClockwise && ccwOrientation || !isClockwise && !ccwOrientation ? JGeometry.createLinearPolygon((double[])GeometryUtil.reverseCoordinates((double[])oords, (int)geomDim), (int)geomDim, (int)srid) : JGeometry.createLinearPolygon((double[])oords, (int)geomDim, (int)srid);
                    } else {
                        geom = JGeometry.createLinearLineString((double[])oords, (int)geomDim, (int)srid);
                    }
                    if (newFeature) {
                        GeometryFeature gfeat = new GeometryFeature();
                        gfeat.setSpatialAttribute(geom);
                        gfeat.setAttributes(fields);
                        String fkey = gfeat.getAttribute(keyColumn).getValue().toString();
                        gfeat.setKey(fkey);
                        gfeat.setLayer(gl2);
                        try {
                            gl2.insertObject(fkey, gfeat);
                        }
                        catch (Exception ex) {
                            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toinsert_object"), MessagesBundle.getMessage("Error"), 0);
                        }
                    } else {
                        try {
                            if (this.getModifier().equals(PENPOLYGON)) {
                                gl2.addPolygonElement(selected2.get(0).getKey().toString(), geom);
                                break block50;
                            }
                            if (this.getModifier().equals(KNIFE)) {
                                gl2.addVoidPolygonElement(selected2.get(0).getKey().toString(), this.getPolygonIndex(), geom);
                                break block50;
                            }
                            gl2.addLineElement(selected2.get(0).getKey().toString(), geom);
                        }
                        catch (Exception ex) {
                            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toadd_spatial_element"), MessagesBundle.getMessage("Error"), 0);
                        }
                    }
                } else if (targetLayer instanceof TopologySetLayer || targetLayer instanceof TopologyPrimitiveLayer) {
                    int srid = targetLayer.getSRID();
                    int geomDim = 2;
                    double[] oords = new double[this.points.size() * geomDim];
                    JGeometry geom = null;
                    for (int i = 0; i < this.points.size(); ++i) {
                        Point2D pt = this.points.get(i);
                        oords[i * geomDim] = pt.getX();
                        oords[i * geomDim + 1] = pt.getY();
                    }
                    geom = this.getModifier().equals(ADDFACE) ? (GeometryUtil.isClockwise((double[])oords) ? JGeometry.createLinearPolygon((double[])GeometryUtil.reverseCoordinates((double[])oords, (int)geomDim), (int)geomDim, (int)srid) : JGeometry.createLinearPolygon((double[])oords, (int)geomDim, (int)srid)) : JGeometry.createLinearLineString((double[])oords, (int)geomDim, (int)srid);
                    try {
                        if (targetLayer instanceof TopologySetLayer) {
                            ((TopologySetLayer)targetLayer).addPrimitiveGeometry(geom);
                            break block50;
                        }
                        ((TopologyPrimitiveLayer)targetLayer).addPrimitive(geom);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toadd_spatial_element") + "\n" + ex.getMessage(), MessagesBundle.getMessage("Error"), 0);
                    }
                } else if (targetLayer instanceof AnnotationTextSetLayer && (elemIndex = ((AnnotationTextFeature)(selected = (gl = (AnnotationTextSetLayer)targetLayer).getSelection()).get(0)).getElement()) > -1) {
                    int srid = gl.getSRID();
                    int geomDim = 2;
                    double[] oords = new double[this.points.size() * geomDim];
                    JGeometry geom = null;
                    for (int i = 0; i < this.points.size(); ++i) {
                        Point2D pt = this.points.get(i);
                        oords[i * geomDim] = pt.getX();
                        oords[i * geomDim + 1] = pt.getY();
                    }
                    geom = JGeometry.createLinearLineString((double[])oords, (int)geomDim, (int)srid);
                    try {
                        gl.updateTextElementLeaderLine(selected.get(0).getKey().toString(), elemIndex, geom);
                    }
                    catch (Exception ex) {
                        ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toupdate_leader_line"), MessagesBundle.getMessage("Error"), 0);
                    }
                }
            }
        }
        this.clear();
    }

    private Layer getTargetLayer() {
        return this.canvas.getLayerManager().getLayerByTag("targetLayer");
    }

    private GeneralPath createPath(AffineTransform xfm) {
        GeneralPath gp = null;
        if (this.points.size() > 0) {
            gp = new GeneralPath();
            for (int i = 0; i < this.points.size(); ++i) {
                Point2D.Double dcpt = new Point2D.Double();
                xfm.transform(this.points.get(i), dcpt);
                if (i == 0) {
                    gp.moveTo(((Point2D)dcpt).getX(), ((Point2D)dcpt).getY());
                    continue;
                }
                gp.lineTo(((Point2D)dcpt).getX(), ((Point2D)dcpt).getY());
            }
        }
        return gp;
    }

    public void registerUndoEvent() {
        PenToolUndoableEdit edit = new PenToolUndoableEdit();
        if (this.firstChange == null) {
            edit.setSignificant(false);
            this.firstChange = new PenFirstChange();
            this.canvas.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, this.firstChange));
        }
        this.firstChange.setLastChange(edit);
        this.canvas.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, edit));
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setMainApp(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    private class PenToolUndoableEdit
    extends AbstractUndoableEdit {
        private int index = -1;
        private Point2D point = null;
        private boolean significant = true;

        public PenToolUndoableEdit() {
            this.index = PenTool.this.points.size() - 1;
            this.point = (Point2D)PenTool.this.points.get(this.index);
        }

        @Override
        public String getPresentationName() {
            return "Pen tool point";
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (PenTool.this.points != null) {
                PenTool.this.points.remove(this.index);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (PenTool.this.points != null) {
                PenTool.this.points.add(this.point);
            }
        }

        public void setSignificant(boolean significant) {
            this.significant = significant;
        }

        @Override
        public boolean isSignificant() {
            return this.significant;
        }
    }

    private class PenFirstChange
    extends AbstractUndoableEdit {
        private UndoableEdit lastChange = null;

        private PenFirstChange() {
        }

        @Override
        public void undo() {
            super.undo();
            if (this.lastChange == null) {
                throw new CannotUndoException();
            }
            PenTool.this.clear();
        }

        @Override
        public void redo() {
            throw new CannotRedoException();
        }

        public void setLastChange(UndoableEdit lastChange) {
            this.lastChange = lastChange;
        }

        public UndoableEdit getLastChange() {
            return this.lastChange;
        }
    }
}

