/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.dbtools.migration.parser.helper.CodeBlockManager;
import oracle.dbtools.migration.parser.helper.TranslationMetaData;
import oracle.dbtools.migration.translation.api.components.Block;

public class TransactionHelper {
    private ArrayList<Savepoint> m_savepointList;
    private Hashtable<Block, String> m_txnCountVarMap;
    private TranslationMetaData m_metadata;
    private CodeBlockManager m_codeBlockMgr;

    public TransactionHelper(CodeBlockManager codeBlockManager, TranslationMetaData translationMetaData) {
        this.m_codeBlockMgr = codeBlockManager;
        this.m_metadata = translationMetaData;
        this.m_savepointList = new ArrayList();
    }

    public void addSavepoint(AST aST, String string) {
        if (aST == null) {
            return;
        }
        Block block = this.m_codeBlockMgr.findEnclosingBlock(aST, "CREATEOBJBLOCK");
        if (block == null) {
            block = this.m_codeBlockMgr.findEnclosingBlock(aST, "GRAMMARROOTBLOCK");
        }
        this.m_savepointList.add(new Savepoint(block, string));
    }

    public boolean isSavepoint(AST aST, String string) {
        if (aST == null) {
            return false;
        }
        Block block = this.m_codeBlockMgr.findEnclosingBlock(aST, "CREATEOBJBLOCK");
        if (block == null) {
            block = this.m_codeBlockMgr.findEnclosingBlock(aST, "GRAMMARROOTBLOCK");
        }
        for (Savepoint savepoint : this.m_savepointList) {
            if (!savepoint.equals(block, string)) continue;
            return true;
        }
        return false;
    }

    public String getTrancountName() {
        return this.m_metadata.getTranslationHelper().getVariableNameTranslator().getEmulationPackageName() + ".trancount";
    }

    class Savepoint {
        private Block m_block;
        private String m_name;

        Savepoint(Block block, String string) {
            this.m_block = block;
            this.m_name = string;
        }

        public String getName() {
            return this.m_name;
        }

        public Block getBlock() {
            return this.m_block;
        }

        public boolean equals(Block block, String string) {
            if (block == null || string == null) {
                return false;
            }
            return block.equals(this.m_block) && this.m_name.equalsIgnoreCase(string);
        }
    }
}

