/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditorFactory;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.NumberRangeComboBoxEditor;
import oracle.bali.inspector.editor.NumberRangeTextFieldEditor;
import oracle.bali.inspector.editor.NumberTextFieldConfig;
import oracle.bali.inspector.editor.TextFieldEditorFactory;

public final class MappedEditorFactory
extends EditorComponentFactory {
    @Override
    public boolean canCreateEditorFrom(Object creationInfo) {
        if (creationInfo instanceof EditorComponentInfo) {
            Object initialValue = ((EditorComponentInfo)creationInfo).initialValue();
            return this.isMappedEditorFactoryInfo(initialValue);
        }
        return this.isMappedEditorFactoryInfo(creationInfo);
    }

    @Override
    public Component createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.isMappedEditorFactoryInfo(initialValue)) {
            return null;
        }
        MappedEditorFactoryInfo targetInfo = (MappedEditorFactoryInfo)initialValue;
        JComboBox editor = this.createComboBox(targetInfo, propertyEditor);
        if (editor != null) {
            return editor;
        }
        return this.createTextField(targetInfo);
    }

    private NumberRangeTextFieldEditor createNumberTextFieldEditor(MappedEditorFactoryInfo targetInfo) {
        Object numberFieldInfo = targetInfo.property(MappedEditorFactoryInfo.PropertyName.COMPONENT_CONFIG_INFO);
        if (!(numberFieldInfo instanceof NumberTextFieldConfig)) {
            return null;
        }
        NumberRangeTextFieldEditor editor = new NumberRangeTextFieldEditor();
        NumberTextFieldConfig config = (NumberTextFieldConfig)numberFieldInfo;
        config.configure(editor);
        return editor;
    }

    private JTextField createTextField(MappedEditorFactoryInfo targetInfo) {
        MappedEditorFactoryInfo.EditorType editorType = targetInfo.editorType();
        if (editorType != null && !MappedEditorFactoryInfo.EditorType.TEXT_FIELD.equals((Object)editorType)) {
            return null;
        }
        NumberRangeTextFieldEditor numberTextField = this.createNumberTextFieldEditor(targetInfo);
        if (numberTextField != null) {
            return numberTextField;
        }
        Object text = targetInfo.property(MappedEditorFactoryInfo.PropertyName.TEXT);
        if (text == null || text instanceof String) {
            JTextField editor = this.textFieldEditorFactory().textField((String)text);
            Object editable = targetInfo.property(MappedEditorFactoryInfo.PropertyName.EDITABLE);
            if (editable instanceof Boolean) {
                editor.setEditable((Boolean)editable);
            }
            return editor;
        }
        return null;
    }

    @Override
    public Component updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.isMappedEditorFactoryInfo(initialValue)) {
            return null;
        }
        MappedEditorFactoryInfo targetInfo = (MappedEditorFactoryInfo)initialValue;
        JComponent editor = this.updateNumberEditor(current, targetInfo);
        if (editor != null) {
            return editor;
        }
        editor = this.updateComboBox(current, targetInfo);
        if (editor != null) {
            return editor;
        }
        if (MappedEditorFactoryInfo.EditorType.TEXT_FIELD.equals((Object)targetInfo.editorType()) || targetInfo.editorType() == null) {
            return this.updateTextField(current, targetInfo, propertyEditor);
        }
        return null;
    }

    private JTextField updateTextField(Component current, MappedEditorFactoryInfo targetInfo, PropertyEditorFactory2 propertyEditor) {
        Object text = targetInfo.property(MappedEditorFactoryInfo.PropertyName.TEXT);
        if (text != null && !(text instanceof String)) {
            return null;
        }
        if (current instanceof JTextField) {
            JTextField textField = (JTextField)current;
            return this.textFieldEditorFactory().textField(textField, (String)text, propertyEditor);
        }
        return null;
    }

    private TextFieldEditorFactory textFieldEditorFactory() {
        return EditorComponentFactoryRegistry.instance().textFieldEditorFactory();
    }

    private boolean isMappedEditorFactoryInfo(Object initialValue) {
        return initialValue instanceof MappedEditorFactoryInfo;
    }

    private JComponent updateNumberEditor(Component current, MappedEditorFactoryInfo targetInfo) {
        Object numberFieldInfo = targetInfo.property(MappedEditorFactoryInfo.PropertyName.COMPONENT_CONFIG_INFO);
        if (!(numberFieldInfo instanceof NumberTextFieldConfig)) {
            return null;
        }
        NumberTextFieldConfig config = (NumberTextFieldConfig)numberFieldInfo;
        if (current instanceof NumberRangeTextFieldEditor) {
            NumberRangeTextFieldEditor editor = (NumberRangeTextFieldEditor)((Object)current);
            config.configure(editor);
            return editor;
        }
        if (current instanceof JComboBox) {
            JComboBox updated;
            JComboBox editor = (JComboBox)current;
            ComboBoxEditor comboBoxEditor = editor.getEditor();
            if (!(comboBoxEditor instanceof NumberRangeComboBoxEditor)) {
                return null;
            }
            config.configure(((NumberRangeComboBoxEditor)comboBoxEditor).numberEditor);
            ComboBoxModel comboBoxModel = null;
            Object model = targetInfo.property(MappedEditorFactoryInfo.PropertyName.MODEL);
            if (model instanceof ComboBoxModel) {
                comboBoxModel = (ComboBoxModel)model;
            }
            if ((updated = this.comboBoxEditorFactory().comboBox(editor, comboBoxModel)) != null) {
                updated.setEditable(true);
            }
            return updated;
        }
        return this.createNumberTextFieldEditor(targetInfo);
    }

    private JComboBox updateComboBox(Component current, MappedEditorFactoryInfo targetInfo) {
        ComboBoxModel model = this.comboBoxModelFrom(targetInfo);
        if (model == null) {
            return null;
        }
        JComboBox comboBox = null;
        if (current instanceof JComboBox) {
            comboBox = (JComboBox)current;
            return this.comboBoxEditorFactory().comboBox(comboBox, model);
        }
        return null;
    }

    private JComboBox createComboBox(MappedEditorFactoryInfo targetInfo, PropertyEditorFactory2 propertyEditor) {
        ComboBoxModel model = this.comboBoxModelFrom(targetInfo);
        if (model == null) {
            return null;
        }
        JComboBox comboBox = this.createComboBox(model, targetInfo, propertyEditor);
        NumberRangeTextFieldEditor numberTextField = this.createNumberTextFieldEditor(targetInfo);
        if (numberTextField != null) {
            comboBox.setEditor(new NumberRangeComboBoxEditor(numberTextField));
            comboBox.setEditable(true);
        }
        return comboBox;
    }

    private ComboBoxModel comboBoxModelFrom(MappedEditorFactoryInfo targetInfo) {
        MappedEditorFactoryInfo.EditorType editorType = targetInfo.editorType();
        if (targetInfo.editorType() != null && !MappedEditorFactoryInfo.EditorType.COMBO_BOX.equals((Object)editorType)) {
            return null;
        }
        Object model = targetInfo.property(MappedEditorFactoryInfo.PropertyName.MODEL);
        if (model instanceof ComboBoxModel) {
            return (ComboBoxModel)model;
        }
        return null;
    }

    private JComboBox createComboBox(ComboBoxModel model, MappedEditorFactoryInfo targetInfo, PropertyEditorFactory2 propertyEditor) {
        JComboBox editor = this.comboBoxEditorFactory().comboBox(model, propertyEditor);
        if (editor == null) {
            return null;
        }
        this.setComboBoxRenderer(editor, targetInfo);
        this.setEditable(editor, targetInfo);
        return editor;
    }

    private ComboBoxEditorFactory comboBoxEditorFactory() {
        return EditorComponentFactoryRegistry.instance().comboBoxEditorFactory();
    }

    private void setComboBoxRenderer(JComboBox comboBox, MappedEditorFactoryInfo targetInfo) {
        Object renderer = targetInfo.property(MappedEditorFactoryInfo.PropertyName.RENDERER);
        if (!(renderer instanceof ListCellRenderer)) {
            return;
        }
        comboBox.setRenderer((ListCellRenderer)renderer);
    }

    private void setEditable(JComboBox comboBox, MappedEditorFactoryInfo targetInfo) {
        Object editable = targetInfo.property(MappedEditorFactoryInfo.PropertyName.EDITABLE);
        if (editable instanceof Boolean) {
            comboBox.setEditable((Boolean)editable);
        }
    }
}

