/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.PostgreSQLParser;
import com.adbs.syntax.PostgreSQLQueryPropertiesDialog;
import com.adbs.syntax.PostgreSQLScanner;
import com.adbs.syntax.PostgreSQLSubQuerySelectExpressionExtender;
import com.adbs.syntax.PostgreSQLSubSelectStatementExtender;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostgreSQLSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> comparisonOperators = new ArrayList();
    private SQLQualifiedName defaultDatabaseName = null;
    private boolean denyIntoClause = false;

    public PostgreSQLSyntaxProvider() {
        this.comparisonOperators.addAll(Arrays.asList("=", ">", "<", ">=", "<=", "<>", "!=", "~~", "~~*", "!~~", "!~~*", "~", "~*", "!~", "!~*"));
        try {
            this.registerExtender(SQLSubSelectStatement.class, PostgreSQLSubSelectStatementExtender.class);
            this.registerExtender(SQLSubQuerySelectExpression.class, PostgreSQLSubQuerySelectExpressionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(PostgreSQLSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    public ArrayList<String> getComparisonOperators() {
        return this.comparisonOperators;
    }

    public void setComparisonOperators(ArrayList<String> comparisonOperators) {
        this.comparisonOperators = comparisonOperators;
    }

    @Override
    public BaseSyntaxProvider clone() {
        PostgreSQLSyntaxProvider result = (PostgreSQLSyntaxProvider)super.clone();
        result.comparisonOperators = this.comparisonOperators;
        return result;
    }

    @Override
    protected Class getScannerClass() {
        return PostgreSQLScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return PostgreSQLParser.class;
    }

    @Override
    public String getDescription() {
        return "PostgreSQL";
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
        ((PostgreSQLParser)parser).setComparisonOperators(this.comparisonOperators);
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.SensitiveLowerCase;
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Bit_And", false);
        names.addIdentifier("Bit_Or", false);
        names.addIdentifier("Bool_And", false);
        names.addIdentifier("Bool_Or", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Every", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("StdDev", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Variance", false);
    }

    @Override
    public void getMultiParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Corr", false);
        names.addIdentifier("Covar_Pop", false);
        names.addIdentifier("Covar_Samp", false);
        names.addIdentifier("Regr_AvgX", false);
        names.addIdentifier("Regr_AvgY", false);
        names.addIdentifier("Regr_Count", false);
        names.addIdentifier("Regr_Intercept", false);
        names.addIdentifier("Regr_R2", false);
        names.addIdentifier("Regr_Slope", false);
        names.addIdentifier("Regr_SXX", false);
        names.addIdentifier("Regr_SXY", false);
        names.addIdentifier("Regr_SYY", false);
        names.addIdentifier("String_Agg", false);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Abbrev");
        names.addBuiltin("Abs");
        names.addBuiltin("Acos");
        names.addBuiltin("Age");
        names.addBuiltin("Area");
        names.addBuiltin("Array_Agg");
        names.addBuiltin("Array_Append");
        names.addBuiltin("Array_Cat");
        names.addBuiltin("Array_Dims");
        names.addBuiltin("Array_Fill");
        names.addBuiltin("Array_Length");
        names.addBuiltin("Array_Lower");
        names.addBuiltin("Array_NDims");
        names.addBuiltin("Array_Prepend");
        names.addBuiltin("Array_To_String");
        names.addBuiltin("Array_Upper");
        names.addBuiltin("Ascii");
        names.addBuiltin("ASin");
        names.addBuiltin("ATan");
        names.addBuiltin("ATan2");
        names.addBuiltin("Avg");
        names.addBuiltin("Bit_And");
        names.addBuiltin("Bit_Length");
        names.addBuiltin("Bit_Or");
        names.addBuiltin("Bool_And");
        names.addBuiltin("Bool_Or");
        names.addBuiltin("Box");
        names.addBuiltin("Broadcast");
        names.addBuiltin("BTrim");
        names.addBuiltin("CbRt");
        names.addBuiltin("Ceil");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Center");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Chr");
        names.addBuiltin("Circle");
        names.addBuiltin("Clock_Timestamp");
        names.addBuiltin("Coalesce");
        names.addBuiltin("Col_Description");
        names.addBuiltin("Concat");
        names.addBuiltin("Concat_Ws");
        names.addBuiltin("Convert");
        names.addBuiltin("Convert_From");
        names.addBuiltin("Convert_To");
        names.addBuiltin("Corr");
        names.addBuiltin("Cos");
        names.addBuiltin("Cot");
        names.addBuiltin("Count");
        names.addBuiltin("Covar_Pop");
        names.addBuiltin("Covar_Samp");
        names.addBuiltin("Cume_Dist");
        names.addBuiltin("Current_Database");
        names.addBuiltin("Current_Query");
        names.addBuiltin("Current_Schema");
        names.addBuiltin("Current_Schemas");
        names.addBuiltin("Current_Setting");
        names.addBuiltin("CurrVal");
        names.addBuiltin("Cursor_To_Xml");
        names.addBuiltin("Cursor_To_XmlSchema");
        names.addBuiltin("Database_To_Xml");
        names.addBuiltin("Database_To_Xml_And_XmlSchema");
        names.addBuiltin("Database_To_XmlSchema");
        names.addBuiltin("Date_Part");
        names.addBuiltin("Date_Trunc");
        names.addBuiltin("Decode");
        names.addBuiltin("Degrees");
        names.addBuiltin("Dense_Rank");
        names.addBuiltin("Diameter");
        names.addBuiltin("Div");
        names.addBuiltin("Encode");
        names.addBuiltin("Enum_First");
        names.addBuiltin("Enum_Last");
        names.addBuiltin("Enum_Range");
        names.addBuiltin("Every");
        names.addBuiltin("Exp");
        names.addBuiltin("Extract");
        names.addBuiltin("Family");
        names.addBuiltin("First_Value");
        names.addBuiltin("Floor");
        names.addBuiltin("Format");
        names.addBuiltin("Format_Type");
        names.addBuiltin("Generate_Series");
        names.addBuiltin("Generate_Subscripts");
        names.addBuiltin("Get_Bit");
        names.addBuiltin("Get_Byte");
        names.addBuiltin("Get_Current_Ts_Config");
        names.addBuiltin("Greatest");
        names.addBuiltin("Has_Any_Column_Privilege");
        names.addBuiltin("Has_Column_Privilege");
        names.addBuiltin("Has_Database_Privilege");
        names.addBuiltin("Has_Foreign_Data_Wrapper_Privilege");
        names.addBuiltin("Has_Function_Privilege");
        names.addBuiltin("Has_Language_Privilege");
        names.addBuiltin("Has_Schema_Privilege");
        names.addBuiltin("Has_Sequence_Privilege");
        names.addBuiltin("Has_Server_Privilege");
        names.addBuiltin("Has_Table_Privilege");
        names.addBuiltin("Has_Tablespace_Privilege");
        names.addBuiltin("Height");
        names.addBuiltin("Host");
        names.addBuiltin("Hostmask");
        names.addBuiltin("Inet_Client_Addr");
        names.addBuiltin("Inet_Client_Port");
        names.addBuiltin("Inet_Server_Addr");
        names.addBuiltin("Inet_Server_Port");
        names.addBuiltin("InitCap");
        names.addBuiltin("IsClosed");
        names.addBuiltin("IsFinite");
        names.addBuiltin("IsOpen");
        names.addBuiltin("Justify_Days");
        names.addBuiltin("Justify_Hours");
        names.addBuiltin("Justify_Interval");
        names.addBuiltin("Lag");
        names.addBuiltin("LastVal");
        names.addBuiltin("Last_value");
        names.addBuiltin("Lead");
        names.addBuiltin("Least");
        names.addBuiltin("Left");
        names.addBuiltin("Length");
        names.addBuiltin("Ln");
        names.addBuiltin("Log");
        names.addBuiltin("Lower");
        names.addBuiltin("LPad");
        names.addBuiltin("LSeg");
        names.addBuiltin("LTrim");
        names.addBuiltin("MaskLen");
        names.addBuiltin("Max");
        names.addBuiltin("md5");
        names.addBuiltin("Min");
        names.addBuiltin("Mod");
        names.addBuiltin("NetMask");
        names.addBuiltin("Network");
        names.addBuiltin("NextVal");
        names.addBuiltin("Now");
        names.addBuiltin("NPoints");
        names.addBuiltin("Nth_Value");
        names.addBuiltin("NTile");
        names.addBuiltin("NullIf");
        names.addBuiltin("NumNode");
        names.addBuiltin("Obj_Description");
        names.addBuiltin("Octet_Length");
        names.addBuiltin("Overlay");
        names.addBuiltin("Path");
        names.addBuiltin("PClose");
        names.addBuiltin("Percent_Rank");
        names.addBuiltin("pg_Advisory_Lock");
        names.addBuiltin("pg_Advisory_Lock_Shared");
        names.addBuiltin("pg_Advisory_Unlock");
        names.addBuiltin("pg_Advisory_Unlock_All");
        names.addBuiltin("pg_Advisory_Unlock_Shared");
        names.addBuiltin("pg_Advisory_xact_Lock");
        names.addBuiltin("pg_Advisory_xact_Lock_Shared");
        names.addBuiltin("pg_Backend_Pid");
        names.addBuiltin("pg_Cancel_Backend");
        names.addBuiltin("pg_Client_Encoding");
        names.addBuiltin("pg_Collation_Is_Visible");
        names.addBuiltin("pg_Column_Size");
        names.addBuiltin("pg_Conf_Load_Time");
        names.addBuiltin("pg_Conversion_Is_Visible");
        names.addBuiltin("pg_Create_Restore_Point");
        names.addBuiltin("pg_Current_xlog_Insert_Location");
        names.addBuiltin("pg_Current_xlog_Location");
        names.addBuiltin("pg_Database_Size");
        names.addBuiltin("pg_Describe_Object");
        names.addBuiltin("pg_Function_Is_Visible");
        names.addBuiltin("pg_Get_ConstraintDef");
        names.addBuiltin("pg_Get_Expr");
        names.addBuiltin("pg_Get_Function_Arguments");
        names.addBuiltin("pg_Get_FunctionDef");
        names.addBuiltin("pg_Get_Function_Identity_Arguments");
        names.addBuiltin("pg_Get_Function_Result");
        names.addBuiltin("pg_Get_IndexDef");
        names.addBuiltin("pg_Get_Keywords");
        names.addBuiltin("pg_Get_RuleDef");
        names.addBuiltin("pg_Get_Serial_Sequence");
        names.addBuiltin("pg_Get_TriggerDef");
        names.addBuiltin("pg_Get_UserById");
        names.addBuiltin("pg_Get_ViewDef");
        names.addBuiltin("pg_Has_Role");
        names.addBuiltin("pg_Indexes_Size");
        names.addBuiltin("pg_Is_In_Recovery");
        names.addBuiltin("pg_Is_Other_Temp_Schema");
        names.addBuiltin("pg_Is_xlog_Teplay_Paused");
        names.addBuiltin("pg_Last_xact_Replay_Timestamp");
        names.addBuiltin("pg_Last_xlog_Receive_Location");
        names.addBuiltin("pg_Last_xlog_Replay_Location");
        names.addBuiltin("pg_Listening_Channels");
        names.addBuiltin("pg_Ls_Dir");
        names.addBuiltin("pg_My_Temp_Schema");
        names.addBuiltin("pg_OpClass_Is_Visible");
        names.addBuiltin("pg_Operator_Is_Visible");
        names.addBuiltin("pg_Options_To_Table");
        names.addBuiltin("pg_Postmaster_Start_Time");
        names.addBuiltin("pg_Read_Binary_File");
        names.addBuiltin("pg_Read_File");
        names.addBuiltin("pg_Relation_FileNode");
        names.addBuiltin("pg_Relation_FilePath");
        names.addBuiltin("pg_Relation_Size");
        names.addBuiltin("pg_Reload_Conf");
        names.addBuiltin("pg_Rotate_Logfile");
        names.addBuiltin("pg_Size_Pretty");
        names.addBuiltin("pg_Sleep");
        names.addBuiltin("pg_Start_Backup");
        names.addBuiltin("pg_Stat_File");
        names.addBuiltin("pg_Stop_Backup");
        names.addBuiltin("pg_Switch_xlog");
        names.addBuiltin("pg_Table_Is_Visible");
        names.addBuiltin("pg_Table_Size");
        names.addBuiltin("pg_Tablespace_Databases");
        names.addBuiltin("pg_Tablespace_Size");
        names.addBuiltin("pg_Terminate_Backend");
        names.addBuiltin("pg_Total_Relation_Size");
        names.addBuiltin("pg_Try_Advisory_Lock");
        names.addBuiltin("pg_Try_Advisory_Lock_Shared");
        names.addBuiltin("pg_Try_Advisory_xact_Lock");
        names.addBuiltin("pg_Try_Advisory_xact_Lock_Shared");
        names.addBuiltin("pg_Ts_Config_Is_Visible");
        names.addBuiltin("pg_Ts_Dict_Is_Visible");
        names.addBuiltin("pg_Ts_Parser_Is_Visible");
        names.addBuiltin("pg_Ts_Template_Is_Visible");
        names.addBuiltin("pg_Type_Is_Visible");
        names.addBuiltin("pg_TypeOf");
        names.addBuiltin("pg_xlogFile_Name");
        names.addBuiltin("pg_xlogFile_Name_Offset");
        names.addBuiltin("pg_xlog_Replay_Pause");
        names.addBuiltin("pg_xlog_Replay_Resume");
        names.addBuiltin("Pi");
        names.addBuiltin("PlainTo_TsQuery");
        names.addBuiltin("Point");
        names.addBuiltin("Polygon");
        names.addBuiltin("POpen");
        names.addBuiltin("Position");
        names.addBuiltin("Power");
        names.addBuiltin("Query_To_Xml");
        names.addBuiltin("Query_To_Xml_And_XmlSchema");
        names.addBuiltin("Query_To_XmlSchema");
        names.addBuiltin("QueryTree");
        names.addBuiltin("Quote_Ident");
        names.addBuiltin("Quote_Literal");
        names.addBuiltin("Quote_Nullable");
        names.addBuiltin("Radians");
        names.addBuiltin("Radius");
        names.addBuiltin("Random");
        names.addBuiltin("Rank");
        names.addBuiltin("Regexp_Matches");
        names.addBuiltin("Regexp_Replace");
        names.addBuiltin("Regexp_Split_To_Array");
        names.addBuiltin("Regexp_Split_To_Table");
        names.addBuiltin("Regr_AvgX");
        names.addBuiltin("Regr_AvgY");
        names.addBuiltin("Regr_Count");
        names.addBuiltin("Regr_Intercept");
        names.addBuiltin("Regr_r2");
        names.addBuiltin("Regr_Slope");
        names.addBuiltin("Regr_sxx");
        names.addBuiltin("Regr_sxy");
        names.addBuiltin("Regr_syy");
        names.addBuiltin("Repeat");
        names.addBuiltin("Replace");
        names.addBuiltin("Reverse");
        names.addBuiltin("Right");
        names.addBuiltin("Round");
        names.addBuiltin("Row_Number");
        names.addBuiltin("RPad");
        names.addBuiltin("RTrim");
        names.addBuiltin("Schema_To_Xml");
        names.addBuiltin("Schema_To_Xml_And_XmlSchema");
        names.addBuiltin("Schema_To_XmlSchema");
        names.addBuiltin("Set_Bit");
        names.addBuiltin("Set_Byte");
        names.addBuiltin("Set_Config");
        names.addBuiltin("Set_MaskLen");
        names.addBuiltin("SetSeed");
        names.addBuiltin("SetVal");
        names.addBuiltin("SetWeight");
        names.addBuiltin("ShObj_Description");
        names.addBuiltin("Sign");
        names.addBuiltin("Sin");
        names.addBuiltin("Split_Part");
        names.addBuiltin("SqRt");
        names.addBuiltin("Statement_Timestamp");
        names.addBuiltin("StdDev");
        names.addBuiltin("StdDev_Pop");
        names.addBuiltin("StdDev_Samp");
        names.addBuiltin("String_Agg");
        names.addBuiltin("String_To_Array");
        names.addBuiltin("Strip");
        names.addBuiltin("StrPos");
        names.addBuiltin("Substr");
        names.addBuiltin("Substring");
        names.addBuiltin("Sum");
        names.addBuiltin("Table_To_Xml");
        names.addBuiltin("Table_To_Xml_and_XmlSchema");
        names.addBuiltin("Table_To_XmlSchema");
        names.addBuiltin("Tan");
        names.addBuiltin("Text");
        names.addBuiltin("TimeOfDay");
        names.addBuiltin("To_Ascii");
        names.addBuiltin("To_Char");
        names.addBuiltin("To_Date");
        names.addBuiltin("To_Hex");
        names.addBuiltin("To_Number");
        names.addBuiltin("To_Timestamp");
        names.addBuiltin("To_TsQuery");
        names.addBuiltin("To_TsVector");
        names.addBuiltin("Transaction_Timestamp");
        names.addBuiltin("Translate");
        names.addBuiltin("Trim");
        names.addBuiltin("Trunc");
        names.addBuiltin("Ts_Debug");
        names.addBuiltin("Ts_HeadLine");
        names.addBuiltin("Ts_Lexize");
        names.addBuiltin("Ts_Parse");
        names.addBuiltin("Ts_Rank");
        names.addBuiltin("Ts_Rank_Cd");
        names.addBuiltin("Ts_Rewrite");
        names.addBuiltin("Ts_Stat");
        names.addBuiltin("Ts_Token_Type");
        names.addBuiltin("TsVector_Update_Trigger");
        names.addBuiltin("TsVector_Update_Trigger_Column");
        names.addBuiltin("txid_Current");
        names.addBuiltin("txid_Current_Snapshot");
        names.addBuiltin("txid_Snapshot_XIp");
        names.addBuiltin("txid_Snapshot_XMax");
        names.addBuiltin("txid_Snapshot_XMin");
        names.addBuiltin("txid_Visible_In_Snapshot");
        names.addBuiltin("UnNest");
        names.addBuiltin("Upper");
        names.addBuiltin("Variance");
        names.addBuiltin("Var_pop");
        names.addBuiltin("Var_samp");
        names.addBuiltin("Version");
        names.addBuiltin("Width");
        names.addBuiltin("Width_Bucket");
        names.addBuiltin("World");
        names.addBuiltin("XmlAgg");
        names.addBuiltin("XmlComment");
        names.addBuiltin("XmlConcat");
        names.addBuiltin("XmlElement");
        names.addBuiltin("XmlExists");
        names.addBuiltin("XmlForest");
        names.addBuiltin("Xml_Is_Well_Formed");
        names.addBuiltin("Xml_Is_Well_Formed_Content");
        names.addBuiltin("Xml_Is_Well_Formed_Document");
        names.addBuiltin("XmlPi");
        names.addBuiltin("XmlRoot");
        names.addBuiltin("XPath");
        names.addBuiltin("XPath_Exists");
    }

    public void getComparisonOperators(List sl) {
        for (String s : this.comparisonOperators) {
            sl.add(s);
        }
    }

    @Override
    public boolean isDenyIntoClause() {
        return this.denyIntoClause;
    }

    @Override
    public void setDenyIntoClause(boolean value) {
        this.denyIntoClause = value;
    }

    @Override
    public boolean isUniversalExpressions() {
        return true;
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public boolean isSupportNullOrdering() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return true;
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return PostgreSQLQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsPostgreSQL(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select " + fieldExpression + " from " + objectExpression + " a where 0<>0 limit 1";
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataObjectsPostgreSQL(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataRelationsPostgreSQL(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName;
        }
        this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNamePostgreSQL(sqlContext);
        if (this.defaultDatabaseName == null) {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        return this.defaultDatabaseName;
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (!LoadMetadataHelpers.getDefaultSchemaNamesPostgreSQL(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        if (sqlContext.isTableExists("pg_attribute") && sqlContext.isTableExists("pg_type") && sqlContext.isTableExists("pg_namespace") && sqlContext.isTableExists("pg_class") && sqlContext.isTableExists("pg_namespace") && sqlContext.isTableExists("pg_type") && sqlContext.isTableExists("pg_attrdef") && sqlContext.isTableExists("pg_description")) {
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery("SELECT cl.relname, na.nspname, att.attname, format_type(ty.oid,NULL) AS typname, isc.character_maximum_length as size, isc.numeric_precision as precision, isc.numeric_scale as scale, case when atttypmod>0 then atttypmod-4 else 0 end as size, att.attnotnull, pg_catalog.pg_get_expr(def.adbin, def.adrelid) AS defval, EXISTS(SELECT 1 FROM  pg_constraint WHERE conrelid=att.attrelid AND contype='f' AND att.attnum=ANY(conkey)) As isfk, EXISTS(SELECT 1 FROM  pg_constraint WHERE conrelid=att.attrelid AND contype='p' AND att.attnum=ANY(conkey)) As ispk, description FROM pg_attribute att JOIN pg_type ty ON ty.oid=atttypid JOIN pg_namespace tn ON tn.oid=ty.typnamespace JOIN pg_class cl ON cl.oid=attrelid JOIN pg_namespace na ON na.oid=cl.relnamespace LEFT OUTER JOIN information_schema.columns isc ON att.attname=isc.column_name AND cl.relname=isc.table_name AND na.nspname=isc.table_schema LEFT OUTER JOIN pg_type et ON et.oid=ty.typelem LEFT OUTER JOIN pg_attrdef def ON adrelid=attrelid AND adnum=attnum LEFT OUTER JOIN pg_description des ON des.objoid=attrelid AND des.objsubid=attnum WHERE cl.relname='" + objectName + "' AND na.nspname='" + objectSchema + "' AND attnum > 0 AND attisdropped IS FALSE ORDER BY attnum");
            mff.setNameFieldName("attname");
            mff.setServerTypeFieldName("typname");
            mff.setSizeFieldName("size");
            mff.setPrecisionFieldName("precision");
            mff.setScaleFieldName("scale");
            mff.setDefaultValueFieldName("defval");
            mff.setNullableFieldName("attnotnull");
            mff.setNonNullableValue(true);
            mff.setPrimaryFieldName("ispk");
            mff.setPrimaryValue(true);
            mff.setLongDescriptionFieldName("description");
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("character") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("character varying") != 0 && type.compareToIgnoreCase("bit") != 0 && type.compareToIgnoreCase("varbit") != 0 && type.compareToIgnoreCase("bit varying") != 0;
    }

    @Override
    public boolean isAsKeywordInExpressionAliasMandatory() {
        return true;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (!LoadMetadataHelpers.getSchemaListPostgreSQL(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }
}

