/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstTokenString;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLGroupByList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.MySQLANSIScanner;
import com.adbs.syntax.MySQLGroupByListExtender;
import com.adbs.syntax.MySQLParser;
import com.adbs.syntax.MySQLQueryPropertiesDialog;
import com.adbs.syntax.MySQLScanner;
import com.adbs.syntax.MySQLSubQuerySelectExpressionExtender;
import com.adbs.syntax.MySQLastTokenStringExtender;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MySQLSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private int serverVersionInt = 80012;
    private IdentCaseSensitivity identCaseSens = IdentCaseSensitivity.Insensitive;
    private boolean ansiQuotes = false;
    private SQLQualifiedName defaultDatabaseName = null;
    private boolean tryToSelectLinksViaDriver = false;
    private boolean denyIntoClause = false;

    public MySQLSyntaxProvider() {
        try {
            this.registerExtender(SQLSubQuerySelectExpression.class, MySQLSubQuerySelectExpressionExtender.class);
            this.registerExtender(SQLGroupByList.class, MySQLGroupByListExtender.class);
            this.registerExtender(AstTokenString.class, MySQLastTokenStringExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(MySQLSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return this.identCaseSens;
    }

    @Override
    public void setIdentCaseSens(IdentCaseSensitivity value) {
        if (this.identCaseSens != value) {
            this.identCaseSens = value;
            this.sendNotifications();
        }
    }

    public int getServerVersionInt() {
        return this.serverVersionInt;
    }

    public void setServerVersionInt(int serverVersionInt) {
        if (this.serverVersionInt != serverVersionInt) {
            this.serverVersionInt = serverVersionInt;
            this.sendNotifications();
        }
    }

    public String getServerVersion() {
        return this.intVersionToString(this.serverVersionInt);
    }

    public void setServerVersion(String serverVersion) {
        try {
            this.setServerVersionInt(LoadMetadataHelpers.parseServerVersionMySQL(serverVersion));
        }
        catch (Exception ex) {
            Logger.getLogger(MySQLSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Deprecated
    public boolean isAutoCalcServerVersion() {
        return this.isDetectServerVersion();
    }

    @Deprecated
    public void setAutoCalcServerVersion(boolean autoCalcServerVersion) {
        this.setDetectServerVersion(autoCalcServerVersion);
    }

    public boolean isAnsiQuotes() {
        return this.ansiQuotes;
    }

    public void setAnsiQuotes(boolean ansiQuotes) {
        this.ansiQuotes = ansiQuotes;
    }

    public boolean isTryToSelectLinksViaDriver() {
        return this.tryToSelectLinksViaDriver;
    }

    public void setTryToSelectLinksViaDriver(boolean tryToSelectLinksViaDriver) {
        this.tryToSelectLinksViaDriver = tryToSelectLinksViaDriver;
    }

    @Override
    public BaseSyntaxProvider clone() {
        MySQLSyntaxProvider result = (MySQLSyntaxProvider)super.clone();
        result.identCaseSens = this.identCaseSens;
        result.serverVersionInt = this.serverVersionInt;
        result.ansiQuotes = this.ansiQuotes;
        return result;
    }

    @Override
    protected Class getScannerClass() {
        if (!this.ansiQuotes) {
            return MySQLScanner.class;
        }
        return MySQLANSIScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return MySQLParser.class;
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
        parser.serverVersion = this.serverVersionInt;
    }

    @Override
    public String getDescription() {
        return "MySQL";
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Bit_And", false);
        names.addIdentifier("Bit_Or", false);
        names.addIdentifier("Bit_XOr", false);
        names.addIdentifier("Std", false);
        names.addIdentifier("StdDev", false);
        names.addIdentifier("StdDev_Pop", false);
        names.addIdentifier("StdDev_Samp", false);
        names.addIdentifier("Var_Pop", false);
        names.addIdentifier("Var_Samp", false);
        names.addIdentifier("Variance", false);
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Group_Concat", false);
    }

    public void getComparisonOperators(List sl) {
        sl.clear();
        sl.add("=");
        sl.add("<=>");
        sl.add("<");
        sl.add("<=");
        sl.add(">");
        sl.add(">=");
        sl.add("<>");
        sl.add("!=");
    }

    @Override
    public String getQuoteBegin() {
        return "`";
    }

    @Override
    public String getQuoteEnd() {
        return "`";
    }

    @Override
    public boolean isSupportViews() {
        return this.serverVersionInt >= 50010;
    }

    @Override
    public boolean isSupportUnions() {
        return this.serverVersionInt >= 40000;
    }

    @Override
    public boolean isSupportBracketsInUnions() {
        return false;
    }

    @Override
    public boolean isSupportDerivedTables() {
        return this.serverVersionInt > 40100;
    }

    @Override
    public boolean isSupportCTE() {
        return this.serverVersionInt >= 80000;
    }

    @Override
    public boolean isSupportSubQueryUnions() {
        return this.serverVersionInt >= 40000;
    }

    @Override
    public boolean isSupportSubQueryBracketsInUnions() {
        return false;
    }

    @Override
    public boolean isSupportSubQueryDerivedTables() {
        return this.serverVersionInt >= 40100;
    }

    @Override
    public boolean isSupportSubQueryCTE() {
        return this.serverVersionInt >= 80000;
    }

    @Override
    public boolean isSupportSchemas() {
        return false;
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return MySQLQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("If");
        names.addBuiltin("IfNull");
        names.addBuiltin("NullIf");
        names.addBuiltin("ASCII");
        names.addBuiltin("Bin");
        names.addBuiltin("Bit_Length");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Char");
        names.addBuiltin("Character_Length");
        names.addBuiltin("Concat_Ws");
        names.addBuiltin("Concat");
        names.addBuiltin("Conv");
        names.addBuiltin("ELT");
        names.addBuiltin("Export_Set");
        names.addBuiltin("Field");
        names.addBuiltin("Find_In_Set");
        names.addBuiltin("Format");
        names.addBuiltin("Hex");
        names.addBuiltin("Insert");
        names.addBuiltin("Instr");
        names.addBuiltin("LCase");
        names.addBuiltin("Left");
        names.addBuiltin("Length");
        names.addBuiltin("Load_File");
        names.addBuiltin("Locate");
        names.addBuiltin("Lower");
        names.addBuiltin("LPad");
        names.addBuiltin("LTrim");
        names.addBuiltin("Make_Set");
        names.addBuiltin("Mid");
        names.addBuiltin("Oct");
        names.addBuiltin("Octet_Length");
        names.addBuiltin("Ord");
        names.addBuiltin("Position");
        names.addBuiltin("Quote");
        names.addBuiltin("Repeat");
        names.addBuiltin("Replace");
        names.addBuiltin("Reverse");
        names.addBuiltin("Right");
        names.addBuiltin("RPad");
        names.addBuiltin("RTrim");
        names.addBuiltin("SoundEx");
        names.addBuiltin("Space");
        names.addBuiltin("StrCmp");
        names.addBuiltin("SubString_Index");
        names.addBuiltin("SubString");
        names.addBuiltin("SibStr");
        names.addBuiltin("Trim");
        names.addBuiltin("UCase");
        names.addBuiltin("UnHex");
        names.addBuiltin("Upper");
        names.addBuiltin("addDate");
        names.addBuiltin("addTime");
        names.addBuiltin("Convert_TZ");
        names.addBuiltin("CurDate");
        names.addBuiltin("Current_Date");
        names.addBuiltin("Current_Time");
        names.addBuiltin("Current_TimeStamp");
        names.addBuiltin("CurTime");
        names.addBuiltin("Date_add");
        names.addBuiltin("Date_Format");
        names.addBuiltin("Date_Sub");
        names.addBuiltin("Date");
        names.addBuiltin("DateDiff");
        names.addBuiltin("Day");
        names.addBuiltin("DayName");
        names.addBuiltin("DayOfMonth");
        names.addBuiltin("DayOfWeek");
        names.addBuiltin("DayOfYear");
        names.addBuiltin("Extract");
        names.addBuiltin("From_Days");
        names.addBuiltin("From_UnixTime");
        names.addBuiltin("Get_Format");
        names.addBuiltin("Hour");
        names.addBuiltin("Last_Day");
        names.addBuiltin("LocalTime");
        names.addBuiltin("LocalTimestamp");
        names.addBuiltin("MakeDate");
        names.addBuiltin("MakeTime");
        names.addBuiltin("Microsecond");
        names.addBuiltin("Minute");
        names.addBuiltin("Month");
        names.addBuiltin("MonthName");
        names.addBuiltin("Now");
        names.addBuiltin("Period_add");
        names.addBuiltin("Period_Diff");
        names.addBuiltin("Quarter");
        names.addBuiltin("Sec_To_Time");
        names.addBuiltin("Second");
        names.addBuiltin("Str_To_Date");
        names.addBuiltin("SubDate");
        names.addBuiltin("SubTime");
        names.addBuiltin("SysDate");
        names.addBuiltin("Time_Format");
        names.addBuiltin("Time_To_Sec");
        names.addBuiltin("Time");
        names.addBuiltin("TimeDiff");
        names.addBuiltin("Timestamp");
        names.addBuiltin("Timestampadd");
        names.addBuiltin("TimestampDiff");
        names.addBuiltin("To_Days");
        names.addBuiltin("Unix_Timestamp");
        names.addBuiltin("UTC_Date");
        names.addBuiltin("UTC_Time");
        names.addBuiltin("UTC_Timestamp");
        names.addBuiltin("Week");
        names.addBuiltin("WeekDay");
        names.addBuiltin("WeekOfYear");
        names.addBuiltin("Year");
        names.addBuiltin("YearWeek");
        names.addBuiltin("Cast");
        names.addBuiltin("ExtractValue");
        names.addBuiltin("UpdateXML");
        names.addBuiltin("AES_Decrypt");
        names.addBuiltin("AES_Encrypt");
        names.addBuiltin("Benchmark");
        names.addBuiltin("Bit_Count");
        names.addBuiltin("Charset");
        names.addBuiltin("Coercibility");
        names.addBuiltin("Collation");
        names.addBuiltin("Compress");
        names.addBuiltin("Connection_Id");
        names.addBuiltin("Current_User");
        names.addBuiltin("Database");
        names.addBuiltin("Decode");
        names.addBuiltin("Default");
        names.addBuiltin("DES_Decrypt");
        names.addBuiltin("DES_Encrypt");
        names.addBuiltin("Encode");
        names.addBuiltin("Encrypt");
        names.addBuiltin("Found_Rows");
        names.addBuiltin("Get_Lock");
        names.addBuiltin("INet_AToN");
        names.addBuiltin("INet_NToA");
        names.addBuiltin("Is_Free_Lock");
        names.addBuiltin("Is_Used_Lock");
        names.addBuiltin("Last_Insert_Id");
        names.addBuiltin("Master_Pos_Wait");
        names.addBuiltin("MD5");
        names.addBuiltin("Name_Const");
        names.addBuiltin("Old_Password");
        names.addBuiltin("Password");
        names.addBuiltin("Release_Lock");
        names.addBuiltin("Row_Count");
        names.addBuiltin("Schema");
        names.addBuiltin("Session_User");
        names.addBuiltin("SHA1");
        names.addBuiltin("SHA");
        names.addBuiltin("Sleep");
        names.addBuiltin("System_User");
        names.addBuiltin("Uncompress");
        names.addBuiltin("Uncompressed_Length");
        names.addBuiltin("User");
        names.addBuiltin("UUID");
        names.addBuiltin("Values");
        names.addBuiltin("Version");
        names.addBuiltin("Coalesce");
        names.addBuiltin("Greatest");
        names.addBuiltin("Interval");
        names.addBuiltin("Least");
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select " + fieldExpression + " from " + objectExpression + " a where 0<>0 limit 0";
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        try {
            if (!LoadMetadataHelpers.getDatabaseListMySQL(sqlContext, databaseList)) {
                super.getDatabaseList(sqlContext, databaseList);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MySQLSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsMySQL(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsMySQL(sqlContext, metadataContainer, metadataFilter, database) && this.tryToSelectLinksViaDriver) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName.clone(sqlContext);
        }
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNameMySQL(sqlContext);
        if (this.defaultDatabaseName == null) {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName.clone(sqlContext);
        }
        return null;
    }

    private String IntToStr(int i) {
        String result = String.valueOf(i);
        if (i != 0 && result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String intVersionToString(int version) {
        String result = Integer.toString(version / 10000);
        result = version % 10000 / 100 > 9 && version % 10000 / 100 % 10 == 0 ? result + "." + Integer.toString(version % 10000 / 1000) : result + "." + this.IntToStr(version % 10000 / 100);
        if (version % 100 != 0) {
            result = version % 100 > 9 && version % 100 % 10 == 0 ? result + "." + Integer.toString(version % 100 / 10) : result + "." + this.IntToStr(version % 100);
        }
        return result;
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsMySQL(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (this.getServerVersionInt() >= 50000) {
            String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            assert (!Str.IsNullOrEmpty(objectName));
            String db = metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery("select * from INFORMATION_SCHEMA.COLUMNS isc where isc.TABLE_NAME='" + objectName + "' and isc.TABLE_SCHEMA='" + db + "'");
            mff.setNameFieldName("COLUMN_NAME");
            mff.setServerTypeFieldName("DATA_TYPE");
            mff.setSizeFieldName("CHARACTER_MAXIMUM_LENGTH");
            mff.setPrecisionFieldName("NUMERIC_PRECISION");
            mff.setScaleFieldName("NUMERIC_SCALE");
            mff.setDefaultValueFieldName("COLUMN_DEFAULT");
            mff.setNullableFieldName("IS_NULLABLE");
            mff.setNonNullableValue("NO");
            mff.setPrimaryFieldName("COLUMN_KEY");
            mff.setPrimaryValue("PRI");
            mff.setShortDescriptionFieldName("COLUMN_COMMENT");
            mff.loadFields(metadataObject.getFields());
        } else {
            String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
            assert (!Str.IsNullOrEmpty(objectName));
            String db = metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
            if (!Str.IsNullOrEmpty(db)) {
                db = db + ".";
            }
            MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
            mff.setQuery("show columns from " + db + objectName);
            mff.setNameFieldName("Field");
            mff.setServerTypeFieldName("Type");
            mff.setDefaultValueFieldName("Default");
            mff.setNullableFieldName("Null");
            mff.setNonNullableValue("NO");
            mff.setPrimaryFieldName("Key");
            mff.setPrimaryValue("PRI");
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("binary") != 0 && type.compareToIgnoreCase("varbinary") != 0;
    }

    @Override
    public boolean isDenyIntoClause() {
        return this.denyIntoClause;
    }

    @Override
    public void setDenyIntoClause(boolean value) {
        this.denyIntoClause = value;
    }

    @Override
    public boolean isInnerKeywordInLinksMandatory() {
        return false;
    }

    @Override
    public boolean isDetectServerVersion() {
        return super.isDetectServerVersion();
    }

    @Override
    public void setDetectServerVersion(boolean detectServerVersion) {
        super.setDetectServerVersion(detectServerVersion);
    }

    @Override
    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        super.doDetectServerVersion(metadataProvider);
        this.setServerVersionInt(LoadMetadataHelpers.calcServerVersionMySQL(metadataProvider));
    }
}

