/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataFilterApplyFor;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.MetadataDatabasesFetcherFromQuery;
import com.adbs.metadata.MetadataObjectFetcherFromQuery;
import com.adbs.metadata.MetadataRelationsFetcherFromQuery;
import com.adbs.metadata.MetadataSchemasFetcherFromQuery;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.InformixMetadataObjectFetcherFromQuery;
import com.adbs.syntax.MySQLMetadataObjectFetcherFromQuery;
import com.adbs.syntax.PostgreSQLMetadataObjectFetcherFromQuery;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.sql.ResultSet;
import java.util.EnumSet;

public class LoadMetadataHelpers {
    public static final int ServerVersionMSSQL7 = 7;
    public static final int ServerVersionMSSQL2000 = 8;
    public static final int ServerVersionMSSQL2005 = 9;
    public static final int ServerVersionMSSQL2008 = 10;
    public static final int ServerVersionMSSQL2012 = 11;
    public static final int ServerVersionMSSQL2014 = 12;
    public static final int ServerVersionMSSQLMin = 7;
    public static final int ServerVersionMSSQLMax = 12;
    public static final int ServerVersionMSSQLDefault = 12;
    public static final int ServerVersionOracle7 = 7;
    public static final int ServerVersionOracle8 = 8;
    public static final int ServerVersionOracle9 = 9;
    public static final int ServerVersionOracle10 = 10;
    public static final int ServerVersionOracle11 = 11;
    public static final int ServerVersionOracle12 = 12;
    public static final int ServerVersionOracle18 = 18;
    public static final int ServerVersionOracleMin = 7;
    public static final int ServerVersionOracleMax = 18;
    public static final int ServerVersionOracleDefault = 18;
    public static final int ServerVersionInformixDS8 = 8;
    public static final int ServerVersionInformixDS9 = 9;
    public static final int ServerVersionInformixDS10 = 10;
    public static final int ServerVersionInformixDS11 = 11;
    public static final int ServerVersionInformixMin = 8;
    public static final int ServerVersionInformixMax = 11;
    public static final int ServerVersionInformixDefault = 11;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsSQL92(BaseMetadataProvider metadataProvider) {
        SyntaxSupportsConectedServer result = SyntaxSupportsConectedServer.Unknown;
        ResultSet resultSet = null;
        if (metadataProvider == null) return SyntaxSupportsConectedServer.Unknown;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        resultSet = metadataProvider.execSQL("select 1 from information_schema.tables", false);
        result = resultSet != null && resultSet.getMetaData().getColumnCount() > 0 ? SyntaxSupportsConectedServer.Yes : SyntaxSupportsConectedServer.Maybe;
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
        catch (Exception ex) {
            try {
                result = SyntaxSupportsConectedServer.No;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet == null) throw throwable;
                    resultSet.getStatement().close();
                    resultSet.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    throw throwable;
                }
                finally {
                    resultSet = null;
                }
            }
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
    }

    public static boolean loadMetadataObjectsSQL92(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("information_schema.tables")) {
            String wheredb;
            String db;
            SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNameSQL92(sqlContext);
            if (!(Helpers.isQualifiedNameEmpty(database) || Helpers.isQualifiedNameEmpty(currDB) || sqlContext.isQualifiedNamesEqual(database, currDB))) {
                db = database.getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer()) + ".";
                wheredb = " where TABLE_CATALOG='" + database.getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes()) + "'";
            } else {
                db = "";
                wheredb = "";
            }
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("select table_schema as TABLE_SCHEMA, table_name as TABLE_NAME, table_type as TABLE_TYPE from " + db + "information_schema.tables" + wheredb);
            mof.setMetadataFilter(metadataFilter);
            mof.setSchemaFieldName("TABLE_SCHEMA");
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTableType(new String[]{"TABLE", "BASE TABLE"});
            mof.setSystemTableType(new String[]{"SYSTEM TABLE"});
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
            if (sqlContext.isTableExists("information_schema.views")) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("select table_schema as TABLE_SCHEMA, table_name as TABLE_NAME from " + db + "information_schema.views" + wheredb);
                mof.setMetadataFilter(metadataFilter);
                mof.setSchemaFieldName("TABLE_SCHEMA");
                mof.setNameFieldName("TABLE_NAME");
                mof.setDefaultObjectClass(MetadataView.class);
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            }
        }
        return result;
    }

    public static boolean loadMetadataRelationsSQL92(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("information_schema.referential_constraints") && sqlContext.isTableExists("information_schema.key_column_usage")) {
            SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNameSQL92(sqlContext);
            String db = !Helpers.isQualifiedNameEmpty(database) && !Helpers.isQualifiedNameEmpty(currDB) && !sqlContext.isQualifiedNamesEqual(database, currDB) ? database.getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer()) + "." : "";
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            String selectRelationFieldsSQL = "select  pf.TABLE_CATALOG as PK_TABLE_DATABASE,  pf.TABLE_SCHEMA as PK_SCHEMA_NAME,  pf.TABLE_NAME as PK_TABLE_NAME,  pf.COLUMN_NAME as PK_FIELD_NAME,  ff.TABLE_CATALOG as FK_TABLE_DATABASE,  ff.TABLE_SCHEMA as FK_SCHEMA_NAME,  ff.TABLE_NAME as FK_TABLE_NAME,  ff.COLUMN_NAME as FK_FIELD_NAME,  pf.ORDINAL_POSITION as ORDINAL from %1$sINFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE ff,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE pf where (rc.CONSTRAINT_NAME = ff.CONSTRAINT_NAME) and  (rc.CONSTRAINT_SCHEMA = ff.CONSTRAINT_SCHEMA) and  (rc.CONSTRAINT_CATALOG = ff.CONSTRAINT_CATALOG) and  (rc.UNIQUE_CONSTRAINT_NAME = pf.CONSTRAINT_NAME) and  (rc.UNIQUE_CONSTRAINT_SCHEMA = pf.CONSTRAINT_SCHEMA) and  (rc.UNIQUE_CONSTRAINT_CATALOG = pf.CONSTRAINT_CATALOG) and  (ff.ORDINAL_POSITION = pf.ORDINAL_POSITION) order by pf.TABLE_SCHEMA, pf.TABLE_NAME, ff.TABLE_SCHEMA, ff.TABLE_NAME, pf.ORDINAL_POSITION";
            mrf.setQuery(String.format("select  pf.TABLE_CATALOG as PK_TABLE_DATABASE,  pf.TABLE_SCHEMA as PK_SCHEMA_NAME,  pf.TABLE_NAME as PK_TABLE_NAME,  pf.COLUMN_NAME as PK_FIELD_NAME,  ff.TABLE_CATALOG as FK_TABLE_DATABASE,  ff.TABLE_SCHEMA as FK_SCHEMA_NAME,  ff.TABLE_NAME as FK_TABLE_NAME,  ff.COLUMN_NAME as FK_FIELD_NAME,  pf.ORDINAL_POSITION as ORDINAL from %1$sINFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE ff,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE pf where (rc.CONSTRAINT_NAME = ff.CONSTRAINT_NAME) and  (rc.CONSTRAINT_SCHEMA = ff.CONSTRAINT_SCHEMA) and  (rc.CONSTRAINT_CATALOG = ff.CONSTRAINT_CATALOG) and  (rc.UNIQUE_CONSTRAINT_NAME = pf.CONSTRAINT_NAME) and  (rc.UNIQUE_CONSTRAINT_SCHEMA = pf.CONSTRAINT_SCHEMA) and  (rc.UNIQUE_CONSTRAINT_CATALOG = pf.CONSTRAINT_CATALOG) and  (ff.ORDINAL_POSITION = pf.ORDINAL_POSITION) order by pf.TABLE_SCHEMA, pf.TABLE_NAME, ff.TABLE_SCHEMA, ff.TABLE_NAME, pf.ORDINAL_POSITION", db));
            mrf.setPkDatabaseFieldName("PK_TABLE_DATABASE");
            mrf.setPkSchemaFieldName("PK_SCHEMA_NAME");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkDatabaseFieldName("FK_TABLE_DATABASE");
            mrf.setFkSchemaFieldName("FK_SCHEMA_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setOrdinalFieldName("ORDINAL");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNameSQL92(BaseSQLContext sqlContext) {
        ResultSet resultSet = null;
        SQLQualifiedName result = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        if (!sqlContext.isTableExists("information_schema.tables")) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select count(*) from information_schema.tables", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), false);
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception2) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsMSSQL(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("exec sp_server_info 1", false);
            if (resultSet != null && resultSet.next() && resultSet.findColumn("attribute_value") > 0) {
                if (resultSet.getString("attribute_value").equals("Microsoft SQL Server")) {
                    SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
                    try {
                        if (resultSet == null) return syntaxSupportsConectedServer;
                        resultSet.getStatement().close();
                        resultSet.close();
                        return syntaxSupportsConectedServer;
                    }
                    catch (Exception exception) {
                        return syntaxSupportsConectedServer;
                    }
                    finally {
                        resultSet = null;
                    }
                }
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Maybe;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int calcServerVersionMSSQL(BaseMetadataProvider metadataProvider) {
        resultSet = null;
        if (metadataProvider != null && metadataProvider.canExecSQL()) {
            try {
                resultSet = metadataProvider.execSQL("SELECT (@@microsoftversion / 0x1000000) & 0xff AS [VersionMajor]", false);
                try {
                    resultSet.next();
                    version = resultSet.getInt(1);
                    switch (version) {
                        case 7: {
                            result = 7;
                            ** break;
                        }
                        case 8: {
                            result = 8;
                            ** break;
                        }
                        case 9: {
                            result = 9;
                            ** break;
                        }
                        case 10: {
                            result = 10;
                            ** break;
                        }
                        case 11: {
                            result = 11;
                            ** break;
                        }
                        case 12: {
                            result = 12;
                            ** break;
                        }
                        default: {
                            result = version > 10 ? 12 : 7;
                        }
                    }
                }
                catch (Throwable var5_7) {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                    }
                    catch (Exception var6_8) {
                    }
                    finally {
                        resultSet = null;
                    }
                    throw var5_7;
                }
lbl43:
                // 7 sources

                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception version) {
                }
                finally {
                    resultSet = null;
                }
            }
            catch (Exception ex) {
                result = 12;
            }
        } else {
            result = 12;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNameMSSQL(BaseSQLContext sqlContext) {
        SQLQualifiedName result = null;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select DB_NAME(DB_ID())", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), false);
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception2) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesMSSQL(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select user_name()", false);
                if (resultSet.next()) {
                    defaultSchemaNames.addIdentifier(resultSet.getString(1));
                }
                if (!defaultSchemaNames.containsSameIdStr("dbo")) {
                    defaultSchemaNames.addIdentifier("dbo");
                }
                result = true;
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return result;
    }

    private static boolean loadDatabaseListFromQuery(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList, String query, String nameField) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataDatabasesFetcherFromQuery mdf = new MetadataDatabasesFetcherFromQuery(sqlContext);
            mdf.setQuery(query);
            mdf.setNameFieldName(nameField);
            if (!mdf.validateQuery()) {
                return false;
            }
            mdf.loadDatabases(databaseList);
            result = true;
        }
        return result;
    }

    public static boolean getDatabaseListMSSQL(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        int version = LoadMetadataHelpers.calcServerVersionMSSQL(sqlContext.getMetadataProvider());
        String query9 = "SELECT dtb.name AS DATABASE_NAME FROM master.sys.databases AS dtb ORDER BY DATABASE_NAME ASC";
        String query7 = "SELECT dtb.name AS DATABASE_NAME FROM master.dbo.sysdatabases AS dtb ORDER BY DATABASE_NAME ASC";
        String sp_databases = "EXEC sp_databases";
        if (version >= 9) {
            return LoadMetadataHelpers.loadDatabaseListFromQuery(sqlContext, databaseList, query9, "DATABASE_NAME") || LoadMetadataHelpers.loadDatabaseListFromQuery(sqlContext, databaseList, query7, "DATABASE_NAME") || LoadMetadataHelpers.loadDatabaseListFromQuery(sqlContext, databaseList, sp_databases, "DATABASE_NAME");
        }
        if (version >= 7) {
            return LoadMetadataHelpers.loadDatabaseListFromQuery(sqlContext, databaseList, query7, "DATABASE_NAME") || LoadMetadataHelpers.loadDatabaseListFromQuery(sqlContext, databaseList, sp_databases, "DATABASE_NAME");
        }
        return LoadMetadataHelpers.loadDatabaseListFromQuery(sqlContext, databaseList, sp_databases, "DATABASE_NAME");
    }

    public static boolean loadMetadataObjectsMSSQL(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        String server = "";
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataObjectFetcherFromQuery mof;
            String dbDot;
            String db;
            SQLQualifiedName currDB = sqlContext.getSyntaxProvider().getDefaultDatabaseName(sqlContext);
            if (!(Helpers.isQualifiedNameEmpty(database) || Helpers.isQualifiedNameEmpty(currDB) || sqlContext.isQualifiedNamesEqual(database, currDB))) {
                if (database.getCount() == 2) {
                    server = database.get(1).getToken();
                    db = database.get(0).getToken();
                    dbDot = database.get(0).getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer()) + ".";
                } else {
                    db = database.get(0).getToken();
                    dbDot = database.getQualifiedNameForServer() + ".";
                }
            } else {
                db = "";
                dbDot = "";
            }
            int serverVersion = LoadMetadataHelpers.calcServerVersionMSSQL(sqlContext.getMetadataProvider());
            if (!Str.IsNullOrEmpty(server)) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("exec dbo.sp_tables_ex @table_server='" + server + "', @table_catalog='" + db + "'");
                mof.setMetadataFilter(metadataFilter);
                mof.setSchemaFieldName("TABLE_SCHEM");
                mof.setNameFieldName("TABLE_NAME");
                mof.setTypeFieldName("TABLE_TYPE");
                mof.setTableType("TABLE");
                mof.setSystemTableType("SYSTEM TABLE");
                mof.setViewType("VIEW");
                mof.setSystemViewType("SYSTEM VIEW");
                mof.getSystemSchemaNames().addIdentifier("[sys]");
                mof.getSystemSchemaNames().addIdentifier("[INFORMATION_SCHEMA]");
                if (!mof.validateQuery()) {
                    return false;
                }
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            } else if (serverVersion >= 9) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("SELECT sch.name AS TABLE_OWNER, ao.name AS TABLE_NAME, RTRIM(ao.type) AS TABLE_TYPE, cast(xp.value as nvarchar(max)) as DESCRIPTION, ao.is_ms_shipped AS SYSTEM, s.base_object_name AS REFERENCED_OBJECT_NAME FROM " + dbDot + "sys.all_objects AS ao LEFT OUTER JOIN " + dbDot + "sys.schemas as sch on ao.schema_id=sch.schema_id LEFT OUTER JOIN " + dbDot + "sys.extended_properties AS xp ON (ao.object_id=xp.major_id)and(xp.name='MS_Description')and(xp.minor_id=0) LEFT OUTER JOIN " + dbDot + "sys.synonyms s on s.object_id=ao.object_id WHERE ao.type in ('IF','S','SN','TF','U','V') AND HAS_PERMS_BY_NAME('" + dbDot + "'+QUOTENAME(sch.name)+N'.'+QUOTENAME(ao.name), 'object','select')=1");
                mof.setMetadataFilter(metadataFilter);
                mof.setSchemaFieldName("TABLE_OWNER");
                mof.setNameFieldName("TABLE_NAME");
                mof.setTypeFieldName("TABLE_TYPE");
                mof.setTableType(new String[]{"S", "U"});
                mof.setSystemTableType(new String[]{"SYSTEM TABLE"});
                mof.setViewType(new String[]{"V"});
                mof.setSynonymType("SN");
                mof.setProcedureType(new String[]{"IF", "TF"});
                mof.setLongDescriptionFieldName("DESCRIPTION");
                mof.setSystemFieldName("SYSTEM");
                mof.setSystemFieldValue(true);
                mof.setReferencedObjectNameFieldName("REFERENCED_OBJECT_NAME");
                if (!mof.validateQuery()) {
                    return false;
                }
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            } else {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("exec " + dbDot + "dbo.sp_tables");
                mof.setMetadataFilter(metadataFilter);
                mof.setSchemaFieldName("TABLE_OWNER");
                mof.setNameFieldName("TABLE_NAME");
                mof.setTypeFieldName("TABLE_TYPE");
                mof.setTableType(new String[]{"TABLE"});
                mof.setSystemTableType(new String[]{"SYSTEM TABLE"});
                mof.setViewType(new String[]{"VIEW"});
                mof.setSystemViewType("SYSTEM VIEW");
                mof.getSystemSchemaNames().addIdentifier("[sys]");
                mof.getSystemSchemaNames().addIdentifier("[INFORMATION_SCHEMA]");
                if (!mof.validateQuery()) {
                    return false;
                }
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            }
            result = true;
            String sql = serverVersion == 8 ? (sqlContext.isTableExists(dbDot + "dbo.sysobjects") && sqlContext.isTableExists(db + "dbo.sysusers") ? "SELECT sudf.name AS PROCEDURE_SCHEMA, udf.name AS PROCEDURE_NAME, CASE WHEN (OBJECTPROPERTY(udf.id, N'IsMSShipped')=1) or (1=OBJECTPROPERTY(udf.id, N'IsSystemTable')) THEN N'SYSTEM PROCEDURE' ELSE N'PROCEDURE' END as PROCEDURE_TYPE FROM " + dbDot + "dbo.sysobjects AS udf INNER JOIN " + dbDot + "dbo.sysusers AS sudf ON sudf.uid = udf.uid WHERE (udf.xtype in ( 'TF', 'FN', 'IF') and udf.name not like N'#%%')and (((case when 1 = OBJECTPROPERTY(udf.id, N'IsScalarFunction') then 1 when 1 = OBJECTPROPERTY(udf.id, N'IsInlineFunction') then 3 when 1 = OBJECTPROPERTY(udf.id, N'IsTableFunction') then 2 else 0 end) in (3,2))and CAST(CASE WHEN (OBJECTPROPERTY(udf.id, N'IsMSShipped')=1) THEN 1 WHEN 1 = OBJECTPROPERTY(udf.id, N'IsSystemTable') THEN 1 ELSE 0 END AS bit)=0) ORDER BY PROCEDURE_SCHEMA, PROCEDURE_NAME" : "") : (serverVersion >= 9 ? (sqlContext.isTableExists(dbDot + "sys.all_objects") ? "SELECT SCHEMA_NAME(udf.schema_id) AS PROCEDURE_SCHEMA, udf.name AS PROCEDURE_NAME, CASE udf.is_ms_shipped WHEN 0 THEN N'PROCEDURE' WHEN 1 THEN N'SYSTEM PROCEDURE' END AS PROCEDURE_TYPE FROM " + dbDot + "sys.all_objects AS udf WHERE (udf.type in ('TF', 'FN', 'IF', 'FS', 'FT'))and (('IF' = udf.type) or ('TF' = udf.type) or ('FT' = udf.type)) ORDER BY PROCEDURE_SCHEMA, PROCEDURE_NAME" : "") : "");
            if (!sql.equals("")) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery(sql);
                mof.setMetadataFilter(metadataFilter);
                mof.setSchemaFieldName("PROCEDURE_SCHEMA");
                mof.setNameFieldName("PROCEDURE_NAME");
                mof.setTypeFieldName("PROCEDURE_TYPE");
                mof.setProcedureType("PROCEDURE");
                mof.setSystemProcedureType("SYSTEM PROCEDURE");
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            }
            sql = serverVersion >= 9 ? (sqlContext.isTableExists(dbDot + "sys.all_objects") ? "SELECT SCHEMA_NAME(syn.schema_id) AS SYNONYM_SCHEMA, syn.name AS SYNONYM_NAME, CASE syn.is_ms_shipped WHEN 0 THEN N'SYNONYM' WHEN 1 THEN N'SYSTEM SYNONYM' END AS SYNONYM_TYPE,  syn.base_object_name as REFERENCED_OBJECT_NAME FROM " + dbDot + "sys.synonyms AS syn ORDER BY SYNONYM_SCHEMA,SYNONYM_NAME" : "") : "";
            if (!sql.equals("")) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery(sql);
                mof.setMetadataFilter(metadataFilter);
                mof.setSchemaFieldName("SYNONYM_SCHEMA");
                mof.setNameFieldName("SYNONYM_NAME");
                mof.setTypeFieldName("SYNONYM_TYPE");
                mof.setSynonymType("SYNONYM");
                mof.setReferencedObjectNameFieldName("REFERENCED_OBJECT_NAME");
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            }
        }
        return result;
    }

    public static boolean getSchemaListMSSQL(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        String db = "";
        boolean result = false;
        String sql2000 = "select NAME from %1$sSYSUSERS where ISSQLROLE=0 and ISAPPROLE=0 order by NAME";
        String sql2005 = "select NAME from %1$sSYS.SCHEMAS order by NAME";
        int version = LoadMetadataHelpers.calcServerVersionMSSQL(sqlContext.getMetadataProvider());
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            if (!Helpers.isQualifiedNameEmpty(fromDatabase)) {
                db = fromDatabase.getQualifiedNameForServer() + ".";
            }
            String query = version >= 9 ? "select NAME from %1$sSYS.SCHEMAS order by NAME" : "select NAME from %1$sSYSUSERS where ISSQLROLE=0 and ISAPPROLE=0 order by NAME";
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery(String.format(query, db));
            msf.setNameFieldName("NAME");
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataRelationsMSSQL(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        String selectRelationsFieldsSQL2005 = "select DB_NAME(DB_ID('%2$s')) as PK_TABLE_DATABASE, ps.name as PK_SCHEMA_NAME, po.name as PK_TABLE_NAME, pc.name as PK_FIELD_NAME, DB_NAME(DB_ID('%2$s')) as FK_TABLE_DATABASE, fs.name as FK_SCHEMA_NAME, fo.name as FK_TABLE_NAME, fc.name as FK_FIELD_NAME, fk.constraint_column_id as ORDINAL from %1$ssys.foreign_key_columns fk inner join %1$ssys.all_objects fo on fo.object_id=fk.parent_object_id inner join %1$ssys.schemas fs on fs.schema_id=fo.schema_id inner join %1$ssys.all_columns fc on fk.parent_column_id=fc.column_id and fo.object_id=fc.object_id inner join %1$ssys.all_objects po on po.object_id=fk.referenced_object_id inner join %1$ssys.schemas ps on ps.schema_id=po.schema_id inner join %1$ssys.all_columns pc on fk.referenced_column_id=pc.column_id and po.object_id=pc.object_id order by fk.referenced_object_id,fk.referenced_column_id,fk.parent_object_id,fk.parent_column_id,fk.constraint_column_id";
        String selectRelationsFieldsSQL = "select pf.TABLE_CATALOG as PK_TABLE_DATABASE,  pf.TABLE_SCHEMA as PK_SCHEMA_NAME,  pf.TABLE_NAME as PK_TABLE_NAME,  pf.COLUMN_NAME as PK_FIELD_NAME,  ff.TABLE_CATALOG as FK_TABLE_DATABASE,  ff.TABLE_SCHEMA as FK_SCHEMA_NAME,  ff.TABLE_NAME as FK_TABLE_NAME,  ff.COLUMN_NAME as FK_FIELD_NAME,  pf.ORDINAL_POSITION as ORDINAL from %1$sINFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE ff,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE pf where (rc.CONSTRAINT_NAME=ff.CONSTRAINT_NAME) and  (rc.CONSTRAINT_SCHEMA=ff.CONSTRAINT_SCHEMA) and  (rc.CONSTRAINT_CATALOG=ff.CONSTRAINT_CATALOG) and  (rc.UNIQUE_CONSTRAINT_NAME=pf.CONSTRAINT_NAME) and  (rc.UNIQUE_CONSTRAINT_SCHEMA=pf.CONSTRAINT_SCHEMA) and  (rc.UNIQUE_CONSTRAINT_CATALOG=pf.CONSTRAINT_CATALOG) and  (ff.ORDINAL_POSITION=pf.ORDINAL_POSITION) order by pf.TABLE_SCHEMA, pf.TABLE_NAME, ff.TABLE_SCHEMA, ff.TABLE_NAME, pf.ORDINAL_POSITION";
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            String dbStr;
            String db;
            int serverVersion = LoadMetadataHelpers.calcServerVersionMSSQL(sqlContext.getMetadataProvider());
            String sqlTemplate = serverVersion >= 9 ? "select DB_NAME(DB_ID('%2$s')) as PK_TABLE_DATABASE, ps.name as PK_SCHEMA_NAME, po.name as PK_TABLE_NAME, pc.name as PK_FIELD_NAME, DB_NAME(DB_ID('%2$s')) as FK_TABLE_DATABASE, fs.name as FK_SCHEMA_NAME, fo.name as FK_TABLE_NAME, fc.name as FK_FIELD_NAME, fk.constraint_column_id as ORDINAL from %1$ssys.foreign_key_columns fk inner join %1$ssys.all_objects fo on fo.object_id=fk.parent_object_id inner join %1$ssys.schemas fs on fs.schema_id=fo.schema_id inner join %1$ssys.all_columns fc on fk.parent_column_id=fc.column_id and fo.object_id=fc.object_id inner join %1$ssys.all_objects po on po.object_id=fk.referenced_object_id inner join %1$ssys.schemas ps on ps.schema_id=po.schema_id inner join %1$ssys.all_columns pc on fk.referenced_column_id=pc.column_id and po.object_id=pc.object_id order by fk.referenced_object_id,fk.referenced_column_id,fk.parent_object_id,fk.parent_column_id,fk.constraint_column_id" : "select pf.TABLE_CATALOG as PK_TABLE_DATABASE,  pf.TABLE_SCHEMA as PK_SCHEMA_NAME,  pf.TABLE_NAME as PK_TABLE_NAME,  pf.COLUMN_NAME as PK_FIELD_NAME,  ff.TABLE_CATALOG as FK_TABLE_DATABASE,  ff.TABLE_SCHEMA as FK_SCHEMA_NAME,  ff.TABLE_NAME as FK_TABLE_NAME,  ff.COLUMN_NAME as FK_FIELD_NAME,  pf.ORDINAL_POSITION as ORDINAL from %1$sINFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE ff,  %1$sINFORMATION_SCHEMA.KEY_COLUMN_USAGE pf where (rc.CONSTRAINT_NAME=ff.CONSTRAINT_NAME) and  (rc.CONSTRAINT_SCHEMA=ff.CONSTRAINT_SCHEMA) and  (rc.CONSTRAINT_CATALOG=ff.CONSTRAINT_CATALOG) and  (rc.UNIQUE_CONSTRAINT_NAME=pf.CONSTRAINT_NAME) and  (rc.UNIQUE_CONSTRAINT_SCHEMA=pf.CONSTRAINT_SCHEMA) and  (rc.UNIQUE_CONSTRAINT_CATALOG=pf.CONSTRAINT_CATALOG) and  (ff.ORDINAL_POSITION=pf.ORDINAL_POSITION) order by pf.TABLE_SCHEMA, pf.TABLE_NAME, ff.TABLE_SCHEMA, ff.TABLE_NAME, pf.ORDINAL_POSITION";
            SQLQualifiedName currDB = sqlContext.getSyntaxProvider().getDefaultDatabaseName(sqlContext);
            if (!(Helpers.isQualifiedNameEmpty(database) || Helpers.isQualifiedNameEmpty(currDB) || sqlContext.isQualifiedNamesEqual(database, currDB))) {
                db = database.getQualifiedNameForServer() + ".";
                dbStr = database.getQualifiedNameWithoutQuotes();
            } else {
                db = "";
                String string = dbStr = !Helpers.isQualifiedNameEmpty(currDB) ? currDB.getQualifiedNameWithoutQuotes() : "";
            }
            if (sqlContext.isTableExists(db + "INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS") && sqlContext.isTableExists(db + "INFORMATION_SCHEMA.KEY_COLUMN_USAGE")) {
                MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
                mrf.setQuery(String.format(sqlTemplate, db, dbStr));
                mrf.setPkDatabaseFieldName("PK_TABLE_DATABASE");
                mrf.setPkSchemaFieldName("PK_SCHEMA_NAME");
                mrf.setPkNameFieldName("PK_TABLE_NAME");
                mrf.setPkFieldName("PK_FIELD_NAME");
                mrf.setFkDatabaseFieldName("FK_TABLE_DATABASE");
                mrf.setFkSchemaFieldName("FK_SCHEMA_NAME");
                mrf.setFkNameFieldName("FK_TABLE_NAME");
                mrf.setFkFieldName("FK_FIELD_NAME");
                mrf.setOrdinalFieldName("ORDINAL");
                if (!mrf.validateQuery()) {
                    return false;
                }
                mrf.loadMetadata(metadataContainer, metadataFilter, database);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsMSSQLCE(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select top (0) * from INFORMATION_SCHEMA.INDEXES", false);
            if (resultSet == null) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    public static boolean loadMetadataObjectsMSSQLCE(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) {
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canCreateInternalConnection()) {
            sqlContext.getMetadataProvider().connect();
        }
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("SELECT TABLE_NAME, TABLE_TYPE FROM INFORMATION_SCHEMA.TABLES");
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTableType(new String[]{"TABLE"});
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
        }
        return true;
    }

    public static boolean loadMetadataRelationsMSSQLCE(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) {
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("select pf.TABLE_NAME as PK_TABLE_NAME, pf.COLUMN_NAME as PK_FIELD_NAME, ff.TABLE_NAME as FK_TABLE_NAME, ff.COLUMN_NAME as FK_FIELD_NAME, pf.ORDINAL_POSITION as ORDINAL from INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc, INFORMATION_SCHEMA.KEY_COLUMN_USAGE ff, INFORMATION_SCHEMA.KEY_COLUMN_USAGE pf where (rc.CONSTRAINT_NAME=ff.CONSTRAINT_NAME) and (rc.UNIQUE_CONSTRAINT_NAME=pf.CONSTRAINT_NAME) and (ff.ORDINAL_POSITION=pf.ORDINAL_POSITION) order by pf.TABLE_NAME, ff.TABLE_NAME, pf.ORDINAL_POSITION");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setOrdinalFieldName("ORDINAL");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsMySQL(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select DATABASE() as `database`, VERSION() as `version`", false);
            if (resultSet == null) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    private static void skipSeparators(String str, Wrapper<Integer> index) {
        while ((Integer)index.value < str.length() && (str.charAt((Integer)index.value) < '0' || str.charAt((Integer)index.value) > '9')) {
            Wrapper<Integer> wrapper = index;
            Integer n = (Integer)wrapper.value;
            wrapper.value = (Integer)wrapper.value + 1;
            Integer n2 = wrapper.value;
        }
    }

    private static String getDigits(String str, Wrapper<Integer> index) {
        StringBuilder sb = new StringBuilder();
        while ((Integer)index.value < str.length() && str.charAt((Integer)index.value) >= '0' && str.charAt((Integer)index.value) <= '9') {
            sb.append(str.charAt((Integer)index.value));
            Wrapper<Integer> wrapper = index;
            Integer n = (Integer)wrapper.value;
            wrapper.value = (Integer)wrapper.value + 1;
            Integer n2 = wrapper.value;
        }
        return sb.toString();
    }

    public static int parseServerVersionMySQL(String version) throws Exception {
        Wrapper<Integer> i = new Wrapper<Integer>(0);
        LoadMetadataHelpers.skipSeparators(version, i);
        String v = LoadMetadataHelpers.getDigits(version, i);
        LoadMetadataHelpers.skipSeparators(version, i);
        String m = LoadMetadataHelpers.getDigits(version, i);
        LoadMetadataHelpers.skipSeparators(version, i);
        String b = LoadMetadataHelpers.getDigits(version, i);
        if (Str.IsNullOrEmpty(v)) {
            throw new Exception(version + " is invalid version value.");
        }
        int ver = Integer.parseInt(v) * 10000;
        if (!Str.IsNullOrEmpty(m)) {
            ver = m.length() == 1 ? (ver += Integer.parseInt(m) * 1000) : (ver += Integer.parseInt(m) * 100);
        }
        if (!Str.IsNullOrEmpty(b)) {
            ver = b.length() == 1 ? (ver += Integer.parseInt(b) * 10) : (ver += Integer.parseInt(b));
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int calcServerVersionMySQL(BaseMetadataProvider metadataProvider) {
        int result;
        block24: {
            ResultSet resultSet = null;
            if (metadataProvider != null && metadataProvider.canExecSQL()) {
                try {
                    resultSet = metadataProvider.execSQL("select version()", false);
                    resultSet.next();
                    result = resultSet.getMetaData().getColumnCount() > 0 && !Str.IsNullOrEmpty(resultSet.getString(1)) ? LoadMetadataHelpers.parseServerVersionMySQL(resultSet.getString(1)) : 30000;
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                        break block24;
                    }
                    catch (Exception exception) {
                        break block24;
                    }
                    finally {
                        resultSet = null;
                    }
                    catch (Exception ex2222222222) {
                        try {
                            result = 30000;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (resultSet != null) {
                                    resultSet.getStatement().close();
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                resultSet = null;
                            }
                            throw throwable;
                        }
                        try {
                            if (resultSet != null) {
                                resultSet.getStatement().close();
                                resultSet.close();
                            }
                        }
                        catch (Exception ex2222222222) {
                        }
                        finally {
                            resultSet = null;
                        }
                    }
                }
                catch (Exception ex) {
                    result = 30000;
                }
            } else {
                result = 0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLQualifiedName getDefaultDatabaseNameMySQL(BaseSQLContext sqlContext) {
        ResultSet resultSet;
        AstNode result;
        block17: {
            String db;
            result = null;
            resultSet = null;
            if (sqlContext.getMetadataProvider() == null) return result;
            if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
            sqlContext.getMetadataProvider().connect();
            resultSet = sqlContext.getMetadataProvider().execSQL("select DATABASE()", false);
            if (!resultSet.next() || resultSet.getMetaData().getColumnCount() <= 0 || Str.IsNullOrEmpty(resultSet.getString(1)) || Str.IsNullOrEmpty(db = resultSet.getString(1))) break block17;
            result = new SQLQualifiedName(sqlContext);
            ((SQLQualifiedName)result).addName(db, false);
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception db) {
            return result;
        }
        finally {
            resultSet = null;
        }
        catch (Exception ex) {
            block18: {
                try {
                    if (result == null) break block18;
                    result.dispose();
                    result = null;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet == null) throw throwable;
                        resultSet.getStatement().close();
                        resultSet.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        throw throwable;
                    }
                    finally {
                        resultSet = null;
                    }
                }
            }
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
    }

    public static boolean getDatabaseListMySQL(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataDatabasesFetcherFromQuery mdf = new MetadataDatabasesFetcherFromQuery(sqlContext);
            mdf.setQuery("show databases");
            mdf.setNameFieldName("DATABASE");
            if (!mdf.validateQuery()) {
                return false;
            }
            mdf.loadDatabases(databaseList);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataObjectsMySQL(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            int version = LoadMetadataHelpers.calcServerVersionMySQL(sqlContext.getMetadataProvider());
            if (version >= 50000 && sqlContext.isTableExists("information_schema.tables")) {
                SQLQualifiedName currDB;
                String db = Helpers.isQualifiedNameEmpty(database) ? (!Helpers.isQualifiedNameEmpty(currDB = sqlContext.getSyntaxProvider().getDefaultDatabaseName(sqlContext)) ? "'" + currDB.getQualifiedNameWithoutQuotes() + "'" : "'%'") : "'" + database.getQualifiedNameWithoutQuotes() + "'";
                MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("select table_name, table_type, table_comment from information_schema.tables where table_schema like " + db);
                mof.setMetadataFilter(metadataFilter);
                mof.setNameFieldName("table_name");
                mof.setTypeFieldName("table_type");
                mof.setTableType(new String[]{"BASE TABLE"});
                mof.setSystemTableType(new String[]{"SYSTEM TABLE"});
                mof.setViewType(new String[]{"VIEW"});
                mof.setSystemViewType("SYSTEM VIEW");
                mof.setLongDescriptionFieldName("TABLE_COMMENT");
                if (!mof.validateQuery()) {
                    return false;
                }
                mof.loadMetadata(metadataContainer, metadataFilter, database);
                result = true;
            } else {
                String db = Helpers.isQualifiedNameEmpty(database) ? "" : " from " + database.getQualifiedName();
                MySQLMetadataObjectFetcherFromQuery mof = new MySQLMetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("show tables" + db);
                mof.setMetadataFilter(metadataFilter);
                mof.setDefaultObjectClass(MetadataTable.class);
                if (!mof.validateQuery()) {
                    return false;
                }
                mof.loadMetadata(metadataContainer, metadataFilter, database);
                result = true;
            }
        }
        return result;
    }

    public static boolean loadMetadataRelationsMySQL(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("information_schema.key_column_usage")) {
            SQLQualifiedName currDB;
            String db = Helpers.isQualifiedNameEmpty(database) ? (!Helpers.isQualifiedNameEmpty(currDB = LoadMetadataHelpers.getDefaultDatabaseNameMySQL(sqlContext)) ? "'" + currDB.getQualifiedNameWithoutQuotes() + "'" : "'%'") : "'" + database.getQualifiedNameWithoutQuotes() + "'";
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            String selectRelationsFieldsSQL = "select  kcu.REFERENCED_TABLE_SCHEMA as PK_TABLE_DATABASE,  kcu.REFERENCED_TABLE_NAME as PK_TABLE_NAME,  kcu.REFERENCED_COLUMN_NAME as PK_FIELD_NAME,  kcu.TABLE_SCHEMA as FK_TABLE_DATABASE,  kcu.TABLE_NAME as FK_TABLE_NAME,  kcu.COLUMN_NAME as FK_FIELD_NAME,  kcu.ORDINAL_POSITION as ORDINAL from  INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu where  (kcu.REFERENCED_COLUMN_NAME is not null) and  (kcu.TABLE_SCHEMA like %1$s) order by  PK_TABLE_DATABASE,  PK_TABLE_NAME,  FK_TABLE_DATABASE,  FK_TABLE_NAME,  ORDINAL";
            mrf.setQuery(String.format(selectRelationsFieldsSQL, db));
            mrf.setPkDatabaseFieldName("PK_TABLE_DATABASE");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkDatabaseFieldName("FK_TABLE_DATABASE");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setOrdinalFieldName("ORDINAL");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsOracle(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select * from sys.V_$VERSION at where RowNum<2", false);
            if (resultSet != null && resultSet.next() && resultSet.getMetaData().getColumnCount() > 0 && resultSet.getString(1).contains("Oracle")) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Maybe;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesOracle(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select sys_context('userenv','current_schema') from dual", false);
                if (resultSet.next()) {
                    defaultSchemaNames.addIdentifier(resultSet.getString(1));
                    result = true;
                }
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return result;
    }

    public static boolean getSchemaListOracle(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        String sql = "select u.USERNAME as NAME from ALL_USERS u where exists(select * from ALL_OBJECTS t where t.OWNER=u.USERNAME) order by u.USERNAME";
        if (sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(fromDatabase)) {
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery("select u.USERNAME as NAME from ALL_USERS u where exists(select * from ALL_OBJECTS t where t.OWNER=u.USERNAME) order by u.USERNAME");
            msf.setNameFieldName("NAME");
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadMetadataObjectsOracle(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canCreateInternalConnection()) {
            sqlContext.getMetadataProvider().connect();
        }
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("all_tables") && sqlContext.isTableExists("all_views")) {
            SQLIdentifiersCollection systemSchemaNames = new SQLIdentifiersCollection(sqlContext);
            try {
                systemSchemaNames.addIdentifier("SYS");
                systemSchemaNames.addIdentifier("SYSTEM");
                systemSchemaNames.addIdentifier("OUTLN");
                systemSchemaNames.addIdentifier("WMSYS");
                systemSchemaNames.addIdentifier("CTXSYS");
                systemSchemaNames.addIdentifier("ORDSYS");
                systemSchemaNames.addIdentifier("XDB");
                systemSchemaNames.addIdentifier("MDSYS");
                systemSchemaNames.addIdentifier("TSMSYS");
                systemSchemaNames.addIdentifier("LBACSYS");
                if (Helpers.isQualifiedNameEmpty(database)) {
                    MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
                    mof.setQuery("select * from (select t.owner as owner, t.table_name as table_name, c.comments as comments from all_tables t, all_tab_comments c where (t.owner=c.owner(+))and(t.table_name=c.table_name(+))) tables where ({D2A96EA6-30C3-45CB-9C88-C71927284386})");
                    mof.setMetadataFilter(metadataFilter);
                    mof.setSchemaFieldName("OWNER");
                    mof.setNameFieldName("TABLE_NAME");
                    mof.setLongDescriptionFieldName("COMMENTS");
                    mof.setSystemSchemaNames(systemSchemaNames);
                    mof.setDefaultObjectClass(MetadataTable.class);
                    if (!mof.validateQuery()) {
                        boolean bl = false;
                        return bl;
                    }
                    mof.loadMetadata(metadataContainer, metadataFilter, database);
                    result = true;
                    mof = new MetadataObjectFetcherFromQuery(sqlContext);
                    mof.setQuery("select * from (select t.owner as owner, t.view_name as view_name, c.comments as comments from all_views t, all_tab_comments c where (t.owner=c.owner(+))and(t.view_name=c.table_name(+))) views where ({ECDC625C-F3BD-4A65-AC25-828D3C06DAD0})");
                    mof.setMetadataFilter(metadataFilter);
                    mof.setSchemaFieldName("OWNER");
                    mof.setNameFieldName("VIEW_NAME");
                    mof.setLongDescriptionFieldName("COMMENTS");
                    mof.setSystemSchemaNames(systemSchemaNames);
                    mof.setDefaultObjectClass(MetadataView.class);
                    mof.loadMetadata(metadataContainer, metadataFilter, database);
                    mof = new MetadataObjectFetcherFromQuery(sqlContext);
                    if (sqlContext.isTableExists("all_mview_comments")) {
                        mof.setQuery("select * from (select t.owner as owner, t.mview_name as view_name, c.comments as comments from all_mviews t, all_mview_comments c where (t.owner=c.owner(+))and(t.mview_name=c.mview_name(+))) views where ({ECDC625C-F3BD-4A65-AC25-828D3C06DAD0})");
                    } else {
                        mof.setQuery("select * from (select t.owner as owner, t.mview_name as view_name, null as comments from all_mviews t) views where ({ECDC625C-F3BD-4A65-AC25-828D3C06DAD0})");
                    }
                    mof.setMetadataFilter(metadataFilter);
                    mof.setSchemaFieldName("OWNER");
                    mof.setNameFieldName("VIEW_NAME");
                    mof.setLongDescriptionFieldName("COMMENTS");
                    mof.setSystemSchemaNames(systemSchemaNames);
                    mof.setDefaultObjectClass(MetadataView.class);
                    mof.loadMetadata(metadataContainer, metadataFilter, database);
                    mof = new MetadataObjectFetcherFromQuery(sqlContext);
                    mof.setQuery("select * from (select s.owner, s.synonym_name, s.table_owner, s.table_name, s.db_link from all_synonyms s, all_objects o where s.table_owner=o.owner and s.table_name=o.object_name and o.object_type in ('TABLE','VIEW','SYNONYM')) where ({9A785FEF-8428-4D8A-8059-21AA7B87C31E})");
                    mof.setMetadataFilter(metadataFilter);
                    mof.setSchemaFieldName("OWNER");
                    mof.setNameFieldName("SYNONYM_NAME");
                    mof.setReferencedDatabaseFieldName("DB_LINK");
                    mof.setReferencedSchemaFieldName("TABLE_OWNER");
                    mof.setReferencedNameFieldName("TABLE_NAME");
                    mof.setDefaultObjectClass(MetadataSynonym.class);
                    mof.setSystemSchemaNames(systemSchemaNames);
                    mof.loadMetadata(metadataContainer, metadataFilter, database);
                    int serverVersion = LoadMetadataHelpers.calcServerVersionOracle(sqlContext.getMetadataProvider());
                    if (serverVersion >= 9) {
                        mof = new MetadataObjectFetcherFromQuery(sqlContext);
                        mof.setQuery("select * from (select distinct owner, object_name from all_procedures where pipelined<>'NO' and procedure_name is null) where ({C9B6D410-A51F-4FD8-9A70-F947D847697A})");
                        mof.setMetadataFilter(metadataFilter);
                        mof.setSchemaFieldName("OWNER");
                        mof.setNameFieldName("OBJECT_NAME");
                        mof.setDefaultObjectClass(MetadataProcedure.class);
                        mof.setSystemSchemaNames(systemSchemaNames);
                        mof.loadMetadata(metadataContainer, metadataFilter, database);
                    }
                } else {
                    systemSchemaNames.addIdentifier("\"sys\"");
                    systemSchemaNames.addIdentifier("\"System\"");
                    systemSchemaNames.addIdentifier("\"outln\"");
                    systemSchemaNames.addIdentifier("\"wmsys\"");
                    systemSchemaNames.addIdentifier("\"ctxsys\"");
                    systemSchemaNames.addIdentifier("\"ordsys\"");
                    systemSchemaNames.addIdentifier("\"xdb\"");
                    systemSchemaNames.addIdentifier("\"mdsys\"");
                    systemSchemaNames.addIdentifier("\"tsmsys\"");
                    systemSchemaNames.addIdentifier("\"lbacsys\"");
                    systemSchemaNames.addIdentifier("information_schema");
                    String db = database.getQualifiedNameForServer();
                    MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
                    mof.setQuery("select * from all_tables@" + db + " where " + "{D2A96EA6-30C3-45CB-9C88-C71927284386}");
                    mof.setMetadataFilter(metadataFilter);
                    mof.setSchemaFieldName("OWNER");
                    mof.setNameFieldName("TABLE_NAME");
                    mof.setDefaultObjectClass(MetadataTable.class);
                    mof.setSystemSchemaNames(systemSchemaNames);
                    if (!mof.validateQuery()) {
                        boolean bl = false;
                        return bl;
                    }
                    mof.loadMetadata(metadataContainer, metadataFilter, database);
                    result = true;
                    mof = new MetadataObjectFetcherFromQuery(sqlContext);
                    mof.setQuery("select * from all_views@" + db + " where " + "{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}");
                    mof.setMetadataFilter(metadataFilter);
                    mof.setSchemaFieldName("OWNER");
                    mof.setNameFieldName("VIEW_NAME");
                    mof.setDefaultObjectClass(MetadataView.class);
                    mof.setSystemSchemaNames(systemSchemaNames);
                    if (!mof.validateQuery()) {
                        boolean bl = result;
                        return bl;
                    }
                    mof.loadMetadata(metadataContainer, metadataFilter, database);
                    if (sqlContext.isTableExists("all_mviews")) {
                        mof = new MetadataObjectFetcherFromQuery(sqlContext);
                        if (sqlContext.isTableExists("all_mview_comments")) {
                            mof.setQuery("select * from (select t.owner as owner, t.mview_name as view_name, c.comments as comments from all_mviews@" + db + " t, all_mview_comments@" + db + " c where (t.owner=c.owner(+))and(t.mview_name=c.mview_name(+))) views where (" + "{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}" + ")");
                        } else {
                            mof.setQuery("select * from (select t.owner as owner, t.mview_name as view_name, null as comments from all_mviews@" + db + " t) views where (" + "{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}" + ")");
                        }
                        mof.setMetadataFilter(metadataFilter);
                        mof.setSchemaFieldName("OWNER");
                        mof.setNameFieldName("VIEW_NAME");
                        mof.setLongDescriptionFieldName("COMMENTS");
                        mof.setSystemSchemaNames(systemSchemaNames);
                        mof.setDefaultObjectClass(MetadataView.class);
                        if (!mof.validateQuery()) {
                            boolean bl = result;
                            return bl;
                        }
                        mof.loadMetadata(metadataContainer, metadataFilter, database);
                    }
                }
            }
            finally {
                systemSchemaNames.dispose();
            }
        }
        return result;
    }

    public static boolean loadMetadataRelationsOracle(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        String selectRelationsFieldsSQL = "select * from ( select pkc.OWNER as PK_SCHEMA_NAME, pkc.TABLE_NAME as PK_TABLE_NAME, pkc.COLUMN_NAME as PK_FIELD_NAME,        fkc.OWNER as FK_SCHEMA_NAME, fkc.TABLE_NAME as FK_TABLE_NAME, fkc.COLUMN_NAME as FK_FIELD_NAME,        pkc.POSITION as ORDINAL from ALL_CONSTRAINTS fk,      ALL_CONS_COLUMNS fkc,      ALL_CONS_COLUMNS pkc where (fk.CONSTRAINT_TYPE in ('R'))and       (fk.OWNER = fkc.OWNER)and(fk.CONSTRAINT_NAME = fkc.CONSTRAINT_NAME)and       (fk.R_OWNER = pkc.OWNER)and(fk.R_CONSTRAINT_NAME = pkc.CONSTRAINT_NAME)and       (fkc.POSITION = pkc.POSITION) ) r where (%1$s) or (%2$s)";
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("ALL_CONSTRAINTS") && sqlContext.isTableExists("ALL_CONS_COLUMNS")) {
            String filterFk;
            String filterPk;
            if (metadataFilter != null) {
                filterPk = metadataFilter.createPrefilterCondition(sqlContext, "PK_SCHEMA_NAME", "PK_TABLE_NAME", EnumSet.of(MetadataFilterApplyFor.Tables), String.valueOf('%'), String.valueOf('_'));
                if (Str.IsNullOrEmpty(filterPk)) {
                    filterPk = "(0=0)";
                }
                if (Str.IsNullOrEmpty(filterFk = metadataFilter.createPrefilterCondition(sqlContext, "FK_SCHEMA_NAME", "FK_TABLE_NAME", EnumSet.of(MetadataFilterApplyFor.Tables), String.valueOf('%'), String.valueOf('_')))) {
                    filterFk = "(0=0)";
                }
            } else {
                filterPk = "(0=0)";
                filterFk = "(0=0)";
            }
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery(String.format("select * from ( select pkc.OWNER as PK_SCHEMA_NAME, pkc.TABLE_NAME as PK_TABLE_NAME, pkc.COLUMN_NAME as PK_FIELD_NAME,        fkc.OWNER as FK_SCHEMA_NAME, fkc.TABLE_NAME as FK_TABLE_NAME, fkc.COLUMN_NAME as FK_FIELD_NAME,        pkc.POSITION as ORDINAL from ALL_CONSTRAINTS fk,      ALL_CONS_COLUMNS fkc,      ALL_CONS_COLUMNS pkc where (fk.CONSTRAINT_TYPE in ('R'))and       (fk.OWNER = fkc.OWNER)and(fk.CONSTRAINT_NAME = fkc.CONSTRAINT_NAME)and       (fk.R_OWNER = pkc.OWNER)and(fk.R_CONSTRAINT_NAME = pkc.CONSTRAINT_NAME)and       (fkc.POSITION = pkc.POSITION) ) r where (%1$s) or (%2$s)", filterPk, filterFk));
            mrf.setPkSchemaFieldName("PK_SCHEMA_NAME");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkSchemaFieldName("FK_SCHEMA_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setOrdinalFieldName("ORDINAL");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calcServerVersionOracle(BaseMetadataProvider metadataProvider) {
        int result = 18;
        ResultSet resultSet = null;
        if (metadataProvider != null && metadataProvider.canExecSQL()) {
            try {
                block22: {
                    resultSet = metadataProvider.execSQL("select BANNER from SYS.V_$VERSION where BANNER like 'CORE%'", false);
                    try {
                        resultSet.next();
                        int bannerField = resultSet.findColumn("BANNER");
                        if (bannerField != -1) {
                            try {
                                String s = resultSet.getString(bannerField);
                                int index = Helpers.skipSeparators(s, 0);
                                String si = Helpers.getDigits(s, index);
                                result = Integer.parseInt(si);
                                if (result < 7) {
                                    result = 7;
                                }
                                if (result > 18) {
                                    result = 18;
                                }
                                break block22;
                            }
                            catch (Exception ex) {
                                result = 18;
                            }
                            break block22;
                        }
                        result = 18;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (resultSet != null) {
                                resultSet.getStatement().close();
                                resultSet.close();
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            resultSet = null;
                        }
                        throw throwable;
                    }
                }
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception bannerField) {
                }
                finally {
                    resultSet = null;
                }
            }
            catch (Exception ex) {
                result = 18;
            }
        } else {
            result = 18;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsMSAccess(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select #01/01/01# as AccessDate", false);
            if (resultSet != null && resultSet.next() && resultSet.findColumn("AccessDate") >= 0) {
                resultSet.getString(resultSet.findColumn("AccessDate"));
                if (!resultSet.wasNull()) {
                    SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
                    try {
                        if (resultSet == null) return syntaxSupportsConectedServer;
                        resultSet.getStatement().close();
                        resultSet.close();
                        return syntaxSupportsConectedServer;
                    }
                    catch (Exception exception) {
                        return syntaxSupportsConectedServer;
                    }
                    finally {
                        resultSet = null;
                    }
                }
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Maybe;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsPostgreSQL(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select cast(version() as char(10)), (select 1 from pg_catalog.pg_class) as t", false);
            if (resultSet != null && resultSet.next() && resultSet.getString(1).equals("PostgreSQL")) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Maybe;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNamePostgreSQL(BaseSQLContext sqlContext) {
        SQLQualifiedName result = null;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select current_database()", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), false);
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception2) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesPostgreSQL(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select array_to_string(current_schemas(true),';')", false);
                if (resultSet.next()) {
                    for (String s : resultSet.getString(1).split(";")) {
                        defaultSchemaNames.addIdentifier(s);
                    }
                    result = true;
                }
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return result;
    }

    public static boolean loadMetadataObjectsPostgreSQL(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(database) && sqlContext.isTableExists("pg_catalog.pg_class")) {
            PostgreSQLMetadataObjectFetcherFromQuery mof = new PostgreSQLMetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("select * from (select ns.nspname as SCHEMANAME, c.relname as TABLENAME, c.relkind as TABLETYPE, d.description as DESCRIPTION  from pg_catalog.pg_class c     inner join pg_catalog.pg_namespace ns on c.relnamespace=ns.oid) q     left join pg_catalog.pg_description d on c.oid=d.objoid where (q.TABLETYPE='v' and {ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}) or   (q.TABLETYPE='r' and {D2A96EA6-30C3-45CB-9C88-C71927284386})");
            mof.setMetadataFilter(metadataFilter);
            mof.setDefaultObjectClass(MetadataTable.class);
            mof.setSchemaFieldName("SCHEMANAME");
            mof.setNameFieldName("TABLENAME");
            mof.setTypeFieldName("TABLETYPE");
            mof.setViewType(new String[]{"v"});
            mof.setTableType(new String[]{"r"});
            mof.setLongDescriptionFieldName("DESCRIPTION");
            mof.getSystemSchemaNames().addIdentifier("pg_catalog");
            mof.getSystemSchemaNames().addIdentifier("information_schema");
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataRelationsPostgreSQL(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNamePostgreSQL(sqlContext);
        if (!(Helpers.isQualifiedNameEmpty(database) || Helpers.isQualifiedNameEmpty(currDB) || sqlContext.isQualifiedNamesEqual(database, currDB))) {
            return false;
        }
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS") && sqlContext.isTableExists("INFORMATION_SCHEMA.KEY_COLUMN_USAGE")) {
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("select   current_database() as PK_TABLE_DATABASE,   kn.nspname as PK_TABLE_SCHEMA,   kt.relname as PK_TABLE_NAME,   array_to_string(ARRAY(select attname from pg_catalog.pg_attribute where attrelid=kt.oid and ARRAY[attnum] <@ c.conkey),';') as pk_field_name,   current_database() as FK_TABLE_DATABASE,   fn.nspname as FK_TABLE_SCHEMA,   ft.relname as FK_TABLE_NAME,   array_to_string(ARRAY(select attname from pg_catalog.pg_attribute where attrelid=ft.oid and ARRAY[attnum] <@ c.confkey),';') as fk_field_name from pg_catalog.pg_constraint c   inner join pg_catalog.pg_class kt on c.conrelid=kt.oid   inner join pg_catalog.pg_namespace kn on kt.relnamespace=kn.oid   inner join pg_catalog.pg_class ft on c.confrelid=ft.oid   inner join pg_catalog.pg_namespace fn on ft.relnamespace=fn.oid where c.contype='f'");
            mrf.setPkDatabaseFieldName("PK_TABLE_DATABASE");
            mrf.setPkSchemaFieldName("PK_TABLE_SCHEMA");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkDatabaseFieldName("FK_TABLE_DATABASE");
            mrf.setFkSchemaFieldName("FK_TABLE_SCHEMA");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setFieldsSeparator(";");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean getSchemaListPostgreSQL(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        String sql = "select nspname as name from pg_catalog.pg_namespace order by name";
        if (sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(fromDatabase)) {
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery("select nspname as name from pg_catalog.pg_namespace order by name");
            msf.setNameFieldName("NAME");
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsFirebird(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select * from rdb$relations", false);
            if (resultSet == null) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    public static boolean loadMetadataObjectsFirebird(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(database) && sqlContext.isTableExists("rdb$relations")) {
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setMetadataFilter(metadataFilter);
            mof.setQuery("select rdb$relation_name table_name, rdb$system_flag table_system, rdb$description description from rdb$relations where rdb$view_blr is null");
            mof.setMetadataFilter(metadataFilter);
            mof.setDefaultObjectClass(MetadataTable.class);
            mof.setNameFieldName("TABLE_NAME");
            mof.setSystemFieldName("TABLE_SYSTEM");
            mof.setSystemFieldValue(1);
            mof.setLongDescriptionFieldName("DESCRIPTION");
            mof.setTrimSpaces(true);
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
            mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setMetadataFilter(metadataFilter);
            mof.setQuery("select rdb$relation_name table_name, rdb$system_flag table_system, rdb$description description from rdb$relations where rdb$view_blr is not null");
            mof.setMetadataFilter(metadataFilter);
            mof.setDefaultObjectClass(MetadataView.class);
            mof.setNameFieldName("TABLE_NAME");
            mof.setSystemFieldName("TABLE_SYSTEM");
            mof.setSystemFieldValue(1);
            mof.setLongDescriptionFieldName("DESCRIPTION");
            mof.setTrimSpaces(true);
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            if (sqlContext.isTableExists("RDB$PROCEDURES")) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setMetadataFilter(metadataFilter);
                mof.setQuery("select RDB$PROCEDURE_NAME as TABLE_NAME, rdb$description description from RDB$PROCEDURES");
                mof.setMetadataFilter(metadataFilter);
                mof.setDefaultObjectClass(MetadataProcedure.class);
                mof.setNameFieldName("TABLE_NAME");
                mof.setTrimSpaces(true);
                mof.setLongDescriptionFieldName("DESCRIPTION");
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            }
        }
        return result;
    }

    public static boolean loadMetadataRelationsFirebird(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(database) && sqlContext.isTableExists("rdb$indices") && sqlContext.isTableExists("rdb$index_segments")) {
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("select pt.RDB$RELATION_NAME as PK_TABLE_NAME, pc.RDB$FIELD_NAME as PK_FIELD_NAME, ct.RDB$RELATION_NAME as FK_TABLE_NAME, cc.RDB$FIELD_NAME as FK_FIELD_NAME, cc.RDB$FIELD_POSITION as ORDINAL from rdb$indices pt, rdb$index_segments pc, rdb$indices ct, rdb$index_segments cc where pt.RDB$INDEX_NAME=ct.RDB$FOREIGN_KEY and pc.RDB$INDEX_NAME=pt.RDB$INDEX_NAME and cc.RDB$INDEX_NAME=ct.RDB$INDEX_NAME and pc.RDB$FIELD_POSITION=cc.RDB$FIELD_POSITION");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setOrdinalFieldName("ORDINAL");
            mrf.setTrimSpaces(true);
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsDB2(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select CURRENT_SCHEMA from SYSIBM.SYSDUMMY1", false);
            if (resultSet == null) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNameDB2(BaseSQLContext sqlContext) {
        SQLQualifiedName result = null;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        if (!sqlContext.isTableExists("SYSIBM.SYSDUMMY1")) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select CURRENT_SERVER as CATALOG_NAME from SYSIBM.SYSDUMMY1", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), false);
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception2) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesDB2(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("SYSIBM.SYSDUMMY1")) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select CURRENT_SCHEMA from SYSIBM.SYSDUMMY1", false);
                if (resultSet.next()) {
                    AstTokenIdentifier userName = defaultSchemaNames.add();
                    userName.setToken(resultSet.getString(1));
                    userName.setCaseSensitive(sqlContext.getSyntaxProvider().getIdentCaseSens() != IdentCaseSensitivity.Insensitive);
                    result = true;
                }
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return result;
    }

    public static boolean loadMetadataObjectsDB2(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("sysibm.systables")) {
            SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNameDB2(sqlContext);
            String db = !Helpers.isQualifiedNameEmpty(database) && !Helpers.isQualifiedNameEmpty(currDB) && !sqlContext.isQualifiedNamesEqual(database, currDB) ? database.getQualifiedName() + "." : "";
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("select * from   (select     cast(creator as varchar(254)) as TABLE_SCHEMA,     cast(name as varchar(254)) as TABLE_NAME,     cast(type as char(1)) as TABLE_TYPE,     cast(remarks as varchar(254)) as TABLE_DESCRIPTION,     cast(base_schema as varchar(254)) as REF_TABLE_SCHEMA,     cast(base_name as varchar(254)) as REF_TABLE_NAME    from " + db + "sysibm.systables) as q where (TABLE_TYPE in ('H','L','P','T','U'))and(" + "{D2A96EA6-30C3-45CB-9C88-C71927284386}" + ") or (TABLE_TYPE in ('V','W','S','M'))and(" + "{ECDC625C-F3BD-4A65-AC25-828D3C06DAD0}" + ") or (TABLE_TYPE in ('N','A'))and(" + "{9A785FEF-8428-4D8A-8059-21AA7B87C31E}" + ") for fetch only");
            mof.setMetadataFilter(metadataFilter);
            mof.setSchemaFieldName("TABLE_SCHEMA");
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setLongDescriptionFieldName("TABLE_DESCRIPTION");
            mof.setReferencedSchemaFieldName("REF_TABLE_SCHEMA");
            mof.setReferencedNameFieldName("REF_TABLE_NAME");
            mof.setTableType(new String[]{"H", "L", "P", "T", "U"});
            mof.setViewType(new String[]{"V", "W", "S", "M"});
            mof.setSynonymType(new String[]{"N", "A"});
            SQLIdentifiersCollection systemSchemaNames = mof.getSystemSchemaNames();
            systemSchemaNames.addIdentifier("syscat");
            systemSchemaNames.addIdentifier("sysfun");
            systemSchemaNames.addIdentifier("sysibm");
            systemSchemaNames.addIdentifier("sysstat");
            systemSchemaNames.addIdentifier("sysproc");
            systemSchemaNames.addIdentifier("systools");
            systemSchemaNames.addIdentifier("sysibmadm");
            mof.setTrimSpaces(true);
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
            if (sqlContext.isTableExists("sysibm.sysroutines")) {
                mof = new MetadataObjectFetcherFromQuery(sqlContext);
                mof.setQuery("select * from sysibm.sysroutines where routinetype = 'F' and function_type = 'T' and ({C9B6D410-A51F-4FD8-9A70-F947D847697A})");
                mof.setMetadataFilter(metadataFilter);
                mof.setDefaultObjectClass(MetadataProcedure.class);
                mof.setSchemaFieldName("ROUTINESCHEMA");
                mof.setNameFieldName("ROUTINENAME");
                systemSchemaNames = mof.getSystemSchemaNames();
                systemSchemaNames.addIdentifier("syscat");
                systemSchemaNames.addIdentifier("sysfun");
                systemSchemaNames.addIdentifier("sysibm");
                systemSchemaNames.addIdentifier("sysstat");
                systemSchemaNames.addIdentifier("sysproc");
                systemSchemaNames.addIdentifier("systools");
                systemSchemaNames.addIdentifier("sysibmadm");
                mof.setTrimSpaces(true);
                mof.loadMetadata(metadataContainer, metadataFilter, database);
            }
        }
        return result;
    }

    public static boolean loadMetadataRelationsDB2(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && sqlContext.isTableExists("sysibm.sqlforeignkeys")) {
            SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNameDB2(sqlContext);
            String db = !Helpers.isQualifiedNameEmpty(database) && !Helpers.isQualifiedNameEmpty(currDB) && !sqlContext.isQualifiedNamesEqual(database, currDB) ? database.getQualifiedName() + "." : "";
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("select * from " + db + "sysibm.sqlforeignkeys where pktable_schem <> fktable_schem or pktable_name <> fktable_name or pkcolumn_name <> fkcolumn_name order by pktable_schem, pktable_name, fktable_schem, fktable_name, key_seq");
            mrf.setPkSchemaFieldName("PKTABLE_SCHEM");
            mrf.setPkNameFieldName("PKTABLE_NAME");
            mrf.setPkFieldName("PKCOLUMN_NAME");
            mrf.setFkSchemaFieldName("FKTABLE_SCHEM");
            mrf.setFkNameFieldName("FKTABLE_NAME");
            mrf.setFkFieldName("FKCOLUMN_NAME");
            mrf.setOrdinalFieldName("KEY_SEQ");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean getSchemaListDB2(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        String sql = "select SCHEMANAME as NAME from SYSCAT.SCHEMATA order by NAME";
        if (sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(fromDatabase)) {
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery("select SCHEMANAME as NAME from SYSCAT.SCHEMATA order by NAME");
            msf.setNameFieldName("NAME");
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    public static SyntaxSupportsConectedServer isConnectedServerIsSybase(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        if (metadataProvider.canExecSQL()) {
            try {
                if (LoadMetadataHelpers.isConnectedServerIsSybaseASA(metadataProvider)) {
                    return SyntaxSupportsConectedServer.Yes;
                }
                if (LoadMetadataHelpers.isConnectedServerIsSybaseASE(metadataProvider)) {
                    return SyntaxSupportsConectedServer.Yes;
                }
                return SyntaxSupportsConectedServer.No;
            }
            catch (Exception ex) {
                return SyntaxSupportsConectedServer.No;
            }
        }
        return SyntaxSupportsConectedServer.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnectedServerIsSybaseASA(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        assert (metadataProvider.canExecSQL());
        ResultSet resultSet = null;
        try {
            resultSet = metadataProvider.execSQL("select xp_msver('CompanyName')", false);
            if (resultSet != null && resultSet.next() && resultSet.getMetaData().getColumnCount() > 0 && (resultSet.getString(1).contains("iAnywhere") || resultSet.getString(1).contains("Sybase"))) {
                boolean bl = true;
                try {
                    if (resultSet == null) return bl;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return bl;
                }
                catch (Exception exception) {
                    return bl;
                }
                finally {
                    resultSet = null;
                }
            }
            boolean bl = false;
            try {
                if (resultSet == null) return bl;
                resultSet.getStatement().close();
                resultSet.close();
                return bl;
            }
            catch (Exception exception) {
                return bl;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConnectedServerIsSybaseASE(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        assert (metadataProvider.canExecSQL());
        ResultSet resultSet = null;
        try {
            resultSet = metadataProvider.execSQL("select @@version", false);
            if (resultSet != null && resultSet.next() && resultSet.getMetaData().getColumnCount() > 0 && resultSet.getString(1).contains("Adaptive Server Enterprise")) {
                boolean bl = true;
                try {
                    if (resultSet == null) return bl;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return bl;
                }
                catch (Exception exception) {
                    return bl;
                }
                finally {
                    resultSet = null;
                }
            }
            boolean bl = false;
            try {
                if (resultSet == null) return bl;
                resultSet.getStatement().close();
                resultSet.close();
                return bl;
            }
            catch (Exception exception) {
                return bl;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNameSybase(BaseSQLContext sqlContext) {
        SQLQualifiedName result = null;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select DB_NAME(DB_ID())", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), false);
            }
        }
        catch (Exception exception) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception2) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesSybase(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select user_name()", false);
                if (resultSet.next()) {
                    defaultSchemaNames.addIdentifier(resultSet.getString(1));
                    result = true;
                }
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        if (!defaultSchemaNames.containsSameIdStr("dbo")) {
            defaultSchemaNames.addIdentifier("dbo");
            result = true;
        }
        return result;
    }

    public static boolean getDatabaseListSybase(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            if (!sqlContext.getMetadataProvider().isConnected()) {
                sqlContext.getMetadataProvider().connect();
            }
            try {
                MetadataDatabasesFetcherFromQuery mdf = new MetadataDatabasesFetcherFromQuery(sqlContext);
                mdf.setQuery("exec sp_databases");
                mdf.setNameFieldName("DATABASE_NAME");
                if (!mdf.validateQuery()) {
                    return false;
                }
                mdf.loadDatabases(databaseList);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean loadMetadataObjectsSybase(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            if (database == null) {
                mof.setQuery("exec dbo.sp_tables");
            } else {
                mof.setQuery("exec " + database.getQualifiedName() + ".dbo.sp_tables");
            }
            mof.setMetadataFilter(metadataFilter);
            mof.setSchemaFieldName("TABLE_OWNER");
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTableType(new String[]{"TABLE"});
            mof.setSystemTableType(new String[]{"SYSTEM TABLE"});
            mof.setViewType(new String[]{"VIEW"});
            mof.setSystemViewType("SYSTEM VIEW");
            mof.getSystemSchemaNames().addIdentifier("sys");
            mof.getSystemSchemaNames().addIdentifier("rs_systabgroup");
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataRelationsSybase(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (LoadMetadataHelpers.isConnectedServerIsSybaseASA(sqlContext.getMetadataProvider())) {
            return LoadMetadataHelpers.loadMetadataRelationsSybaseASA(sqlContext, metadataContainer, metadataFilter, database);
        }
        if (LoadMetadataHelpers.isConnectedServerIsSybaseASE(sqlContext.getMetadataProvider())) {
            return LoadMetadataHelpers.loadMetadataRelationsSybaseASE(sqlContext, metadataContainer, metadataFilter, database);
        }
        return false;
    }

    public static boolean loadMetadataRelationsSybaseASA(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNameSybase(sqlContext);
            String db = !Helpers.isQualifiedNameEmpty(database) && !Helpers.isQualifiedNameEmpty(currDB) && !sqlContext.isQualifiedNamesEqual(database, currDB) ? database.getQualifiedName() + "." : "";
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            String selectRelationsFieldsSQL = "select   pktbluser.user_name as PK_SCHEMA_NAME, pktbl.table_name as PK_TABLE_NAME, pkcol.column_name as PK_FIELD_NAME,   fktbluser.user_name as FK_SCHEMA_NAME, fktbl.table_name as FK_TABLE_NAME, fkcol.column_name as FK_FIELD_NAME,   fkcols.foreign_key_id as FOREIGN_KEY_ID from SYSFOREIGNKEY fk   inner join %1$sSYS.SYSFKCOL fkcols on fk.foreign_table_id=fkcols.foreign_table_id and fk.foreign_key_id=fkcols.foreign_key_id   inner join %1$sSYS.SYSCOLUMN pkcol on fk.primary_table_id=pkcol.table_id and fkcols.primary_column_id=pkcol.column_id   inner join %1$sSYS.SYSCOLUMN fkcol on fk.foreign_table_id=fkcol.table_id and fkcols.foreign_column_id =fkcol.column_id   inner join %1$sSYS.SYSTABLE pktbl on fk.primary_table_id=pktbl.table_id   inner join %1$sSYS.SYSUSERPERM pktbluser on pktbluser.user_id=pktbl.creator   inner join %1$sSYS.SYSTABLE fktbl on fk.foreign_table_id=fktbl.table_id   inner join %1$sSYS.SYSUSERPERM fktbluser on fktbluser.user_id=fktbl.creator order by fk.foreign_table_id, fk.foreign_key_id";
            mrf.setQuery(String.format(selectRelationsFieldsSQL, db));
            mrf.setPkSchemaFieldName("PK_SCHEMA_NAME");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkSchemaFieldName("FK_SCHEMA_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setForeignKeyIdFieldName("FOREIGN_KEY_ID");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataRelationsSybaseASE(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            String db_dot;
            String db;
            SQLQualifiedName currDB = LoadMetadataHelpers.getDefaultDatabaseNameSybase(sqlContext);
            if (!(Helpers.isQualifiedNameEmpty(database) || Helpers.isQualifiedNameEmpty(currDB) || sqlContext.isQualifiedNamesEqual(database, currDB))) {
                db = database.getQualifiedName();
                db_dot = db + ".";
            } else {
                db = "";
                db_dot = "";
            }
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            String selectRelationsFieldsSQL = "select     pk_table_id,     pk_database_name = isnull(db_name(r.pk_database_id), '%2$s'),     pk_schema_name = user_name(pko.uid),     pk_table_name = object_name(r.pk_table_id, r.pk_database_id),     pk_field_name = col_name(r.pk_table_id,r.pk_field_id,r.pk_database_id),     fk_table_id,     fk_database_name = isnull(db_name(r.fk_database_id), '%2$s'),     fk_schema_name = user_name(fko.uid),     fk_table_name = object_name(r.fk_table_id, r.fk_database_id),     fk_field_name = col_name(r.fk_table_id,r.fk_field_id,r.fk_database_id),     foreign_key_id from     (         select pk_database_id = pmrydbid,             pk_table_id = reftabid,             pk_field_id=refkey1,             fk_database_id = frgndbid,             fk_table_id = tableid,             fk_field_id=fokey1,             foreign_key_id=constrid         from %1$sdbo.sysreferences         where fokey1!=0         union         select pmrydbid, reftabid, refkey2, frgndbid, tableid, fokey2, constrid         from %1$sdbo.sysreferences         where fokey2!=0         union         select pmrydbid, reftabid, refkey3, frgndbid, tableid, fokey3, constrid         from %1$sdbo.sysreferences         where fokey3!=0         union         select pmrydbid, reftabid, refkey4, frgndbid, tableid, fokey4, constrid         from %1$sdbo.sysreferences         where fokey4!=0     ) r,     %1$sdbo.sysobjects pko,     %1$sdbo.sysobjects fko where (r.pk_table_id=pko.id) and (r.fk_table_id=fko.id) order by pk_table_id, fk_table_id, foreign_key_id";
            mrf.setQuery(String.format(selectRelationsFieldsSQL, db_dot, db));
            mrf.setPkDatabaseFieldName("PK_DATABASE_NAME");
            mrf.setPkSchemaFieldName("PK_SCHEMA_NAME");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkDatabaseFieldName("FK_DATABASE_NAME");
            mrf.setFkSchemaFieldName("FK_SCHEMA_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setForeignKeyIdFieldName("FOREIGN_KEY_ID");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean getSchemaListSybase(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        String sql = "select NAME from SYSUSERS order by NAME";
        if (sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(fromDatabase)) {
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery("select NAME from SYSUSERS order by NAME");
            msf.setNameFieldName("NAME");
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsInformix(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select first 1 dbinfo('version', 'full') from systables", false);
            if (resultSet == null) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    public static boolean loadMetadataObjectsInformix(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(database) && sqlContext.isTableExists("systables")) {
            InformixMetadataObjectFetcherFromQuery mof = new InformixMetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("select tabname as TABLE_NAME, owner as TABLE_OWNER, tabtype as TABLE_TYPE from systables WHERE tabid not in (90,91) and tabname != ' VERSION'");
            mof.setMetadataFilter(metadataFilter);
            mof.setSchemaFieldName("TABLE_OWNER");
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTrimSpaces(true);
            mof.getSystemSchemaNames().addIdentifier("informix");
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataRelationsInformix(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(database) && sqlContext.isTableExists("syscolumns") && sqlContext.isTableExists("systables") && sqlContext.isTableExists("sysconstraints") && sqlContext.isTableExists("sysreferences") && sqlContext.isTableExists("sysindexes")) {
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("select  n.owner as PK_SCHEMA_NAME,  n.tabname as PK_TABLE_NAME,  p.colname as PK_FIELD_NAME,  t.owner as FK_SCHEMA_NAME,  t.tabname as FK_TABLE_NAME,  c.colname as FK_FIELD_NAME,  p.colno as ORDINAL from syscolumns c,  systables t,  sysconstraints s,  sysreferences r,  systables n,  sysindexes i,  syscolumns p where t.tabid = c.tabid  AND t.tabid = s.tabid  AND s.constrtype = 'R'  AND i.idxname = s.idxname  AND i.part1 = c.colno  AND r.constrid = s.constrid  AND p.tabid = r.ptabid  AND p.colno = 1  AND n.tabid = r.ptabid ORDER BY t.tabname");
            mrf.setPkSchemaFieldName("PK_SCHEMA_NAME");
            mrf.setPkNameFieldName("PK_TABLE_NAME");
            mrf.setPkFieldName("PK_FIELD_NAME");
            mrf.setFkSchemaFieldName("FK_SCHEMA_NAME");
            mrf.setFkNameFieldName("FK_TABLE_NAME");
            mrf.setFkFieldName("FK_FIELD_NAME");
            mrf.setOrdinalFieldName("ORDINAL");
            mrf.setTrimSpaces(true);
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static boolean getSchemaListInformix(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        String sql = "select distinct OWNER as NAME from SYSTABLES where tabid not in (90,91) and tabname != ' VERSION' order by NAME";
        if (sqlContext.getMetadataProvider().canExecSQL() && Helpers.isQualifiedNameEmpty(fromDatabase)) {
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery("select distinct OWNER as NAME from SYSTABLES where tabid not in (90,91) and tabname != ' VERSION' order by NAME");
            msf.setNameFieldName("NAME");
            msf.setTrimSpaces(true);
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int calcServerVersionInformix(BaseMetadataProvider metadataProvider) {
        resultSet = null;
        if (metadataProvider != null && metadataProvider.canExecSQL()) {
            try {
                resultSet = metadataProvider.execSQL("select first 1 dbinfo('version', 'major') from systables", false);
                try {
                    resultSet.next();
                    version = resultSet.getInt(1);
                    switch (version) {
                        case 8: {
                            result = 8;
                            ** break;
                        }
                        case 9: {
                            result = 9;
                            ** break;
                        }
                        case 10: {
                            result = 10;
                            ** break;
                        }
                        case 11: {
                            result = 11;
                            ** break;
                        }
                        default: {
                            result = version > 11 ? 11 : 8;
                        }
                    }
                }
                catch (Throwable var5_7) {
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                    }
                    catch (Exception var6_8) {
                    }
                    finally {
                        resultSet = null;
                    }
                    throw var5_7;
                }
lbl37:
                // 5 sources

                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception version) {
                }
                finally {
                    resultSet = null;
                }
            }
            catch (Exception ex) {
                result = 11;
            }
        } else {
            result = 11;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsSQLite(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select NAME from sqlite_master", false);
            if (resultSet == null) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    public static boolean loadMetadataObjectsSQLite(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            String db = Helpers.isQualifiedNameEmpty(database) || database.getQualifiedNameForServer().compareToIgnoreCase("main") == 0 ? "main" : database.getQualifiedNameForServer();
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("select * from " + db + ".sqlite_master");
            mof.setMetadataFilter(metadataFilter);
            mof.setNameFieldName("NAME");
            mof.setTypeFieldName("TYPE");
            mof.setTableType(new String[]{"table"});
            mof.setViewType(new String[]{"view"});
            mof.setTrimSpaces(true);
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    public static SQLQualifiedName getDefaultDatabaseNameSQLite(BaseSQLContext sqlContext) {
        SQLQualifiedName result = new SQLQualifiedName(sqlContext);
        result.addName("main", false);
        return result;
    }

    public static boolean getDatabaseListSQLite(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            if (!sqlContext.getMetadataProvider().isConnected()) {
                sqlContext.getMetadataProvider().connect();
            }
            try {
                MetadataDatabasesFetcherFromQuery mdf = new MetadataDatabasesFetcherFromQuery(sqlContext);
                mdf.setQuery("pragma database_list");
                mdf.setNameFieldName("NAME");
                if (!mdf.validateQuery()) {
                    return false;
                }
                mdf.loadDatabases(databaseList);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsVistaDB(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("SELECT @@VERSION;", false);
            if (resultSet != null && resultSet.next() && resultSet.getMetaData().getColumnCount() > 0 && resultSet.getString(1).contains("VistaDB")) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Maybe;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsTeradata(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select * from dbc.dbcinfo", false);
            if (resultSet != null && resultSet.next() && resultSet.findColumn("VERSION") > 0) {
                SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.Yes;
                try {
                    if (resultSet == null) return syntaxSupportsConectedServer;
                    resultSet.getStatement().close();
                    resultSet.close();
                    return syntaxSupportsConectedServer;
                }
                catch (Exception exception) {
                    return syntaxSupportsConectedServer;
                }
                finally {
                    resultSet = null;
                }
            }
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesTeradata(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select database", false);
                if (resultSet.next()) {
                    defaultSchemaNames.addIdentifier(resultSet.getString(1).trim());
                    result = true;
                }
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return result;
    }

    public static boolean getSchemaListTeradata(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            msf.setQuery("SELECT DatabaseName AS DATABASE_NAME FROM dbc.DatabasesX");
            msf.setTrimSpaces(true);
            msf.setNameFieldName("DATABASE_NAME");
            if (!msf.validateQuery()) {
                return false;
            }
            msf.loadSchemas(schemasList);
            result = true;
        }
        return result;
    }

    public static boolean loadMetadataObjectsTeradata(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) {
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canCreateInternalConnection()) {
            sqlContext.getMetadataProvider().connect();
        }
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("select DatabaseName, TableName, TableKind, CommentString from dbc.TablesX where (TableKind in ('T','V'))");
            mof.setTrimSpaces(true);
            mof.setMetadataFilter(metadataFilter);
            mof.setSchemaFieldName("DatabaseName");
            mof.setNameFieldName("TableName");
            mof.setTypeFieldName("TableKind");
            mof.setTableType("T");
            mof.setViewType("V");
            mof.setShortDescriptionFieldName("CommentString");
            SQLIdentifiersCollection systemSchemaNames = mof.getSystemSchemaNames();
            systemSchemaNames.addIdentifier("DBC");
            systemSchemaNames.addIdentifier("SQLJ");
            systemSchemaNames.addIdentifier("SYSLIB");
            systemSchemaNames.addIdentifier("SYSSPATIAL");
            systemSchemaNames.addIdentifier("TDStats");
            systemSchemaNames.addIdentifier("TDPUSER");
            systemSchemaNames.addIdentifier("SYSUDTLIB");
            systemSchemaNames.addIdentifier("Crashdumps");
            systemSchemaNames.addIdentifier("TD_SYSFNLIB");
            systemSchemaNames.addIdentifier("SysAdmin");
            systemSchemaNames.addIdentifier("SystemFe");
            systemSchemaNames.addIdentifier("Sys_Calendar");
            systemSchemaNames.addIdentifier("dbcmngr");
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
        }
        return true;
    }

    public static boolean loadMetadataRelationsTeradata(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("select * from dbc.all_ri_parents");
            mrf.setTrimSpaces(true);
            mrf.setPkSchemaFieldName("ParentDB");
            mrf.setPkNameFieldName("ParentTable");
            mrf.setPkFieldName("ParentKeyColumn");
            mrf.setFkSchemaFieldName("ChildDB");
            mrf.setFkNameFieldName("ChildTable");
            mrf.setFkFieldName("ChildKeyColumn");
            mrf.setOrdinalFieldName("IndexID");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsAdvantage(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select USER(), APPLICATION_ID() from system.iota", false);
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = resultSet != null ? SyntaxSupportsConectedServer.Yes : SyntaxSupportsConectedServer.No;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNameAdvantage(BaseSQLContext sqlContext) {
        SQLQualifiedName result = null;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select DATABASE() from system.iota", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), false);
            }
        }
        catch (Throwable throwable) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    public static boolean getDatabaseListAdvantage(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        boolean result = false;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            if (!sqlContext.getMetadataProvider().isConnected()) {
                sqlContext.getMetadataProvider().connect();
            }
            try {
                MetadataDatabasesFetcherFromQuery mdf = new MetadataDatabasesFetcherFromQuery(sqlContext);
                mdf.setQuery("execute procedure sp_GetCatalogs()");
                mdf.setNameFieldName("TABLE_CAT");
                if (!mdf.validateQuery()) {
                    return false;
                }
                mdf.loadDatabases(databaseList);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean loadMetadataObjectsAdvantage(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            String databaseName = Helpers.isQualifiedNameEmpty(database) ? "Database()" : "'" + database.getQualifiedNameWithoutQuotes() + "'";
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery("execute procedure sp_GetTables(" + databaseName + ", null, null, null)");
            mof.setMetadataFilter(metadataFilter);
            mof.setDefaultObjectClass(MetadataTable.class);
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTableType(new String[]{"TABLE"});
            mof.setViewType(new String[]{"VIEW"});
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            return true;
        }
        return false;
    }

    public static boolean loadMetadataRelationsAdvantage(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            String databaseName = Helpers.isQualifiedNameEmpty(database) ? "Database()" : "'" + database.getQualifiedNameWithoutQuotes() + "'";
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("execute procedure sp_GetForeignKeyColumns(" + databaseName + ", null, null, null)");
            mrf.setPkNameFieldName("PKTABLE_NAME");
            mrf.setPkFieldName("PKCOLUMN_NAME");
            mrf.setFkNameFieldName("FKTABLE_NAME");
            mrf.setFkFieldName("FKCOLUMN_NAME");
            mrf.setOrdinalFieldName("KEY_SEQ");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SyntaxSupportsConectedServer isConnectedServerIsNetezza(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        ResultSet resultSet = null;
        if (!metadataProvider.canExecSQL()) return SyntaxSupportsConectedServer.Unknown;
        try {
            resultSet = metadataProvider.execSQL("select cast(version() as char(10)), current_useroid as t", false);
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = resultSet != null ? SyntaxSupportsConectedServer.Yes : SyntaxSupportsConectedServer.No;
            try {
                if (resultSet == null) return syntaxSupportsConectedServer;
                resultSet.getStatement().close();
                resultSet.close();
                return syntaxSupportsConectedServer;
            }
            catch (Exception exception) {
                return syntaxSupportsConectedServer;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Exception ex) {
            SyntaxSupportsConectedServer syntaxSupportsConectedServer = SyntaxSupportsConectedServer.No;
            return syntaxSupportsConectedServer;
        }
        finally {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                }
                catch (Exception exception) {
                    resultSet = null;
                }
            }
            catch (Throwable throwable) {
                resultSet = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SQLQualifiedName getDefaultDatabaseNameNetezza(BaseSQLContext sqlContext) {
        SQLQualifiedName result = null;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() == null) return result;
        if (!sqlContext.getMetadataProvider().canExecSQL()) return result;
        sqlContext.getMetadataProvider().connect();
        try {
            resultSet = sqlContext.getMetadataProvider().execSQL("select cast(current_catalog as varchar(255))", false);
            if (resultSet.next()) {
                result = new SQLQualifiedName(sqlContext);
                result.addName(resultSet.getString(1), true);
            }
        }
        catch (Throwable throwable) {
            try {
                if (resultSet == null) return result;
                resultSet.getStatement().close();
                resultSet.close();
                return result;
            }
            catch (Exception exception) {
                return result;
            }
            finally {
                resultSet = null;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    resultSet = null;
                    throw throwable;
                }
                catch (Exception exception) {
                    resultSet = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable2) {
                resultSet = null;
                throw throwable2;
            }
        }
        try {
            if (resultSet == null) return result;
            resultSet.getStatement().close();
            resultSet.close();
            return result;
        }
        catch (Exception exception) {
            return result;
        }
        finally {
            resultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getDefaultSchemaNamesNetezza(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        boolean result = false;
        ResultSet resultSet = null;
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            try {
                resultSet = sqlContext.getMetadataProvider().execSQL("select cast(current_schema as varchar(255))", false);
                if (resultSet != null && resultSet.next()) {
                    defaultSchemaNames.addIdentifier(resultSet.getString(1).trim());
                    result = true;
                }
            }
            catch (Exception exception) {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception2) {
                }
                finally {
                    resultSet = null;
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    resultSet = null;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSchemaListNetezza(BaseSQLContext sqlContext, SQLIdentifiersCollection schemasList, SQLQualifiedName fromDatabase) {
        boolean result = false;
        String query1 = "select schema as schema_name from %1$s.._v_schema where database=%2$s";
        String query2 = "select defschema as schema_name from _v_database where database=%1$s";
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            String databaseSql;
            String databaseString;
            if (Helpers.isQualifiedNameEmpty(fromDatabase)) {
                databaseString = "current_catalog";
                databaseSql = "";
            } else {
                databaseString = "'" + fromDatabase.getQualifiedNameWithoutQuotes() + "'";
                databaseSql = fromDatabase.getQualifiedNameForServer();
            }
            MetadataSchemasFetcherFromQuery msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            try {
                msf.setQuery(String.format("select schema as schema_name from %1$s.._v_schema where database=%2$s", databaseSql, databaseString));
                msf.setNameFieldName("schema_name");
                if (!msf.validateQuery()) {
                    boolean bl = false;
                    return bl;
                }
                msf.loadSchemas(schemasList);
                result = true;
            }
            finally {
                msf.dispose();
            }
            msf = new MetadataSchemasFetcherFromQuery(sqlContext);
            try {
                msf.setQuery(String.format("select defschema as schema_name from _v_database where database=%1$s", databaseString));
                msf.setNameFieldName("schema_name");
                if (!msf.validateQuery()) {
                    boolean bl = false;
                    return bl;
                }
                msf.loadSchemas(schemasList);
                result = true;
            }
            finally {
                msf.dispose();
            }
        }
        return result;
    }

    public static boolean loadMetadataObjectsNetezza(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            String databaseSql;
            String databaseString;
            if (Helpers.isQualifiedNameEmpty(database)) {
                databaseString = "current_catalog";
                databaseSql = "";
            } else {
                databaseString = "'" + database.getQualifiedNameWithoutQuotes() + "'";
                databaseSql = database.getQualifiedNameForServer() + "..";
            }
            MetadataObjectFetcherFromQuery mof = new MetadataObjectFetcherFromQuery(sqlContext);
            mof.setQuery(String.format("select * from %1$s_v_odbc_tables3 where table_cat=%2$s", databaseSql, databaseString));
            mof.setMetadataFilter(metadataFilter);
            mof.setSchemaFieldName("TABLE_SCHEM");
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTableType(new String[]{"TABLE"});
            mof.setSystemTableType(new String[]{"SYSTEM TABLE", "MANAGEMENT TABLE"});
            mof.setViewType(new String[]{"VIEW"});
            mof.setSystemViewType(new String[]{"SYSTEM VIEW", "MANAGEMENT VIEW"});
            mof.setDefaultObjectClass(MetadataTable.class);
            mof.setLongDescriptionFieldName("DESCRIPTION");
            if (!mof.validateQuery()) {
                return false;
            }
            mof.loadMetadata(metadataContainer, metadataFilter, database);
            return true;
        }
        return false;
    }

    public static boolean loadMetadataRelationsNetezza(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            String databaseSql;
            String databaseString;
            if (Helpers.isQualifiedNameEmpty(database)) {
                databaseString = "current_catalog";
                databaseSql = "";
            } else {
                databaseString = "'" + database.getQualifiedNameWithoutQuotes() + "'";
                databaseSql = database.getQualifiedNameForServer() + "..";
            }
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery(String.format("select * from %1$s_v_odbc_foreignkeys3 where fktable_cat=%2$s", databaseSql, databaseString));
            mrf.setPkDatabaseFieldName("PKTABLE_CAT");
            mrf.setPkSchemaFieldName("PKTABLE_SCHEM");
            mrf.setPkNameFieldName("PKTABLE_NAME");
            mrf.setPkFieldName("PKCOLUMN_NAME");
            mrf.setFkDatabaseFieldName("FKTABLE_CAT");
            mrf.setFkSchemaFieldName("FKTABLE_SCHEM");
            mrf.setFkNameFieldName("FKTABLE_NAME");
            mrf.setFkFieldName("FKCOLUMN_NAME");
            mrf.setOrdinalFieldName("key_seq");
            if (!mrf.validateQuery()) {
                return false;
            }
            mrf.loadMetadata(metadataContainer, metadataFilter, database);
            return true;
        }
        return false;
    }
}

