/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.find;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.FindToolbar;
import oracle.ide.controls.Toolbar;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;

public final class CodeEditorFindToolbarController
extends AbstractFindToolbarController {
    private final CodeEditor codeEditor;
    private final Toolbar dedicatedToolbar = new Toolbar();
    private final Toolbar sharedToolbar = new Toolbar();
    private final EditorComponentL editorComponentL;
    private final FindFocusL findFocusL = new FindFocusL();
    private boolean autoHideOptions = true;

    public CodeEditorFindToolbarController(CodeEditor codeEditor) {
        super(codeEditor.getFocusedEditorPane());
        this.codeEditor = codeEditor;
        Toolbar editorToolbar = codeEditor.getToolbar();
        FindToolbar findToolbar = this.getFindToolbar();
        this.sharedToolbar.add((Component)this.getFindAndOptionsToolbar());
        this.sharedToolbar.addFiller();
        this.sharedToolbar.addSeparator();
        this.sharedToolbar.addFiller();
        this.sharedToolbar.setBorder(null);
        editorToolbar.add((Component)this.sharedToolbar, 0);
        this.editorComponentL = new EditorComponentL(editorToolbar);
        editorToolbar.addComponentListener((ComponentListener)this.editorComponentL);
        findToolbar.getSearchField().getTextField().addFocusListener((FocusListener)this.findFocusL);
        this.getEditor().addFocusListener((FocusListener)this.findFocusL);
        this.setFindOptionsVisible(false);
        this.dedicatedToolbar.setPrimaryViewToolbar(true);
        this.getReplaceToolbar().getToolbar().setSecondaryViewToolbar(true);
        this.getReplaceToolbar().allowExtraButtons();
        this.getFindToolbarOptions().allowExtraButtons();
    }

    @Override
    public void dispose() {
        this.getFindToolbar().getSearchField().getTextField().removeFocusListener((FocusListener)this.findFocusL);
        this.getEditor().removeFocusListener((FocusListener)this.findFocusL);
        this.codeEditor.getToolbar().removeComponentListener((ComponentListener)this.editorComponentL);
        Toolbar toolbar = this.codeEditor.getToolbar();
        if (toolbar != null) {
            toolbar.remove((Component)this.getFindToolbar().getSearchField());
        }
        this.getFindToolbar().dispose();
        this.getFindToolbarOptions().dispose();
        this.getReplaceToolbar().dispose();
    }

    @Override
    public void setReplaceShowing(boolean showing) {
        super.setReplaceShowing(showing);
        Toolbar replaceToolbar = this.getReplaceToolbar().getToolbar();
        if (showing) {
            this.setFindShowing(true);
            ((JComponent)this.codeEditor.getFixedTopMargin()).add((Component)replaceToolbar);
            this.setFindOptionsVisible(true);
        } else {
            if (replaceToolbar.getParent() != null) {
                replaceToolbar.getParent().remove((Component)replaceToolbar);
            }
            if (this.codeEditor.getFocusedEditorPane().hasFocus() && this.autoHideOptions) {
                this.setFindOptionsVisible(false);
            }
        }
        this.codeEditor.getFixedTopMargin().revalidate();
    }

    @Override
    public void updateVisibleActions() {
        this.codeEditor.updateVisibleActions();
        super.updateVisibleActions();
    }

    @Override
    public boolean isReplaceShowing() {
        return this.getReplaceToolbar().getToolbar().getParent() != null;
    }

    @Override
    public void setFindShowing(boolean showing) {
        if (showing) {
            if (!this.isFindShowing() && !this.codeEditor.getToolbar().isShowing()) {
                Toolbar findandOptionsToolbar = this.getFindAndOptionsToolbar();
                this.dedicatedToolbar.add((Component)findandOptionsToolbar);
                ((JComponent)this.codeEditor.getFixedTopMargin()).add((Component)this.dedicatedToolbar);
                this.setFindOptionsVisible(true);
                this.codeEditor.getFixedTopMargin().revalidate();
                this.autoHideOptions = false;
            }
            this.getFindToolbar().getSearchField().requestFocus();
        } else {
            if (this.dedicatedToolbar.isShowing() && this.dedicatedToolbar.getParent() != null) {
                this.dedicatedToolbar.getParent().remove((Component)this.dedicatedToolbar);
            }
            this.setReplaceShowing(false);
        }
        this.codeEditor.getFixedTopMargin().revalidate();
    }

    @Override
    public boolean isFindShowing() {
        return this.getFindAndOptionsToolbar().isShowing();
    }

    private void setFindOptionsVisible(boolean visible) {
        if (!visible && !this.autoHideOptions) {
            return;
        }
        if (!visible && this.isReplaceShowing()) {
            return;
        }
        this.getFindToolbarOptions().getOptionsComponent().setVisible(visible);
    }

    @Override
    public void navigate(int start, int length) {
        OffsetNavigationPoint point = new OffsetNavigationPoint(this.codeEditor.getContext(), start, length);
        try {
            NavigationManager navMan = NavigationManager.getNavigationManager();
            if (navMan != null) {
                navMan.navigateTo((NavigationPoint)point);
            } else {
                super.navigate(start, length);
            }
        }
        catch (Exception e) {
            Logger.getLogger("global").log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private class FindFocusL
    implements FocusListener {
        private FindFocusL() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == CodeEditorFindToolbarController.this.getFindToolbar().getSearchField().getTextField()) {
                CodeEditorFindToolbarController.this.setFindOptionsVisible(true);
            } else if (e.getSource() == CodeEditorFindToolbarController.this.getEditor()) {
                CodeEditorFindToolbarController.this.setFindOptionsVisible(false);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class EditorComponentL
    extends ComponentAdapter {
        final Toolbar editorToolbar;

        EditorComponentL(Toolbar editorToolbar) {
            this.editorToolbar = editorToolbar;
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (CodeEditorFindToolbarController.this.dedicatedToolbar.getParent() != null) {
                CodeEditorFindToolbarController.this.dedicatedToolbar.getParent().remove((Component)CodeEditorFindToolbarController.this.dedicatedToolbar);
            }
            if (CodeEditorFindToolbarController.this.sharedToolbar.getParent() == null) {
                this.editorToolbar.add((Component)CodeEditorFindToolbarController.this.sharedToolbar, 0);
            }
            CodeEditorFindToolbarController.this.sharedToolbar.add((Component)CodeEditorFindToolbarController.this.getFindAndOptionsToolbar(), 0);
            CodeEditorFindToolbarController.this.autoHideOptions = true;
            CodeEditorFindToolbarController.this.setFindOptionsVisible(CodeEditorFindToolbarController.this.getFindToolbar().getSearchField().hasFocus());
            CodeEditorFindToolbarController.this.codeEditor.getFixedTopMargin().revalidate();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            CodeEditorFindToolbarController.this.setReplaceShowing(false);
        }
    }
}

