/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.exports.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DDLConfig {
    public static final String DDL_SELECTION_LIST = "DDLSelection.local";
    public static final String PERSISTED_DDL_SELECTION = "DatamodelerPersistedDDLSelection";
    public static final String SELECTED_SUBVIEW = "selectedSubView";
    public static final String INCLUDE_COMMENTS = "IncludeComments";
    public static final String GENERATE_DDL_IN_FILES = "generateDDLInFiles";
    public static final String GENERATE_REST_SERVICES = "generateRESTServices";
    public static final String APPLY_NAME_SUBSTITUTION = "applyNameSubstitution";
    public static final String INCLUDE_TABLE_SCRIPTS = "includeTableScripts";
    public static final String TABLE_SCRIPT = "tableScript";
    public static final String TABLE_NAME = "tableName";
    public static final String SD_OBJECT = "storageDesignObject";
    public static final String SD_CLASS = "storageDesignClass";
    public static final String SD_NAME = "storageDesignName";
    public static final String DROP_SELECTION = "dropSelection";
    public static final String DROP_GENERATED_OBJECTS_ONLY = "dropGeneratedObjectsOnly";
    public static final String USE_DROP_DEPENDENCIES = "useDropDependencies";
    public static final String DROPABLE_OBJECT = "dropableObject";
    public static final String ACTIVE_SCRIPT_SET_CB_INDEX = "activeScriptSetCBIndex";
    public static final String SELECTED_INDEX = "selectedIndex";
    public static final String NAMES_SUBSTITUTION = "namesSubstitution";
    public static final String NAME_SUBSTITUTION = "nameSubstitution";
    public static final String IS_CASE_SENSITIVE = "isCaseSensitive";
    public static final String OLD_NAME = "oldName";
    public static final String NEW_NAME = "newName";
    public static final String COMMENTS = "comments";
    public static final String TYPE = "type";
    public static final String KEY = "OSDDM_DDLPP";
    public static final String USE_DDL_TRANSFORMATION_SCRIPT = "UseDDLTransformationScript";
    public static final String TABLE_COLUMN = "tableColumn";
    public static final String COLUMN_ID = "columnID";
    public static final String CONSTRAINT_MARKED_GENERATE = "constraintMarkedGenerate";
    public static final String TABLE_LEVEL_CONSTRAINT = "tableLevelConstraint";
    public static final String EXISTENCE_DEPENDENCY = "existenceDependency";
    public static final String EXISTENCE_DEPENDENCY_NAME = "existenceDependencyName";
    public static final String MARKED_GENERATE = "markedGenerate";
    public static final String FK_DEP_COLUMN_CONSTRAINT_IN_DDL = "dependantColConstrInDDL";
    public static final String CONSTRAINT_NAME = "constraintName";
    public static final String OBJECT = "object";
    public static final String OBJECT_TYPE = "objectType";
    public static final String OBJECT_ID = "objectID";
    public static final String OBJECT_NAME = "name";
    public static final String SEQ_NAME = "seqName";
    public static final String PROPERTY_CLASSNAME = "propertyClassName";
    public static final String PROPERTY_PARENTID = "propertyParentId";
    public static final String PROPERTY_SOURCEID = "propertySourceId";
    public static final String PROPERTY_TARGETID = "propertyTargetId";
    public static final String CONTAINER_ID = "containerID";
    public static final String REF_CONTAINER_ID = "refContainerID";
    public static final String DIAGRAM_LIST = "Diagrams.local";
    public static final String VISIBLE = "visible";
    public static final String TRUE = "true";

    public static void loadConfig(String fileName, RelationalDesign relModel) throws Exception {
        Design design = relModel.getDesign();
        DesignLevelSettings settings = design.getDesignLevelSettings();
        Document doc = null;
        if (fileName.endsWith(".xmlz")) {
            doc = XMLTransformationManager.getDocument(new File(fileName));
        } else {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            File file = new File(fileName);
            if (file.exists()) {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                doc = db.parse(new InputSource(reader));
                reader.close();
            }
        }
        if (doc != null) {
            Element node;
            int i;
            NodeList nodeList = doc.getElementsByTagName(PERSISTED_DDL_SELECTION);
            if (nodeList.getLength() == 0) {
                throw new Exception(MessageFormat.format(Messages.getString("DDLConfig.NotADDLSelectionFile"), fileName));
            }
            Element node2 = (Element)nodeList.item(0);
            if (!design.getObjectID().equals(node2.getAttribute(OBJECT_ID))) {
                throw new Exception(MessageFormat.format(Messages.getString("DDLConfig.NotADDLSelectionForThisDesign"), fileName));
            }
            nodeList = doc.getElementsByTagName(INCLUDE_COMMENTS);
            boolean includeComments = false;
            if (nodeList.getLength() > 0) {
                Element node3 = (Element)nodeList.item(0);
                includeComments = Boolean.parseBoolean(node3.getAttribute("isSelected"));
            }
            DDLGenerationOptions.setIncludeComments(includeComments);
            nodeList = doc.getElementsByTagName(APPLY_NAME_SUBSTITUTION);
            boolean applyNameSubstitution = false;
            if (nodeList.getLength() > 0) {
                Element node4 = (Element)nodeList.item(0);
                applyNameSubstitution = Boolean.parseBoolean(node4.getAttribute("isSelected"));
            }
            design.setApplyNameSubstitution(applyNameSubstitution);
            nodeList = doc.getElementsByTagName(GENERATE_DDL_IN_FILES);
            boolean generateDDLInFiles = false;
            if (nodeList.getLength() > 0) {
                Element node5 = (Element)nodeList.item(0);
                generateDDLInFiles = Boolean.parseBoolean(node5.getAttribute("isSelected"));
            }
            DDLGenerationOptions.setGenerateDDLInFiles(generateDDLInFiles);
            nodeList = doc.getElementsByTagName(GENERATE_REST_SERVICES);
            boolean generateRESTServices = false;
            if (nodeList.getLength() > 0) {
                Element node6 = (Element)nodeList.item(0);
                generateRESTServices = Boolean.parseBoolean(node6.getAttribute("isSelected"));
            }
            DDLGenerationOptions.setGenerateRESTServices(generateRESTServices);
            nodeList = doc.getElementsByTagName(DROP_GENERATED_OBJECTS_ONLY);
            boolean dropGeneratedObjectsOnly = false;
            if (nodeList.getLength() > 0) {
                Element node7 = (Element)nodeList.item(0);
                dropGeneratedObjectsOnly = Boolean.parseBoolean(node7.getAttribute("isSelected"));
            }
            Design.DROP_GENERATED_OBJECTS_ONLY = dropGeneratedObjectsOnly;
            nodeList = doc.getElementsByTagName(USE_DROP_DEPENDENCIES);
            boolean useDropDependencies = false;
            if (nodeList.getLength() > 0) {
                Element node8 = (Element)nodeList.item(0);
                useDropDependencies = Boolean.parseBoolean(node8.getAttribute("isSelected"));
            }
            Design.USE_DROP_DEPENDENCY = useDropDependencies;
            nodeList = doc.getElementsByTagName(TABLE_SCRIPT);
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = (Element)nodeList.item(i);
                String tableName = node.getAttribute(TABLE_NAME);
                boolean isSelected = Boolean.valueOf(node.getAttribute("isSelected"));
                Iterator it = relModel.getTableSet().iterator();
                while (it.hasNext()) {
                    Table table = (Table)it.next();
                    if (!table.getLongName().equalsIgnoreCase(tableName)) continue;
                    table.setShouldGenerateScript(isSelected);
                }
            }
            nodeList = doc.getElementsByTagName(NAME_SUBSTITUTION);
            settings.getSubstitutionList().clear();
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = (Element)nodeList.item(i);
                boolean isSelected = Boolean.valueOf(node.getAttribute("isSelected"));
                boolean isCaseSensitive = Boolean.valueOf(node.getAttribute(IS_CASE_SENSITIVE));
                String oldName = node.getAttribute(OLD_NAME);
                String newName = node.getAttribute(NEW_NAME);
                String comments = node.getAttribute(COMMENTS);
                SubstitutionPattern sp = new SubstitutionPattern(oldName, newName, isSelected, isCaseSensitive, comments);
                settings.getSubstitutionList().add(sp);
            }
            nodeList = doc.getElementsByTagName(OBJECT_TYPE);
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = (Element)nodeList.item(i);
                boolean isSelected = Boolean.valueOf(node.getAttribute("isSelected"));
                String objType = node.getAttribute(TYPE);
                StorageDesign.ObjectType obj = (StorageDesign.ObjectType)relModel.getStorageDesign().getNameSubstituionTypes().get(objType);
                if (obj == null) continue;
                obj.setSelected(isSelected);
            }
            design.getSettings().setGenerateTypeSubstTriggers(DDLConfig.loadDDLPPSetting(doc, "type_subst_triggers"));
            design.getSettings().setGenerateFKArcTriggers(DDLConfig.loadDDLPPSetting(doc, "fkarct_triggers"));
            design.getSettings().setGenerateFKNoneTransferableTriggers(DDLConfig.loadDDLPPSetting(doc, "fk_none_transferable_triggers"));
            design.getSettings().setShowByteCharInDDL(DDLConfig.loadDDLPPSetting(doc, "show_char_byte_in_ddl"));
            design.getSettings().setExtendedSizeForCharacters(DDLConfig.loadDDLPPSetting(doc, "extended_size_for_chars"));
            design.getSettings().setNotNullShortFormGeneration(DDLConfig.loadDDLPPSetting(doc, "not_null_short_form_generation"));
            design.getSettings().setUseQuotedIdentifiers(DDLConfig.loadDDLPPSetting(doc, "use_quoted_identifiers"));
            design.getSettings().setCreateDomainsDuringImport(DDLConfig.loadDDLPPSetting(doc, "create_domains_during_import"));
            design.getSettings().setGenerateCommentsInRDBMS(DDLConfig.loadDDLPPSetting(doc, "generate_comments_in_rdbms"));
            design.getSettings().setGenerateInlineColumnCC(DDLConfig.loadDDLPPSetting(doc, "generate_inline_column_cc"));
            design.getSettings().setGenerateValidValueCC(DDLConfig.loadDDLPPSetting(doc, "generate_valid_value_cc"));
            design.getSettings().setIncludeDefaultSettingsInDDL(DDLConfig.loadDDLPPSetting(doc, "include_default_settings_in_ddl"));
            design.getSettings().setIncludeLoggingInDDL(DDLConfig.loadDDLPPSetting(doc, "include_logging_in_ddl"));
            design.getSettings().setIncludeSchemaInDDL(DDLConfig.loadDDLPPSetting(doc, "include_schema_in_ddl"));
            design.getSettings().setIncludeStorageInDDL(DDLConfig.loadDDLPPSetting(doc, "include_storage_in_ddl"));
            design.getSettings().setIncludeTablespaceInDDL(DDLConfig.loadDDLPPSetting(doc, "include_tablespace_in_ddl"));
            design.getSettings().setIncludeRedactionInDDL(DDLConfig.loadDDLPPSetting(doc, "include_redaction_in_ddl"));
            design.getSettings().setIncludeTSDPInDDL(DDLConfig.loadDDLPPSetting(doc, "include_tsdp_in_ddl"));
            design.getDesignLevelSettings().setAutomaticPKGeneration(DDLConfig.loadDDLPPSetting(doc, "automatic_pk_generation"));
            design.getDesignLevelSettings().setAutomaticUKGeneration(DDLConfig.loadDDLPPSetting(doc, "automatic_uk_generation"));
            design.getDesignLevelSettings().setAutomaticFKGeneration(DDLConfig.loadDDLPPSetting(doc, "automatic_fk_generation"));
            design.getSettings().setIncludePctFreeInDDL(DDLConfig.loadDDLPPSetting(doc, "include_pctfree_in_ddl"));
            design.getSettings().setIncludePctUsedInDDL(DDLConfig.loadDDLPPSetting(doc, "include_pctused_in_ddl"));
            design.getSettings().setIncludeInitransInDDL(DDLConfig.loadDDLPPSetting(doc, "include_initrans_in_ddl"));
            design.getSettings().setIncludeInitialExtentInDDL(DDLConfig.loadDDLPPSetting(doc, "include_initialextent_in_ddl"));
            design.getSettings().setIncludeNextExtentInDDL(DDLConfig.loadDDLPPSetting(doc, "include_nextextent_in_ddl"));
            design.getSettings().setIncludeMinExtentsInDDL(DDLConfig.loadDDLPPSetting(doc, "include_minextents_in_ddl"));
            design.getSettings().setIncludeMaxExtentsInDDL(DDLConfig.loadDDLPPSetting(doc, "include_maxextents_in_ddl"));
            design.getSettings().setIncludePctIncreaseInDDL(DDLConfig.loadDDLPPSetting(doc, "include_pctincrease_in_ddl"));
            design.getSettings().setIncludeBufferPoolInDDL(DDLConfig.loadDDLPPSetting(doc, "include_bufferpool_in_ddl"));
            design.getSettings().setIncludeFreeListsInDDL(DDLConfig.loadDDLPPSetting(doc, "include_freelists_in_ddl"));
            design.getSettings().setIncludeFreeListGroupsInDDL(DDLConfig.loadDDLPPSetting(doc, "include_freelistgroups_in_ddl"));
            design.getSettings().setIncludeOptimalInDDL(DDLConfig.loadDDLPPSetting(doc, "include_optimal_in_ddl"));
            design.getSettings().setIncludeEncryptionInDDL(DDLConfig.loadDDLPPSetting(doc, "include_encryption_in_ddl"));
            nodeList = doc.getElementsByTagName(DROPABLE_OBJECT);
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = (Element)nodeList.item(i);
                String name = node.getAttribute(OBJECT_NAME);
                boolean isSelected = Boolean.valueOf(node.getAttribute("isSelected"));
                List list = null;
                list = relModel.getStorageDesign().isOpen() ? relModel.getStorageDesign().getDropableSets() : relModel.getDropableSets();
                for (ModelObject obj : list) {
                    if (!obj.getName().equalsIgnoreCase(name)) continue;
                    Iterator dit = null;
                    if (obj instanceof ModelIDObjectSet) {
                        dit = ((ModelIDObjectSet)obj).iterator();
                    } else if (obj instanceof DesignObjectSet) {
                        dit = ((DesignObjectSet)obj).iterator();
                    } else if (obj instanceof RelationalObjectProxySet) {
                        dit = ((RelationalObjectProxySet)obj).iterator();
                    }
                    if (dit == null) continue;
                    while (dit.hasNext()) {
                        ModelIDObject mo = (ModelIDObject)dit.next();
                        mo.setDropEnabled(isSelected);
                    }
                }
            }
            nodeList = doc.getElementsByTagName(OBJECT);
            for (i = 0; i < nodeList.getLength(); ++i) {
                node = (Element)nodeList.item(i);
                DesignObject obj = design.getDesignObject(node.getAttribute(OBJECT_ID));
                if (obj instanceof Table) {
                    Table table = (Table)obj;
                    String useDDLTransformationScript = node.getAttribute(USE_DDL_TRANSFORMATION_SCRIPT);
                    if (useDDLTransformationScript != null && !useDDLTransformationScript.isEmpty()) {
                        table.setUseDDLTransformationScript(Boolean.valueOf(useDDLTransformationScript));
                    }
                    ColumnSet tcs = table.getColumnSet();
                    NodeList tableColumnList = node.getElementsByTagName(TABLE_COLUMN);
                    for (int ic = 0; ic < tableColumnList.getLength(); ++ic) {
                        Element columnNode = (Element)tableColumnList.item(ic);
                        DDLConfig.setColumnGenerateConstraintInDDL(table.getObjectID(), tcs, columnNode.getAttribute(COLUMN_ID), columnNode.getAttribute(CONSTRAINT_MARKED_GENERATE));
                    }
                    NodeList tableLevelConstraintsList = node.getElementsByTagName(TABLE_LEVEL_CONSTRAINT);
                    for (int tc = 0; tc < tableLevelConstraintsList.getLength(); ++tc) {
                        Element tableLevelConstraintNode = (Element)tableLevelConstraintsList.item(tc);
                        DDLConfig.setTableLevelGenerateConstraintInDDL(table, tableLevelConstraintNode);
                    }
                    NodeList existanceDepenndanciesList = node.getElementsByTagName(EXISTENCE_DEPENDENCY);
                    for (int tc = 0; tc < existanceDepenndanciesList.getLength(); ++tc) {
                        Element existanceDepenndancyNode = (Element)existanceDepenndanciesList.item(tc);
                        if (!table.getExistDependencyConstraintName().equals(existanceDepenndancyNode.getAttribute(EXISTENCE_DEPENDENCY_NAME))) continue;
                        if (Boolean.valueOf(existanceDepenndancyNode.getAttribute(MARKED_GENERATE)).booleanValue()) {
                            table.setExistDependencyGenerateInDDl(true);
                            continue;
                        }
                        table.setExistDependencyGenerateInDDl(false);
                    }
                    continue;
                }
                if (!(obj instanceof FKIndexAssociation)) continue;
                ((FKIndexAssociation)obj).setColumnDependencyConstraintGenerateInDDL(Boolean.valueOf(node.getAttribute(FK_DEP_COLUMN_CONSTRAINT_IN_DDL)));
            }
            StorageDesign[] storageDesigns = relModel.getStorageDesignFactory().getOpenStorageDesigns();
            for (int i2 = 0; i2 < storageDesigns.length; ++i2) {
                StorageDesign storageDesign = storageDesigns[i2];
                if (!storageDesign.isOpen()) continue;
                DDLConfig.restoreDDLSelection(storageDesign, doc);
            }
        }
    }

    private static boolean loadDDLPPSetting(Document doc, String elementName) {
        int i = 0;
        NodeList nodeList = doc.getElementsByTagName(elementName);
        if (i < nodeList.getLength()) {
            Element node = (Element)nodeList.item(i);
            return Boolean.valueOf(node.getAttribute("isSelected"));
        }
        return false;
    }

    private static void setColumnGenerateConstraintInDDL(String tableObjectID, ColumnSet tcs, String columnID, String GenerateConstraintInDDL) {
        for (int i = 0; i < tcs.size(); ++i) {
            Column column = (Column)tcs.getElement(i);
            if (!column.getTable().getObjectID().equalsIgnoreCase(tableObjectID) || !column.getObjectID().equals(columnID)) continue;
            if (GenerateConstraintInDDL.equalsIgnoreCase("yes")) {
                column.setGenerateConstraintInDDL(true);
            } else {
                column.setGenerateConstraintInDDL(false);
            }
            return;
        }
    }

    private static void setTableLevelGenerateConstraintInDDL(Table table, Element tableLevelConstraintNode) {
        List tlcc = table.getCheckConstraints();
        if (tlcc == null) {
            return;
        }
        if (tlcc.size() > 0) {
            for (TableLevelConstraint tc : tlcc) {
                if (!tc.getName().equals(tableLevelConstraintNode.getAttribute(CONSTRAINT_NAME))) continue;
                if (tableLevelConstraintNode.getAttribute(MARKED_GENERATE).equalsIgnoreCase("yes")) {
                    tc.setGenerateInDDL(true);
                } else {
                    tc.setGenerateInDDL(false);
                }
                return;
            }
        }
    }

    private static List getObjects(Document doc) {
        ArrayList<XMLTransformationManager.ObjectHelper> list = new ArrayList<XMLTransformationManager.ObjectHelper>();
        NodeList nodeList = doc.getElementsByTagName(OBJECT);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element node = (Element)nodeList.item(i);
            XMLTransformationManager.ObjectHelper helper = new XMLTransformationManager.ObjectHelper();
            helper.type = node.getAttribute(OBJECT_TYPE);
            helper.id = node.getAttribute(OBJECT_ID);
            helper.markedGenerate = Boolean.valueOf(node.getAttribute(MARKED_GENERATE));
            helper.name = StringUtilities.decodeAttributeValue(node.getAttribute(OBJECT_NAME));
            helper.seq_name = node.getAttribute(SEQ_NAME);
            helper.propertyClassname = node.getAttribute(PROPERTY_CLASSNAME);
            helper.propertyParentid = node.getAttribute(PROPERTY_PARENTID);
            helper.propertySourceid = node.getAttribute(PROPERTY_SOURCEID);
            helper.propertyTargetid = node.getAttribute(PROPERTY_TARGETID);
            if ("FKIndexAssociation".equals(helper.type)) {
                helper.contID = node.getAttribute(CONTAINER_ID);
                helper.refContID = node.getAttribute(REF_CONTAINER_ID);
            }
            list.add(helper);
        }
        return list;
    }

    private static void restoreDDLSelection(StorageDesign storageDesign, Document doc) {
        List markedGenerateObjects = DDLConfig.getObjects(doc);
        for (XMLTransformationManager.ObjectHelper markedGenerateObject : markedGenerateObjects) {
            ModelIDObject object = storageDesign.getModelIDObject(markedGenerateObject.id);
            if (object == null) continue;
            if (markedGenerateObject.type.equals("Package Body")) {
                PackageBodyOracle pbo = ((PackageOracle)object).getBody();
                if (pbo == null) continue;
                pbo.setMarkedGenerate(markedGenerateObject.markedGenerate);
                continue;
            }
            object.setMarkedGenerate(markedGenerateObject.markedGenerate);
        }
    }

    public static void restoreDDLSelection(StorageDesign storageDesign) {
        List<XMLTransformationManager.ObjectHelper> notMarkedGenerateObjects = XMLTransformationManager.getObjects(storageDesign.getStoragePath(), DDL_SELECTION_LIST, storageDesign.getDesign().isCompressedDesign());
        for (XMLTransformationManager.ObjectHelper notMarkedGenerateObject : notMarkedGenerateObjects) {
            ModelIDObject object = storageDesign.getModelIDObject(notMarkedGenerateObject.id);
            if (object == null) continue;
            object.setMarkedGenerate(false);
        }
    }

    public static void restoreDDLSelection(DesignPart designPart) {
        Design design = designPart.getDesign();
        List<XMLTransformationManager.ObjectHelper> markedGenerateObjects = XMLTransformationManager.getObjects(designPart.getStoragePath(), DDL_SELECTION_LIST, design.isCompressedDesign());
        for (XMLTransformationManager.ObjectHelper markedGenerateObject : markedGenerateObjects) {
            DesignObject designObject = design.getDesignObject(markedGenerateObject.id);
            if (designObject == null) continue;
            designObject.setMarkedGenerate(markedGenerateObject.markedGenerate);
        }
    }
}

