/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.util.string.ToStringComparator;

public abstract class ModelObjectSet
extends ModelObject
implements ElementSet,
Iterable {
    public static final Comparator TOSTRING_COMPARATOR = new ToStringComparator();
    public static final Comparator NAME_COMPARATOR = new NameComparator();
    public static final Comparator NAME_IGNORE_CASE_COMPARATOR = new NameIgnoreCaseComparator();
    public static final Comparator LONG_NAME_COMPARATOR = new LongNameComparator();
    public static final Comparator UPPERCASE_NAME_COMPARATOR = new UpperCaseNameComparator();
    protected int count = 1;
    protected List elements = new ArrayList();
    private Set listeners = new HashSet();
    private int maxIndex = 0;

    public Comparator getElementSorter() {
        return TOSTRING_COMPARATOR;
    }

    public void add(ModelObject object) {
        this.elements.add(object);
        if (object.getName() == null || object.getName().equals("")) {
            while (!object.setName(this.createName())) {
            }
        }
        this.doAdd();
        int childIndex = -1;
        this.fireAdded(object, childIndex);
    }

    public void doAdd() {
    }

    public boolean remove(ModelObject object) {
        int i = this.elements.indexOf(object);
        i = -1;
        boolean result = this.elements.remove(object);
        if (result) {
            this.fireRemoved(object, i);
        }
        return result;
    }

    public boolean moveElementToIndex(ModelObject object, int index) {
        if (this.elements.contains(object) && this.elements.size() > index && index >= 0) {
            this.elements.remove(object);
            this.elements.add(index, object);
            return true;
        }
        return false;
    }

    public void removeAll() {
        ModelObject[] mos = (ModelObject[])this.toArray();
        for (int i = 0; i < mos.length; ++i) {
            this.remove(mos[i]);
        }
    }

    @Override
    public boolean contains(ModelObject object) {
        return this.elements.contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray(this.getProtoTypeArray());
    }

    public List getElementsList() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public Iterator iterator() {
        return this.getElementsList().iterator();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public abstract Object[] getProtoTypeArray();

    public void addSetListener(ModelObjectSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeSetListener(ModelObjectSetListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAdded(ModelObject affected, int childIndex) {
        this.fireChange(affected, 1, childIndex);
    }

    protected void fireRemoved(ModelObject affected, int childIndex) {
        this.fireChange(affected, 0, childIndex);
    }

    public void fireObjectStarusChanged(ModelObject affected) {
        int index = this.elements.indexOf(affected);
        if (index > -1) {
            this.fireChange(affected, 2, index);
        }
    }

    protected void fireChange(ModelObject affected, int type, int childIndex) {
        Iterator it = this.listeners.iterator();
        ModelObjectSetEvent event = new ModelObjectSetEvent(affected, type);
        event.childIndex = childIndex;
        while (it.hasNext()) {
            ((ModelObjectSetListener)it.next()).changed(this, event);
        }
    }

    public abstract String getDefaultNamePrefix();

    public String getSeparator() {
        return "_";
    }

    public boolean containsName(String name) {
        for (ModelObject mo : this.elements) {
            if (!name.equalsIgnoreCase(mo.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ModelObject getByName(String name) {
        if (name != null) {
            String trimedName = name.trim();
            for (ModelObject mo : this.elements) {
                if (mo.getName() == null || !mo.getName().trim().equalsIgnoreCase(trimedName)) continue;
                return mo;
            }
        }
        return null;
    }

    public boolean notContainsName(String name) {
        return !this.containsName(name);
    }

    public boolean containsLongName(String name) {
        for (ModelObject mo : this.elements) {
            if (!name.equalsIgnoreCase(mo.getLongName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsLongName(ModelObject object, String name) {
        for (ModelObject mo : this.elements) {
            if (object == mo || !name.equalsIgnoreCase(mo.getLongName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsName(ModelObject object, String name) {
        for (ModelObject mo : this.elements) {
            if (object == mo || !name.equalsIgnoreCase(mo.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean notContainsLongName(String name) {
        return !this.containsLongName(name);
    }

    public Class getElementClass() {
        return this.getProtoTypeArray().getClass().getComponentType();
    }

    protected String createName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        while (this.containsName(buffer.toString() + String.valueOf(this.count))) {
            ++this.count;
        }
        buffer.append(this.count++);
        return buffer.toString();
    }

    protected void setNameCounter(int value) {
        this.count = value;
    }

    public void resetCounter() {
        this.count = 1;
    }

    protected void nameCounterDecrement() {
        --this.count;
    }

    public ModelObject getElement(int index) {
        return (ModelObject)this.elements.get(index);
    }

    public int getIndexOf(ModelObject child) {
        return this.elements.indexOf(child);
    }

    @Override
    public int getNumberOfChildren() {
        return this.size();
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.getIndexOf(child);
    }

    @Override
    public ModelObject getChild(int index) {
        return this.getElement(index);
    }

    @Override
    public boolean isLeaf() {
        return this.size() <= 0;
    }

    @Override
    public boolean isObjectCollection() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(DesignObject object) {
        return this.getObjectGeneratedBy(object.getObjectID());
    }

    @Override
    public ModelIDObject getObjectGeneratedBy(String generatorID) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ModelIDObject object = (ModelIDObject)it.next();
            if (!generatorID.equals(object.getGeneratorID())) continue;
            it = null;
            return object;
        }
        it = null;
        return null;
    }

    @Override
    public ModelIDObject getObjectByID(String objectID) {
        for (ModelIDObject object : this.elements) {
            if (!objectID.equals(object.getObjectID())) continue;
            return object;
        }
        return null;
    }

    @Override
    public Collection getObjectsGeneratedBy(String generatorId, Collection collection) {
        for (DesignObject object : this) {
            if (!generatorId.equals(object.getGeneratorID())) continue;
            collection.add(object);
        }
        return collection;
    }

    @Override
    public void addAllElementsTo(Collection collection) {
        collection.addAll(this.elements);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (super.getName() != null && !super.getName().trim().equalsIgnoreCase("")) {
            return super.getName();
        }
        return this.getDefaultNamePrefix();
    }

    public DesignObject[] getProtoArray() {
        return (DesignObject[])this.getProtoTypeArray();
    }

    public void sortByLongName() {
        Collections.sort(this.elements, LONG_NAME_COMPARATOR);
    }

    public void sortByName() {
        Collections.sort(this.elements, NAME_COMPARATOR);
    }

    public void updateMaxIndex(int index) {
        this.maxIndex = Math.max(this.maxIndex, index);
    }

    public int nextIndex() {
        return ++this.maxIndex;
    }

    @Override
    public boolean canSort() {
        return false;
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, NAME_COMPARATOR);
    }

    static class UpperCaseNameComparator
    implements Comparator {
        UpperCaseNameComparator() {
        }

        public int compare(Object one, Object two) {
            return ((LongNameObject)one).getName().toUpperCase().compareTo(((LongNameObject)two).getName().toUpperCase());
        }
    }

    static class LongNameComparator
    implements Comparator {
        LongNameComparator() {
        }

        public int compare(Object one, Object two) {
            return ((LongNameObject)one).getLongName().compareTo(((LongNameObject)two).getLongName());
        }
    }

    static class NameIgnoreCaseComparator
    implements Comparator {
        NameIgnoreCaseComparator() {
        }

        public int compare(Object one, Object two) {
            return ((LongNameObject)one).getName().compareToIgnoreCase(((LongNameObject)two).getName());
        }
    }

    static class NameComparator
    implements Comparator {
        NameComparator() {
        }

        public int compare(Object one, Object two) {
            return ((LongNameObject)one).getName().compareTo(((LongNameObject)two).getName());
        }
    }
}

