/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerFileWatcher;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class CSSBSchedulerFileWatcher
extends CSSBScheduler {
    Map<String, String> excludeNullsMap = new HashMap<String, String>();

    public CSSBSchedulerFileWatcher() {
        this.excludeNullsMap.put("OWNER", "OWNER");
        this.excludeNullsMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeNullsMap.put("DIRECTORY_PATH", "DIRECTORY_PATH");
        this.excludeNullsMap.put("FILE_NAME", "FILE_NAME");
        this.excludeNullsMap.put("CREDENTIAL_OWNER", "CREDENTIAL_OWNER");
        this.excludeNullsMap.put("CREDENTIAL_NAME", "CREDENTIAL_NAME");
        this.excludeNullsMap.put("DESTINATION", "DESTINATION");
        this.excludeNullsMap.put("DESTINATION_OWNER", "DESTINATION_OWNER");
        this.excludeNullsMap.put("ENABLED", "ENABLED");
        this.excludeNullsMap.put("MIN_FILE_SIZE", "MIN_FILE_SIZE");
    }

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeMap.put("CREDENTIAL_OWNER", "CREDENTIAL_OWNER");
        this.excludeMap.put("CREDENTIAL_NAME", "CREDENTIAL_NAME");
        this.excludeMap.put("DESTINATION", "DESTINATION");
        this.excludeMap.put("DESTINATION_OWNER", "DESTINATION_OWNER");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SchedulerObjectCompare comp;
        if (object instanceof SchedulerObjectCompare && (comp = (SchedulerObjectCompare)object).isModified()) {
            Map<String, String> excludeMap = this.getExcludeMap();
            StringBuffer buffer = new StringBuffer();
            CSSBSchedulerFileWatcher.appendStringWithSpace(buffer, "BEGIN");
            CSSBSchedulerFileWatcher.appendNullAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerFileWatcher.appendDestination(buffer, comp, prettyPrint);
            CSSBSchedulerFileWatcher.appendCredential(buffer, comp, prettyPrint);
            CSSBSchedulerFileWatcher.appendAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerFileWatcher.appendEnable(buffer, comp, false, prettyPrint);
            CSSBSchedulerFileWatcher.appendNewLine(buffer, prettyPrint, 0);
            CSSBSchedulerFileWatcher.appendString(buffer, "END");
            CSSBSchedulerFileWatcher.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, "");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerObjectCompare && ((SchedulerObjectCompare)object).getSource() instanceof SchedulerFileWatcher;
    }
}

