/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.date;

import com.ibm.icu.util.ULocale;
import ilog.views.util.swing.date.DateCellEditorPopupMenu;
import ilog.views.util.text.IlvDateFormatFactory;
import ilog.views.util.text.internal.IlvFormatUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicArrowButton;

class DateEditorDropDown
extends JComponent {
    static final String a = "StopEdition";
    static final String b = "CancelEdition";
    protected ULocale locale;
    protected JTextField dateField;
    protected JButton arrowButton;
    protected DateCellEditorPopupMenu popup;
    protected FormattedDatePropertyEditor propertyEditor;
    protected Object currentDate;
    protected FocusListener focusListener;
    static String c = "DateProperty";

    public DateEditorDropDown(ULocale uLocale) {
        this.locale = uLocale;
        this.propertyEditor = new FormattedDatePropertyEditor(uLocale);
        this.installComponents();
        this.installListeners();
    }

    public ULocale getULocale() {
        return this.locale;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.propertyEditor.setFormat(dateFormat);
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.popup.setTimeFormat(dateFormat);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dateField.setEnabled(bl);
        this.arrowButton.setVisible(bl);
    }

    public JComponent getEditorComponent() {
        return this.dateField;
    }

    protected void installComponents() {
        this.setLayout(new BorderLayout());
        this.popup = new DateCellEditorPopupMenu(this);
        this.dateField = new JTextField();
        this.dateField.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.dateField, "Center");
        this.arrowButton = new BasicArrowButton(5);
        if (this.getComponentOrientation().isLeftToRight()) {
            this.add((Component)this.arrowButton, "East");
        } else {
            this.add((Component)this.arrowButton, "West");
        }
        this.a();
    }

    protected void installListeners() {
        this.installFocusListener();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && DateEditorDropDown.this.isEnabled()) {
                    DateEditorDropDown.this.a(mouseEvent);
                    DateEditorDropDown.this.b();
                }
            }
        };
        this.arrowButton.addMouseListener(mouseAdapter);
        this.propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = DateEditorDropDown.this.propertyEditor.getValue();
                if (DateEditorDropDown.this.currentDate != null && DateEditorDropDown.this.currentDate.equals(object)) {
                    return;
                }
                DateEditorDropDown.this.currentDate = object;
                DateEditorDropDown.this.e();
            }
        });
        this.installActionListener();
        this.installAncestorListener();
    }

    protected void installActionListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DateEditorDropDown.this.dateField.getText();
                try {
                    Object object = IlvFormatUtil.parseObjectFully(DateEditorDropDown.this.propertyEditor.getFormat(), string);
                    DateEditorDropDown.this.propertyEditor.setValue(object);
                    ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), DateEditorDropDown.a);
                    DateEditorDropDown.this.a(actionEvent2);
                }
                catch (ParseException parseException) {
                    DateEditorDropDown.this.dateField.setBorder(new LineBorder(Color.red));
                }
            }
        };
        this.dateField.addActionListener(actionListener);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateEditorDropDown.this.a(actionEvent);
            }
        };
        this.popup.addActionListener(actionListener);
    }

    protected void installFocusListener() {
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary() && !DateEditorDropDown.this.dateField.hasFocus()) {
                    DateEditorDropDown.this.d();
                }
                DateEditorDropDown.this.repaint();
            }
        };
        this.addFocusListener(this.focusListener);
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                DateEditorDropDown.this.validate();
                DateEditorDropDown.this.repaint();
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DateEditorDropDown.this.d();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void a() {
        this.arrowButton.setEnabled(this.isEnabled());
        this.arrowButton.resetKeyboardActions();
    }

    private void a(MouseEvent mouseEvent) {
        if (this.getEditorComponent().isRequestFocusEnabled()) {
            this.getEditorComponent().requestFocusInWindow();
        } else if (this.isRequestFocusEnabled()) {
            this.requestFocusInWindow();
        }
    }

    private void b() {
        if (this.popup.isVisible()) {
            this.popup.b();
        } else {
            this.popup.a();
        }
    }

    private void c() {
        this.popup.a();
        this.popup.requestFocusInWindow();
    }

    private void d() {
        this.popup.b();
    }

    public void setDate(Object object) {
        Object object2 = this.currentDate;
        if (object instanceof Date) {
            this.currentDate = (Date)object;
            this.propertyEditor.setValue(this.currentDate);
        } else if (object instanceof String) {
            try {
                this.propertyEditor.setAsText((String)object);
                this.currentDate = this.propertyEditor.getValue();
            }
            catch (Exception exception) {
                this.currentDate = null;
            }
        }
        this.e();
    }

    public Object getDate() {
        return this.currentDate;
    }

    private void e() {
        if (this.dateField != null) {
            if (this.currentDate != null) {
                this.dateField.setText(this.propertyEditor.getAsText());
                this.dateField.setCaretPosition(0);
                this.dateField.setBorder(new LineBorder(Color.black));
            } else {
                this.dateField.setText("");
                this.dateField.setBorder(new LineBorder(Color.red));
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void a(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    protected class FormattedDatePropertyEditor
    extends PropertyEditorSupport {
        private DateFormat a;

        public FormattedDatePropertyEditor(ULocale uLocale) {
            this.a = IlvDateFormatFactory.getDateInstance(2, uLocale);
        }

        public void setFormat(DateFormat dateFormat) {
            this.a = dateFormat;
        }

        public DateFormat getFormat() {
            return this.a;
        }

        @Override
        public void setAsText(String string) {
            if (string == null) {
                this.setValue(null);
            }
            if (string.equals("")) {
                this.setValue(null);
            }
            Object object = null;
            try {
                object = IlvFormatUtil.parseObjectFully(this.getFormat(), string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("could not parse: " + string);
            }
            this.setValue(object);
        }

        @Override
        public String getAsText() {
            try {
                Object object = this.getValue();
                if (object != null) {
                    return this.getFormat().format(object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            return "";
        }
    }
}

