/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

import ilog.views.util.print.IlvPrintableComponent;
import ilog.views.util.print.IlvUnit;
import ilog.views.util.print.TransformerUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;

public class IlvTransformedPrintable
extends IlvPrintableComponent {
    private AffineTransform a;

    public IlvTransformedPrintable(Component component, IlvUnit.Rectangle rectangle, double d, double d2, double d3) {
        super(component, rectangle);
        this.setTransform(new AffineTransform(d3, 0.0, 0.0, d3, d, d2));
    }

    public IlvTransformedPrintable(Component component, IlvUnit.Rectangle rectangle, Rectangle rectangle2) {
        super(component, rectangle);
        this.computeTransform(rectangle2);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Shape shape = graphics2D.getClip();
            IlvUnit.Rectangle rectangle = this.getPrintableArea();
            graphics2D.clipRect((int)rectangle.getXAs(IlvUnit.POINTS), (int)rectangle.getYAs(IlvUnit.POINTS), (int)rectangle.getWidthAs(IlvUnit.POINTS), (int)rectangle.getHeightAs(IlvUnit.POINTS));
            if (this.a.isIdentity()) {
                this.getComponent().print(graphics2D);
            } else {
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.transform(this.a);
                AffineTransform affineTransform2 = graphics2D.getTransform();
                affineTransform2.setTransform(affineTransform2.getScaleX(), affineTransform2.getShearY(), affineTransform2.getShearX(), affineTransform2.getScaleY(), Math.floor(affineTransform2.getTranslateX()), Math.floor(affineTransform2.getTranslateY()));
                graphics2D.setTransform(affineTransform2);
                this.getComponent().print(graphics2D);
                graphics2D.setTransform(affineTransform);
            }
            graphics2D.setClip(shape);
        }
        return 0;
    }

    public void computeTransform(Rectangle rectangle) {
        float f = (float)this.getPrintableArea().getXAs(IlvUnit.POINTS);
        float f2 = (float)this.getPrintableArea().getYAs(IlvUnit.POINTS);
        float f3 = rectangle.x + rectangle.width;
        float f4 = rectangle.y + rectangle.height;
        float f5 = (float)this.getPrintableArea().getWidthAs(IlvUnit.POINTS);
        float f6 = (float)this.getPrintableArea().getHeightAs(IlvUnit.POINTS);
        double d = TransformerUtil.ComputeZoomFactor(rectangle.x, f3, f5);
        double d2 = TransformerUtil.ComputeZoomFactor(rectangle.y, f4, f6);
        double d3 = TransformerUtil.ComputeTranslation(rectangle.x, f, d);
        double d4 = TransformerUtil.ComputeTranslation(rectangle.y, f2, d2);
        this.a = new AffineTransform(d, 0.0, 0.0, d2, d3, d4);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.a = affineTransform;
    }

    public AffineTransform getTransform() {
        return this.a;
    }
}

