/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

import ilog.views.util.print.IlvFlow;
import ilog.views.util.print.IlvFooter;
import ilog.views.util.print.IlvHeader;
import ilog.views.util.print.IlvPage;
import ilog.views.util.print.IlvUnit;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.print.attribute.standard.Sides;

public class IlvPrintableDocument
implements Printable,
Pageable {
    private Vector<IlvPage> a;
    private int b;
    private Paper c;
    private IlvPage d;
    private String e;
    private String f;
    private Sides g;
    private Date h = new Date();
    private IlvFooter i;
    private IlvHeader j;
    private PropertyChangeSupport k;
    private int l = 1;
    private int m = -1;
    private IlvFlow n;
    public static final int ORDERED_BY_COLUMNS = 0;
    public static final int ORDERED_BY_ROWS = 1;
    private boolean o = false;
    private transient int p;

    public IlvPrintableDocument(String string, PageFormat pageFormat) {
        this.d();
        this.b = pageFormat.getOrientation();
        this.c = pageFormat.getPaper();
        this.e = string;
    }

    public IlvPrintableDocument(String string, int n, Paper paper) {
        IlvPrintableDocument.a(n);
        this.d();
        this.b = n;
        this.c = paper != null ? (Paper)paper.clone() : null;
        this.e = string;
    }

    public IlvPrintableDocument(String string, int n) {
        IlvPrintableDocument.a(n);
        this.d();
        this.b = n;
        this.c = null;
        this.e = string;
    }

    public IlvPrintableDocument(String string) {
        this.d();
        this.b = 1;
        this.c = new Paper();
        this.e = string;
    }

    private void d() {
        this.a = new Vector();
        this.k = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.e;
    }

    public void setName(String string) {
        String string2 = this.e;
        this.e = string;
        this.firePropertyChange("name", string2, this.e);
    }

    public Date getDate() {
        return this.h;
    }

    public void setDate(Date date) {
        Date date2 = this.h;
        this.h = date;
        this.invalidateFlowLayout();
        this.firePropertyChange("date", date2, this.h);
    }

    public String getAuthor() {
        return this.f;
    }

    public void setAuthor(String string) {
        String string2 = this.f;
        this.f = string;
        this.invalidateFlowLayout();
        this.firePropertyChange("author", string2, this.f);
    }

    public Sides getSides() {
        return this.g;
    }

    public void setSides(Sides sides) {
        this.g = sides;
    }

    public IlvPage getTemplatePage() {
        return this.d;
    }

    public void setTemplatePage(IlvPage ilvPage) {
        IlvPage ilvPage2 = this.d;
        this.d = ilvPage;
        if (ilvPage != null) {
            ilvPage.setDocument(this);
        }
        this.firePropertyChange("templatePage", ilvPage2, this.d);
    }

    public IlvHeader getHeader() {
        return this.j;
    }

    public void setHeader(IlvHeader ilvHeader) {
        if (ilvHeader == null && this.j == null) {
            return;
        }
        if (ilvHeader != null && ilvHeader.equals(this.j)) {
            return;
        }
        if (this.getTemplatePage() != null && this.j != null) {
            this.getTemplatePage().removePrintableObject(this.j);
        }
        if (ilvHeader != null) {
            if (this.getTemplatePage() == null) {
                this.setTemplatePage(new IlvPage());
            }
            this.getTemplatePage().addPrintableObject(ilvHeader);
        }
        IlvHeader ilvHeader2 = this.j;
        this.j = ilvHeader;
        this.invalidateFlowLayout();
        this.firePropertyChange("header", ilvHeader2, this.j);
    }

    public IlvFooter getFooter() {
        return this.i;
    }

    public void setFooter(IlvFooter ilvFooter) {
        if (ilvFooter == null && this.i == null) {
            return;
        }
        if (ilvFooter != null && ilvFooter.equals(this.i)) {
            return;
        }
        if (this.getTemplatePage() != null && this.i != null) {
            this.getTemplatePage().removePrintableObject(this.i);
        }
        if (ilvFooter != null) {
            if (this.getTemplatePage() == null) {
                this.setTemplatePage(new IlvPage());
            }
            this.getTemplatePage().addPrintableObject(ilvFooter);
        }
        IlvFooter ilvFooter2 = this.i;
        this.i = ilvFooter;
        this.invalidateFlowLayout();
        this.firePropertyChange("footer", ilvFooter2, this.i);
    }

    public int getOrientation() {
        return this.b;
    }

    public void setOrientation(int n) {
        IlvPrintableDocument.a(n);
        if (this.b != n) {
            int n2 = this.b;
            this.b = n;
            this.invalidateFlowLayout();
            this.firePropertyChange("orientation", new Integer(n2), new Integer(this.b));
        }
    }

    private static void a(int n) {
        if (n != 1 && n != 0 && n != 2) {
            throw new IllegalArgumentException("orientation");
        }
    }

    public Paper getPaperFormat() {
        if (this.c != null) {
            return (Paper)this.c.clone();
        }
        return null;
    }

    public void setPaperFormat(Paper paper) {
        if (!(this.c == null ? paper == null : paper != null && this.c.getWidth() == paper.getWidth() && this.c.getHeight() == paper.getHeight() && this.c.getImageableX() == paper.getImageableX() && this.c.getImageableY() == paper.getImageableY() && this.c.getImageableWidth() == paper.getImageableWidth() && this.c.getImageableHeight() == paper.getImageableHeight())) {
            Paper paper2 = this.c;
            this.c = paper != null ? (Paper)paper.clone() : null;
            this.invalidateFlowLayout();
            this.firePropertyChange("paperFormat", paper2, this.c);
        }
    }

    public PageFormat getPageFormat() {
        Paper paper = this.getPaperFormat();
        if (paper != null) {
            PageFormat pageFormat = new PageFormat();
            pageFormat.setOrientation(this.getOrientation());
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        return null;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.setOrientation(pageFormat.getOrientation());
        this.setPaperFormat(pageFormat.getPaper());
    }

    public IlvUnit.Rectangle getImageableBounds() {
        PageFormat pageFormat = this.getPageFormat();
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        if (this.getHeader() != null) {
            d2 += this.getHeader().getHeight();
            d4 -= this.getHeader().getHeight();
        }
        d2 = Math.min(pageFormat.getImageableY() + pageFormat.getImageableHeight(), d2);
        if (this.getFooter() != null) {
            d4 -= this.getFooter().getHeight();
        }
        if (d4 < 0.0) {
            d4 = 1.0;
        }
        return new IlvUnit.Rectangle(d, d2, d3, d4, IlvUnit.POINTS);
    }

    public synchronized void addPage(IlvPage ilvPage) {
        int n = this.getNumberOfPages();
        this.a.add(ilvPage);
        ilvPage.setDocument(this);
        this.firePropertyChange("pageCount", new Integer(n), new Integer(this.getNumberOfPages()));
    }

    public synchronized void removePage(IlvPage ilvPage) {
        int n = this.getNumberOfPages();
        this.a.remove(ilvPage);
        ilvPage.setDocument(null);
        this.firePropertyChange("pageCount", new Integer(n), new Integer(this.getNumberOfPages()));
    }

    public synchronized void removeAll() {
        int n = this.getNumberOfPages();
        Iterator<IlvPage> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().setDocument(null);
        }
        this.a.clear();
        this.firePropertyChange("pageCount", new Integer(n), new Integer(0));
    }

    public synchronized void setPages(IlvPage[] ilvPageArray) {
        int n = this.getNumberOfPages();
        if (ilvPageArray == null) {
            this.removeAll();
            return;
        }
        this.a.clear();
        for (int i = 0; i < ilvPageArray.length; ++i) {
            this.a.add(ilvPageArray[i]);
            ilvPageArray[i].setDocument(this);
        }
        this.firePropertyChange("pageCount", new Integer(n), new Integer(this.getNumberOfPages()));
    }

    public IlvFlow getFlow() {
        if (this.n == null) {
            this.n = new IlvFlow(this);
        }
        return this.n;
    }

    public boolean isFlowLayoutValid() {
        if (this.n == null) {
            return true;
        }
        return this.n.isValid();
    }

    public void invalidateFlowLayout() {
        if (this.n != null) {
            this.n.invalidate();
        }
    }

    void a() {
        if (this.n != null) {
            this.n.layout();
        }
    }

    public int getColumnCount() {
        return this.m;
    }

    public void setColumnCount(int n) {
        this.m = n;
    }

    public int getPageOrder() {
        return this.l;
    }

    public void setPageOrder(int n) {
        if (n != this.l) {
            int n2 = this.l;
            this.l = n;
            this.invalidateFlowLayout();
            this.firePropertyChange("pageOrder", new Integer(n2), new Integer(this.l));
        }
    }

    protected void prepareDocument() {
    }

    private void e() {
        this.maybeInvalidatePages();
        if (!this.o) {
            this.o = true;
            this.removeAll();
            IlvPage[] ilvPageArray = this.createPages();
            this.o = true;
            this.setPages(ilvPageArray);
        }
    }

    protected void maybeInvalidatePages() {
    }

    protected void invalidatePages() {
        this.o = false;
    }

    protected IlvPage[] createPages() {
        return null;
    }

    public IlvPage getPage(int n) {
        this.e();
        return this.a.elementAt(n);
    }

    public int getPageIndex(IlvPage ilvPage) {
        this.e();
        return this.a.indexOf(ilvPage);
    }

    @Override
    public synchronized int getNumberOfPages() {
        this.e();
        return this.a.size();
    }

    @Override
    public PageFormat getPageFormat(int n) {
        return this.getPage(n).getPageFormat();
    }

    @Override
    public Printable getPrintable(int n) {
        return this.getPage(n);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        this.setDate(new Date());
        if (n >= this.a.size()) {
            return 1;
        }
        return this.getPrintable(n).print(graphics, pageFormat, n);
    }

    void b() {
        if (this.p++ == 0) {
            this.enablePrintStyle(true);
        }
    }

    void c() {
        if (this.p > 0 && --this.p == 0) {
            this.enablePrintStyle(false);
        }
    }

    public void enablePrintStyle(boolean bl) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.k.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.k.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.k.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.k.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.k.removePropertyChangeListener(propertyChangeListener);
    }
}

