/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.internal.impl;

import com.ibm.icu.util.ULocale;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.internal.IlvUtility;
import ilog.views.util.IlvComponentOrientationAware;
import ilog.views.util.IlvULocaleAware;
import ilog.views.util.text.IlvBaseTextDirectionInterface;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.ComponentOrientation;

public final class IlvBidiGraphicBag
implements IlvGraphicBag,
IlvULocaleAware,
IlvComponentOrientationAware,
IlvBaseTextDirectionInterface {
    private IlvGraphic a;
    private ULocale b;
    private ComponentOrientation c;
    private int d;

    public IlvBidiGraphicBag(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        this.b = ilvGraphic.getULocale();
        this.c = ilvGraphic.getComponentOrientation();
        this.d = ilvGraphic.getResolvedBaseTextDirection();
        this.setObject(ilvGraphic2);
    }

    public IlvGraphic getObject() {
        return this.a;
    }

    public void setObject(IlvGraphic ilvGraphic) {
        if (this.getObject() != null) {
            this.getObject().setGraphicBag(null);
        }
        this.a = ilvGraphic;
        if (ilvGraphic != null) {
            ilvGraphic.setGraphicBag(this);
        }
    }

    @Override
    public void setULocale(ULocale uLocale) {
        IlvGraphicVector ilvGraphicVector = IlvGraphicUtil.startBidiChange(this);
        try {
            this.b = uLocale;
        }
        finally {
            IlvGraphicUtil.stopBidiChange(this, ilvGraphicVector, true);
        }
    }

    @Override
    public ULocale getULocale() {
        return this.b;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        IlvGraphicVector ilvGraphicVector = IlvGraphicUtil.startBidiChange(this);
        try {
            this.c = componentOrientation;
        }
        finally {
            IlvGraphicUtil.stopBidiChange(this, ilvGraphicVector, true);
        }
    }

    @Override
    public ComponentOrientation getComponentOrientation() {
        return this.c;
    }

    @Override
    public void setBaseTextDirection(int n) {
        IlvBidiUtil.checkBaseTextDirectionChoice(n, false, true);
        IlvGraphicVector ilvGraphicVector = IlvGraphicUtil.startBidiChange(this);
        try {
            this.d = n;
        }
        finally {
            IlvGraphicUtil.stopBidiChange(this, ilvGraphicVector, true);
        }
    }

    @Override
    public int getBaseTextDirection() {
        return this.d;
    }

    @Override
    public int getResolvedBaseTextDirection() {
        return this.d;
    }

    @Override
    public void addObject(IlvGraphic ilvGraphic, boolean bl) {
        if (this.getObject() != null) {
            throw new RuntimeException("This bag is full");
        }
        this.setObject(ilvGraphic);
    }

    @Override
    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic != this.getObject()) {
            throw new RuntimeException("Object is not in this bag");
        }
        this.setObject(null);
    }

    @Override
    public IlvGraphicEnumeration getObjects() {
        return IlvUtility.getObjectsImpl(this, this.getObject());
    }

    @Override
    public void reDrawObj(IlvGraphic ilvGraphic) {
    }

    @Override
    public void reDrawRegion(IlvRegion ilvRegion) {
    }

    @Override
    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        if (ilvGraphic != this.getObject()) {
            throw new RuntimeException("Object is not in this bag");
        }
        ilvGraphic.moveResize(ilvRect);
    }

    @Override
    public void moveObject(IlvGraphic ilvGraphic, float f, float f2, boolean bl) {
        if (ilvGraphic != this.getObject()) {
            throw new RuntimeException("Object is not in this bag");
        }
        ilvGraphic.move(f, f2);
    }

    @Override
    public void applyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        if (ilvGraphic != this.getObject()) {
            throw new RuntimeException("Object is not in this bag");
        }
        IlvUtility.applyToObjectImplForBag(this, ilvGraphic, ilvApplyObject, object, bl);
    }

    @Override
    public boolean setObjectName(IlvGraphic ilvGraphic, String string) {
        if (ilvGraphic != this.getObject()) {
            return false;
        }
        ilvGraphic.setNameImpl(string);
        return true;
    }

    @Override
    public IlvGraphic getObject(String string) {
        if (string == this.getObject().getName() || string != null && string.equals(this.getObject().getName())) {
            return this.getObject();
        }
        return null;
    }

    @Override
    public IlvGraphicBag getGraphicBag() {
        return null;
    }
}

